/* psbb.y
 *
 * Parser grammar to drive the lexical analyser for extraction of bounding
 * box properties from EPS, or PDF files, to support groff's .psbb request.
 *
 * Written by Keith Marshall <keith@users.osdn.me>
 * Copyright (C) 2017, Free Software Foundation, Inc.
 *
 * This file is part of groff.
 *
 * groff is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * groff is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
%{
#include "psbb.h"

#define psbb_assign  psbb_assign_registers
%}

%name-prefix = "psbb_"

%token PDFSTART PDFROOT
%token VALUE PDFLOOKUP PDFOBJECT PDFOBJREF PDFENDOBJ

%%
/* A .psbb related parse of either any [E]PS, or any PDF file,
 * MUST conform to this "psbb" grammar.
 */
psbb: /* nothing */
    | psbb root PDFOBJREF		{ psbb_walk(); }
    | psbb PDFLOOKUP VALUE VALUE	{ psbb_lookup( $3, $4 ); }
    | psbb PDFOBJREF VALUE VALUE 'R'	{ psbb_locate( $3, $4 ); }
    | psbb VALUE VALUE PDFOBJECT	{ psbb_chkref( $2, $3 ); }
    | psbb PDFENDOBJ			{ psbb_walk(); }
    | psbb bbox
    ;

/* The "root" rule is specific to parsing of PDF files; it should
 * be invoked just once, early in the parse cycle for each file, to
 * initiate location and parsing of the PDF /Catalog object.
 */
root: PDFROOT VALUE VALUE 'R'		{ psbb_locate( $2, $3 ); }
    ;

/* Applicable to either [E]PS or PDF files, at any time when we
 * have accumulated four numeric values on the parser stack, we
 * assume that they represent bounding box co-ordinates.
 */
bbox: VALUE VALUE VALUE VALUE		{ psbb_assign( $1, $2, $3, $4 ); }
    ;

/* vim: set cin fo=croqj: */
