/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package com.sample.interceptor;

import java.io.Serializable;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;

/**
 *
 * @author konishiyuji
 */
// インターセプターの宣言
//@Interceptor
//@Dependent
//// 優先度
//@Priority(Interceptor.Priority.APPLICATION)
//// バインド用アノテーション
//@LogIntercept
@LogIntercept
@Interceptor
public class LogInterceptor implements Serializable {
    // TODO ログレベル
    // http://qiita.com/yohjizzz/items/55b5d5d6362c8a07554c
    
    @AroundInvoke
    public Object invoke(final InvocationContext ic) throws Throwable {
        // ターゲットは、CDIのクライアントプロキシなので、スーパークラスを取得。
        String classAndMethod = ic.getTarget().getClass()
                .getSuperclass().getName() 
                + "#" + ic.getMethod().getName(); 
        
        System.err.println("BEGIN: " + classAndMethod);
        Object obj = ic.proceed();
        System.err.println("END:   " + classAndMethod);

        return obj;
    }
}
