/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package com.sample.managedbean;

import com.sample.BackingDTO;
import com.sample.FacesContextUtil;
import com.sample.Person;
import com.sample.SessionDTO;
import com.sample.ifacade.BackingBeanFacade21;
import com.sample.ifacade.BackingBeanFacade29;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ViewScoped;
import javax.inject.Inject;

/**
 *
 * @author konishiyuji
 */
@ManagedBean
@ViewScoped
public class UpdatePersonBean implements Serializable {
    @Inject
    private FacesContextUtil facesContextUtil;
    @Inject
    private SessionDTO sessionDTO;
    @Inject
    private BackingBeanFacade21 backingBeanFacade;
    @Inject
    private BackingBeanFacade29 backingBeanFacade2;
    
    private Person person;

    @PostConstruct
    public void execute(){
        System.err.println("BEGIN: UpdatePersonBean.execute()");

        Map<String,String> params = facesContextUtil.getParams();
        String selectedId = params.get("RADIO");        

        List<String> messages = (List<String>) sessionDTO.get("MESSAGES");
        facesContextUtil.addMessages(messages);
        sessionDTO.put("MESSAGES", null);
        
        BackingDTO backingDto = new BackingDTO();
        backingDto.put("RADIO", selectedId);
        
        // 業務ロジックの呼び出し
        String errorCode = backingBeanFacade.execute(backingDto);
        if (!errorCode.equals("000")){
            // エラー
            sessionDTO.put("MESSAGES", messages);
            facesContextUtil.redirect("TODO");
            return;
        }
        
        setPerson((Person) backingDto.get("PERSON"));
        System.err.println("END  : UpdatePersonBean.execute()");
    }

    public String action(){
        BackingDTO backingDto = new BackingDTO();
        backingDto.put("PERSON", person);

        // 業務ロジックの呼び出し
        // TODO エラー処理
        String errorCode = backingBeanFacade2.execute(backingDto);

        return "personList";
    }
    
    public String cancel(){
        return "personList";
    }

    /**
     * @return the person
     */
    public Person getPerson() {
        return person;
    }

    /**
     * @param person the person to set
     */
    public void setPerson(Person person) {
        this.person = person;
    }
}
