#!/bin/busybox sh
jpgfmt=/mnt/onboard/screen%02d.jpg
k=1
while : ; do
  jpg=$(printf $jpgfmt $k)
  k=$((k+1))
  [ -f $jpg ] && continue
  touch $jpg
  break
done
{
  # generate substitution statements and eval
  # w=_width_;h=_height_;dda="bs=_width_x_pix/byte_x2 count=_height_/2"
  eval $(fbset | awk '
    $1=="geometry"{
      printf "w=%d;h=%d;dda=\"bs=%d count=%d\";", \
        $2, $3, $2*$6/4, $3/2;
      exit;
    }')
  tmpimg=`mktemp /tmp/scrn.XXXXXX`
  # shoot
  dd if=/dev/fb0 of=$tmpimg $dda
  dd if=/dev/zero $dda | /usr/local/Kobo/pickel showpic 1
  /usr/local/Kobo/pickel showpic 1 < $tmpimg
  # convert to jpeg via ascii ppm, very slow
  od -v -A n -t u2 --width=128 $tmpimg |
    awk -v w=$w -v h=$h '
      BEGIN{printf "P3\n%d %d\n31\n", w, h;}
      {
        for (i=1; i<=NF; i++) {
          g = int($i/64);
          printf "%d %d %d\n", g/32, g%32, $i%32;
       }
    }' | cjpeg | jpegtran -rotate 90 > $jpg
  rm -f $tmpimg
} >/dev/null 2>&1 </dev/null &

exit
