/*
 * Decompiled with CFR 0.152.
 */
package saccubus;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JLabel;
import saccubus.ConvertStopFlag;
import saccubus.Converter;
import saccubus.ConvertingSetting;
import saccubus.WayBackDate;
import saccubus.net.Path;
import saccubus.util.DuplicatedOutput;

public class Prompt {
    private static final String LOGFILE = ".\\log.txt";
    private static DuplicatedOutput dout = null;
    private static String logname = ".\\log.txt";
    private static int maxsize = 1000000;
    private static boolean enablePupup = false;
    private static Hashtable<String, String> settingMap = new Hashtable(16);
    private static Hashtable<String, String> optionMap = new Hashtable(16);
    private static Hashtable<String, String> downloadMap = new Hashtable(16);
    private static String optionFilePrefix = "";
    private static ConvertingSetting setting;

    public static void main(String[] args) {
        if (!Prompt.setLog(logname)) {
            Prompt.exit(1);
        }
        System.out.println(WayBackDate.formatNow());
        if (args.length < 3) {
            System.out.println("Error. MailAddress, Password, VideoID must be specified.");
            Prompt.exit(2);
        }
        String mail = args[0];
        String pass = args[1];
        String tag = args[2];
        String time = args.length < 4 ? "" : args[3];
        int i = 4;
        while (i < args.length) {
            String arg = args[i];
            if (arg != null && !arg.isEmpty()) {
                String value;
                String key;
                int index;
                if (arg.startsWith("#") || arg.startsWith("//")) break;
                if (arg.equals("@NDL")) {
                    downloadMap.put("SaveVideoFile", "false");
                    downloadMap.put("SaveCommentFile", "false");
                    System.out.println("Set No Download.");
                } else if (arg.equals("@DLO")) {
                    downloadMap.put("SaveVideoFile", "true");
                    downloadMap.put("SaveCommentFile", "true");
                    downloadMap.put("SaveConvertedFile", "false");
                    System.out.println("Set Download Only.");
                } else if (arg.equals("@PUP")) {
                    enablePupup = true;
                } else if (arg.startsWith("-") && arg.contains("=")) {
                    index = arg.indexOf(61);
                    key = arg.substring(1, index);
                    value = arg.substring(index + 1);
                    optionMap.put(key, value);
                } else if (arg.contains("=")) {
                    index = arg.indexOf(61);
                    key = arg.substring(0, index);
                    value = arg.substring(index + 1);
                    settingMap.put(key, value);
                } else if (arg.contains(":")) {
                    if (time.contains(":")) {
                        time = String.valueOf(time.trim()) + " " + arg.trim();
                    }
                } else if (optionFilePrefix.isEmpty() && Character.isLetter(arg.charAt(0))) {
                    optionFilePrefix = arg.trim();
                } else {
                    System.out.println("Undefined Argument: <" + arg + ">");
                }
            }
            ++i;
        }
        setting = ConvertingSetting.loadSetting(mail, pass);
        setting.override(optionFilePrefix, settingMap, optionMap);
        setting.override(downloadMap);
        JLabel status = new JLabel();
        JLabel info = new JLabel();
        JLabel watch = new JLabel();
        JButton stopButton = new JButton();
        final ConvertStopFlag cuiStop = new ConvertStopFlag(stopButton, "\u505c\u6b62", "\u5f85\u6a5f", "\u7d42\u4e86");
        stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                cuiStop.stop();
            }
        });
        Window popup = new Window(null);
        popup.setSize(300, 25);
        popup.setLocation(0, 0);
        popup.setLayout(new BorderLayout(5, 0));
        Color fg = Color.black;
        Color bg = Color.lightGray;
        popup.setForeground(fg);
        popup.setBackground(bg);
        stopButton.setForeground(fg);
        stopButton.setBackground(bg);
        stopButton.setSize(40, 20);
        stopButton.setVisible(true);
        status.setForeground(fg);
        status.setBackground(bg);
        status.setVisible(true);
        popup.add((Component)stopButton, "West");
        popup.add((Component)status, "Center");
        popup.setVisible(enablePupup);
        Converter conv = new Converter(tag, time, setting, status, cuiStop, info, watch);
        System.out.println("-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-");
        System.out.println("Saccubus on CUI");
        System.out.println();
        System.out.println("-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-");
        System.out.println("Mailaddr: " + mail);
        System.out.println("Password: hidden");
        System.out.println("VideoID: " + tag);
        System.out.println("WaybackTime: " + time);
        if (!optionFilePrefix.isEmpty()) {
            System.out.println("OptionPrefix: " + optionFilePrefix);
        }
        if (args.length > 4) {
            System.out.print("Other args:");
            int i2 = 4;
            while (i2 < args.length) {
                System.out.print(" " + args[i2]);
                ++i2;
            }
            System.out.println();
        }
        System.out.println("-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-");
        System.out.println("Version 1.28");
        conv.start();
        try {
            conv.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        popup.dispose();
        System.out.println("Finished.");
    }

    private static int getLogsize() {
        String logsize = System.getenv("logsize");
        if (logsize != null && !logsize.isEmpty()) {
            return Prompt.decode(logsize);
        }
        return maxsize;
    }

    private static int decode(String str) {
        if (str == null || str.isEmpty()) {
            return maxsize;
        }
        str = str.toLowerCase();
        int value = 1;
        int len = str.length();
        char suffix = str.charAt(len - 1);
        if (suffix == 'k') {
            value = 1000;
            str = str.substring(0, len - 1);
        } else if (suffix == 'm') {
            value = 1000000;
            str = str.substring(0, len - 1);
        }
        try {
            value *= Integer.decode(str).intValue();
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            value = maxsize;
        }
        return value;
    }

    private static void exit(int status) {
        if (dout != null) {
            dout.flush();
            dout.close();
        }
        System.exit(status);
    }

    private static boolean setLog(String path) {
        String text;
        int len;
        File log = new File(path);
        if (log.exists() && log.canRead() && (len = (text = Path.readAllText(path, "MS932")).length()) > Prompt.getLogsize()) {
            text = text.substring(len - Prompt.getLogsize());
            if (log.delete()) {
                try {
                    PrintStream ps = new PrintStream(log);
                    ps.print(text);
                    ps.flush();
                    ps.close();
                    dout = new DuplicatedOutput(log);
                    System.setErr(dout.dup(System.err));
                    System.setOut(dout.dup(System.out));
                    return true;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
            }
        }
        if (!log.exists() || log.canWrite()) {
            try {
                dout = new DuplicatedOutput(log);
                System.setErr(dout.dup(System.err));
                System.setOut(dout.dup(System.out));
                return true;
            }
            catch (IOException e1) {
                e1.printStackTrace();
                return false;
            }
        }
        return true;
    }
}

