/*
 * Decompiled with CFR 0.152.
 */
package saccubus;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.JLabel;
import saccubus.ConvertStopFlag;
import saccubus.ConvertingSetting;
import saccubus.FFmpeg;
import saccubus.WayBackDate;
import saccubus.conv.CombineXML;
import saccubus.conv.ConvertToVideoHook;
import saccubus.net.BrowserInfo;
import saccubus.net.NicoClient;
import saccubus.net.Path;
import saccubus.util.Cws2Fws;
import saccubus.util.Stopwatch;

public class Converter
extends Thread {
    private final ConvertingSetting Setting;
    private String Tag;
    private String VideoID;
    private String VideoTitle;
    private String Time;
    private JLabel Status;
    private final ConvertStopFlag StopFlag;
    private static final String TMP_COMMENT = "_vhook.tmp";
    private static final String TMP_OWNERCOMMENT = "_vhookowner.tmp";
    private static final String TMP_OPTIONALTHREAD = "_vhookoptional.tmp";
    private static final String VIDEO_URL_PARSER = "http://www.nicovideo.jp/watch/";
    public static final String OWNER_EXT = "[Owner].xml";
    public static final String OPTIONAL_EXT = "{Optional}.xml";
    private static final String TMP_COMBINED_XML = "_tmp_comment.xml";
    private static final String TMP_COMBINED_XML2 = "_tmp_optional.xml";
    private String OtherVideo;
    private final String WatchInfo;
    private final JLabel MovieInfo;
    private BrowserInfo.BrowserCookieKind BrowserKind = BrowserInfo.BrowserCookieKind.NONE;
    private final BrowserInfo BrowserInfo = new BrowserInfo();
    private String UserSession = "";
    private final Stopwatch Stopwatch;
    private File selectedVhook;
    private FFmpeg.Aspect videoAspect;
    private File fwsFile = null;
    private VideoIDFilter DefaultVideoIDFilter;
    private File VideoFile = null;
    private File CommentFile = null;
    private File OwnerCommentFile = null;
    private File OptionalThreadFile = null;
    private File ConvertedVideoFile = null;
    private File CommentMiddleFile = null;
    private File OwnerMiddleFile = null;
    private File OptionalMiddleFile = null;
    private FFmpeg ffmpeg = null;
    private File VhookNormal = null;
    private File VhookWide = null;
    private int wayOfVhook = 0;
    private ArrayList<File> listOfCommentFile = new ArrayList();
    private String optionalThreadID = "";
    private static final int CODE_CONVERTING_ABORTED = 100;
    private String ExtOption;
    private String InOption;
    private String OutOption;
    private String MainOption;
    private String ffmpegOptionName = "\u76f4\u63a5\u5165\u529b";
    private String ffmpegVfOption = "";
    private static final String VFILTER_FLAG = "-vfilters";
    private static final String TCOMMENT_EXT = ".txml";

    public Converter(String url, String time, ConvertingSetting setting, JLabel status, ConvertStopFlag flag, JLabel movieInfo, JLabel watch) {
        int index;
        url = url.trim();
        if (url.startsWith(VIDEO_URL_PARSER)) {
            url = url.substring(VIDEO_URL_PARSER.length());
        }
        if ((index = url.indexOf(63)) >= 0) {
            this.Tag = url.substring(0, index);
            this.WatchInfo = url.substring(index);
        } else {
            this.Tag = url;
            this.WatchInfo = "";
        }
        this.VideoID = "[" + this.Tag + "]";
        this.DefaultVideoIDFilter = new VideoIDFilter(this.VideoID);
        this.Time = time.equals("000000") || time.equals("0") ? "" : time;
        this.Setting = setting;
        this.Status = status;
        this.StopFlag = flag;
        this.MovieInfo = movieInfo;
        this.MovieInfo.setText(" ");
        this.Stopwatch = new Stopwatch(watch);
    }

    public File getVideoFile() {
        return this.VideoFile;
    }

    public ConvertingSetting getSetting() {
        return this.Setting;
    }

    private void sendtext(String text) {
        this.Status.setText(text);
    }

    private boolean isSaveConverted() {
        return this.Setting.isSaveConverted();
    }

    private boolean isSaveVideo() {
        return this.Setting.isSaveVideo();
    }

    private boolean isSaveComment() {
        return this.Setting.isSaveComment();
    }

    private boolean isSaveOwnerComment() {
        return this.Setting.isSaveOwnerComment();
    }

    private boolean isConvertWithComment() {
        return this.Setting.isConvertWithComment();
    }

    private boolean isConvertWithOwnerComment() {
        return this.Setting.isConvertWithOwnerComment();
    }

    private boolean isVideoFixFileName() {
        return this.Setting.isVideoFixFileName();
    }

    private boolean isCommentFixFileName() {
        return this.Setting.isCommentFixFileName();
    }

    private String getProxy() {
        return this.Setting.getProxy();
    }

    private int getProxyPort() {
        return this.Setting.getProxyPort();
    }

    private String getMailAddress() {
        return this.Setting.getMailAddress();
    }

    private String getPassword() {
        return this.Setting.getPassword();
    }

    private boolean isDeleteVideoAfterConverting() {
        return this.Setting.isDeleteVideoAfterConverting();
    }

    private boolean isDeleteCommentAfterConverting() {
        return this.Setting.isDeleteCommentAfterConverting();
    }

    private boolean useProxy() {
        return this.Setting.useProxy();
    }

    private boolean checkOK() {
        this.sendtext("\u30c1\u30a7\u30c3\u30af\u3057\u3066\u3044\u307e\u3059");
        if (!(this.isSaveConverted() || this.isSaveVideo() || this.isSaveComment() || this.isSaveOwnerComment())) {
            this.sendtext("\u4f55\u3082\u3059\u308b\u3053\u3068\u304c\u3042\u308a\u307e\u305b\u3093");
            return false;
        }
        if (this.isSaveConverted()) {
            File a = new File(this.Setting.getFFmpegPath());
            if (!a.canRead()) {
                this.sendtext("FFmpeg\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002");
                return false;
            }
            this.ffmpeg = new FFmpeg(this.Setting.getFFmpegPath());
            if (this.Setting.isUseVhookNormal()) {
                if (this.Setting.getVhookPath().indexOf(32) >= 0) {
                    this.sendtext("\u3059\u3044\u307e\u305b\u3093\u3002\u73fe\u5728vhook\u30e9\u30a4\u30d6\u30e9\u30ea\u306b\u306f\u534a\u89d2\u7a7a\u767d\u306f\u4f7f\u3048\u307e\u305b\u3093\u3002");
                    return false;
                }
                this.VhookNormal = new File(this.Setting.getVhookPath());
                if (!this.VhookNormal.canRead()) {
                    this.sendtext("Vhook\u30e9\u30a4\u30d6\u30e9\u30ea\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002");
                    return false;
                }
                ++this.wayOfVhook;
            }
            if (this.Setting.isUseVhookWide()) {
                if (this.Setting.getVhookWidePath().isEmpty()) {
                    this.VhookWide = this.VhookNormal;
                } else {
                    if (this.Setting.getVhookWidePath().indexOf(32) >= 0) {
                        this.sendtext("\u3059\u3044\u307e\u305b\u3093\u3002\u73fe\u5728vhook\u30d5\u30a1\u30a4\u30eb\u540d\u306b\u306f\u534a\u89d2\u7a7a\u767d\u306f\u4f7f\u3048\u307e\u305b\u3093\u3002");
                        return false;
                    }
                    this.VhookWide = new File(this.Setting.getVhookWidePath());
                }
                if (!this.VhookWide.canRead()) {
                    this.sendtext("Vhook\u30e9\u30a4\u30d6\u30e9\u30ea\uff08\u30ef\u30a4\u30c9\uff09\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002");
                    return false;
                }
                ++this.wayOfVhook;
            }
            if (this.wayOfVhook == 0) {
                this.sendtext("\u4f7f\u7528\u3067\u304d\u308bVhook\u30e9\u30a4\u30d6\u30e9\u30ea\u304c\u3042\u308a\u307e\u305b\u3093\u3002");
                return false;
            }
            a = new File(this.Setting.getFontPath());
            if (!a.canRead()) {
                this.sendtext("\u30d5\u30a9\u30f3\u30c8\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002");
                return false;
            }
        } else {
            if (this.isDeleteVideoAfterConverting()) {
                this.sendtext("\u5909\u63db\u3057\u306a\u3044\u306e\u306b\u3001\u52d5\u753b\u524a\u9664\u3057\u3061\u3083\u3063\u3066\u826f\u3044\u3093\u3067\u3059\u304b\uff1f");
                return false;
            }
            if (this.isDeleteCommentAfterConverting()) {
                this.sendtext("\u5909\u63db\u3057\u306a\u3044\u306e\u306b\u3001\u30b3\u30e1\u30f3\u30c8\u524a\u9664\u3057\u3061\u3083\u3063\u3066\u826f\u3044\u3093\u3067\u3059\u304b\uff1f");
                return false;
            }
        }
        if (this.isSaveVideo() || this.isSaveComment() || this.isSaveOwnerComment()) {
            if (this.Setting.isBrowserIE()) {
                this.BrowserKind = BrowserInfo.BrowserCookieKind.MSIE;
                this.UserSession = this.BrowserInfo.getUserSession(this.BrowserKind);
            }
            if (this.UserSession.isEmpty() && this.Setting.isBrowserFF()) {
                this.BrowserKind = BrowserInfo.BrowserCookieKind.Firefox;
                this.UserSession = this.BrowserInfo.getUserSession(this.BrowserKind);
            }
            if (this.UserSession.isEmpty() && this.Setting.isBrowserChrome()) {
                this.BrowserKind = BrowserInfo.BrowserCookieKind.Chrome;
                this.UserSession = this.BrowserInfo.getUserSession(this.BrowserKind);
            }
            if (this.UserSession.isEmpty() && this.Setting.isBrowserChromium()) {
                this.BrowserKind = BrowserInfo.BrowserCookieKind.Chromium;
                this.UserSession = this.BrowserInfo.getUserSession(this.BrowserKind);
            }
            if (this.UserSession.isEmpty() && this.Setting.isBrowserOpera()) {
                this.BrowserKind = BrowserInfo.BrowserCookieKind.Opera;
                this.UserSession = this.BrowserInfo.getUserSession(this.BrowserKind);
            }
            if (this.UserSession.isEmpty() && this.Setting.isBrowserOther()) {
                this.BrowserKind = BrowserInfo.BrowserCookieKind.Other;
                this.UserSession = this.BrowserInfo.getUserSessionOther(this.Setting.getBrowserCookiePath());
            }
            if (this.BrowserKind != BrowserInfo.BrowserCookieKind.NONE && this.UserSession.isEmpty()) {
                this.sendtext("\u30d6\u30e9\u30a6\u30b6\u3000" + this.BrowserKind.toString() + "\u3000\u306e\u30bb\u30c3\u30b7\u30e7\u30f3\u53d6\u5f97\u306b\u5931\u6557");
                return false;
            }
            if (this.BrowserKind == BrowserInfo.BrowserCookieKind.NONE && (this.getMailAddress() == null || this.getMailAddress().isEmpty() || this.getPassword() == null || this.getPassword().isEmpty())) {
                this.sendtext("\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u304b\u30d1\u30b9\u30ef\u30fc\u30c9\u304c\u7a7a\u767d\u3067\u3059\u3002");
                return false;
            }
            if (this.useProxy() && (this.getProxy() == null || this.getProxy().isEmpty() || this.getProxyPort() < 0 || this.getProxyPort() > 65535)) {
                this.sendtext("\u30d7\u30ed\u30ad\u30b7\u306e\u8a2d\u5b9a\u304c\u4e0d\u6b63\u3067\u3059\u3002");
                return false;
            }
        }
        this.sendtext("\u30c1\u30a7\u30c3\u30af\u7d42\u4e86");
        return true;
    }

    private NicoClient getNicoClient() {
        if (this.isSaveVideo() || this.isSaveComment() || this.isSaveOwnerComment()) {
            String proxy = null;
            int proxy_port = -1;
            if (this.useProxy()) {
                proxy = this.getProxy();
                proxy_port = this.getProxyPort();
            }
            this.sendtext("\u30ed\u30b0\u30a4\u30f3\u4e2d");
            NicoClient client = null;
            client = this.BrowserKind != BrowserInfo.BrowserCookieKind.NONE ? new NicoClient(this.BrowserKind, this.UserSession, proxy, proxy_port, this.Stopwatch) : new NicoClient(this.getMailAddress(), this.getPassword(), proxy, proxy_port, this.Stopwatch);
            if (!client.isLoggedIn()) {
                this.sendtext("\u30ed\u30b0\u30a4\u30f3\u5931\u6557 " + this.BrowserInfo.getBrowserName() + " " + client.getExtraError());
            } else {
                this.sendtext("\u30ed\u30b0\u30a4\u30f3\u6210\u529f " + this.BrowserInfo.getBrowserName());
            }
            return client;
        }
        return null;
    }

    private boolean saveVideo(NicoClient client) {
        File folder = this.Setting.getVideoFixFileNameFolder();
        this.sendtext("\u52d5\u753b\u306e\u4fdd\u5b58");
        if (this.isSaveVideo()) {
            if (this.isVideoFixFileName()) {
                if (folder.mkdir()) {
                    System.out.println("Folder created: " + folder.getPath());
                }
                if (!folder.isDirectory()) {
                    this.sendtext("\u52d5\u753b\u306e\u4fdd\u5b58\u5148\u30d5\u30a9\u30eb\u30c0\u304c\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3002");
                    return false;
                }
                this.VideoFile = new File(folder, String.valueOf(this.VideoID) + this.VideoTitle + ".flv");
            } else {
                this.VideoFile = this.Setting.getVideoFile();
            }
            this.sendtext("\u52d5\u753b\u306e\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u958b\u59cb\u4e2d");
            if (client == null) {
                this.sendtext("\u30ed\u30b0\u30a4\u30f3\u3057\u3066\u306a\u3044\u306e\u306b\u52d5\u753b\u306e\u4fdd\u5b58\u306b\u306a\u308a\u307e\u3057\u305f");
                return false;
            }
            this.VideoFile = client.getVideo(this.VideoFile, this.Status, this.StopFlag);
            if (this.stopFlagReturn()) {
                return false;
            }
            if (this.VideoFile == null) {
                this.sendtext("\u52d5\u753b\u306e\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u306b\u5931\u6557");
                return false;
            }
            if (this.optionalThreadID == null || this.optionalThreadID.isEmpty()) {
                this.optionalThreadID = client.getOptionalThreadID();
            }
        } else if (this.isSaveConverted()) {
            if (this.isVideoFixFileName()) {
                String videoFilename = this.detectTitleFromVideo(folder);
                if (videoFilename == null) {
                    if (this.OtherVideo == null) {
                        this.sendtext("\u52d5\u753b\u30d5\u30a1\u30a4\u30eb\u304c\u30d5\u30a9\u30eb\u30c0\u306b\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
                    } else {
                        this.sendtext("\u52d5\u753b\u30d5\u30a1\u30a4\u30eb\u304c.flv\u3067\u3042\u308a\u307e\u305b\u3093\uff1a" + this.OtherVideo);
                    }
                    return false;
                }
                this.VideoFile = new File(folder, videoFilename);
                if (!this.VideoFile.canRead()) {
                    this.sendtext("\u52d5\u753b\u30d5\u30a1\u30a4\u30eb\u304c\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093\u3002");
                    return false;
                }
            } else {
                this.VideoFile = this.Setting.getVideoFile();
                if (!this.VideoFile.exists()) {
                    this.sendtext("\u52d5\u753b\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
                    return false;
                }
            }
        }
        this.sendtext("\u52d5\u753b\u306e\u4fdd\u5b58\u3092\u7d42\u4e86");
        return true;
    }

    private boolean saveComment(NicoClient client) {
        this.sendtext("\u30b3\u30e1\u30f3\u30c8\u306e\u4fdd\u5b58");
        File folder = this.Setting.getCommentFixFileNameFolder();
        String commentTitle = "";
        String prefix = "";
        String back_comment = this.Setting.getBackComment();
        if (this.isSaveComment()) {
            if (this.isCommentFixFileName()) {
                if (folder.mkdir()) {
                    System.out.println("Folder created: " + folder.getPath());
                }
                if (!folder.isDirectory()) {
                    this.sendtext("\u30b3\u30e1\u30f3\u30c8\u306e\u4fdd\u5b58\u5148\u30d5\u30a9\u30eb\u30c0\u304c\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3002");
                    return false;
                }
                if (this.Setting.isAddTimeStamp()) {
                    WayBackDate wbDate;
                    prefix = this.Time == null || this.Time.isEmpty() || this.Time.equals("0") || this.Time.equals("Owner") || this.Time.equals("Optional") ? "[" + WayBackDate.formatNow() + "]" : ((wbDate = new WayBackDate(this.Time)).isValid() ? "[" + wbDate.format() + "]" : "[" + this.Time + "]");
                }
                commentTitle = String.valueOf(this.VideoID) + this.VideoTitle + prefix;
                this.CommentFile = new File(folder, String.valueOf(commentTitle) + ".xml");
            } else {
                this.CommentFile = this.Setting.getCommentFile();
            }
            if (client == null) {
                this.sendtext("\u30ed\u30b0\u30a4\u30f3\u3057\u3066\u306a\u3044\u306e\u306b\u30b3\u30e1\u30f3\u30c8\u306e\u4fdd\u5b58\u306b\u306a\u308a\u307e\u3057\u305f");
                return false;
            }
            if (this.Setting.isFixCommentNum()) {
                back_comment = client.getBackCommentFromLength(back_comment);
            }
            this.sendtext("\u30b3\u30e1\u30f3\u30c8\u306e\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u958b\u59cb\u4e2d");
            this.CommentFile = client.getComment(this.CommentFile, this.Status, back_comment, this.Time, this.StopFlag);
            if (this.stopFlagReturn()) {
                return false;
            }
            if (this.CommentFile == null) {
                this.sendtext("\u30b3\u30e1\u30f3\u30c8\u306e\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u306b\u5931\u6557 " + client.getExtraError());
                return false;
            }
            this.sendtext("\u30b3\u30e1\u30f3\u30c8\u306e\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u7d42\u4e86");
            this.optionalThreadID = client.getOptionalThreadID();
            this.sendtext("\u30aa\u30d7\u30b7\u30e7\u30ca\u30eb\u30b9\u30ec\u30c3\u30c9\u306e\u4fdd\u5b58");
            if (this.optionalThreadID != null && !this.optionalThreadID.isEmpty()) {
                this.OptionalThreadFile = this.isCommentFixFileName() ? new File(folder, String.valueOf(this.VideoID) + this.VideoTitle + prefix + OPTIONAL_EXT) : this.getOptionalThreadFile(this.Setting.getCommentFile());
                this.sendtext("\u30aa\u30d7\u30b7\u30e7\u30ca\u30eb\u30b9\u30ec\u30c3\u30c9\u306e\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u958b\u59cb\u4e2d");
                this.OptionalThreadFile = client.getOptionalThread(this.OptionalThreadFile, this.Status, this.optionalThreadID, back_comment, this.Time, this.StopFlag);
                if (this.stopFlagReturn()) {
                    return false;
                }
                if (this.OptionalThreadFile == null) {
                    this.sendtext("\u30aa\u30d7\u30b7\u30e7\u30ca\u30eb\u30b9\u30ec\u30c3\u30c9\u306e\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u306b\u5931\u6557 " + client.getExtraError());
                    return false;
                }
                this.sendtext("\u30aa\u30d7\u30b7\u30e7\u30ca\u30eb\u30b9\u30ec\u30c3\u30c9\u306e\u4fdd\u5b58\u7d42\u4e86");
            }
        }
        this.sendtext("\u30b3\u30e1\u30f3\u30c8\u306e\u4fdd\u5b58\u7d42\u4e86");
        return true;
    }

    private File getOptionalThreadFile(File file) {
        String path = file.getPath();
        if (path == null) {
            return this.mkTemp(OPTIONAL_EXT);
        }
        int index = path.lastIndexOf(".");
        if (index > path.lastIndexOf(File.separator)) {
            path = path.substring(0, index);
        }
        return new File(String.valueOf(path) + OPTIONAL_EXT);
    }

    private boolean saveOwnerComment(NicoClient client) {
        this.sendtext("\u6295\u7a3f\u8005\u30b3\u30e1\u30f3\u30c8\u306e\u4fdd\u5b58");
        File folder = this.Setting.getCommentFixFileNameFolder();
        if (this.isSaveOwnerComment()) {
            if (this.isCommentFixFileName()) {
                if (folder.mkdir()) {
                    System.out.println("Folder created: " + folder.getPath());
                }
                if (!folder.isDirectory()) {
                    this.sendtext("\u6295\u7a3f\u8005\u30b3\u30e1\u30f3\u30c8\u306e\u4fdd\u5b58\u5148\u30d5\u30a9\u30eb\u30c0\u304c\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3002");
                    return false;
                }
                this.OwnerCommentFile = new File(folder, String.valueOf(this.VideoID) + this.VideoTitle + OWNER_EXT);
            } else {
                this.OwnerCommentFile = this.Setting.getOwnerCommentFile();
            }
            this.sendtext("\u6295\u7a3f\u8005\u30b3\u30e1\u30f3\u30c8\u306e\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u958b\u59cb\u4e2d");
            if (client == null) {
                this.sendtext("\u30ed\u30b0\u30a4\u30f3\u3057\u3066\u306a\u3044\u306e\u306b\u6295\u7a3f\u8005\u30b3\u30e1\u30f3\u30c8\u306e\u4fdd\u5b58\u306b\u306a\u308a\u307e\u3057\u305f");
                return false;
            }
            this.OwnerCommentFile = client.getOwnerComment(this.OwnerCommentFile, this.Status, this.StopFlag);
            if (this.stopFlagReturn()) {
                return false;
            }
            if (this.OwnerCommentFile == null) {
                this.sendtext("\u6295\u7a3f\u8005\u30b3\u30e1\u30f3\u30c8\u306e\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u306b\u5931\u6557");
                return false;
            }
            if (this.optionalThreadID == null || this.optionalThreadID.isEmpty()) {
                this.optionalThreadID = client.getOptionalThreadID();
            }
        }
        this.sendtext("\u6295\u7a3f\u8005\u30b3\u30e1\u30f3\u30c8\u306e\u4fdd\u5b58\u7d42\u4e86");
        return true;
    }

    private Path mkTemp(String uniq) {
        return Path.mkTemp(String.valueOf(this.Tag) + uniq);
    }

    private boolean convertComment() {
        this.sendtext("\u30b3\u30e1\u30f3\u30c8\u306e\u4e2d\u9593\u30d5\u30a1\u30a4\u30eb\u3078\u306e\u5909\u63db\u4e2d");
        File folder = this.Setting.getCommentFixFileNameFolder();
        if (this.isConvertWithComment()) {
            if (this.Setting.isAddTimeStamp() && this.isCommentFixFileName()) {
                ArrayList<String> pathlist = this.detectFilelistFromComment(folder);
                if (pathlist == null || pathlist.isEmpty()) {
                    this.sendtext(String.valueOf(this.Tag) + ": \u30b3\u30e1\u30f3\u30c8\u30d5\u30a1\u30a4\u30eb\u30fb\u904e\u53bb\u30ed\u30b0\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
                    return false;
                }
                if (pathlist.size() > 0) {
                    ArrayList<File> filelist = new ArrayList<File>();
                    for (String path : pathlist) {
                        filelist.add(new File(folder, path));
                    }
                    this.CommentFile = this.mkTemp(TMP_COMBINED_XML);
                    this.sendtext("\u30b3\u30e1\u30f3\u30c8\u30d5\u30a1\u30a4\u30eb\u7d50\u5408\u4e2d");
                    if (!CombineXML.combineXML(filelist, this.CommentFile)) {
                        this.sendtext("\u30b3\u30e1\u30f3\u30c8\u30d5\u30a1\u30a4\u30eb\u304c\u7d50\u5408\u51fa\u6765\u307e\u305b\u3093\u3067\u3057\u305f\uff08\u30d0\u30b0\uff1f\uff09");
                        return false;
                    }
                    this.listOfCommentFile = filelist;
                } else {
                    File comfile = new File(folder, pathlist.get(0));
                    if (this.isSaveComment()) {
                        ArrayList filelist = new ArrayList();
                        this.listOfCommentFile = filelist;
                    } else {
                        this.CommentFile = comfile;
                    }
                }
            }
            if (!this.isSaveComment()) {
                if (this.isCommentFixFileName()) {
                    if (!this.Setting.isAddTimeStamp()) {
                        String commentfilename = this.detectTitleFromComment(folder);
                        if (commentfilename == null) {
                            this.sendtext("\u30b3\u30e1\u30f3\u30c8\u30d5\u30a1\u30a4\u30eb\u304c\u30d5\u30a9\u30eb\u30c0\u306b\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
                            return false;
                        }
                        this.CommentFile = new File(folder, commentfilename);
                        if (!this.CommentFile.canRead()) {
                            this.sendtext("\u30b3\u30e1\u30f3\u30c8\u30d5\u30a1\u30a4\u30eb\u304c\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093\u3002");
                            return false;
                        }
                    }
                } else {
                    this.CommentFile = this.Setting.getCommentFile();
                    if (!this.CommentFile.exists()) {
                        this.sendtext("\u30b3\u30e1\u30f3\u30c8\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
                        return false;
                    }
                }
            }
            this.CommentMiddleFile = this.convertToCommentMiddle(this.CommentFile, this.mkTemp(TMP_COMMENT));
            if (this.CommentMiddleFile == null) {
                this.sendtext("\u30b3\u30e1\u30f3\u30c8\u5909\u63db\u306b\u5931\u6557\u3002\u304a\u305d\u3089\u304f\u6b63\u898f\u8868\u73fe\u306e\u9593\u9055\u3044\uff1f");
                return false;
            }
        }
        return true;
    }

    private boolean convertOprionalThread() {
        this.sendtext("\u30aa\u30d7\u30b7\u30e7\u30ca\u30eb\u30b9\u30ec\u30c3\u30c9\u306e\u4e2d\u9593\u30d5\u30a1\u30a4\u30eb\u3078\u306e\u5909\u63db\u4e2d");
        File folder = this.Setting.getCommentFixFileNameFolder();
        if (this.isConvertWithComment()) {
            if (this.Setting.isAddTimeStamp() && this.isCommentFixFileName()) {
                ArrayList<String> pathlist = this.detectFilelistFromOptionalThread(folder);
                if (pathlist == null || pathlist.isEmpty()) {
                    this.sendtext(String.valueOf(this.Tag) + ": \u30aa\u30d7\u30b7\u30e7\u30ca\u30eb\u30b9\u30ec\u30c3\u30c9\u30fb\u904e\u53bb\u30ed\u30b0\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
                    this.OptionalThreadFile = null;
                    return true;
                }
                if (pathlist.size() > 0) {
                    ArrayList<File> filelist = new ArrayList<File>();
                    for (String path : pathlist) {
                        filelist.add(new File(folder, path));
                    }
                    this.OptionalThreadFile = this.mkTemp(TMP_COMBINED_XML2);
                    this.sendtext("\u30aa\u30d7\u30b7\u30e7\u30ca\u30eb\u30b9\u30ec\u30c3\u30c9\u7d50\u5408\u4e2d");
                    if (!CombineXML.combineXML(filelist, this.OptionalThreadFile)) {
                        this.sendtext("\u30aa\u30d7\u30b7\u30e7\u30ca\u30eb\u30b9\u30ec\u30c3\u30c9\u304c\u7d50\u5408\u51fa\u6765\u307e\u305b\u3093\u3067\u3057\u305f\uff08\u30d0\u30b0\uff1f\uff09");
                        return false;
                    }
                    this.listOfCommentFile.addAll(filelist);
                }
            }
            if (!this.isSaveComment()) {
                if (this.isCommentFixFileName()) {
                    if (!this.Setting.isAddTimeStamp()) {
                        String commentfilename = this.detectTitleFromOptionalThread(folder);
                        if (commentfilename == null) {
                            this.sendtext("\u30aa\u30d7\u30b7\u30e7\u30ca\u30eb\u30b9\u30ec\u30c3\u30c9\u304c\u30d5\u30a9\u30eb\u30c0\u306b\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
                            this.OptionalThreadFile = null;
                            return true;
                        }
                        this.OptionalThreadFile = new File(folder, commentfilename);
                        if (!this.OptionalThreadFile.canRead()) {
                            this.sendtext("\u30aa\u30d7\u30b7\u30e7\u30ca\u30eb\u30b9\u30ec\u30c3\u30c9\u304c\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093\u3002");
                            return false;
                        }
                    }
                } else {
                    this.OptionalThreadFile = this.getOptionalThreadFile(this.Setting.getCommentFile());
                    if (!this.OptionalThreadFile.exists()) {
                        this.sendtext("\u30aa\u30d7\u30b7\u30e7\u30ca\u30eb\u30b9\u30ec\u30c3\u30c9\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
                        this.OptionalThreadFile = null;
                        return true;
                    }
                }
            }
            this.OptionalMiddleFile = this.convertToCommentMiddle(this.OptionalThreadFile, this.mkTemp(TMP_OPTIONALTHREAD));
            if (this.OptionalMiddleFile == null) {
                this.sendtext("\u30aa\u30d7\u30b7\u30e7\u30ca\u30eb\u30b9\u30ec\u30c3\u30c9\u5909\u63db\u306b\u5931\u6557\u3002\u304a\u305d\u3089\u304f\u6b63\u898f\u8868\u73fe\u306e\u9593\u9055\u3044\uff1f");
                return false;
            }
        }
        return true;
    }

    private boolean convertOwnerComment() {
        this.sendtext("\u6295\u7a3f\u8005\u30b3\u30e1\u30f3\u30c8\u306e\u4e2d\u9593\u30d5\u30a1\u30a4\u30eb\u3078\u306e\u5909\u63db\u4e2d");
        File folder = this.Setting.getCommentFixFileNameFolder();
        if (this.isConvertWithOwnerComment()) {
            if (!this.isSaveOwnerComment()) {
                if (this.isCommentFixFileName()) {
                    String ownerfilename = this.detectTitleFromOwnerComment(folder);
                    if (ownerfilename == null) {
                        this.sendtext("\u6295\u7a3f\u8005\u30b3\u30e1\u30f3\u30c8\u30d5\u30a1\u30a4\u30eb\u304c\u30d5\u30a9\u30eb\u30c0\u306b\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
                        return false;
                    }
                    this.OwnerCommentFile = new File(folder, ownerfilename);
                    if (!this.OwnerCommentFile.canRead()) {
                        this.sendtext("\u6295\u7a3f\u8005\u30b3\u30e1\u30f3\u30c8\u30d5\u30a1\u30a4\u30eb\u304c\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093\u3002");
                        return false;
                    }
                } else {
                    this.OwnerCommentFile = this.Setting.getOwnerCommentFile();
                    if (!this.OwnerCommentFile.exists()) {
                        this.sendtext("\u6295\u7a3f\u8005\u30b3\u30e1\u30f3\u30c8\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
                        return false;
                    }
                }
            }
            this.OwnerMiddleFile = this.convertToCommentMiddle(this.OwnerCommentFile, this.mkTemp(TMP_OWNERCOMMENT));
            if (this.OwnerMiddleFile == null) {
                this.sendtext("\u6295\u7a3f\u8005\u30b3\u30e1\u30f3\u30c8\u5909\u63db\u306b\u5931\u6557\u3002\u304a\u305d\u3089\u304f\u6b63\u898f\u8868\u73fe\u306e\u9593\u9055\u3044\uff1f");
                return false;
            }
        }
        return true;
    }

    private void deleteCommentFile() {
        if (this.CommentFile.delete()) {
            System.out.println("Deleted: " + this.CommentFile.getPath());
        }
        if (this.OptionalThreadFile != null && this.OptionalThreadFile.delete()) {
            System.out.println("Deleted: " + this.OptionalThreadFile.getPath());
        }
        this.deleteList(this.listOfCommentFile);
        if (this.OwnerCommentFile != null && this.OwnerCommentFile.delete()) {
            System.out.println("Deleted: " + this.OwnerCommentFile.getPath());
        }
    }

    private File convertToCommentMiddle(File commentfile, File middlefile) {
        if (!ConvertToVideoHook.convert(commentfile, middlefile, this.Setting.getNG_ID(), this.Setting.getNG_Word())) {
            return null;
        }
        return middlefile;
    }

    private boolean convertVideo() throws IOException {
        this.sendtext("\u52d5\u753b\u306e\u5909\u63db\u3092\u958b\u59cb");
        this.Stopwatch.start();
        File folder = this.Setting.getConvFixFileNameFolder();
        if (!this.chekAspectVhookOption(this.VideoFile, this.wayOfVhook)) {
            return false;
        }
        if (this.Setting.isConvFixFileName()) {
            if (folder.mkdir()) {
                System.out.println("Created folder: " + folder.getPath());
            }
            if (!folder.isDirectory()) {
                this.sendtext("\u5909\u63db\u5f8c\u306e\u4fdd\u5b58\u5148\u30d5\u30a9\u30eb\u30c0\u304c\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3002");
                return false;
            }
            String conv_name = this.VideoTitle;
            if (conv_name == null) {
                conv_name = "";
            }
            if (!this.Setting.isNotAddVideoID_Conv()) {
                conv_name = String.valueOf(this.VideoID) + conv_name;
            }
            if (conv_name.isEmpty()) {
                this.sendtext("\u5909\u63db\u5f8c\u306e\u30d3\u30c7\u30aa\u30d5\u30a1\u30a4\u30eb\u540d\u304c\u78ba\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002");
                return false;
            }
            if (this.Setting.isAddOption_ConvVideoFile()) {
                byte[] dirName = new File(folder, conv_name).getAbsolutePath().getBytes("Shift_JIS");
                if (dirName.length > 243) {
                    conv_name = this.VideoID;
                }
                if ((folder = new File(folder, conv_name = conv_name.trim())).mkdir()) {
                    System.out.println("Created folder: " + folder.getPath());
                }
                if (!folder.isDirectory()) {
                    this.sendtext("\u52d5\u753b(FFmpeg\u8a2d\u5b9a\u540d)\u30d5\u30a1\u30a4\u30eb\u306e\u4fdd\u5b58\u5148\u30d5\u30a9\u30eb\u30c0\u304c\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3002");
                    return false;
                }
                conv_name = String.valueOf(this.MainOption) + this.InOption + this.OutOption;
                if (!this.getFFmpegVfOption().isEmpty()) {
                    conv_name = "-vfilters " + this.getFFmpegVfOption() + conv_name;
                }
                if ((dirName = new File(folder, conv_name = String.valueOf(this.getFFmpegOptionName()) + Converter.safeAsciiFileName(conv_name)).getAbsolutePath().getBytes("Shift_JIS")).length > 252) {
                    int len = conv_name.length() - (dirName.length - 252);
                    if (len < 1) {
                        this.sendtext("\u4f5c\u6210\u3059\u308b\u30d3\u30c7\u30aa\u30d5\u30a1\u30a4\u30eb\u540d\u304c\u9577\u3059\u304e\u307e\u3059\u3002");
                        return false;
                    }
                    conv_name = conv_name.substring(0, len);
                }
                conv_name = conv_name.trim();
            }
            this.ConvertedVideoFile = new File(folder, String.valueOf(conv_name) + this.ExtOption);
        } else {
            String filename = this.Setting.getConvertedVideoFile().getPath();
            if (!filename.endsWith(this.ExtOption)) {
                filename = String.valueOf(filename.substring(0, filename.lastIndexOf(46))) + this.ExtOption;
                this.ConvertedVideoFile = new File(filename);
            } else {
                this.ConvertedVideoFile = this.Setting.getConvertedVideoFile();
            }
        }
        if (this.ConvertedVideoFile.getAbsolutePath().equals(this.VideoFile.getAbsolutePath())) {
            this.sendtext("\u5909\u63db\u5f8c\u306e\u30d5\u30a1\u30a4\u30eb\u540d\u304c\u5909\u63db\u524d\u3068\u540c\u3058\u3067\u3059");
            return false;
        }
        int code = this.converting_video();
        this.Stopwatch.stop();
        if (code == 0) {
            this.sendtext("\u5909\u63db\u304c\u6b63\u5e38\u306b\u7d42\u4e86\u3057\u307e\u3057\u305f\u3002");
            System.out.println(this.ffmpeg.getLastFrame());
            return true;
        }
        if (code != 100) {
            this.sendtext("\u5909\u63db\u30a8\u30e9\u30fc\uff1a" + this.ffmpeg.getLastError());
        }
        return false;
    }

    private static String safeAsciiFileName(String str) {
        str = str.replace('/', '_').replace('\\', '_').replace('?', '_').replace('*', '_').replace(':', ';').replace('|', '_').replace('\"', '\'').replace('<', '(').replace('>', ')').replaceAll(" +", " ").trim();
        return str;
    }

    @Override
    public void run() {
        try {
            this.Stopwatch.clear();
            this.Stopwatch.start();
            if (!this.checkOK()) {
                return;
            }
            NicoClient client = this.getNicoClient();
            if (client != null) {
                if (!client.isLoggedIn()) {
                    return;
                }
                if (!client.getVideoInfo(this.Tag, this.WatchInfo, this.Time)) {
                    this.sendtext(String.valueOf(this.Tag) + "\u306e\u60c5\u5831\u306e\u53d6\u5f97\u306b\u5931\u6557 " + client.getExtraError());
                    return;
                }
                if (this.stopFlagReturn()) {
                    return;
                }
                this.VideoTitle = client.getVideoTitle();
                this.sendtext(String.valueOf(this.Tag) + "\u306e\u60c5\u5831\u306e\u53d6\u5f97\u306b\u6210\u529f");
            }
            this.Stopwatch.show();
            if (!this.saveVideo(client) || this.stopFlagReturn()) {
                return;
            }
            this.Stopwatch.show();
            if (!this.saveComment(client) || this.stopFlagReturn()) {
                return;
            }
            this.Stopwatch.show();
            if (!this.saveOwnerComment(client) || this.stopFlagReturn()) {
                return;
            }
            this.Stopwatch.show();
            System.out.println("\u5909\u63db\u524d\u6642\u9593\u3000" + this.Stopwatch.formatElapsedTime());
            if (!this.isSaveConverted()) {
                this.sendtext("\u52d5\u753b\u30fb\u30b3\u30e1\u30f3\u30c8\u3092\u4fdd\u5b58\u3057\u3001\u5909\u63db\u306f\u884c\u3044\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
                return;
            }
            this.Stopwatch.show();
            if (!this.convertComment() || this.stopFlagReturn()) {
                return;
            }
            this.Stopwatch.show();
            if (!this.convertOwnerComment() || this.stopFlagReturn()) {
                return;
            }
            this.Stopwatch.show();
            if (!this.convertOprionalThread() || this.stopFlagReturn()) {
                return;
            }
            try {
                this.Stopwatch.show();
                if (this.convertVideo()) {
                    if (this.isDeleteCommentAfterConverting() && this.CommentFile != null) {
                        this.deleteCommentFile();
                    }
                    if (this.isDeleteVideoAfterConverting() && this.VideoFile != null && this.VideoFile.delete()) {
                        System.out.println("Deleted: " + this.VideoFile.getPath());
                    }
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        finally {
            this.StopFlag.finished();
            if (this.CommentMiddleFile != null && this.CommentMiddleFile.delete()) {
                System.out.println("Deleted: " + this.CommentMiddleFile.getPath());
            }
            if (this.OwnerMiddleFile != null && this.OwnerMiddleFile.delete()) {
                System.out.println("Deleted: " + this.OwnerMiddleFile.getPath());
            }
            this.Stopwatch.show();
            this.Stopwatch.stop();
            System.out.println("\u5909\u63db\u6642\u9593\u3000" + this.Stopwatch.formatLatency());
            System.out.println("LastStatus: " + this.Status.getText());
            System.out.println("VideoInfo: " + this.MovieInfo.getText());
        }
    }

    private void deleteList(ArrayList<File> list) {
        if (list == null) {
            return;
        }
        boolean b = true;
        for (File file : list) {
            boolean bl = b = file.delete() && b;
        }
        if (!b) {
            System.out.println("Can't delete list of all Comment.");
        }
    }

    private boolean chekAspectVhookOption(File video, int way) {
        String str;
        this.fwsFile = null;
        try {
            this.fwsFile = Cws2Fws.createFws(video);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.fwsFile != null) {
            this.VideoFile = this.fwsFile;
            video = this.fwsFile;
        }
        this.videoAspect = this.ffmpeg.getAspect(video);
        if (this.videoAspect == null) {
            str = "Analize Error   ";
            this.videoAspect = FFmpeg.Aspect.NORMAL;
        } else {
            str = String.valueOf(this.videoAspect.explain()) + "  ";
        }
        if (way == 1) {
            if (this.VhookNormal == null) {
                if (!this.videoAspect.isWide()) {
                    str = "\u2260" + str;
                }
                this.videoAspect = FFmpeg.Aspect.WIDE;
            } else {
                if (this.videoAspect.isWide()) {
                    str = "\u2260" + str;
                }
                this.videoAspect = FFmpeg.Aspect.NORMAL;
            }
        }
        if (this.videoAspect.isWide()) {
            this.selectedVhook = this.VhookWide;
            this.MovieInfo.setText("\u62e1\u5f35Vhook \u30ef\u30a4\u30c9 " + str);
        } else {
            this.selectedVhook = this.VhookNormal;
            this.MovieInfo.setText("\u62e1\u5f35Vhook \u5f93\u6765 " + str);
        }
        if (!this.detectOption(this.videoAspect.isWide())) {
            this.sendtext("\u5909\u63db\u30aa\u30d7\u30b7\u30e7\u30f3\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            return false;
        }
        return true;
    }

    private int converting_video() {
        int code = -1;
        this.ffmpeg.setCmd("-y ");
        this.ffmpeg.addCmd(this.MainOption);
        this.ffmpeg.addCmd(" ");
        this.ffmpeg.addCmd(this.InOption);
        this.ffmpeg.addCmd(" -i ");
        this.ffmpeg.addFile(this.VideoFile);
        this.ffmpeg.addCmd(" ");
        this.ffmpeg.addCmd(this.OutOption);
        if (!this.Setting.isVhookDisabled()) {
            if (!this.addVhookSetting(this.ffmpeg, this.selectedVhook, this.videoAspect.isWide())) {
                return -1;
            }
        } else if (!this.getFFmpegVfOption().isEmpty()) {
            this.ffmpeg.addCmd(" -vfilters ");
            this.ffmpeg.addCmd(this.getFFmpegVfOption());
        }
        this.ffmpeg.addCmd(" ");
        this.ffmpeg.addFile(this.ConvertedVideoFile);
        System.out.println("arg:" + this.ffmpeg.getCmd());
        code = this.ffmpeg.exec(this.Status, 100, this.StopFlag, this.Stopwatch);
        return code;
    }

    private boolean addVhookSetting(FFmpeg ffmpeg, File vhookExe, boolean isWide) {
        try {
            ffmpeg.addCmd(" -vfilters \"");
            if (!this.getFFmpegVfOption().isEmpty()) {
                ffmpeg.addCmd(this.getFFmpegVfOption());
                ffmpeg.addCmd(",");
            }
            ffmpeg.addCmd("vhext=");
            ffmpeg.addFile(vhookExe);
            ffmpeg.addCmd("|");
            if (this.CommentMiddleFile != null) {
                ffmpeg.addCmd("--data-user:");
                ffmpeg.addCmd(URLEncoder.encode(Path.toUnixPath(this.CommentMiddleFile), "Shift_JIS"));
                ffmpeg.addCmd("|");
            }
            if (this.OwnerMiddleFile != null) {
                ffmpeg.addCmd("--data-owner:");
                ffmpeg.addCmd(URLEncoder.encode(Path.toUnixPath(this.OwnerMiddleFile), "Shift_JIS"));
                ffmpeg.addCmd("|");
                ffmpeg.addCmd("--show-owner:1000|");
            }
            if (this.OptionalMiddleFile != null) {
                ffmpeg.addCmd("--data-optional:");
                ffmpeg.addCmd(URLEncoder.encode(Path.toUnixPath(this.OptionalMiddleFile), "Shift_JIS"));
                ffmpeg.addCmd("|");
            }
            ffmpeg.addCmd("--font:");
            ffmpeg.addCmd(URLEncoder.encode(Path.toUnixPath(this.Setting.getFontPath()), "Shift_JIS"));
            ffmpeg.addCmd("|--font-index:");
            ffmpeg.addCmd(this.Setting.getFontIndex());
            ffmpeg.addCmd("|--show-user:");
            ffmpeg.addCmd(this.Setting.getVideoShowNum());
            ffmpeg.addCmd("|--show-optional:");
            ffmpeg.addCmd(this.Setting.getVideoShowNum());
            if (this.Setting.isOptionalTranslucent()) {
                ffmpeg.addCmd("|--optional-translucent");
            }
            ffmpeg.addCmd("|--shadow:" + this.Setting.getShadowIndex());
            if (this.Setting.isVhook_ShowConvertingVideo()) {
                ffmpeg.addCmd("|--enable-show-video");
            }
            if (this.Setting.isFixFontSize()) {
                ffmpeg.addCmd("|--enable-fix-font-size");
            }
            if (this.Setting.isOpaqueComment()) {
                ffmpeg.addCmd("|--enable-opaque-comment");
            }
            if (isWide) {
                ffmpeg.addCmd("|--nico-width-wide");
            }
            ffmpeg.addCmd("|\"");
            return true;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isConverted() {
        return this.StopFlag.isConverted();
    }

    private boolean stopFlagReturn() {
        if (this.StopFlag.needStop()) {
            this.sendtext("\u4e2d\u6b62\u3057\u307e\u3057\u305f\u3002");
            return true;
        }
        return false;
    }

    public ConvertStopFlag getStopFlag() {
        return this.StopFlag;
    }

    boolean detectOption(boolean isWide) {
        File option_file = null;
        option_file = !isWide ? this.Setting.getOptionFile() : this.Setting.getWideOptionFile();
        if (option_file != null) {
            block7: {
                try {
                    Properties prop = new Properties();
                    prop.loadFromXML(new FileInputStream(option_file));
                    this.ExtOption = prop.getProperty("EXT");
                    this.InOption = prop.getProperty("IN");
                    this.OutOption = prop.getProperty("OUT");
                    this.MainOption = prop.getProperty("MAIN");
                    if (this.ExtOption != null && this.InOption != null && this.OutOption != null && this.MainOption != null) break block7;
                    return false;
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    return false;
                }
            }
            this.ffmpegOptionName = option_file.getName().replace(".xml", "");
        }
        if (!isWide) {
            this.ExtOption = this.Setting.getCmdLineOptionExt();
            this.InOption = this.Setting.getCmdLineOptionIn();
            this.OutOption = this.Setting.getCmdLineOptionOut();
            this.MainOption = this.Setting.getCmdLineOptionMain();
        } else {
            this.ExtOption = this.Setting.getWideCmdLineOptionExt();
            this.InOption = this.Setting.getWideCmdLineOptionIn();
            this.OutOption = this.Setting.getWideCmdLineOptionOut();
            this.MainOption = this.Setting.getWideCmdLineOptionMain();
        }
        if (this.ExtOption != null && !this.ExtOption.startsWith(".")) {
            this.ExtOption = "." + this.ExtOption;
        }
        this.ffmpegVfOption = this.getvfOption();
        return true;
    }

    private String getvfOption() {
        String vfIn = this.getvfOption(this.InOption);
        this.InOption = this.deletevfOption(this.InOption, vfIn);
        String vfOut = this.getvfOption(this.OutOption);
        this.OutOption = this.deletevfOption(this.OutOption, vfOut);
        String vfMain = this.getvfOption(this.MainOption);
        this.MainOption = this.deletevfOption(this.MainOption, vfMain);
        if (vfIn.isEmpty()) {
            vfIn = vfMain;
        } else if (!vfMain.isEmpty()) {
            vfIn = String.valueOf(vfIn) + "," + vfMain;
        }
        if (vfIn.isEmpty()) {
            vfIn = vfOut;
        } else if (!vfOut.isEmpty()) {
            vfIn = String.valueOf(vfIn) + "," + vfOut;
        }
        return vfIn;
    }

    private String getvfOption(String option) {
        if (option == null) {
            return "";
        }
        int index = option.indexOf(VFILTER_FLAG);
        if (index < 0) {
            return "";
        }
        option = option.substring(index + VFILTER_FLAG.length());
        index = (option = option.trim()).indexOf(" ");
        if (index < 0) {
            return option;
        }
        option = option.substring(0, index);
        return option;
    }

    private String deletevfOption(String option, String vfoption) {
        if (option == null) {
            return "";
        }
        return option.replace(VFILTER_FLAG, "").replace(vfoption, "").replaceAll(" +", " ");
    }

    public String getInOption() {
        return this.InOption;
    }

    public String getFFmpegOptionName() {
        return this.ffmpegOptionName;
    }

    public String getFFmpegVfOption() {
        return this.ffmpegVfOption;
    }

    private void setVideoTitleIfNull(String path) {
        if (this.VideoTitle == null) {
            this.VideoTitle = this.getTitleFromPath(path, this.VideoID);
            int index = this.VideoTitle.lastIndexOf("[");
            if (index >= 0) {
                this.VideoTitle = this.VideoTitle.substring(0, index);
            }
        }
    }

    String detectTitleFromVideo(File dir) {
        if (dir == null) {
            return null;
        }
        String[] list = dir.list(this.DefaultVideoIDFilter);
        if (list == null) {
            return null;
        }
        int i = 0;
        while (i < list.length) {
            if (list[i].startsWith(this.VideoID)) {
                String path = list[i];
                if (!path.endsWith(".flv")) {
                    this.OtherVideo = path;
                } else {
                    this.setVideoTitleIfNull(path);
                    return path;
                }
            }
            ++i;
        }
        return null;
    }

    private String detectTitleFromComment(File dir) {
        String[] list = dir.list(this.DefaultVideoIDFilter);
        if (list == null) {
            return null;
        }
        int i = 0;
        while (i < list.length) {
            String path = list[i];
            if (path.endsWith(".xml") && !path.endsWith(OWNER_EXT) && !path.endsWith(OPTIONAL_EXT)) {
                this.setVideoTitleIfNull(path);
                return path;
            }
            ++i;
        }
        return null;
    }

    private String detectTitleFromOwnerComment(File dir) {
        String[] list = dir.list(this.DefaultVideoIDFilter);
        if (list == null) {
            return null;
        }
        int i = 0;
        while (i < list.length) {
            block7: {
                String ext;
                String path;
                block6: {
                    block5: {
                        path = list[i];
                        if (!path.endsWith(OWNER_EXT)) break block5;
                        ext = OWNER_EXT;
                        break block6;
                    }
                    if (!path.endsWith(TCOMMENT_EXT)) break block7;
                    ext = TCOMMENT_EXT;
                }
                this.setVideoTitleIfNull(path.replace(ext, ""));
                return path;
            }
            ++i;
        }
        return null;
    }

    private String detectTitleFromOptionalThread(File dir) {
        String[] list = dir.list(this.DefaultVideoIDFilter);
        if (list == null) {
            return null;
        }
        int i = 0;
        while (i < list.length) {
            String path = list[i];
            if (path.endsWith(OPTIONAL_EXT)) {
                this.setVideoTitleIfNull(path.replace(OPTIONAL_EXT, ""));
                return path;
            }
            ++i;
        }
        return null;
    }

    private ArrayList<String> detectFilelistFromComment(File dir) {
        String[] list = dir.list(this.DefaultVideoIDFilter);
        if (list == null) {
            return null;
        }
        ArrayList<String> filelist = new ArrayList<String>();
        String[] stringArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            if (path.endsWith(".xml") && !path.endsWith(OWNER_EXT) && !path.endsWith(OPTIONAL_EXT)) {
                this.setVideoTitleIfNull(path);
                filelist.add(path);
            }
            ++n2;
        }
        return filelist;
    }

    private ArrayList<String> detectFilelistFromOptionalThread(File dir) {
        String[] list = dir.list(this.DefaultVideoIDFilter);
        if (list == null) {
            return null;
        }
        ArrayList<String> filelist = new ArrayList<String>();
        String[] stringArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            if (path.endsWith(OPTIONAL_EXT)) {
                this.setVideoTitleIfNull(path.replace(OPTIONAL_EXT, ""));
                filelist.add(path);
            }
            ++n2;
        }
        return filelist;
    }

    private String getTitleFromPath(String path, String videoID) {
        if (path.indexOf(videoID) >= 0) {
            path = path.replace(videoID, "");
        }
        if (path.lastIndexOf(".") > path.lastIndexOf(File.separator)) {
            path = path.substring(0, path.lastIndexOf("."));
        }
        return path;
    }

    private static class VideoIDFilter
    implements FilenameFilter {
        private final String VideoTag;

        public VideoIDFilter(String videoTag) {
            this.VideoTag = videoTag;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.indexOf(this.VideoTag) >= 0;
        }
    }
}

