<?php
/**
 * フォーム入力確認 Class
 *	validation.php


 * 更新履歴列記
    param_項目名を"_”を変更できるようにした。 
	Validationメッソドの第3引数に指定する
	function Validation($validation_ini_file, $action_name,$separator_str="_") 

 *	◆ 使用方法
 *		1. Validation クラスを宣言
 *		2. $class->start() で確認処理開始
 *	
 *	◆ 確認ロジック
 *		FORMの変数で下記のような項目に対し
 *			<INPUT TYPE="text"   NAME="param">
 *		Validation.ini ファイルにて
 *          param_No     = 一括エラー表示時の表示順（010, 020 などにより定義）、未定義時は "param"値となる
 *			param_TITLE	 = エラー画面に表示するタイトル
 *			param_CHECK	 = 入力規則（正規表現、専用規則）
 *			param_LENGTH = 最大文字列長
 *          param_GLUE   = 配列変数の場合に連結させる文字
 *          param_MESSAGE= 出力するエラーメッセージ
 *			
 *		param の入力された内容に対し param_CHECK で指定した内容でチェックを行う
 *		チェック内容にしたがった内容でない場合は、エラーとする
 *			param_TITLE値 --> エラーメッセージ（変数で定義）
 *
 *  ◆ エラーについて
 *     チェックに引っかかったエラーは配列で返却される
 *         array(errNo => array("title"     => エラー項目名
 *                             ,"message"   => エラーメッセージ
 *                             ,"err_value" => エラーとなった値)
 *               ..... 
 *     を戻り値として返す
 *	
 *	◆ 入力指定内容以外・例外的な特別方法でのチェック
 *		● 定義済みの入力チェック内容
 *			param_CHECK が以下であると定義済み方法でチェックを行う
 *			is_ がついているときに定義済みのチェック方法として認識する
 *			is_number: 数値チェック ^[0-9.]+$
 *			is_email:  Email        ^[a-zA-Z0-9_.-][a-zA-Z0-9_.-]+@[a-zA-Z0-9_-]+(\.[a-zA-Z0-9_-]+)+$"
 *			is_date:   日付の妥当性チェック
 *				date の場合は
 *				param_year,param_month,param_day の３セットがあると仮定して
 *				それらから日付チェックを行う
 *			is_zip, is_tel: 		^[0-9-]+\$
 *		● 確認入力チェック
 *			<INPUT TYPE="text" NAME="para,_COMPARE">  <-- 確認入力をするフィールド
 *			上記が定義されている場合（param_CHECK にエラーがない場合で）に
 *			param と param_COMPARE の値が一致しているかどうかをチェックする
 *		● 入力チェック内容を個別に定義したい場合
 *			function check_item_extra() 関数を使用
 *			
 *			クラスをオーバーライドして定義する：
 *			class CLASS_NAME extends confirm{
 *				fnction check_item_extra（）{
 *					ここにチェック内容を定義する
 *				}
 *			}

 */
class Validation {
	/** 入力チェックをするアクション名 */
	var $_action_name;

	/** 入力チェック定義がされている設定ファイル */
	var $_validation_ini_file;
	/**                  */
	var $separator ="_";


	// 入力エラー時のエラー画面に表示するための suffix
	var $suffix_no      = "NO";       // 項目名
	var $suffix_title   = "TITLE";    // 項目名
	var $suffix_check   = "CHECK";    // チェック方法
	var $suffix_compare = "COMPARE";  // 比較チェック
	var $suffix_length  = "LENGTH";   // 項目長のチェック
	var $suffix_glue    = "GLUE";     // フォームパラメータが配列の場合、それを連結する文字列
    var $suffix_message = "MESSAGE";  // エラーメッセージ
	var $suffix_date    = "DATE";     // 日付入力チェックを行う項目の suffix
	var $suffix_year    = "Year";     // 日付表記の "年"
	var $suffix_month   = "Month";    // 日付表記の "月"
	var $suffix_day     = "Day";      // 日付表記の "日"

	// 入力チェック定義
	var $is_number = "^[0-9.]+\$"; // 数値
	var $is_email = "^[a-zA-Z0-9_.-][a-zA-Z0-9_.-]+@[a-zA-Z0-9_-]+(\.[a-zA-Z0-9_-]+)+\$";
	var $is_url   = "^(http|https|ftp):(\/\/[-_.!~*\'()a-zA-Z0-9;\/?:\@&=+\$,%#]+)+\$";

	var $is_date = ""; // 日付の場合は xxxx_DATE_CHECK を対象とする
	var $is_zip = "^[0-9-]+\$"; // 数値
	var $is_tel = "^[0-9-\(\)]+\$"; // 数値
	var $is_not_null = "^.+"; // 空以外
	
	// エラーメッセージ
/*
	var $ERROR_MSG_ESSENTIAL = "必須入力です。"; // 必須入力エラー
	var $ERROR_MSG_PATERN = "入力内容に誤りがあるか、入力されていません。"; // 指定された内容と違う場合
	var $ERROR_MSG_PATERN1 = "入力形式に誤りがあるります。"; // 指定された内容と違う場合
	var $ERROR_MSG_COMPARE = "確認入力をしたものと異なっています。"; // 確認入力チェック
	var $ERROR_MSG_LENGTH = "入力した文字数が規定より長すぎます。"; // 確認入力チェック
	var $ERROR_MSG_MIN_LEN = "入力した文字数が規定より短すぎます。"; // 確認入力チェック
*/
	var $ERROR_MSG_ESSENTIAL = ""; // 必須入力エラー
	var $ERROR_MSG_PATERN = ""; // 指定された内容と違う場合
	var $ERROR_MSG_PATERN1 = ""; // 指定された内容と違う場合
	var $ERROR_MSG_COMPARE = ""; // 確認入力チェック
	var $ERROR_MSG_LENGTH = ""; // 確認入力チェック
	var $ERROR_MSG_MIN_LEN = ""; // 確認入力チェック

	// その他
	var $ERROR_NOERROR = 0;
	var $ERROR_ESSENTIAL = 1; // 必須入力エラー
	var $ERROR_PATERN = 2; // 指定された入力エラー
	var $ERROR_COMPARE = 3; // 比較入力エラー
	var $ERROR_LENGTH = 4; // 入力長エラー

	var $ERROR_CLASS = "warning_text";

	var $_conf; // 入力チェック内容の配列の格納

	/**
	 * コンストラクタ
	 */
	function Validation($validation_ini_file, $action_name,$separator_str="_") {
		// 実行するアクションをローカルの変数に取得
		$this->_action_name = $action_name;
		$this->_validation_ini_file = $validation_ini_file;
		$this->separator = $separator_str;
		// 入力エラー時のエラー画面に表示するための suffix
		$this->suffix_no      = $this->separator."NO";       // 項目名
		$this->suffix_title   = $this->separator."TITLE";    // 項目名
		$this->suffix_check   = $this->separator."CHECK";    // チェック方法
		$this->suffix_compare = $this->separator."COMPARE";  // 比較チェック
		$this->suffix_length  = $this->separator."LENGTH";   // 項目長のチェック
		$this->suffix_glue    = $this->separator."GLUE";     // フォームパラメータが配列の場合、それを連結する文字列
    	$this->suffix_message = $this->separator."MESSAGE";  // エラーメッセージ
		$this->suffix_date    = $this->separator."DATE";     // 日付入力チェックを行う項目の suffix
		$this->suffix_year    = $this->separator."Year";     // 日付表記の "年"
		$this->suffix_month   = $this->separator."Month";    // 日付表記の "月"
		$this->suffix_day     = $this->separator."Day";      // 日付表記の "日"


	}

	/**
	 * 確認入力チェックの開始
	 *
	 */
	function getInstance($validation_ini_file, $action_name,$separator_str="_") {
		// 実行するアクションをローカルの変数に取得
		$this->_action_name = $action_name;
		$this->_validation_ini_file = $validation_ini_file;
		$this->separator = $separator_str;
		// 入力エラー時のエラー画面に表示するための suffix
		$this->suffix_no      = $this->separator."NO";       // 項目名
		$this->suffix_title   = $this->separator."TITLE";    // 項目名
		$this->suffix_check   = $this->separator."CHECK";    // チェック方法
		$this->suffix_compare = $this->separator."COMPARE";  // 比較チェック
		$this->suffix_length  = $this->separator."LENGTH";   // 項目長のチェック
		$this->suffix_glue    = $this->separator."GLUE";     // フォームパラメータが配列の場合、それを連結する文字列
    	$this->suffix_message = $this->separator."MESSAGE";  // エラーメッセージ
		$this->suffix_date    = $this->separator."DATE";     // 日付入力チェックを行う項目の suffix
		$this->suffix_year    = $this->separator."Year";     // 日付表記の "年"
		$this->suffix_month   = $this->separator."Month";    // 日付表記の "月"
		$this->suffix_day     = $this->separator."Day";      // 日付表記の "日"

		$ret = $this->start();
		
		return $ret;
	}

	function start() {
		// 設定ファイルの内容を読み込みアクションの内容だけを $_conf へ格納
		$conf_all = parse_ini_file($this->_validation_ini_file, true);
		$this->_conf = $conf_all[$this->_action_name];

		$ary_error = $this->checkItem(); // チェック内容を配列に設定

		return $ary_error;
	}

	/**
	 * 入力定義に沿ったチェックを行う
	 *
	 */
	function checkItem() {
		$error_general = $this->checkItemGeneral(); // 規定チェック
		$error_extra = $this->checkItemExtra(); // その他のチェック（Class オーバーライドによる）

		//$error_fields = array_merge($error_general, $error_extra); // PHP4の関数
		$error_fields = $error_general + $error_extra;
		$error_fielss = ksort($error_fields);

		return $error_fields;
	}

	/**
	 * 一般的なチェック方法
	 *
	 */
	function checkItemGeneral() {
		$error_fields = array();
		$form_parameter = array_merge($_GET, $_POST);

		// 送信された値に対する入力チェックを行う
		foreach ($form_parameter as $item_name => $check_value) {
			$error = $this->ERROR_NOERROR; // 初期：エラー無し

			// xxxx_year のような項目が見つかったときの
			// xxxx_month, xxxx_day も存在する場合は日付項目と判断し入力チェックを行う
			if (preg_match("/".$this->suffix_year."$/", $item_name)) {
				$key_name = preg_replace("/".$this->suffix_year."$/", "", $item_name);
				if (isset($form_parameter[$key_name.$this->suffix_month]) and isset($form_parameter[$key_name.$this->suffix_day])) {
					$item_name = $key_name;
				}
			}

			// 項目のタイトルの取得
			if (empty($this->_conf[$item_name.$this->suffix_title])) {
				$item_title = $item_name;
			} else {
				$item_title = $this->_conf[$item_name.$this->suffix_title];
			}

			// 入力チェック規則が定義されていないときは次の項目をチェックする
			if (!empty($this->_conf[$item_name.$this->suffix_check])) {
				// 1. 入力規則チェックの実行
				list ($error, $check_value) = $this->checkItemInput($item_name);
			}
			if ($error == 0 and isset($form_parameter[$item_name.$this->suffix_compare])) {
				// 2. 比較入力チェックの実行
				list ($error, $check_value) = $this->checkItemCompare($item_name);
			}

			// 文字列長のチェックはいずれにせよ行う
			// 文字列長チェックが指定されているときにチェック 
			if ($error == 0 and !empty($this->_conf[$item_name.$this->suffix_length])) {
				list ($error, $check_value) = $this->checkItemLength($item_name);
			}

			// エラーが発生した場合は $error_fielsd配列に TITLE, エラーメッセージを格納する
            // エラーが発生しなかった場合は、次の項目チェックに進む
			if ($error == $this->ERROR_NOERROR) {
				continue;

			} elseif ($error == $this->ERROR_ESSENTIAL) { // Normalなエラーのとき（必須入力）
                // ノーマルエラー時は、定義エラーメッセージを表示する
                $error_message = $this->_conf[$item_name.$this->suffix_message] .$this->ERROR_MSG_ESSENTIAL; 

			} elseif ($error == $this->ERROR_PATERN) { // 入力方法指定のエラー
                // 入力方法指定のエラー時は、定義エラーメッセージを表示する
                $error_message = $this->_conf[$item_name.$this->suffix_message].$this->ERROR_MSG_PATERN ;

			} elseif ($error == $this->ERROR_LENGTH) { // 入力文字列長エラー
                // 入力文字列長エラー時は、定義エラーメッセージを表示する
                $error_message = $this->_conf[$item_name.$this->suffix_message] .$this->ERROR_MSG_LENGTH ;
            
            } elseif ($error == $this->ERROR_COMPARE) { // 比較入力エラー
                $error_message = $this->ERROR_MSG_COMPARE;

			}
            //$error_message .= empty($error_message) ? "" : "<BR>\n";

            /*
			if ($check_value != "") {
				$error_message = $check_value."<BR>$error_message";
			}
            */
            
            // エラー内容を配列に追加する
            $err_index = empty($this->_conf[$item_name.$this->suffix_no]) ? $item_name : $this->_conf[$item_name.$this->suffix_no];
			$error_fields[$err_index] = 
                    array( 
                           "key"       => $item_name
                         , "title"     => $item_title
                         , "message"   => $error_message
                         , "err_value" => $check_value
                         , "err_class" => $this->ERROR_CLASS
                         );

		}

		return $error_fields;
	}

	/**
	 * 専用のチェック機能（extends して使うべし）
	 *
	 */
	function checkItemExtra() {
		$formparameter = array_merge($_GET, $_POST);
		$error_fields = array();
		//===== here extends 

		return $error_fields;
	}

	/**
	 * 入力チェックの実行
	 * 
	 * 
	 */
	function checkItemInput($item_name) {
		////extract($this->query_string);
		$form_parameter = array_merge($_GET, $_POST); // POST, GET変数の順に配列を連結

		// "check_value"という変数に値を格納
		$check_value = $form_parameter[$item_name];
		$check_rule = $this->_conf[$item_name.$this->suffix_check];

		// フォームパラメーターが配列の場合は連結
		// TODO GLUEが未定義の場合は連結しない方がいいか？
		if (is_array($check_value)) {
			$check_value = implode($this->_conf[$item_name.$this->suffix_glue], $check_value);
		}

		if ($check_rule == "is_date") {
			// ■ 日付入力チェック
			// 年月日の項目名を定義する
			$fp_name_year = $form_parameter[$item_name.$this->suffix_year]; // 年月日の項目名を定義
			$fp_name_month = $form_parameter[$item_name.$this->suffix_month];
			$fp_name_day = $form_parameter[$item_name.$this->suffix_day];

			$check_value = $fp_name_year."-".$fp_name_month."-".$fp_name_day;
			if (!checkdate($fp_name_month, $fp_name_day, $fp_name_year)) {
				return array($this->ERROR_PATERN, $check_value);
			}

		}
		elseif ($check_rule == "is_zip" OR $check_rule == "is_tel") {
			// ■ 電話番号、郵便番号チェック(xxx-xxxx-xxxx形式)
			if (!preg_match("/".$this->$check_rule."/", $check_value) OR $check_value == "-") {
				return array($this->ERROR_PATERN, $check_value);
			}
		}

		elseif ($check_rule == "is_not_null" ) {
			// ■ ブランクチェック
			if (!preg_match("/".$this->$check_rule."/", $check_value) ) {
				return array($this->ERROR_ESSENTIAL, $check_value);
			}
		}

		elseif ($check_rule == "is_url" ) {
			// ■ URLチェック
			if (!preg_match("/".$this->$check_rule."/", $check_value) ) {
				return array($this->ERROR_MSG_PATERN1, $check_value);
			}
		}

		elseif (ereg("^is_", $check_rule)) {
			// ■ 日付・TEL・ZIP以外のチェック
			if (!preg_match("/".$this->$check_rule."/", $check_value)) {
				return array($this->ERROR_PATERN, $check_value);
			}

		} else {
			// ■ is_xxx 以外の法則
			// 値が設定されていないときまたは、指定の正規表現からはずれているとき
			if (!isset($check_value) or !preg_match("/$check_rule/", $check_value)) {
				return array($this->ERROR_PATERN, $check_value);
			}
			//}elseif($in{$item_name} eq ""){
			//	$error = 1;
		}

		return array($this->ERROR_NOERROR, $check_value);
	}

	/**
	 * 比較入力チェックの実行
	 * 
	 * 
	 */
	function checkItemCompare($item_name) {
		$form_parameter = array_merge($_GET, $_POST); // POST, GET変数の順に配列を連結

		$check_value = $form_parameter[$item_name];
		$compare_value = $form_parameter[$item_name.$this->suffix_compare];

		// 比較チェック
		if (empty($check_value)) {
			return array($this->ERROR_ESSENTIAL, $check_value);
		}

		if ($check_value != $compare_value) {
			return array($this->ERROR_COMPARE, $chekc_value);
		}

		return array($this->ERROR_NOERROR, $check_value);
	}

	/**
	 * 入力長の確認
	 * 
	 */
	function checkItemLength($item_name) {
		$form_parameter = array_merge($_GET, $_POST); // POST, GET変数の順に配列を連結
		$check_value = $form_parameter[$item_name];

		if (strlen($check_value) > $this->_conf[$item_name.$this->suffix_length]) {
			return array($this->ERROR_LENGTH, $check_value);
		}

		return array($this->ERROR_NOERROR, $check_value);
	}
}
?>