<?php
/*
* サブ関数
*
*/


define("CNV_DATE" , 1);
define("CNV_DATETIME" , 2);

// DBからの文字コードをutf-8->SJIS-HTMLエンコード

//
function db2htmlsjis($str){
	$ret=mb_convert_encoding($str, "SJIS", "utf-8");
	$ret=htmlspecialchars($ret); 
	return $ret;
}


// sjis→utf-8 に変換
function db2utf8($str){
	$ret=mb_convert_encoding($str,  "utf-8","SJIS");
	return $ret;

}


// pager()関数ここから

function pager($idname,$countRe){
	$title='title="'.$countRe.'"';
    $id =$_GET[$idname];
    // ページ情報以外のパラメータを補完し、$other_paramにセット
    foreach($_GET as $key => $value){
        // $idname 以外のGETメソッドのパラメータを $other_param に再構築
        if ($key != $idname){
            // リンクさせるためにurlencodeする.
			if(is_array($value)){
			    foreach($value as $value1){
			        $other_param .= "&".$key."[]=".@urlencode($value1);
				}
			} else {
            		$other_param .= "&".$key."=".@urlencode($value);
			}

        }
    }


    foreach($_POST as $key => $value){
        // $idname 以外のGETメソッドのパラメータを $other_param に再構築

        if ($key != $idname){
            // リンクさせるためにurlencodeする.
			if(is_array($value)){
			    foreach($value as $value1){
			        $other_param .= "&".$key."[]=".@urlencode($value1);
				}
			} else {
            		$other_param .= "&".$key."=".@urlencode($value);
			}

        }
    }

    // ページ数の指定がなければページ数を1にセット
    if($id=="") $id=1;
    // 最終ページを計算する
    // 総Hit数をページング単位で割ると総ページ数が計算される
    // ページング単位PER_PAGEを10とすると最終ページ数$maxPageは
    // 総Hit数 / PER_PAGEを切り上げたものとなる。
    // 検索結果205件 PER_PAGE:10の場合 $maxPage = ceil(205 / 10) = 21
    $maxPage=ceil($countRe / PER_PAGE);
    // maxPage=1の場合(PER_PAGEより少ない検索結果)
    // 選択したページ数(id)よりもmaxPageが小さいときはfalse
    if( ($maxPage == 1) or ($maxPage < $id) ) return false;

    // 選択したページ数がVIEW_PAGE_MENU_WIDTHより大きいとき
    if($id > VIEW_PAGE_MENU_WIDTH + 1){
        // スタートページは選択ページからVIEW_PAGE_MENU_WIDTHを
        // 引いたもの程度出せばよい
        $startPage = $id - VIEW_PAGE_MENU_WIDTH;
        // より小さいもの「 < 」の部分はさらにその$startPageから1を引いたもの
        $startMore = "<li class=\"before\"><a href=\"$PHP_SELF?".$idname."=".($startPage - 1).$other_param."\"   $title>".PREV_MARK." </a></li>";
    }else{
        // そうでなければ$startPage=1(一番はじめのページ = 1)になる
        $startPage = 1;
    }



    // 選択したページ数に5を足したものより、更に$maxPage
    // （最大ページ)が大きければ
    if($id + VIEW_PAGE_MENU_WIDTH < $maxPage){
        // 表示される最終ページは選択したページに
        // VIEW_PAGE_MENU_WIDTHを足したものになる
        $endPage = $id + VIEW_PAGE_MENU_WIDTH;
        $endMore = "<li class=\"next\"> <a href=\"$PHP_SELF?".$idname."=".($endPage + 1).$other_param."\" $title > ".NEXT_MARK."</a></li>";
    }else{
        // そうでなければ、$endPageは最終ページになる
        $endPage = $maxPage;
    }
    // ここまでで、計算されたのは
    // $id        : 現在選択しているページ番号
    // $maxPage   : 検索の最終ページ
    // $startPage : 表示されるはじめのページ
    // $endPage   : 表示される最後のページ
    // $page_footer="" として$page_footerを初期化
    $page_footer="";
    // $startPage から $endPageまで繰り返し
    for($i = $startPage ; $i <= $endPage ; $i++){
        // $i = $idだったら選択されたページなので、fontsizeを大きくする
        // その際、リンクはなし
        // そうでなければ、id=$iをリンクにセットする
        $page_footer.= " ".(($id==$i)?"<span style='font-Size:120%'>$i</span>":"<a href=\"$PHP_SELF?$idname=$i$other_param\">$i</a>");
//        $page_footer.= " ".(($id==$i)?"<li><span style='font-Size:120%'>$i</span></li>":"<li><a href=\"$PHP_SELF?$idname=$i$other_param\">$i</a></li>");
    }
    // $startMoreと$endMoreを$page_footerの前後に付け足す
    $page_footer = $startMore.$page_footer.$endMore;
    // $page_footerをreturn 
     return  $page_footer;
}


define( "ONE_DAY_SEC", 24 * 3600 );

// 日付けの差分をとる関数
function dateDiff( $date1, $date2 ) {
    return ( strtotime( $date1) - strtotime( $date2 ) ) / ONE_DAY_SEC;
}


/**
 * 2つの日付の差を求める関数
 * $year1 1つのめ日付の年
 * $month1 1つめの日付の月
 * $day1 1つめの日付の日
 * $year2 2つのめ日付の年
 * $month2 2つめの日付の月
 * $day2 2つめの日付の日
 */
function compareDate($year1, $month1, $day1, $year2, $month2, $day2) {
    $dt1 = mktime(0, 0, 0, $month1, $day1, $year1);
    $dt2 = mktime(0, 0, 0, $month2, $day2, $year2);
    $diff = $dt1 - $dt2;
    $diffDay = $diff / 86400;//1日は86400秒
    return $diffDay;
}


// 時間の差分をとる関数
function timeDiff( $time1, $time2 ) {
    // strtotime("0:0:0") を足して localtime を補正
    return date( "H:i:s", strtotime( $time1 ) - strtotime( $time2 )  + strtotime("0:0:0"));
}

function mobile_header(){
$agent = $_SERVER['HTTP_USER_AGENT'];
if(ereg("DoCoMo",$agent)){
	header('Content-Type: application/xhtml+xml; charset=Shift_JIS');
	$ret='<!DOCTYPE html PUBLIC "-//i-mode group (ja)//DTD XHTML i-XHTML(Locale/Ver.=ja/1.1) 1.0//EN" "i-xhtml_4ja_10.dtd">';
}
else if(ereg("^UP.Browser|^KDDI", $agent)){
	$ret= '<!DOCTYPE html PUBLIC "-//OPENWAVE//DTD XHTML 1.0//EN" "http://www.openwave.com/DTD/xhtml-basic.dtd">';
}
else if(ereg("^J-PHONE|^Vodafone|^SoftBank", $agent)){
	$ret= '<!DOCTYPE html PUBLIC "-//J-PHONE//DTD XHTML Basic 1.0 Plus//EN" "xhtml-basic10-plus.dtd">';
}else{
	header("location: /index.php");
	$ret ;
 }
	return $ret;

}

function get_carrier(){
	$http_ua = $_SERVER['HTTP_USER_AGENT'];
	$carrier = '';
	if(preg_match("/DoCoMo/",$http_ua)){
		$carrier = 'dcm';
	}elseif(preg_match("/SoftBank/",$http_ua) || preg_match("/Vodafone/",$http_ua) || preg_match("/J-PHONE/",$http_ua) || 
		preg_match("/J-EMULATOR/",$http_ua) || preg_match("/Vemulator/",$http_ua) || preg_match("/MOTEMULATOR-/",$http_ua)){
		$carrier = 'sb';
	}elseif(preg_match("/KDDI-/",$http_ua) || preg_match("/UP\.Browser/",$http_ua)){
		$carrier = 'au';
	}else{
		$carrier = 'pc';
	}
	return $carrier;
}



function dbdate2date( $dbdate , $cnv=CNV_DATE )
{
	switch( $cnv ){
		case	CNV_DATE:
			$date_str =  preg_replace("/(\d\d\d\d)(\d\d)(\d\d)(\d\d)(\d\d)(\d\d)/","\\1/\\2/\\3 " , $dbdate );
			break;
		case	CNV_DATETIME:
			$date_str = preg_replace("/(\d\d\d\d)(\d\d)(\d\d)(\d\d)(\d\d)(\d\d)/","\\1/\\2/\\3 \\4:\\5" , $dbdate );
			break;
	}
	return $date_str;
}



	/*
		画像タグ
		をリサイズしてタグ生成

		$width=80 ,height=80,$file_path, $title="",$href"" $rot=0横1 縦基準 )
	
	*/
function set_image_tag_ref( $width_src=80 ,$height_src=80,$file_path, $title="",$href="",$style="",$rot=1){
			$a_path=$file_path;
			if(substr($file_path,0,1)=="/"){
				$a_path =$_SERVER['DOCUMENT_ROOT'].$file_path;
			} 
			// 実際のサイズ　0 番目および 1 番目の要素は、それぞれ画像の幅と高さを表します。 
			list($width,$height,$type,$width_height) = getimagesize($a_path);
			if( empty($width) || empty($height) ){
				$width = 50;
				$height = 50;
				$photo_size = 150;
				$alt = '"file damage';
				$title = ' "file damage"';
			}

			// サイズオーバー
			//横サイズ基準
			if($rot==0){
				if( ($width > $width_src)   ||  ($height >$height_src)   ){
					$r = $width /($width_src) ;
					$h = round (  $height / $r );
					$w =  $width_src ;
				} else {
					$h =   $height ;
					$w =   $width ;

				}
			} else {
			// サイズオーバー
			//縦サイズ基準
				//    
				if( ($width > $width_src)   ||  ($height >$height_src)   ){
					$r = $height/($height_src) ;
					$w = round (  $width / $r );
					$h=$height_src ;
				} else {
					$h =    $height ;
					$w =    $width ;

				}
			}





    	$str_img_tag="<img $style src=\"$file_path\" border=\"0\" width=\"$w\" height=\"$h\" alt= $title title=$title $str  >\n";
	if($href){
			$str_img_tag="<a href=$href>".$str_img_tag."</a>";
		}
			return $str_img_tag;

}


	/*
		画像タグ
	*/
function set_image_tag( $photo_size=1500 ,$file_path, $style=""){
			$a_path=$file_path;
			if(substr($file_path,0,1)=="/"){
				$a_path =$_SERVER['DOCUMENT_ROOT'].$file_path;
			} 
			list($height,$width,$type,$width_height) = getimagesize($a_path);
			$alt = "";
			$title = ' title="CLICK  "';
			if( empty($width) || empty($height) ){
				$width = 150;
				$height = 120;
				$photo_size = 150;
				$alt = ' alt=\"file damage\" ';
				$title = ' title=\"file damage\" ';
			}
			$r =1;
			if( ($width * $height) > $photo_size){
					$r = ($width * $height) / $photo_size;
				$w = round (  $width / $r );
				$h = round (  $height / $r) ;
			} else {
					$w =  $width ;
					$h =  $height ;
				}

					$w =  $width ;
					$h =  $height ;

			return <<<___
<img $style src="$file_path" border="0" width="$w" height="$h" $alt $title >
___;

}


// ディレクトリをオープンし、その中のゴミファイルを削除
// ディレクトリをオープンし、その中のゴミファイルを削除
function del_file($dir,$tmp_file="TMP", $time_vale=3600) {
$today  = mktime(date("h") ,date("i"), 0, date("m")  , date("d"), date("Y"));
//	echo $dir;
	if ($handle = opendir("$dir")) {
  	  while (false !== ($file = readdir($handle))) {
    	    if ($file != "." && $file != "..") {
					$m=date ("m", filemtime("${dir}${file}"));
					$Y=date ("Y", filemtime("${dir}${file}"));
					$d=date ("d", filemtime("${dir}${file}"));
					$h=date ("h", filemtime("${dir}${file}"));
					$i=date ("i", filemtime("${dir}${file}"));
					$file_time  = mktime($h, $i, 0, $m  , $d, $Y);
					$def= (intval($today) - intval($file_time)) ;
					if( strstr($file, $tmp_file )  && $def >$time_vale ){
								unlink("${dir}${file}");
						 }
        	}
	    }
    closedir($handle);
	}
}




 function valid_mail($email) // 正しい書式のメールアドレスの場合は、1 を返す
{
if(preg_match('/^(?:[^(\040)<>@,;:".\\\\\[\]\000-\037\x80-\xff]+(?![^(\040)<>@,;:".\\\\\[\]\000-\037\x80-\xff])|"[^\\\\\x80-\xff\n\015"]*(?:\\\\[^\x80-\xff][^\\\\\x80-\xff\n\015"]*)*")(?:\.(?:[^(\040)<>@,;:".\\\\\[\]\000-\037\x80-\xff]+(?![^(\040)<>@,;:".\\\\\[\]\000-\037\x80-\xff])|"[^\\\\\x80-\xff\n\015"]*(?:\\\\[^\x80-\xff][^\\\\\x80-\xff\n\015"]*)*"))*@(?:[^(\040)<>@,;:".\\\\\[\]\000-\037\x80-\xff]+(?![^(\040)<>@,;:".\\\\\[\]\000-\037\x80-\xff])|\[(?:[^\\\\\x80-\xff\n\015\[\]]|\\\\[^\x80-\xff])*\])(?:\.(?:[^(\040)<>@,;:".\\\\\[\]\000-\037\x80-\xff]+(?![^(\040)<>@,;:".\\\\\[\]\000-\037\x80-\xff])|\[(?:[^\\\\\x80-\xff\n\015\[\]]|\\\\[^\x80-\xff])*\]))*$/', $email)) return 1;
}




// タイムスタンプをUnix　時間に変更
//
//
 function timestamp2time($time_str)
{
 $r1=split("-",$i[0]);
 $r2=split(":",$i[1]);
 $yy=$r1[0];
 $m =$r1[1];
 $d =$r1[2];

 if(mktime(23, 59, 59, $m, $d, $yy)){
	 return mktime(23, 59, 59, $m, $d, $y);
	}else {
	 return time();
	}

}

// DBからのデータをEUC->utf8に変換して、HTMLにエンコード
function  ArrayDB2str($Quote_data) { 
	$a=Array();
	foreach($Quote_data as $key => $value)
	{
//		$value= mb_convert_encoding($value, 'utf8', 'EUC');
		$a[$key]= htmlspecialchars($value,ENT_QUOTES);
	}	
   return($a); 
}


// 配列をシングルクォートで囲む　ABCD--＞　'ABCD'
function Array_Quote($Quote_data) { 
	$a=Array();
	foreach($Quote_data as $key => $value)
	{
		$i= addslashes($value);
		$a[$key]= "'".$i."'";
	}	
   return($a); 
}



// N桁の英語、数字のパスワードをランダムに作成 
function MakePasswd_N ($N) { 
	$aa="";
	for($ii=0 ;$ii<$N; $ii++) { 
		$i[] = MakePasswdsub();
 	$aa=$aa.$i[$ii]; 
	}
   return $aa ; 
}




function MakePasswdsub() { 
  mt_srand((double)microtime()*1000000);
  $kazu1 =mt_rand(0,2);

  if ($kazu1 ==2) {
    $kazu = mt_rand(0,10);
  } else {
    $kazu = mt_rand(0,25);
  }  
  $ar[] =array ("a","b","c","d","e","f","g","h","i","j","k","l","m","n",
                "o","p","q","r","s","t","u","v","w","x","y","z"); 

  $ar[] =array ("A","B","C","D","E","F","G","H","I","J","K","L","M","N",
                "O","P","Q","R","S","T","U","V","W","X","Y","Z"); 

  $ar[] =array (0,1,2,3,4,5,6,7,8,9,0); 
  return $ar[$kazu1][$kazu]; 
} 

// 指定したタグで囲む
function split_tag( $str,$split_str,$tag="li",$len=40  ) {
	$data=explode ( $split_str , $str );
	$word_str="";
	foreach( $data as $values ){
		$value=wordwrap($values, $len, "<br />\n");
		$word_str.="<".$tag.">".  $value."</".$tag.">"; 
	}
    return $word_str;
}

// 画像のユニークＩＤをＧＥＴ
function image_get_id(  ) {
    $ret=MakePasswd_N(12).date("jHi");;
    return $ret;
}


// 画像をアップロード
//                        $_FILES,file_fullpath,
function image_upload_id( $files_name, $upload_dir,$upload_thumb_dir,$file_name,$resize=true ) {
		$err_mes="";
		$num=time();
	  	$handle = new upload($files_name);
  		$handle->allowed = array("image/*");//許可するのは image タイプのファイルのみ（jpg,jpeg,gif,png)

	  	if ($handle->uploaded) {

			 //通常の大きさの画像
  		   	$handle->file_overwrite     = true;      //ファイル上書き有効
  			$handle->file_auto_rename   = false;     //ファイル名自動リネーム無効
      		$handle->file_new_name_body   = IMG_TMP_PREFIX.$file_name.$num;//ファイル名
			$handle->image_max_width =  1024;
			$handle->image_max_height = 800;

      		$handle->process($upload_dir);
      	if ($handle->processed) {
        	  //echo 'image resized';
			  //アップロード後のファイル名
	 		$img_file =$file_name.$num.".".$handle->file_src_name_ext;
      		} else {
		 	$err_mes .="画像のアップロードに失敗しました。<br />".$handle->error;			
         	//echo 'error : ' . $handle->error;
      	}

		 //サムネイル画像
	  		$handle->file_overwrite     = true;
  			$handle->file_auto_rename   = false;
  			$handle->file_src_name_body = IMG_TMP_PREHUMB.$file_name.$num;
  			$handle->image_resize       = true;
  			$handle->image_y  		    = THUMBNAIL_HEIGHT;
  			$handle->image_ratio_x      = true;

			$handle->image_max_width =  1024;
			$handle->image_max_height = 768;
  			$handle->Process($upload_thumb_dir);

      	if ($handle->processed) {
        	  //echo 'image resized';
			  //アップロード後のファイル名
	 		$img_file_thumb=$file_name.$num.".".$handle->file_src_name_ext;
          	$handle->clean();
      		} else {
		 	$err_mes .="サムネイル画像のアップロードに失敗しました。<br />.$handle->error";			
         	//echo 'error : ' . $handle->error;
      	}

  	}
	$data=array();
	$data[]=$err_mes;
	$data[]=$img_file;
	$data[]=$img_file_thumb;


	return $data;

}
?>