require 'rubygems'
require 'open-uri'
require 'hpricot'
require 'kconv'
require 'logger'
require 'mysql_for_webdb'

$KCODE="u"

# 幅優先探索によるクローリングを行なう。
# 取得したページとリンクをデータベースに格納する。
# 最大深度、最大取得ページ数を指定し、どちらかに達するまで再帰的にクローリングを行なう。
# proxyは'http://<proxy-host>:<proxy-port>'のように設定する。nilならばプロキシを使用せず、デフォルトはnil。
#
# connectorはクロールの結果取得したページやリンクを保存するためのクラスオブジェクトで、以下の二つのメソッドが必要。
# * get_page_id(url) : 引数のURLのページがすでに保存されているならばそのIDを返し、保存されていないならば新たに保存し、IDを採番した上でそれを返す。
# * insert_links(links): {:from_id, :to_id}というハッシュで表現されたリンクの配列を引数とし、そのリンク情報を保存する。
# デフォルトはWebGraphクラスで、これはページとリンクの構造からなるグラフを表現したクラス。
# MySQLと連携を行なうmysql_for_webdbクラスはページやリンクの情報をデータベースに保存するが、あらかじめテーブルを作成する必要がある。

class Crawler
	@@log = Logger.new(STDOUT)
	@@log.level = Logger::DEBUG
	@@log.progname = "Crawler"

  attr_reader :max_seach_depth, :max_page_numbjer, :proxy, :connector

  # 最大深度、最大取得ページで初期化する
  def initialize(max_search_depth, max_page_number, proxy = nil, connector = WebGraph.new)
    @max_search_depth = max_search_depth
    @max_page_number = max_page_number
    @proxy = proxy
    @connector = connector
  end

  def crawl_start(root_url_list)
		@@log.info("start: max_depth=" + @max_search_depth.to_s + ", max_page=" + @max_page_number.to_s)
    crawl(1, 1, root_url_list)
  end

  def crawl(current_search_depth, current_page_number, root_url_list)
    # 最大深度または最大取得ページ数を超えていた場合はクロール終了
    if current_search_depth >= @max_search_depth
			@@log.info("finish: exceed max search depth")
      return
		elsif current_page_number >= @max_page_number
			@@log.info("finish: exceed max page number")
      return
		end

		@@log.info("depth=" + current_search_depth.to_s + "/" + @max_search_depth.to_s)
    # 次回クロール時のパラメータを初期化
    next_search_depth = current_search_depth
    next_page_number = current_page_number
    next_url_list = []

    root_url_list.each do |url|
      # URLにアクセスしHTMLを取得
      begin
        html = open(url, :proxy => @proxy).read #@proxyがnilの場合はプロキシを使用しないで通信する
        html = Kconv.toutf8(html) # 文字コードをUTF-8に変換
      rescue Timeout::Error, StandardError
       	@@log.warn("Could not open:" + url)
        next
      end

      # URLをデータベースに格納しIDを取得
      page_id = @connector.get_page_id(url)
			@@log.debug("url:" + url + ", id:" + page_id.to_s)

      # 取得したHTMLをパースし、リンクを取得
      link_hash_array = []
      doc = Hpricot(html)
      links = (doc/:a)
      links.each do |link|
        next unless link = link[:href] # リンクがnilの場合は無視
        link = URI.join(url, link).to_s unless /^http[s]?:\/\//i =~ link # 相対パスの場合は絶対パスに変換
        (link, fragment), = link.scan(/^([^\#]+)(\#.+)?/) # fragmentを分離
        next_url_list.push(link)
				@@log.info("page_num=" + next_page_number.to_s + "/" + @max_page_number.to_s)
				@@log.debug("link:" + link)

        # リンクをデータベースに格納しIDを取得
        link_to_page_id = @connector.get_page_id(link)
        link_hash_array.push( {:from_id => page_id, :to_id => link_to_page_id})
        # 最大取得ページ数を超えた場合はリンクをデータベースに格納し、クロール終了
        next_page_number += 1
        if next_page_number > @max_page_number
          @connector.insert_links(link_hash_array)
					@@log.info("finish: exceed max page number")
          return
        end
      end
    end

    # リンクをデータベースに格納
    @connector.insert_links(link_hash_array)

    # 一つ下のdepthのページを再帰的にクロール
    next_search_depth += 1
    self.crawl(next_search_depth, next_page_number, next_url_list)
  end
  private :crawl
end
