CREATE TABLE IF NOT EXISTS `c_access_block` (
  `c_access_block_id` int(11) NOT NULL auto_increment,
  `c_member_id` int(11) NOT NULL default '0',
  `c_member_id_block` int(11) NOT NULL default '0',
  `r_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`c_access_block_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `c_access_log` (
  `c_access_log_id` int(11) NOT NULL auto_increment,
  `c_member_id` int(11) NOT NULL default '0',
  `page_name` varchar(100) NOT NULL default '',
  `target_c_member_id` int(11) default '0',
  `target_c_commu_id` int(11) default '0',
  `target_c_commu_topic_id` int(11) default '0',
  `target_c_diary_id` int(11) default '0',
  `ktai_flag` int(11) NOT NULL default '0',
  `r_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `ip_address` varchar(16) NOT NULL default '',
  PRIMARY KEY  (`c_access_log_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `c_admin_config` (
  `c_admin_config_id` int(11) NOT NULL auto_increment,
  `name` varchar(64) NOT NULL default '',
  `value` text NOT NULL,
  PRIMARY KEY  (`c_admin_config_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `c_admin_user` (
  `c_admin_user_id` int(11) NOT NULL auto_increment,
  `username` varchar(64) NOT NULL default '',
  `password` varchar(40) NOT NULL default '',
  `auth_type` enum('all','normal') NOT NULL default 'all',
  PRIMARY KEY  (`c_admin_user_id`),
  UNIQUE KEY `username` (`username`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `c_api_member` (
  `c_api_member_id` int(11) NOT NULL auto_increment,
  `c_member_id` int(11) NOT NULL default '0',
  `token` varchar(64) NOT NULL default '',
  PRIMARY KEY  (`c_api_member_id`),
  UNIQUE KEY `c_member_id` (`c_member_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `c_ashiato` (
  `c_ashiato_id` int(11) NOT NULL auto_increment,
  `c_member_id_from` int(11) NOT NULL default '0',
  `c_member_id_to` int(11) NOT NULL default '0',
  `r_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `r_date` date NOT NULL default '0000-00-00',
  `is_mobile` varchar(8) NOT NULL default 'pc',
  PRIMARY KEY  (`c_ashiato_id`),
  KEY `c_member_id_from` (`c_member_id_from`),
  KEY `c_member_id_to` (`c_member_id_to`),
  KEY `c_ashiato_to_rdatetime` (`c_member_id_to`,`r_datetime`),
  KEY `c_ashiato_to_rdate` (`c_member_id_to`,`r_date`),
  KEY `c_ashiato_to_from_rdate` (`c_member_id_to`,`c_member_id_from`,`r_date`),
  KEY `c_ashiato_to_from_rdate_rdatetime` (`c_member_id_to`,`c_member_id_from`,`r_date`,`r_datetime`),
  KEY `c_ashiato_rdatetime` (`r_datetime`),
  KEY `c_ashiato_rdate` (`r_date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `c_banner` (
  `c_banner_id` int(11) NOT NULL auto_increment,
  `image_filename` text NOT NULL,
  `a_href` text NOT NULL,
  `type` enum('TOP','SIDE') NOT NULL default 'TOP',
  `nickname` text NOT NULL,
  `is_hidden_before` tinyint(1) NOT NULL default '0',
  `is_hidden_after` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`c_banner_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `c_banner_log` (
  `c_banner_log_id` int(11) NOT NULL auto_increment,
  `r_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `r_date` date NOT NULL default '0000-00-00',
  `c_banner_id` int(11) NOT NULL default '0',
  `c_member_id` int(11) NOT NULL default '0',
  `clicked_from` text NOT NULL,
  PRIMARY KEY  (`c_banner_log_id`),
  KEY `c_banner_id` (`c_banner_id`),
  KEY `c_member_id` (`c_member_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `c_bookmark` (
  `c_bookmark_id` int(11) NOT NULL auto_increment,
  `c_member_id_from` int(11) NOT NULL default '0',
  `c_member_id_to` int(11) NOT NULL default '0',
  `r_datetime` varchar(100) NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`c_bookmark_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `c_commu` (
  `c_commu_id` int(11) NOT NULL auto_increment,
  `name` text NOT NULL,
  `c_member_id_admin` int(11) NOT NULL default '0',
  `info` text NOT NULL,
  `c_commu_category_id` int(11) NOT NULL default '0',
  `r_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `r_date` date NOT NULL default '0000-00-00',
  `image_filename` text NOT NULL,
  `public_flag` enum('public','auth_public','auth_sns','auth_commu_member') NOT NULL default 'public',
  `is_send_join_mail` tinyint(1) NOT NULL default '1',
  `is_regist_join` tinyint(1) NOT NULL default '0',
  `is_display_map` tinyint(1) NOT NULL default '0',
  `map_latitude` double NOT NULL default '0',
  `map_longitude` double NOT NULL default '0',
  `map_zoom` int(11) NOT NULL default '0',
  PRIMARY KEY  (`c_commu_id`),
  KEY `c_commu_category_id` (`c_commu_category_id`),
  KEY `c_member_id_admin` (`c_member_id_admin`),
  KEY `r_datetime` (`r_datetime`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `c_commu_admin_confirm` (
  `c_commu_admin_confirm_id` int(11) NOT NULL auto_increment,
  `c_commu_id` int(11) NOT NULL default '0',
  `c_member_id_to` int(11) NOT NULL default '0',
  `r_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `message` text NOT NULL,
  PRIMARY KEY  (`c_commu_admin_confirm_id`),
  KEY `c_member_id_to` (`c_member_id_to`),
  KEY `c_commu_id` (`c_commu_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `c_commu_admin_invite` (
  `c_commu_admin_invite_id` int(11) NOT NULL auto_increment,
  `c_commu_id` int(11) NOT NULL default '0',
  `c_member_id_to` int(11) NOT NULL default '0',
  `r_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`c_commu_admin_invite_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `c_commu_category` (
  `c_commu_category_id` int(11) NOT NULL auto_increment,
  `name` text NOT NULL,
  `sort_order` int(11) NOT NULL default '0',
  `c_commu_category_parent_id` int(11) NOT NULL default '0',
  PRIMARY KEY  (`c_commu_category_id`),
  KEY `c_commu_category_parent_id` (`c_commu_category_parent_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `c_commu_category_parent` (
  `c_commu_category_parent_id` int(11) NOT NULL auto_increment,
  `name` text NOT NULL,
  `sort_order` int(11) NOT NULL default '0',
  PRIMARY KEY  (`c_commu_category_parent_id`),
  KEY `sort_order` (`sort_order`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `c_commu_member` (
  `c_commu_member_id` int(11) NOT NULL auto_increment,
  `c_member_id` int(11) NOT NULL default '0',
  `c_commu_id` int(11) NOT NULL default '0',
  `r_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `is_receive_mail` tinyint(1) NOT NULL default '0',
  `is_receive_mail_pc` int(11) NOT NULL default '0',
  `is_receive_message` int(11) NOT NULL default '1',
  PRIMARY KEY  (`c_commu_member_id`),
  KEY `c_commu_id` (`c_commu_id`),
  KEY `c_member_id` (`c_member_id`),
  KEY `c_commu_id_r_datetime` (`c_commu_id`,`r_datetime`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `c_commu_member_confirm` (
  `c_commu_member_confirm_id` int(11) NOT NULL auto_increment,
  `c_commu_id` int(11) NOT NULL default '0',
  `c_member_id` int(11) NOT NULL default '0',
  `r_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `message` text NOT NULL,
  PRIMARY KEY  (`c_commu_member_confirm_id`),
  KEY `c_member_id` (`c_member_id`),
  KEY `c_commu_id` (`c_commu_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `c_commu_review` (
  `c_commu_review_id` int(11) NOT NULL auto_increment,
  `c_commu_id` int(11) NOT NULL default '0',
  `c_review_id` int(11) NOT NULL default '0',
  `c_member_id` int(11) NOT NULL default '0',
  `r_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`c_commu_review_id`),
  KEY `c_commu_id` (`c_commu_id`,`c_review_id`,`c_member_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `c_commu_topic` (
  `c_commu_topic_id` int(11) NOT NULL auto_increment,
  `c_commu_id` int(11) NOT NULL default '0',
  `name` text NOT NULL,
  `r_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `r_date` date NOT NULL default '0000-00-00',
  `c_member_id` int(11) NOT NULL default '0',
  `open_date` date NOT NULL default '0000-00-00',
  `open_date_comment` varchar(100) NOT NULL default '',
  `open_pref_id` int(11) NOT NULL default '0',
  `open_pref_comment` varchar(100) NOT NULL default '',
  `invite_period` date NOT NULL default '0000-00-00',
  `event_flag` int(11) NOT NULL default '0',
  `e_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`c_commu_topic_id`),
  KEY `c_member_id` (`c_member_id`),
  KEY `c_commu_id` (`c_commu_id`),
  KEY `e_datetime` (`e_datetime`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `c_commu_topic_comment` (
  `c_commu_topic_comment_id` int(11) NOT NULL auto_increment,
  `c_commu_id` int(11) NOT NULL default '0',
  `c_member_id` int(11) NOT NULL default '0',
  `body` text NOT NULL,
  `r_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `r_date` date NOT NULL default '0000-00-00',
  `number` int(11) NOT NULL default '0',
  `c_commu_topic_id` int(11) NOT NULL default '0',
  `image_filename1` varchar(200) NOT NULL default '',
  `image_filename2` varchar(200) NOT NULL default '',
  `image_filename3` varchar(200) NOT NULL default '',
  PRIMARY KEY  (`c_commu_topic_comment_id`),
  KEY `c_commu_topic_id` (`c_commu_topic_id`),
  KEY `c_commu_id` (`c_commu_id`),
  KEY `c_member_id` (`c_member_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `c_diary` (
  `c_diary_id` int(11) NOT NULL auto_increment,
  `c_member_id` int(11) NOT NULL default '0',
  `subject` text NOT NULL,
  `body` text NOT NULL,
  `r_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `r_date` date NOT NULL default '0000-00-00',
  `image_filename_1` text NOT NULL,
  `image_filename_2` text NOT NULL,
  `image_filename_3` text NOT NULL,
  `is_checked` tinyint(1) NOT NULL default '0',
  `public_flag` enum('public','friend','private','open') NOT NULL default 'public',
  `etsuran_count` int(11) NOT NULL default '0',
  `comment_count` int(11) NOT NULL default '0',
  `e_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`c_diary_id`),
  KEY `c_member_id` (`c_member_id`),
  KEY `r_datetime_c_member_id` (`r_datetime`,`c_member_id`),
  KEY `c_member_id_r_date` (`c_member_id`,`r_date`),
  KEY `c_member_id_r_datetime` (`c_member_id`,`r_datetime`),
  KEY `r_datetime` (`r_datetime`),
  KEY `e_datetime` (`c_member_id`,`e_datetime`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `c_diary_comment` (
  `c_diary_comment_id` int(11) NOT NULL auto_increment,
  `c_diary_id` int(11) NOT NULL default '0',
  `c_member_id` int(11) NOT NULL default '0',
  `body` text NOT NULL,
  `r_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `image_filename_1` text NOT NULL,
  `image_filename_2` text NOT NULL,
  `image_filename_3` text NOT NULL,
  `comment_number` int(11) NOT NULL default '0',
  PRIMARY KEY  (`c_diary_comment_id`),
  KEY `c_member_id` (`c_member_id`),
  KEY `c_diary_id` (`c_diary_id`),
  KEY `r_datetime_c_diary_id_c_member_id` (`r_datetime`,`c_diary_id`,`c_member_id`),
  KEY `c_member_id_c_diary_id` (`c_member_id`,`c_diary_id`),
  KEY `c_diary_id_r_datetime` (`c_diary_id`,`r_datetime`),
  KEY `c_member_id_r_datetime_c_diary_id` (`c_member_id`,`r_datetime`,`c_diary_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `c_event_member` (
  `c_event_member_id` int(11) NOT NULL auto_increment,
  `c_commu_topic_id` int(11) NOT NULL default '0',
  `c_member_id` int(11) NOT NULL default '0',
  `is_admin` tinyint(4) NOT NULL default '0',
  `r_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`c_event_member_id`),
  KEY `c_commu_topic_id` (`c_commu_topic_id`),
  KEY `c_member_id` (`c_member_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `c_friend` (
  `c_friend_id` int(11) NOT NULL auto_increment,
  `c_member_id_from` int(11) NOT NULL default '0',
  `c_member_id_to` int(11) NOT NULL default '0',
  `r_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `intro` text NOT NULL,
  `r_datetime_intro` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`c_friend_id`),
  KEY `c_member_id_to` (`c_member_id_to`),
  KEY `c_member_id_from` (`c_member_id_from`),
  KEY `c_member_id_from_c_friend_id` (`c_member_id_from`,`c_friend_id`),
  KEY `c_member_id_from_r_datetime` (`c_member_id_from`,`r_datetime`),
  KEY `c_member_id_to_r_datetime_intro` (`c_member_id_to`,`r_datetime_intro`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `c_friend_confirm` (
  `c_friend_confirm_id` int(11) NOT NULL auto_increment,
  `c_member_id_from` int(11) NOT NULL default '0',
  `c_member_id_to` int(11) NOT NULL default '0',
  `r_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `message` text NOT NULL,
  PRIMARY KEY  (`c_friend_confirm_id`),
  KEY `c_member_id_to` (`c_member_id_to`),
  KEY `c_member_id_from` (`c_member_id_from`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `c_image` (
  `c_image_id` int(11) NOT NULL auto_increment,
  `filename` text NOT NULL,
  `bin` longblob NOT NULL,
  `r_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `type` text,
  PRIMARY KEY  (`c_image_id`),
  KEY `filename` (`filename`(100)),
  KEY `r_datetime` (`r_datetime`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `c_ktai_address_pre` (
  `c_ktai_address_pre_id` int(11) NOT NULL auto_increment,
  `c_member_id` int(11) NOT NULL default '0',
  `session` varchar(32) NOT NULL default '',
  `ktai_address` varchar(64) NOT NULL default '',
  `r_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`c_ktai_address_pre_id`),
  UNIQUE KEY `session` (`session`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `c_login_failure` (
  `c_login_failure_id` int(11) NOT NULL auto_increment,
  `ip_addr` varchar(64) NOT NULL default '',
  `r_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`c_login_failure_id`),
  KEY `ip_addr` (`ip_addr`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `c_login_reject` (
  `c_login_reject_id` int(11) NOT NULL auto_increment,
  `ip_addr` varchar(64) NOT NULL default '',
  `expired_at` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`c_login_reject_id`),
  UNIQUE KEY `ip_addr` (`ip_addr`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `c_member` (
  `c_member_id` int(11) NOT NULL auto_increment,
  `nickname` text NOT NULL,
  `birth_year` smallint(4) NOT NULL default '0',
  `birth_month` tinyint(2) NOT NULL default '0',
  `birth_day` tinyint(2) NOT NULL default '0',
  `public_flag_birth_year` enum('public','friend','private') NOT NULL default 'public',
  `image_filename` text NOT NULL,
  `image_filename_1` text NOT NULL,
  `image_filename_2` text NOT NULL,
  `image_filename_3` text NOT NULL,
  `access_date` datetime NOT NULL default '0000-00-00 00:00:00',
  `r_date` datetime NOT NULL default '0000-00-00 00:00:00',
  `rss` text NOT NULL,
  `ashiato_mail_num` int(11) NOT NULL default '0',
  `is_receive_mail` tinyint(1) NOT NULL default '0',
  `is_receive_daily_news` tinyint(1) NOT NULL default '0',
  `is_receive_ktai_mail` tinyint(1) NOT NULL default '0',
  `c_member_id_invite` int(11) NOT NULL default '0',
  `c_password_query_id` int(11) NOT NULL default '0',
  `public_flag_diary` enum('public','friend','private') NOT NULL default 'public',
  `is_login_rejected` tinyint(1) NOT NULL default '0',
  `is_shinobiashi` tinyint(1) NOT NULL default '0',
  `ashiato_count_log` int(11) NOT NULL default '0',
  `is_diary_comment_mail` int(1) NOT NULL default '0',
  `mobile_view` INT(11) NOT NULL DEFAULT '0',
  `pc_view` INT(11) NOT NULL DEFAULT '0',
  PRIMARY KEY  (`c_member_id`),
  KEY `birth_year_c_member_id` (`birth_year`,`c_member_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `c_member_ktai_pre` (
  `c_member_ktai_pre_id` int(11) NOT NULL auto_increment,
  `session` varchar(32) NOT NULL default '',
  `ktai_address` varchar(64) NOT NULL default '',
  `r_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `c_member_id_invite` int(11) NOT NULL default '0',
  PRIMARY KEY  (`c_member_ktai_pre_id`),
  UNIQUE KEY `session` (`session`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `c_member_pre` (
  `c_member_pre_id` int(11) NOT NULL auto_increment,
  `session` varchar(255) NOT NULL default '',
  `nickname` text NOT NULL,
  `birth_year` smallint(4) NOT NULL default '0',
  `birth_month` tinyint(2) NOT NULL default '0',
  `birth_day` tinyint(2) NOT NULL default '0',
  `public_flag_birth_year` enum('public','friend','private') NOT NULL default 'public',
  `r_date` datetime NOT NULL default '0000-00-00 00:00:00',
  `is_receive_mail` tinyint(1) NOT NULL default '0',
  `is_receive_daily_news` tinyint(1) NOT NULL default '0',
  `is_receive_ktai_mail` tinyint(1) NOT NULL default '0',
  `c_member_id_invite` int(11) NOT NULL default '0',
  `password` text NOT NULL,
  `pc_address` text NOT NULL,
  `ktai_address` text NOT NULL,
  `regist_address` text NOT NULL,
  `easy_access_id` text NOT NULL,
  `c_password_query_id` int(11) NOT NULL default '0',
  `c_password_query_answer` text NOT NULL,
  PRIMARY KEY  (`c_member_pre_id`),
  UNIQUE KEY `session` (`session`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `c_member_pre_profile` (
  `c_member_pre_profile_id` int(11) NOT NULL auto_increment,
  `c_member_pre_id` int(11) NOT NULL default '0',
  `c_profile_id` int(11) NOT NULL default '0',
  `c_profile_option_id` int(11) NOT NULL default '0',
  `value` text NOT NULL,
  `public_flag` enum('public','friend','private') NOT NULL default 'public',
  PRIMARY KEY  (`c_member_pre_profile_id`),
  KEY `c_member_pre_id` (`c_member_pre_id`),
  KEY `c_profile_id` (`c_profile_id`),
  KEY `c_profile_option_id` (`c_profile_option_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `c_member_profile` (
  `c_member_profile_id` int(11) NOT NULL auto_increment,
  `c_member_id` int(11) NOT NULL default '0',
  `c_profile_id` int(11) NOT NULL default '0',
  `c_profile_option_id` int(11) NOT NULL default '0',
  `value` text NOT NULL,
  `public_flag` enum('public','friend','private') NOT NULL default 'public',
  PRIMARY KEY  (`c_member_profile_id`),
  KEY `c_member_id` (`c_member_id`),
  KEY `c_profile_id` (`c_profile_id`),
  KEY `c_profile_option_id` (`c_profile_option_id`),
  KEY `c_profile_option_id_c_member_id` (`c_profile_option_id`,`c_member_id`),
  KEY `public_flag_c_profile_option_id` (`public_flag`,`c_profile_option_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

  CREATE TABLE IF NOT EXISTS `c_member_secure` (
  `c_member_secure_id` int(11) NOT NULL auto_increment,
  `c_member_id` int(11) NOT NULL default '0',
  `hashed_password` blob NOT NULL,
  `hashed_password_query_answer` blob NOT NULL,
  `pc_address` blob NOT NULL,
  `ktai_address` blob NOT NULL,
  `regist_address` blob NOT NULL,
  `easy_access_id` blob NOT NULL,
  `pc_address_aes` text NOT NULL,
  `ktai_address_aes` text NOT NULL,
  `regist_address_aes` text NOT NULL,
  `easy_access_id_aes` text NOT NULL,
  PRIMARY KEY  (`c_member_secure_id`),
  UNIQUE KEY `c_member_id` (`c_member_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `c_message` (
  `c_message_id` int(11) NOT NULL auto_increment,
  `c_member_id_to` int(11) NOT NULL default '0',
  `c_member_id_from` int(11) NOT NULL default '0',
  `r_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `body` text NOT NULL,
  `subject` text NOT NULL,
  `is_read` tinyint(1) NOT NULL default '0',
  `is_syoudaku` tinyint(1) NOT NULL default '0',
  `is_deleted_to` tinyint(1) NOT NULL default '0',
  `is_deleted_from` tinyint(1) NOT NULL default '0',
  `is_send` tinyint(1) NOT NULL default '0',
  `is_hensin` tinyint(1) NOT NULL default '0',
  `hensinmoto_c_message_id` int(8) NOT NULL default '0',
  `is_kanzen_sakujo_from` tinyint(1) NOT NULL default '0',
  `is_kanzen_sakujo_to` tinyint(1) NOT NULL default '0',
  `image_filename_1` text NOT NULL,
  `image_filename_2` text NOT NULL,
  `image_filename_3` text NOT NULL,
  PRIMARY KEY  (`c_message_id`),
  KEY `c_member_id_from` (`c_member_id_from`),
  KEY `c_member_id_to` (`c_member_id_to`),
  KEY `c_member_id_from_r_datetime` (`c_member_id_from`,`r_datetime`),
  KEY `c_member_id_to_r_datetime` (`c_member_id_to`,`r_datetime`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `c_navi` (
  `c_navi_id` int(11) NOT NULL auto_increment,
  `navi_type` varchar(10) NOT NULL default '',
  `sort_order` int(11) NOT NULL default '0',
  `url` text NOT NULL,
  `caption` text NOT NULL,
  PRIMARY KEY  (`c_navi_id`),
  KEY `type_sort` (`navi_type`,`sort_order`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `c_password_query` (
  `c_password_query_id` int(11) NOT NULL auto_increment,
  `c_password_query_question` text NOT NULL,
  PRIMARY KEY  (`c_password_query_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `c_pc_address_pre` (
  `c_pc_addess_pre_id` int(11) NOT NULL auto_increment,
  `c_member_id` int(11) NOT NULL default '0',
  `pc_address` text NOT NULL,
  `session` varchar(32) NOT NULL default '',
  `r_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`c_pc_addess_pre_id`),
  KEY `c_member_id` (`c_member_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `c_profile` (
  `c_profile_id` int(11) NOT NULL auto_increment,
  `name` text NOT NULL,
  `caption` text NOT NULL,
  `is_required` tinyint(1) NOT NULL default '0',
  `public_flag_edit` tinyint(1) NOT NULL default '0',
  `public_flag_default` enum('public','friend','private') NOT NULL default 'public',
  `form_type` enum('text','textarea','select','checkbox','radio') NOT NULL default 'text',
  `sort_order` int(11) NOT NULL default '0',
  `disp_regist` tinyint(1) NOT NULL default '0',
  `disp_config` tinyint(1) NOT NULL default '1',
  `disp_search` tinyint(1) NOT NULL default '1',
  `val_type` text NOT NULL,
  `val_regexp` text NOT NULL,
  `val_min` int(11) NOT NULL default '0',
  `val_max` int(11) NOT NULL default '0',
  PRIMARY KEY  (`c_profile_id`),
  KEY `sort_order` (`sort_order`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `c_profile_option` (
  `c_profile_option_id` int(11) NOT NULL auto_increment,
  `c_profile_id` int(11) NOT NULL default '0',
  `value` text NOT NULL,
  `sort_order` int(11) NOT NULL default '0',
  PRIMARY KEY  (`c_profile_option_id`),
  KEY `c_profile_id` (`c_profile_id`),
  KEY `sort_order` (`sort_order`),
  KEY `c_profile_id_sort_order` (`c_profile_id`,`sort_order`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `c_profile_pref` (
  `c_profile_pref_id` int(11) NOT NULL auto_increment,
  `pref` text NOT NULL,
  `sort_order` int(11) NOT NULL default '0',
  `map_latitude` double NOT NULL default '0',
  `map_longitude` double NOT NULL default '0',
  `map_zoom` int(11) NOT NULL default '0',
  PRIMARY KEY  (`c_profile_pref_id`),
  KEY `sort_order` (`sort_order`),
  KEY `map_latitude_map_longitude` (`map_latitude`,`map_longitude`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `c_review` (
  `c_review_id` int(11) NOT NULL auto_increment,
  `title` text NOT NULL,
  `release_date` varchar(100) NOT NULL default '0000-00-00',
  `manufacturer` text NOT NULL,
  `author` text NOT NULL,
  `c_review_category_id` int(11) NOT NULL default '0',
  `image_small` text NOT NULL,
  `image_medium` text NOT NULL,
  `image_large` text NOT NULL,
  `url` text NOT NULL,
  `asin` varchar(100) NOT NULL default '',
  `list_price` varchar(100) NOT NULL default '0',
  `retail_price` varchar(100) NOT NULL default '0',
  `r_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`c_review_id`),
  KEY `c_review_category_id` (`c_review_category_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `c_review_category` (
  `c_review_category_id` int(11) NOT NULL auto_increment,
  `category` varchar(100) NOT NULL default '',
  `category_disp` varchar(100) NOT NULL default '',
  `sort_order` int(11) NOT NULL default '0',
  PRIMARY KEY  (`c_review_category_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `c_review_clip` (
  `c_review_clip_id` int(11) NOT NULL auto_increment,
  `c_member_id` int(11) NOT NULL default '0',
  `c_review_id` int(11) NOT NULL default '0',
  `r_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`c_review_clip_id`),
  KEY `c_member_id` (`c_member_id`,`c_review_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `c_review_comment` (
  `c_review_comment_id` int(11) NOT NULL auto_increment,
  `c_review_id` int(11) NOT NULL default '0',
  `c_member_id` int(11) NOT NULL default '0',
  `body` text NOT NULL,
  `satisfaction_level` int(11) NOT NULL default '0',
  `r_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`c_review_comment_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `c_rss_cache` (
  `c_rss_cache_id` int(11) NOT NULL auto_increment,
  `c_member_id` int(11) NOT NULL default '0',
  `subject` text NOT NULL,
  `body` text NOT NULL,
  `r_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `link` text NOT NULL,
  `cache_date` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`c_rss_cache_id`),
  KEY `c_member_id` (`c_member_id`),
  KEY `c_member_id_r_datetime` (`c_member_id`,`r_datetime`),
  KEY `r_datetime` (`r_datetime`),
  KEY `r_datetime_c_member_id` (`r_datetime`,`c_member_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `c_schedule` (
  `c_schedule_id` int(11) NOT NULL auto_increment,
  `c_member_id` int(11) NOT NULL default '0',
  `title` text NOT NULL,
  `body` text NOT NULL,
  `start_date` date NOT NULL default '0000-00-00',
  `start_time` time default NULL,
  `end_date` date NOT NULL default '0000-00-00',
  `end_time` time default NULL,
  `is_receive_mail` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`c_schedule_id`),
  KEY `c_member_id` (`c_member_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `c_searchlog` (
  `c_searchlog_id` int(11) NOT NULL auto_increment,
  `searchword` text NOT NULL,
  `r_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `c_member_id` int(11) NOT NULL default '0',
  PRIMARY KEY  (`c_searchlog_id`),
  KEY `c_member_id` (`c_member_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `c_session` (
  `c_session_id` int(11) NOT NULL auto_increment,
  `sess_name` varchar(64) NOT NULL default '',
  `sess_id` varchar(32) NOT NULL default '',
  `sess_time` int(11) NOT NULL default '0',
  `sess_data` text NOT NULL,
  PRIMARY KEY  (`c_session_id`),
  UNIQUE KEY `sess_name` (`sess_name`,`sess_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `c_siteadmin` (
  `c_siteadmin_id` int(11) NOT NULL auto_increment,
  `target` varchar(100) NOT NULL default '',
  `body` text NOT NULL,
  `r_date` date NOT NULL default '0000-00-00',
  PRIMARY KEY  (`c_siteadmin_id`),
  UNIQUE KEY `target` (`target`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `c_skin_filename` (
  `c_skin_filename_id` int(11) NOT NULL auto_increment,
  `skinname` varchar(64) NOT NULL default '',
  `filename` text NOT NULL,
  PRIMARY KEY  (`c_skin_filename_id`),
  UNIQUE KEY `skinname` (`skinname`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `c_sns_config` (
  `c_sns_config_id` int(11) NOT NULL auto_increment,
  `key_name` varchar(100) NOT NULL default '',
  `border_00` text NOT NULL,
  `border_01` text NOT NULL,
  `border_02` text NOT NULL,
  `border_03` text NOT NULL,
  `border_04` text NOT NULL,
  `border_05` text NOT NULL,
  `border_06` text NOT NULL,
  `border_07` text NOT NULL,
  `border_08` text NOT NULL,
  `border_09` text NOT NULL,
  `border_10` text NOT NULL,
  `bg_00` text NOT NULL,
  `bg_01` text NOT NULL,
  `bg_02` text NOT NULL,
  `bg_03` text NOT NULL,
  `bg_04` text NOT NULL,
  `bg_05` text NOT NULL,
  `bg_06` text NOT NULL,
  `bg_07` text NOT NULL,
  `bg_08` text NOT NULL,
  `bg_09` text NOT NULL,
  `bg_10` text NOT NULL,
  `bg_11` text NOT NULL,
  `bg_12` text NOT NULL,
  `bg_13` text NOT NULL,
  `caption` varchar(100) NOT NULL default '',
  `symbol` text NOT NULL,
  PRIMARY KEY  (`c_sns_config_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `c_template` (
  `c_template_id` int(11) NOT NULL auto_increment,
  `name` varchar(64) NOT NULL default '',
  `source` text NOT NULL,
  `r_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`c_template_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `c_tmp_image` (
  `c_tmp_image_id` int(11) NOT NULL auto_increment,
  `filename` text NOT NULL,
  `bin` longblob NOT NULL,
  `r_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `type` text,
  PRIMARY KEY  (`c_tmp_image_id`),
  KEY `filename` (`filename`(100))
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `mail_queue` (
  `id` bigint(20) NOT NULL default '0',
  `create_time` datetime NOT NULL default '0000-00-00 00:00:00',
  `time_to_send` datetime NOT NULL default '0000-00-00 00:00:00',
  `sent_time` datetime default NULL,
  `id_user` bigint(20) NOT NULL default '0',
  `ip` varchar(20) NOT NULL default 'unknown',
  `sender` varchar(50) NOT NULL default '',
  `recipient` varchar(50) NOT NULL default '',
  `headers` text NOT NULL,
  `body` longtext NOT NULL,
  `try_sent` tinyint(4) NOT NULL default '0',
  `delete_after_send` tinyint(1) NOT NULL default '1',
  PRIMARY KEY  (`id`),
  KEY `id` (`id`),
  KEY `time_to_send` (`time_to_send`),
  KEY `id_user` (`id_user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `mail_queue_seq` (
  `id` int(10) unsigned NOT NULL auto_increment,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `c_etsuran` (
 `c_etsuran_id` int(11) NOT NULL auto_increment,
 `c_member_id_from` int(11) NOT NULL default '0',
 `c_diary_id` int(11) NOT NULL default '0',
 `r_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
 PRIMARY KEY  (`c_etsuran_id`),
 KEY `c_member_id_from` (`c_member_id_from`),
 KEY `c_diary_id` (`c_diary_id`),
 KEY `c_member_from_diary_id` (`c_member_id_from`,`c_diary_id`,`r_datetime`)
 ) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `c_ranking` (
  `c_ranking_id` int(11) NOT NULL auto_increment,
  `ranking_date` date NOT NULL,
  `ranking_flag` int(1) NOT NULL,
  `id` int(11) NOT NULL,
  `ranking_count` int(11) NOT NULL,
  PRIMARY KEY  (`c_ranking_id`),
  KEY `ranking_date` (`ranking_date`,`ranking_count`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `c_tags` (
  `c_tags_id` int(11) NOT NULL auto_increment,
  `c_tags_name` varchar(36) NOT NULL ,
  `c_member_id` int(11) NOT NULL default '0',
  `r_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY (`c_tags_id`),
  KEY `c_tags_name` (`c_tags_name`),
  KEY `c_member_id` (`c_member_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `c_entry_tag` (
  `c_entry_tag_id` int(11) NOT NULL auto_increment,
  `c_entry_id` int(11) NOT NULL default '0',
  `c_entry_flag` tinyint(1) NOT NULL default '0',
  `c_tags_id` int(11) NOT NULL default '0',
  `c_member_id` int(11) NOT NULL default '0',
  `r_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY (`c_entry_tag_id`),
  KEY `c_entry_id` (`c_entry_id`),
  KEY `c_entry_id_flag` (`c_entry_id`,`c_entry_flag`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `c_dengon_comment` (
  `c_dengon_comment_id` int(11) NOT NULL auto_increment,
  `c_member_id_to` int(11) NOT NULL default '0',
  `c_member_id_from` int(11) NOT NULL default '0',
  `body` text NOT NULL,
  `r_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`c_dengon_comment_id`),
  KEY `c_member_id_to` (`c_member_id_to`,`r_datetime`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `c_display_view` (
    `c_display_view_id` int(11) NOT NULL auto_increment,
    `c_display_name` varchar(60) NOT NULL,
    `is_pc` tinyint(1) NOT NULL default '0',
    `is_money_flag` int(11) NOT NULL default '0',
    `template_foldername` text NOT NULL,
    PRIMARY KEY (`c_display_view_id`),
    KEY `is_money_flag` (`is_money_flag`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE IF NOT EXISTS `c_admin_information` (
    `c_admin_information_id` int(11) NOT NULL auto_increment,
    `subject` text NOT NULL,
    `body` text NOT NULL,
    `category` varchar(64) NOT NULL,
    `r_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
    `c_view_flag` tinyint(1) NOT NULL default '0',
    `public_flag` tinyint(1) NOT NULL default '0',
    PRIMARY KEY (`c_admin_information_id`),
    KEY `category` (`category`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8  ;
CREATE TABLE IF NOT EXISTS `c_delete_member_data` (
 `c_delete_member_data_id` int(11) NOT NULL auto_increment,
 `c_member_id` int(11) NOT NULL ,
 `nickname` text NOT NULL,
 `pc_address` text NOT NULL,
 `ktai_address` text NOT NULL,
 `regist_address` text NOT NULL,
 `easy_access_id` text NOT NULL,
 `ip_address` text NOT NULL,
 `user_agent` text NOT NULL,
 `delete_comment` text NOT NULL,
 `delete_flag` tinyint(1) NOT NULL default '0',
 `regist_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
 `delete_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
 `c_member_id_invite` int(11) NOT NULL,
 PRIMARY KEY  (`c_delete_member_data_id`),
 KEY `ktai_address` (`ktai_address`(100)),
 KEY `pc_address` (`pc_address`(100)),
 KEY `regist_address` (`regist_address`(100)),
 KEY `easy_access_id` (`easy_access_id`(50)),
 KEY `delete_datetime` (`delete_datetime`),
 KEY `regist_datetime` (`regist_datetime`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8  ;

CREATE TABLE IF NOT EXISTS `c_version` (
 c_version_id int(11) NOT NULL auto_increment,
 old_version_name text NOT NULL ,
 new_version_name text NOT NULL ,
 r_datetime datetime NOT NULL default '0000-00-00 00:00:00',
 PRIMARY KEY (`c_version_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `c_inquiry` (
    `c_inquiry_id` int(11) NOT NULL auto_increment,
    `c_member_id` int(11) NOT NULL ,
    `category_flag` tinyint NOT NULL default '0',
    `body` text NOT NULL,
    `data_id` int(11) NOT NULL default '0',
    `data_flag` int(2) NOT NULL default '0',
    `r_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
    PRIMARY KEY  (`c_inquiry_id`),
    KEY `c_member_id_r_datetime` (`c_member_id`,`r_datetime`),
    KEY `category_flag` (`category_flag`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


INSERT INTO `c_commu_category` VALUES (1,'地域情報',100,1);
INSERT INTO `c_commu_category` VALUES (2,'グルメスポット',200,1);
INSERT INTO `c_commu_category` VALUES (3,'趣味',300,1);

INSERT INTO `c_commu_category_parent` VALUES (1,'コミュニティカテゴリ',1);

INSERT INTO `c_member` VALUES (1,'Usagiちゃん',0,1,1,'private','','','','',NOW(),NOW(),'',0,1,1,1,0,1,'public',0,0,0,0,0,0);

INSERT INTO `c_password_query` VALUES (1,'母または父の旧姓は?');
INSERT INTO `c_password_query` VALUES (2,'運転免許証番号の下 5 桁は?');
INSERT INTO `c_password_query` VALUES (3,'初恋の人の名前は?');
INSERT INTO `c_password_query` VALUES (4,'卒業した小学校の名前は？');
INSERT INTO `c_password_query` VALUES (5,'本籍地の県名は？');

INSERT INTO `c_profile` VALUES (1,'sex','性別',0,0,'public','select',200,0,1,1,'string','',0,0);
INSERT INTO `c_profile` VALUES (2,'blood_type','血液型',0,1,'public','select',300,0,1,1,'string','',0,0);
INSERT INTO `c_profile` VALUES (3,'pre_addr_pref','現住所',0,1,'public','select',400,0,1,1,'string','',0,0);
INSERT INTO `c_profile` VALUES (4,'old_addr_pref','出身地',0,1,'public','select',500,0,1,1,'string','',0,0);
INSERT INTO `c_profile` VALUES (5,'self_intro','自己紹介',0,0,'public','textarea',600,0,1,1,'string','',0,0);

INSERT INTO `c_profile_option` VALUES (1,1,'男性',1);
INSERT INTO `c_profile_option` VALUES (2,1,'女性',2);
INSERT INTO `c_profile_option` VALUES (3,2,'A',1);
INSERT INTO `c_profile_option` VALUES (4,2,'B',2);
INSERT INTO `c_profile_option` VALUES (5,2,'O',3);
INSERT INTO `c_profile_option` VALUES (6,2,'AB',4);
INSERT INTO `c_profile_option` VALUES (7,3,'北海道',1);
INSERT INTO `c_profile_option` VALUES (8,3,'青森県',2);
INSERT INTO `c_profile_option` VALUES (9,3,'岩手県',3);
INSERT INTO `c_profile_option` VALUES (10,3,'宮城県',4);
INSERT INTO `c_profile_option` VALUES (11,3,'秋田県',5);
INSERT INTO `c_profile_option` VALUES (12,3,'山形県',6);
INSERT INTO `c_profile_option` VALUES (13,3,'福島県',7);
INSERT INTO `c_profile_option` VALUES (14,3,'茨城県',8);
INSERT INTO `c_profile_option` VALUES (15,3,'栃木県',9);
INSERT INTO `c_profile_option` VALUES (16,3,'群馬県',10);
INSERT INTO `c_profile_option` VALUES (17,3,'埼玉県',11);
INSERT INTO `c_profile_option` VALUES (18,3,'千葉県',12);
INSERT INTO `c_profile_option` VALUES (19,3,'東京都',13);
INSERT INTO `c_profile_option` VALUES (20,3,'神奈川県',14);
INSERT INTO `c_profile_option` VALUES (21,3,'新潟県',15);
INSERT INTO `c_profile_option` VALUES (22,3,'富山県',16);
INSERT INTO `c_profile_option` VALUES (23,3,'石川県',17);
INSERT INTO `c_profile_option` VALUES (24,3,'福井県',18);
INSERT INTO `c_profile_option` VALUES (25,3,'山梨県',19);
INSERT INTO `c_profile_option` VALUES (26,3,'長野県',20);
INSERT INTO `c_profile_option` VALUES (27,3,'岐阜県',21);
INSERT INTO `c_profile_option` VALUES (28,3,'静岡県',22);
INSERT INTO `c_profile_option` VALUES (29,3,'愛知県',23);
INSERT INTO `c_profile_option` VALUES (30,3,'三重県',24);
INSERT INTO `c_profile_option` VALUES (31,3,'滋賀県',25);
INSERT INTO `c_profile_option` VALUES (32,3,'京都府',26);
INSERT INTO `c_profile_option` VALUES (33,3,'大阪府',27);
INSERT INTO `c_profile_option` VALUES (34,3,'兵庫県',28);
INSERT INTO `c_profile_option` VALUES (35,3,'奈良県',29);
INSERT INTO `c_profile_option` VALUES (36,3,'和歌山県',30);
INSERT INTO `c_profile_option` VALUES (37,3,'鳥取県',31);
INSERT INTO `c_profile_option` VALUES (38,3,'島根県',32);
INSERT INTO `c_profile_option` VALUES (39,3,'岡山県',33);
INSERT INTO `c_profile_option` VALUES (40,3,'広島県',34);
INSERT INTO `c_profile_option` VALUES (41,3,'山口県',35);
INSERT INTO `c_profile_option` VALUES (42,3,'徳島県',36);
INSERT INTO `c_profile_option` VALUES (43,3,'香川県',37);
INSERT INTO `c_profile_option` VALUES (44,3,'愛媛県',38);
INSERT INTO `c_profile_option` VALUES (45,3,'高知県',39);
INSERT INTO `c_profile_option` VALUES (46,3,'福岡県',40);
INSERT INTO `c_profile_option` VALUES (47,3,'佐賀県',41);
INSERT INTO `c_profile_option` VALUES (48,3,'長崎県',42);
INSERT INTO `c_profile_option` VALUES (49,3,'熊本県',43);
INSERT INTO `c_profile_option` VALUES (50,3,'大分県',44);
INSERT INTO `c_profile_option` VALUES (51,3,'宮崎県',45);
INSERT INTO `c_profile_option` VALUES (52,3,'鹿児島県',46);
INSERT INTO `c_profile_option` VALUES (53,3,'沖縄県',47);
INSERT INTO `c_profile_option` VALUES (54,3,'その他',48);
INSERT INTO `c_profile_option` VALUES (55,4,'北海道',1);
INSERT INTO `c_profile_option` VALUES (56,4,'青森県',2);
INSERT INTO `c_profile_option` VALUES (57,4,'岩手県',3);
INSERT INTO `c_profile_option` VALUES (58,4,'宮城県',4);
INSERT INTO `c_profile_option` VALUES (59,4,'秋田県',5);
INSERT INTO `c_profile_option` VALUES (60,4,'山形県',6);
INSERT INTO `c_profile_option` VALUES (61,4,'福島県',7);
INSERT INTO `c_profile_option` VALUES (62,4,'茨城県',8);
INSERT INTO `c_profile_option` VALUES (63,4,'栃木県',9);
INSERT INTO `c_profile_option` VALUES (64,4,'群馬県',10);
INSERT INTO `c_profile_option` VALUES (65,4,'埼玉県',11);
INSERT INTO `c_profile_option` VALUES (66,4,'千葉県',12);
INSERT INTO `c_profile_option` VALUES (67,4,'東京都',13);
INSERT INTO `c_profile_option` VALUES (68,4,'神奈川県',14);
INSERT INTO `c_profile_option` VALUES (69,4,'新潟県',15);
INSERT INTO `c_profile_option` VALUES (70,4,'富山県',16);
INSERT INTO `c_profile_option` VALUES (71,4,'石川県',17);
INSERT INTO `c_profile_option` VALUES (72,4,'福井県',18);
INSERT INTO `c_profile_option` VALUES (73,4,'山梨県',19);
INSERT INTO `c_profile_option` VALUES (74,4,'長野県',20);
INSERT INTO `c_profile_option` VALUES (75,4,'岐阜県',21);
INSERT INTO `c_profile_option` VALUES (76,4,'静岡県',22);
INSERT INTO `c_profile_option` VALUES (77,4,'愛知県',23);
INSERT INTO `c_profile_option` VALUES (78,4,'三重県',24);
INSERT INTO `c_profile_option` VALUES (79,4,'滋賀県',25);
INSERT INTO `c_profile_option` VALUES (80,4,'京都府',26);
INSERT INTO `c_profile_option` VALUES (81,4,'大阪府',27);
INSERT INTO `c_profile_option` VALUES (82,4,'兵庫県',28);
INSERT INTO `c_profile_option` VALUES (83,4,'奈良県',29);
INSERT INTO `c_profile_option` VALUES (84,4,'和歌山県',30);
INSERT INTO `c_profile_option` VALUES (85,4,'鳥取県',31);
INSERT INTO `c_profile_option` VALUES (86,4,'島根県',32);
INSERT INTO `c_profile_option` VALUES (87,4,'岡山県',33);
INSERT INTO `c_profile_option` VALUES (88,4,'広島県',34);
INSERT INTO `c_profile_option` VALUES (89,4,'山口県',35);
INSERT INTO `c_profile_option` VALUES (90,4,'徳島県',36);
INSERT INTO `c_profile_option` VALUES (91,4,'香川県',37);
INSERT INTO `c_profile_option` VALUES (92,4,'愛媛県',38);
INSERT INTO `c_profile_option` VALUES (93,4,'高知県',39);
INSERT INTO `c_profile_option` VALUES (94,4,'福岡県',40);
INSERT INTO `c_profile_option` VALUES (95,4,'佐賀県',41);
INSERT INTO `c_profile_option` VALUES (96,4,'長崎県',42);
INSERT INTO `c_profile_option` VALUES (97,4,'熊本県',43);
INSERT INTO `c_profile_option` VALUES (98,4,'大分県',44);
INSERT INTO `c_profile_option` VALUES (99,4,'宮崎県',45);
INSERT INTO `c_profile_option` VALUES (100,4,'鹿児島県',46);
INSERT INTO `c_profile_option` VALUES (101,4,'沖縄県',47);
INSERT INTO `c_profile_option` VALUES (102,4,'その他',48);
INSERT INTO `c_profile_pref` VALUES (1,'北海道',1,43.068612,141.350768,7);
INSERT INTO `c_profile_pref` VALUES (2,'青森県',2,40.828668,140.734738,7);
INSERT INTO `c_profile_pref` VALUES (3,'岩手県',3,39.701547,141.136599,7);
INSERT INTO `c_profile_pref` VALUES (4,'宮城県',4,38.260027,140.882158,7);
INSERT INTO `c_profile_pref` VALUES (5,'秋田県',5,39.716748,140.129931,7);
INSERT INTO `c_profile_pref` VALUES (6,'山形県',6,38.248098,140.327253,7);
INSERT INTO `c_profile_pref` VALUES (7,'福島県',7,37.754123,140.45968,7);
INSERT INTO `c_profile_pref` VALUES (8,'茨城県',8,36.370911,140.47676,7);
INSERT INTO `c_profile_pref` VALUES (9,'栃木県',9,36.559246,139.898389,7);
INSERT INTO `c_profile_pref` VALUES (10,'群馬県',10,36.383399,139.072833,7);
INSERT INTO `c_profile_pref` VALUES (11,'埼玉県',11,35.906439,139.62405,7);
INSERT INTO `c_profile_pref` VALUES (12,'千葉県',12,35.613425,140.112837,7);
INSERT INTO `c_profile_pref` VALUES (13,'東京都',13,35.681391,139.766103,7);
INSERT INTO `c_profile_pref` VALUES (14,'神奈川県',14,35.465941,139.622847,7);
INSERT INTO `c_profile_pref` VALUES (15,'新潟県',15,37.912299,139.060869,7);
INSERT INTO `c_profile_pref` VALUES (16,'富山県',16,36.701384,137.213091,7);
INSERT INTO `c_profile_pref` VALUES (17,'石川県',17,36.578117,136.648166,7);
INSERT INTO `c_profile_pref` VALUES (18,'福井県',18,36.061479,136.223261,7);
INSERT INTO `c_profile_pref` VALUES (19,'山梨県',19,35.667054,138.569015,7);
INSERT INTO `c_profile_pref` VALUES (20,'長野県',20,36.643307,138.189101,7);
INSERT INTO `c_profile_pref` VALUES (21,'岐阜県',21,35.409967,136.756324,7);
INSERT INTO `c_profile_pref` VALUES (22,'静岡県',22,34.971629,138.388579,7);
INSERT INTO `c_profile_pref` VALUES (23,'愛知県',23,35.170694,136.881637,7);
INSERT INTO `c_profile_pref` VALUES (24,'三重県',24,34.734418,136.510581,7);
INSERT INTO `c_profile_pref` VALUES (25,'滋賀県',25,35.002997,135.864651,7);
INSERT INTO `c_profile_pref` VALUES (26,'京都府',26,34.985705,135.758228,7);
INSERT INTO `c_profile_pref` VALUES (27,'大阪府',27,34.702398,135.495188,7);
INSERT INTO `c_profile_pref` VALUES (28,'兵庫県',28,34.679453,135.178221,7);
INSERT INTO `c_profile_pref` VALUES (29,'奈良県',29,34.680482,135.818935,7);
INSERT INTO `c_profile_pref` VALUES (30,'和歌山県',30,34.232436,135.191454,7);
INSERT INTO `c_profile_pref` VALUES (31,'鳥取県',31,35.493953,134.225901,7);
INSERT INTO `c_profile_pref` VALUES (32,'島根県',32,35.463947,133.063871,7);
INSERT INTO `c_profile_pref` VALUES (33,'岡山県',33,34.666572,133.918552,7);
INSERT INTO `c_profile_pref` VALUES (34,'広島県',34,34.397446,132.475593,7);
INSERT INTO `c_profile_pref` VALUES (35,'山口県',35,34.172649,131.48061,7);
INSERT INTO `c_profile_pref` VALUES (36,'徳島県',36,34.074572,134.551391,7);
INSERT INTO `c_profile_pref` VALUES (37,'香川県',37,34.350754,134.046821,7);
INSERT INTO `c_profile_pref` VALUES (38,'愛媛県',38,33.839954,132.751149,7);
INSERT INTO `c_profile_pref` VALUES (39,'高知県',39,33.566758,133.543522,7);
INSERT INTO `c_profile_pref` VALUES (40,'福岡県',40,33.590002,130.420622,7);
INSERT INTO `c_profile_pref` VALUES (41,'佐賀県',41,33.264212,130.297608,7);
INSERT INTO `c_profile_pref` VALUES (42,'長崎県',42,32.753085,129.870515,7);
INSERT INTO `c_profile_pref` VALUES (43,'熊本県',43,32.789207,130.688499,7);
INSERT INTO `c_profile_pref` VALUES (44,'大分県',44,33.232794,131.606595,7);
INSERT INTO `c_profile_pref` VALUES (45,'宮崎県',45,31.915323,131.432083,7);
INSERT INTO `c_profile_pref` VALUES (46,'鹿児島県',46,31.602098,130.564112,7);
INSERT INTO `c_profile_pref` VALUES (47,'沖縄県',47,26.212401,127.680932,7);
INSERT INTO `c_profile_pref` VALUES (50,'その他',50,0,0,0);
INSERT INTO `c_review_category` VALUES (1,'Books','和書',1);
INSERT INTO `c_review_category` VALUES (2,'ForeignBooks','洋書',2);
INSERT INTO `c_review_category` VALUES (3,'Music','CDポピュラー',3);
INSERT INTO `c_review_category` VALUES (4,'Classical','CDクラシック',4);
INSERT INTO `c_review_category` VALUES (5,'DVD','DVD',5);
INSERT INTO `c_review_category` VALUES (6,'VideoGames','ゲーム',6);
INSERT INTO `c_review_category` VALUES (7,'Software','ソフトウェア',7);
INSERT INTO `c_review_category` VALUES (8,'Electronics','エレクトロニクス',8);
INSERT INTO `c_review_category` VALUES (9,'Kitchen','キッチン',9);
INSERT INTO `c_review_category` VALUES (10,'Toys','おもちゃ＆ホビー',10);
INSERT INTO `c_review_category` VALUES (11,'SportingGoods','スポーツ',11);
INSERT INTO `c_review_category` VALUES (12,'HealthPersonalCare','ヘルス＆ビューティー',12);
INSERT INTO `c_review_category` VALUES (13,'Watches','時計',13);
INSERT INTO `c_review_category` VALUES (14,'Baby','ベビー＆マタニティ',14);
INSERT INTO `c_review_category` VALUES (15,'Apparel','アパレル＆シューズ',15);

INSERT INTO `c_siteadmin` VALUES (1,'inc_page_footer_before','<a href=\"?m=pc&a=page_o_sns_kiyaku\" target=\"_blank\">利用規約</a> <a href=\"?m=pc&a=page_o_sns_privacy\" target=\"_blank\">プライバシーポリシー</a> <a href=\"http://usagi.mynets.jp/\" target=\"_blank\">Usagi Projectとは</a>',NOW());
INSERT INTO `c_siteadmin` VALUES (2,'inc_page_footer_after','<a href=\"?m=pc&a=page_o_sns_kiyaku\" target=\"_blank\">利用規約</a> <a href=\"?m=pc&a=page_o_sns_privacy\" target=\"_blank\">プライバシーポリシー</a>',NOW());
INSERT INTO `c_siteadmin` VALUES (3,'inc_custom_css','/**フォント色変更**/\n\n/*リンク関連*/\na:link    { color: #026CD1; }\na:visited { color: #004A95; }\na:hover   { color: #76AFE6; }\na:active  { color: #76AFE6; }\n\n/*コンテンツ見出しlv1*/\ntd.bg_06 span.b_b,\n.c_00 { color: #222222; }\n\n/*コンテンツ見出しlv2*/\n.c_01 { color: #444444; }\n\n/*強調文字暖色*/\n.c_02 { color: #D92C49; }\n\n/*強調文字寒色*/\n.c_03 { color: #2C65D9; }\n\n/*その他文字色*/\nbody { color: #000000; }',NOW());

INSERT INTO `c_skin_filename` VALUES (1,'no_image','skin_no_image.gif');
INSERT INTO `c_skin_filename` VALUES (2,'no_logo','skin_no_logo.gif');
INSERT INTO `c_skin_filename` VALUES (3,'no_logo_small','skin_no_logo_small.gif');

INSERT INTO `c_sns_config` VALUES (1,'default','FFFFFF','B7B9C6','FFFFFF','FFFFFF','FFFFFF','FFFFFF','FFFFFF','B7B9C6','FFFFFF','FFFFFF','FFFFFF','FFFFFF','B7B9C6','FFFFFF','FFFFFF','B7B9C6','FFFFFF','B7B9C6','B7B9C6','FFFFFF','FFFFFF','B7B9C6','C1C6CF','FFFFFF','E9EAF0','戻す','E9EAF0');
INSERT INTO `c_sns_config` VALUES (2,'red','FFFFFF','DCAA9D','FFFFFF','FFFFFF','FFFFFF','FFFFFF','FFFFFF','DCAA9D','FFFFFF','FFFFFF','FFFFFF','FFFFFF','DCAA9D','FFFFFF','FFFFFF','DCAA9D','FFFFFF','DCAA9D','DCAA9D','FFFFFF','FFFFFF','DCAA9D','E5A6A6','FFFFFF','FAE1DB','赤','E66161');
INSERT INTO `c_sns_config` VALUES (3,'yellow','FFFFFF','E9DC90','FFFFFF','FFFFFF','FFFFFF','FFFFFF','FFFFFF','E9DC90','FFFFFF','FFFFFF','FFFFFF','FFFFFF','E9DC90','FFFFFF','FFFFFF','E9DC90','FFFFFF','E9DC90','E9DC90','FFFFFF','FFFFFF','E9DC90','F2D299','FFFFFF','FFF9D6','黄色','FFDE1E');
INSERT INTO `c_sns_config` VALUES (4,'green','FFFFFF','AEDC9D','FFFFFF','FFFFFF','FFFFFF','FFFFFF','FFFFFF','AEDC9D','FFFFFF','FFFFFF','FFFFFF','FFFFFF','AEDC9D','FFFFFF','FFFFFF','AEDC9D','FFFFFF','AEDC9D','AEDC9D','FFFFFF','FFFFFF','AEDC9D','C5E5A6','FFFFFF','E3FADB','緑','6FDD46');
INSERT INTO `c_sns_config` VALUES (5,'gold','FFFFFF','C6C4B7','FFFFFF','FFFFFF','FFFFFF','FFFFFF','FFFFFF','C6C4B7','FFFFFF','FFFFFF','FFFFFF','FFFFFF','C6C4B7','FFFFFF','FFFFFF','C6C4B7','FFFFFF','C6C4B7','C6C4B7','FFFFFF','FFFFFF','C6C4B7','CFCAC1','FFFFFF','F0EFE9','黄金','DEC079');
INSERT INTO `c_sns_config` VALUES (6,'water','FFFFFF','95CEEA','FFFFFF','FFFFFF','FFFFFF','FFFFFF','FFFFFF','95CEEA','FFFFFF','FFFFFF','FFFFFF','FFFFFF','95CEEA','FFFFFF','FFFFFF','95CEEA','FFFFFF','95CEEA','95CEEA','FFFFFF','FFFFFF','95CEEA','9BE6F0','FFFFFF','D6F2FF','水色','2BD1E7');
INSERT INTO `c_sns_config` VALUES (7,'purple','FFFFFF','C29EE3','FFFFFF','FFFFFF','FFFFFF','FFFFFF','FFFFFF','C29EE3','FFFFFF','FFFFFF','FFFFFF','FFFFFF','C29EE3','FFFFFF','FFFFFF','C29EE3','FFFFFF','C29EE3','C29EE3','FFFFFF','FFFFFF','C29EE3','BCA7EC','FFFFFF','EEDCFE','紫','8A1EEA');
INSERT INTO `c_sns_config` VALUES (8,'default','FFFFFF','B7B9C6','FFFFFF','FFFFFF','FFFFFF','FFFFFF','FFFFFF','B7B9C6','FFFFFF','FFFFFF','FFFFFF','FFFFFF','B7B9C6','FFFFFF','FFFFFF','B7B9C6','FFFFFF','B7B9C6','B7B9C6','FFFFFF','FFFFFF','B7B9C6','C1C6CF','FFFFFF','E9EAF0','初期設定','E9EAF0');
INSERT INTO `mail_queue_seq` VALUES (1);

INSERT INTO `c_tags` (`c_tags_name`,`c_member_id`) VALUES ('その他','1');
INSERT INTO `c_display_view` (`c_display_name`,`is_pc`,`is_money_flag`,`template_foldername`) values (
    'ノーマル画面','0','0','') ;
INSERT INTO `c_display_view` (`c_display_name`,`is_pc`,`is_money_flag`,`template_foldername`) values (
    'サムネイル付き画面','0','0','new_templates') ;
INSERT INTO `c_display_view` (`c_display_name`,`is_pc`,`is_money_flag`,`template_foldername`) values (
    'Mixi風画面','1','0','new_templates') ;
INSERT INTO `c_admin_config` (`c_admin_config_id`, `name`, `value`) VALUES ( null, 'SKIN_FOLDER', 'default');
INSERT INTO `c_display_view` (`c_display_name`,`is_pc`,`is_money_flag`,`template_foldername`) values (
    '携帯用ライトページ','0','0','light_templates') ;

DROP TABLE IF EXISTS `c_diary_tag`;
