<?php

/* ========================================================================
 *
 * @license This source file is subject to version 3.01 of the PHP license,
 *              that is available at http://www.php.net/license/3_01.txt
 *              If you did not receive a copy of the PHP license and are unable
 *              to obtain it through the world-wide-web, please send a note to
 *              license@php.net so we can mail you a copy immediately.
 *
 * @category   Application of MyNETS
 * @project    OpenPNE UsagiProject 2006-2007
 * @package    MyNETS
 * @author     UsagiProject <info@usagi.mynets.jp>
 * @copyright  2006-2007 UsagiProject <author member ad http://usagi.mynets.jp/member.html>
 * @version    MyNETS,v 1.0.0
 * @since      File available since Release 1.0.0 Nighty
 * @chengelog  [2007/02/17] Ver1.1.0Nighty package
 * ========================================================================
 */

/*
 * Using Pattern public_html/img/moji/x_(unicode).gif
 *
*/
function smarty_modifier_t_moji($string)
{

    $moji_pattern = '/&(?:amp;|)#x([0-9A-F][0-9A-F][0-9A-F][0-9A-F]);/i';
    return preg_replace_callback($moji_pattern, 'smarty_modifier_t_moji_callback', $string);
}

function smarty_modifier_t_moji_callback($matches)
{
    $moji_file = sprintf('/moji/x_%s.gif',strtolower($matches[1]));
    if( is_readable("./img" . $moji_file) )
      return sprintf("<img src=\"img%s\">",$moji_file);
    else
      return $matches[0];
}

?>
