<?php

/* ========================================================================
 *
 * @license This source file is subject to version 3.01 of the PHP license,
 *              that is available at http://www.php.net/license/3_01.txt
 *              If you did not receive a copy of the PHP license and are unable 
 *              to obtain it through the world-wide-web, please send a note to 
 *              license@php.net so we can mail you a copy immediately.  
 *
 * @category   Application of MyNETS
 * @project    OpenPNE UsagiProject 2006-2007
 * @package    MyNETS
 * @author     UsagiProject <info@usagi.mynets.jp>
 * @copyright  2006-2007 UsagiProject <author member ad http://usagi.mynets.jp/member.html>
 * @version    MyNETS,v 1.0.0
 * @since      File available since Release 1.0.0 Nighty
 * @chengelog  [2007/02/17] Ver1.1.0Nighty package
 * ======================================================================== 
 */

/**
 * OpenPNE
 * @copyright 2005-2006 OpenPNE Project
 * @link      http://www.tejimaya.com/openpne.shtml
 *
 */

class pc_page_c_event_list extends OpenPNE_Action
{
    function execute($requests)
    {
        $u = $GLOBALS['AUTH']->uid();

        // --- リクエスト変数
        $c_commu_id = $requests['target_c_commu_id'];
        $direc = $requests['direc'];
        $page = $requests['page'];
        // ----------


        $page_size = 20;
        $c_commu = _db_c_commu4c_commu_id($c_commu_id);

        //コミュニティの存在の有無
        if (!$c_commu) {
            openpne_redirect('pc', 'page_h_err_c_home');
        }

        $this->set('inc_navi', fetch_inc_navi('c', $c_commu_id));

        $page += $direc;

        $this->set("c_commu", $c_commu);
        list($result, $is_prev, $is_next, $total_num, $start_num, $end_num)
            = p_c_topic_list_c_topic_list4target_c_commu_id($c_commu_id, $u, $page, $page_size, 1, 1);
        $this->set("c_topic_list", $result);
        $this->set("is_prev", $is_prev);
        $this->set("is_next", $is_next);
        $this->set("page", $page);
        $this->set("total_num", $total_num);
        $this->set('start_num', $start_num);
        $this->set('end_num', $end_num);


        //--- 権限チェック
        $is_c_commu_member = _db_is_c_commu_member($c_commu_id, $u);

        if (!$is_c_commu_member && $c_commu['public_flag'] == "auth_commu_member") {
            $is_warning = true;
        } else {
            $is_warning = false;
        }
        $this->set("is_warning", $is_warning);
        //---

        $this->set("is_c_commu_admin", _db_is_c_commu_admin($c_commu_id, $u));
        $this->set("is_c_commu_member", $is_c_commu_member);

        return 'success';
    }
}

?>
