<?php
/* ========================================================================
 *
 * @license This source file is subject to version 3.01 of the PHP license,
 *              that is available at http://www.php.net/license/3_01.txt
 *              If you did not receive a copy of the PHP license and are unable
 *              to obtain it through the world-wide-web, please send a note to
 *              license@php.net so we can mail you a copy immediately.
 *
 * @category   Application of MyNETS
 * @project    OpenPNE UsagiProject 2006-2007
 * @package    MyNETS
 * @author     UsagiProject <info@usagi.mynets.jp>
 * @copyright  2006-2007 UsagiProject <author member ad http://usagi.mynets.jp/>
 * @version    MyNETS,v 1.0.0
 * @since      File available since Release 1.0.0 Nighty
 * @chengelog  [2007/05/24] Ver1.1.0Nighty package
 * ========================================================================
 */


//// サーバー管理設定 ////

//--- 必須設定

// Web上の絶対パス(URL)(最後にスラッシュを付けてください)
define('OPENPNE_URL', 'http://mynets.sakura.ne.jp/Usagi/');

// DBサーバ設定
$GLOBALS['_OPENPNE_DSN_LIST']['main'] = array(
'dsn'  => array(
    'phptype'  => 'mysql',
    'username' => 'mynets',
    'password' => '11091109',
    'hostspec' => 'mysql26.db.sakura.ne.jp',
    'database' => 'mynets',
    'new_link' => false,
    ),
);

//MyNETSでテーブルのPREFIXを利用するかどうか
//define('MYNETS_PREFIX_NAME','MyNETS_');
define('MYNETS_PREFIX_NAME','mynets_');

// DB暗号化キー(56バイト以内のASCII文字列)
define('ENCRYPT_KEY', 'usagi');

// メールサーバードメイン
// 携帯メール投稿の宛先などのドメイン名に使われる
define('MAIL_SERVER_DOMAIN', 'pooldigest.go2.jp');


//--- オプション設定

// デバッグモード
// 0: off ... エラー非表示、エラーログを記録する
// 1: on  ... エラー表示、エラーログを記録しない
// 2: on  ... 1 + Smartyデバッグコンソール
define('OPENPNE_DEBUGGING', 0);

// 無効にするモジュール
$GLOBALS['_OPENPNE_DISABLE_MODULES'] = array();
//$GLOBALS['_OPENPNE_DISABLE_MODULES'] = array('admin', 'setup');

// メンテナンスモード
// true: メンバーにメンテナンス画面を表示
define('OPENPNE_UNDER_MAINTENANCE', false);

// メンテナンス中でも表示するモジュール名
$GLOBALS['_OPENPNE_MAINTENANCE_MODULES'] = array('admin');

// 1.8以前形式のURLでアクセスした場合の動作設定
// 0    : 直接新URLへ移動する
// n(>0): URL変更お知らせ画面を表示、n秒後に移動する
// -1   : URL変更お知らせ画面を表示、自動的に移動しない
define('WAIT_REDIRECT_TIME', 5);

// Crypt_Blowfish ライブラリの旧バージョン使用設定
// 2.2以前からのアップグレードでログインできないなどの
//暗号化まわりの不具合が起こった場合はtrueに設定してください
define('OPENPNE_USE_OLD_CRYPT_BLOWFISH', false);

// ファンクションキャッシュ使用設定
//有効にした場合は、最新情報の表示に遅延が起こることがあります
define('OPENPNE_USE_FUNCTION_CACHE', false);

// MySQL ヒント使用設定
define('OPENPNE_USE_MYSQL_HINT', true);

// セッション情報をDBに保存するかどうか
// (有効にする場合は、以下のDBサーバ設定も行ってください)
define('SESSION_SAVE_DB', false);

// 確認画面用の一時画像をDBに保存するかどうか
define('OPENPNE_TMP_IMAGE_DB', false);

///
// DBサーバ設定
///

// メインデータ読み込み用DB(オプション)
//$GLOBALS['_OPENPNE_DSN_LIST']['main_reader'][] = array(
//'priority' => 1,
//'dsn' => array(
//    'phptype'  => 'mysql',
//    'username' => '',
//    'password' => '',
//    'hostspec' => 'localhost',
//    'database' => '',
//    'new_link' => false,
//    ),
//);
//$GLOBALS['_OPENPNE_DSN_LIST']['main_reader'][] = array(
//'priority' => 1,
//'dsn' => array(
//    'phptype'  => 'mysql',
//    'username' => '',
//    'password' => '',
//    'hostspec' => 'localhost',
//    'database' => '',
//    'new_link' => false,
//    ),
//);

// セッションデータ保存用DB(オプション)
//$GLOBALS['_OPENPNE_DSN_LIST']['session'] = array(
//'dsn' => array(
//    'phptype'  => 'mysql',
//    'username' => '',
//    'password' => '',
//    'hostspec' => 'localhost',
//    'database' => '',
//    'new_link' => false,
//    ),
//);

// 画像データ保存用DB(オプション)
//$GLOBALS['_OPENPNE_DSN_LIST']['image'] = array(
//'dsn' => array(
//    'phptype'  => 'mysql',
//    'username' => '',
//    'password' => '',
//    'hostspec' => 'localhost',
//    'database' => '',
//    ),
//);

///
// SSL設定
///

// 特定ページだけのSSLを使用するかどうか
define('OPENPNE_USE_PARTIAL_SSL', false);

// SSL使用状況をリクエストパラメータから取得するかどうか
define('OPENPNE_USE_SSL_PARAM', false);

// SSL用URL (Cookieの値を引き継ぐため、OPENPNE_URL と同一ドメイン・パスである必要があります)
define('OPENPNE_SSL_URL', 'https://sns.example.com/');

// SSLを使用することが必須であるモジュールリスト
$GLOBALS['_OPENPNE_SSL_REQUIRED_MODULES'] = array('admin');

// SSLを使用することが必須であるアクションリスト
$GLOBALS['_OPENPNE_SSL_REQUIRED'] = array(
'pc' => array(
    'page_o_regist_prof',  'page_o_regist_prof_confirm', 'do_o_regist_prof',
    'page_o_regist_intro', 'page_o_ri', 'page_o_regist_end',
    'page_h_config_prof', 'page_h_config_prof_confirm', 'do_h_config_prof',
    'page_h_config_ktai', 'do_h_config_ktai_send',
),
'ktai' => array(
    'page_o_login', 'do_o_login', 'do_o_easy_login',
    'page_o_login2', 'do_o_update_ktai_address',
    'page_o_regist_pre', 'page_o_regist_input', 'do_o_insert_c_member',
    'page_o_regist_end',
    'page_o_password_query', 'do_o_password_query',
    'page_h_config_prof', 'do_h_config_prof_update_c_member',
    'page_h_config_easy_login', 'do_h_config_easy_login',
    'page_h_config_mail', 'do_h_config_mail_insert_c_ktai_address_pre',
    'page_h_pc_send', 'page_h_pc_send_confirm', 'do_h_pc_send_insert_c_pc_address_pre',
    'page_h_config_password_query', 'do_h_config_password_query_update_password_query',
    'page_h_config_password', 'do_h_config_password_update_password',
));

// SSLを使用するかどうかメンバーが選択できるアクションリスト
$GLOBALS['_OPENPNE_SSL_SELECTABLE'] = array(
'pc' => array(
    'page_h_config', 'do_h_config_1', 'do_h_config_2', 'do_h_config_3',
    'page_o_login', 'page_o_tologin', 'do_o_login',
),
'ktai' => array(
    'page_h_config',
));

///
// パス設定
///

define('OPENPNE_LIB_DIR'    , OPENPNE_DIR . '/lib');
define('OPENPNE_VAR_DIR'    , OPENPNE_DIR . '/var');
define('OPENPNE_WEBAPP_DIR' , OPENPNE_DIR . '/webapp');
define('OPENPNE_MODULES_DIR', OPENPNE_WEBAPP_DIR . '/modules');
define('OPENPNE_RSS_CACHE_DIR', OPENPNE_VAR_DIR . '/rss_cache');

///
// webapp_ext ディレクトリ使用設定
///

define('USE_EXT_DIR', false);
define('OPENPNE_WEBAPP_EXT_DIR' , OPENPNE_DIR . '/webapp_ext');
define('OPENPNE_MODULES_EXT_DIR', OPENPNE_WEBAPP_EXT_DIR . '/modules');

///
// デバッグ、エラーハンドリング、ログ設定
///

error_reporting(E_ALL ^ E_NOTICE);
$GLOBALS['SMARTY'] = array();

switch(OPENPNE_DEBUGGING) {
// テスト開発環境
case 2:
    $GLOBALS['SMARTY']['debugging'] = true;
case 1:
    ini_set('display_errors', true);
    ini_set('log_errors', false);
//  $GLOBALS['SMARTY']['autoload_filters'] = array( "pre" => array("strip"),"output"=>array("comment") );
    break;
// 本番運用環境
case 0:
default:
    ini_set('display_errors', false);
    ini_set('log_errors', true);
    ini_set('error_log', OPENPNE_VAR_DIR . '/log/php_errors.log');
    $GLOBALS['SMARTY']['autoload_filters'] = array( "pre" => array("strip"),"output"=>array("comment") );
    break;
}

// アクセスログを取得するかどうか(c_access_log)
define('LOG_C_ACCESS_LOG', true);

///
// セッション・クッキー設定
///

ini_set('session.gc_maxlifetime', 432000); // 5 days
//session_save_path('/tmp');

// PC版
// セッション生成時からの有効期限(秒) (0 の場合は無期限)
$GLOBALS['OpenPNE']['common']['session_lifetime'] = 0;
// セッションの有効期限(秒)
$GLOBALS['OpenPNE']['common']['session_idletime'] = 432000; // 5 days

// 携帯版
// セッション生成時からの有効期限(秒) (0 の場合は無限)
$GLOBALS['OpenPNE']['ktai']['session_lifetime'] = 0;
// セッションの有効期限(秒)
$GLOBALS['OpenPNE']['ktai']['session_idletime'] = 3600; // 1 hour

// 管理画面版
// セッション生成時からの有効期限(秒) (0 の場合は無限)
$GLOBALS['OpenPNE']['admin']['session_lifetime'] = 0;
// セッションの有効期限(秒)
$GLOBALS['OpenPNE']['admin']['session_idletime'] = 86400; // 1 day

// セッションにOPENPNE_URLを保存しておく
// 同一サーバ上で複数のSNSを運用する場合のセッションの混同を防ぐ
// falseからtrueにした場合、または2.4RC1以前のバージョンからアップデートした場合
// それまでのセッションが無効になりログアウトされます
define('OPENPNE_SESSION_CHECK_URL', true);

///
// 画像
///

// 画像を別サーバに設定する場合に指定する
//define('OPENPNE_IMG_URL', 'http://img.example.com/');

// 画像キャッシュをpublic_html以下に置くかどうか(要mod_rewrite)
define('OPENPNE_IMG_CACHE_PUBLIC', false);

// 画像キャッシュディレクトリ(要書き込み権限)
if (OPENPNE_IMG_CACHE_PUBLIC) {
    define('OPENPNE_IMG_CACHE_DIR', OPENPNE_DIR . '/public_html/img');
} else {
    define('OPENPNE_IMG_CACHE_DIR', OPENPNE_VAR_DIR . '/img_cache');
}

// 画像変換時に許可する解像度のリスト (幅x高さ)
// (空の配列を指定すると無制限になります)
$GLOBALS['_OPENPNE_IMG_ALLOWED_SIZE'] = array('36x36', '76x76', '120x120', '180x180', '360x360');

// 画像キャッシュのファイル名のprefix
define('OPENPNE_IMG_CACHE_PREFIX', 'img_cache_');

// 画像変換後のJPEGのQUALITY値
define('OPENPNE_IMG_JPEG_QUALITY', 75);

// ImageMagick使用設定
// 0: off ... ImageMagickを使わない
// 1: on  ... GIFのみImageMagickを使う
// 2: on  ... JEPG,PNG,GIFにImageMagickを使う(ただし、GDも必要)
define('USE_IMAGEMAGICK', 0);

// ImageMagick の convertコマンドのパス
define('IMGMAGICK_APP', '/usr/bin/convert');
//define('IMGMAGICK_APP', '"C:\Program Files\ImageMagick-6.2.5-Q16\convert"');

// ImageMagick のオプション(デフォルトは -resize)
//define('IMGMAGICK_OPT', '-thumbnail');
//define('IMGMAGICK_OPT', '-deconstruct -coalesce -resize');

// アップロード画像のファイルサイズ制限(KB)
define('IMAGE_MAX_FILESIZE', 300);

///
// 外部RSS取得
///

// 一度に取得するRSSの件数
define('RSS_CACHE_LIMIT', 100);

///
// 携帯メール投稿
///

// 宛先アドレスのprefix
//define('MAIL_ADDRESS_PREFIX', 'sns_');

// 宛先アドレスをハッシュにするか
define('MAIL_ADDRESS_HASHED', true);

// 受信メールの文字コード(Content-Typeから取得できない場合に使う)
//define('MAIL_FROM_ENCODING', 'JIS');
define('MAIL_FROM_ENCODING', 'auto');

// メールログを取るかどうか(var/log/mail.log)
define('MAIL_DEBUG_LOG', false);

///
// メール送信設定
///

// 半角カタカナを全角カタカナに変換して送信する
define('MAIL_HAN2ZEN', true);

// MTAに渡すヘッダの改行コード(LF->CRLF の自動変換が行われることへの対策)
//define('MAIL_HEADER_SEP', 'CRLF');
define('MAIL_HEADER_SEP', 'LF');

// Envelope-From で設定するメールアドレス
//(指定しない場合は、管理者メールアドレス(Fromと同じ))
//define('MAIL_ENVFROM', 'system@example.com');

///
// mbstring設定
///

mb_language('Japanese');
ini_set('mbstring.detect_order', 'auto');
ini_set('mbstring.http_input'  , 'auto');
ini_set('mbstring.http_output' , 'pass');
ini_set('mbstring.internal_encoding', 'UTF-8');
ini_set('mbstring.script_encoding'  , 'UTF-8');
ini_set('mbstring.substitute_character', 'none');
mb_regex_encoding('UTF-8');

// Validatorで全角スペースを削除するかどうか
// mb_ereg_replace でエラーが出る場合は false にしてください
define('OPENPNE_TRIM_DOUBLEBYTE_SPACE', true);

///
// API通信設定
///

// API通信使用設定
define('OPENPNE_USE_API', false);

// セッション鍵生成用文字列(適当な文字列に変更してください)
define('OPENPNE_API_TOKEN', 'OpenPNE');

// 許可するIPリスト('any'が含まれている場合はIPをチェックしません)
$GLOBALS['_OPENPNE_API_IP_LIST'] = array(
'127.0.0.1',
//'192.168.0.1',
//'any',
);

// クライアントのIPアドレスのあるサーバ変数名($_SERVER['REMOTE_ADDR'])
//define('SERVER_IP_KEY', 'HTTP_X_FORWARDED_FOR');
define('SERVER_IP_KEY', 'REMOTE_ADDR');

///
// umask設定
///

umask(0);

///
// Google Maps API key
///
define('GOOGLE_MAPS_API_KEY', 'ABQIAAAAOhYgEtdZ3tGDw4V46myN5RTbcWqBLpxi6yxFEGeCIB0nCXk8yxRM2f0IVRpwB6EdBuGjHxLjk20CXg');


//// SNSアプリケーション設定 ////

// 管理画面のURL設定
//(OPENPNE_URL)?m=ADMIN_MODULE_NAME (例. http://sns.example.com/?m=admin)
define('ADMIN_MODULE_NAME', 'admin');

// 管理画面の初期設定項目を表示するかどうか
define('ADMIN_INIT_CONFIG', true);

// 管理画面にバージョン情報を表示するかどうか
define('DISPLAY_VERSION', true);

// 管理画面にOpenPNE更新情報(RSS)を表示するかどうか
define('DISPLAY_OPENPNE_INFO', true);

// OpenPNE Usagi Project更新情報のURL設定
define('OPENPNE_INFO_URL', 'http://usagi.mynets.jp/PRESS/feed/');


// 携帯版でUser-Agentのチェックをするかどうか
define('CHECK_KTAI_UA', true);

// メール一斉送信のメールキューの使用
define('OPENPNE_MAIL_QUEUE', false);
// メールキューで一度に送信するメールの数
define('SEND_MAIL_QUEUE_NUM', 10);

/* ここからうさぎちゃん */

// 未ログイン日数を変更(default=3)
//define('LASTLOGIN_DAYS', 7);

// どのDBモジュールを使用するか ('pne','mysql')
define('MYNETS_DB_MODULE', 'mysql');

// CAPTCHA（画像のなかの文字列をメンバーに入力させる認証方式）を使用するかどうか
define('MYNETS_USE_CAPTCHA', true);

?>
