<?php

/* ========================================================================
 *
 * @license This source file is subject to version 3.01 of the PHP license,
 *              that is available at http://www.php.net/license/3_01.txt
 *              If you did not receive a copy of the PHP license and are unable 
 *              to obtain it through the world-wide-web, please send a note to 
 *              license@php.net so we can mail you a copy immediately.  
 *
 * @category   Application of MyNETS
 * @project    OpenPNE UsagiProject 2006-2007
 * @package    MyNETS
 * @author     UsagiProject <info@usagi.mynets.jp>
 * @copyright  2006-2007 UsagiProject <author member ad http://usagi.mynets.jp/member.html>
 * @version    MyNETS,v 1.0.0
 * @since      File available since Release 1.0.0 Nighty
 * @chengelog  [2007/02/17] Ver1.1.0Nighty package
 * ======================================================================== 
 */


//タグの抽出

/**
 * タグリスト取得
 * 
 * ORDER BY タグ名称//後日変更可能性あり
 * @return array タグリスト
 */
function getTagList()
{
    $sql = 'SELECT * FROM ' . MYNETS_PREFIX_NAME . 'c_tags ' .
            ' ORDER BY tag_name ';
    return db_get_all($sql);
}

/**
 * タグ名称取得
 * 
 * 
 * @return タグ名
 */
function getTagName($c_tags_id)
{
    $sql = 'SELECT * FROM ' . MYNETS_PREFIX_NAME . 'c_tags ' .
            ' WHERE c_tags_id = ? ';
    return db_get_row($sql,array(intval($c_tags_id)));
}

/**
 * 日記で利用されているタグの抽出
 * 
 * @param c_diary_id
 * @return array タグリスト
 */
function getDiaryTag($c_diary_id)
{
    $sql = 'SELECT * FROM ' . MYNETS_PREFIX_NAME . 'c_diary_tag ' .
            ' WHERE c_diary_id = ? ';
    $list = db_get_all($sql,array(intval($c_diary_id)));

    foreach($list as $key => $value) {
        $list[$key]['tag_name'] = getTagName($value['c_tags_id']);
    }
    return $list;
}


/**
 * タグ利用率による抽出？
 * 
 */


?>
