/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.schema.identity;

import org.apache.xerces.framework.XMLAttrList;
import org.apache.xerces.utils.IntStack;
import org.apache.xerces.utils.NamespacesScope;
import org.apache.xerces.utils.QName;
import org.apache.xerces.utils.StringPool;
import org.apache.xerces.validators.schema.identity.XPath;

public class XPathMatcher {
    protected static final boolean DEBUG_ALL = false;
    protected static final boolean DEBUG_METHODS = false;
    protected static final boolean DEBUG_METHODS2 = false;
    protected static final boolean DEBUG_METHODS3 = false;
    protected static final boolean DEBUG_MATCH = false;
    protected static final boolean DEBUG_STACK = false;
    protected static final boolean DEBUG_ANY = false;
    private XPath.LocationPath fLocationPath;
    private boolean fShouldBufferContent;
    private boolean fBufferContent;
    private StringBuffer fMatchedBuffer = new StringBuffer();
    private boolean fMatched;
    private String fMatchedString;
    private IntStack fStepIndexes = new IntStack();
    private int fCurrentStep;
    private int fNoMatchDepth;
    protected StringPool fStringPool;
    protected NamespacesScope fNamespacesScope;

    public XPathMatcher(XPath xPath) {
        this(xPath, false);
    }

    public XPathMatcher(XPath xPath, boolean bl) {
        this.fLocationPath = xPath.getLocationPath();
        this.fShouldBufferContent = bl;
    }

    public boolean isMatched() {
        return this.fMatched;
    }

    public String getMatchedString() {
        return this.fMatchedString;
    }

    protected void matched(String string) throws Exception {
    }

    public void startDocumentFragment(StringPool stringPool, NamespacesScope namespacesScope) throws Exception {
        this.clear();
        this.fMatchedBuffer.setLength(0);
        this.fStepIndexes.clear();
        this.fCurrentStep = 0;
        this.fNoMatchDepth = 0;
        this.fStringPool = stringPool;
        this.fNamespacesScope = namespacesScope;
        if (namespacesScope == null) {
            this.fNamespacesScope = new NamespacesScope();
        }
    }

    public void startElement(QName qName, XMLAttrList xMLAttrList, int n) throws Exception {
        XPath.NodeTest nodeTest;
        int n2 = this.fCurrentStep;
        this.fStepIndexes.push(n2);
        if (this.fMatched || this.fNoMatchDepth > 0) {
            ++this.fNoMatchDepth;
            return;
        }
        XPath.Step[] stepArray = this.fLocationPath.steps;
        while (this.fCurrentStep < stepArray.length && stepArray[this.fCurrentStep].axis.type == 3) {
            ++this.fCurrentStep;
        }
        if (this.fCurrentStep == stepArray.length) {
            this.fMatched = true;
            boolean bl = this.fBufferContent = this.fShouldBufferContent;
        }
        if (this.fCurrentStep == n2 && stepArray[this.fCurrentStep].axis.type == 1) {
            XPath.Step step = stepArray[this.fCurrentStep];
            nodeTest = step.nodeTest;
            if (nodeTest.type == 1 && !nodeTest.name.equals(qName)) {
                ++this.fNoMatchDepth;
                return;
            }
            ++this.fCurrentStep;
        }
        if (this.fCurrentStep == stepArray.length) {
            this.fMatched = true;
            boolean bl = this.fBufferContent = this.fShouldBufferContent;
        }
        if (this.fCurrentStep < stepArray.length && stepArray[this.fCurrentStep].axis.type == 2) {
            int n3 = xMLAttrList.getFirstAttr(n);
            if (n3 != -1) {
                nodeTest = stepArray[this.fCurrentStep].nodeTest;
                QName qName2 = new QName();
                while (n3 != -1) {
                    int n4 = xMLAttrList.getAttrPrefix(n3);
                    int n5 = xMLAttrList.getAttrLocalpart(n3);
                    int n6 = xMLAttrList.getAttrName(n3);
                    int n7 = xMLAttrList.getAttrURI(n3);
                    qName2.setValues(n4, n5, n6, n7);
                    if (nodeTest.type != 1 || nodeTest.name.equals(qName2)) {
                        ++this.fCurrentStep;
                        if (this.fCurrentStep != stepArray.length) break;
                        this.fMatched = true;
                        int n8 = xMLAttrList.getAttValue(n3);
                        this.fMatchedString = this.fStringPool.toString(n8);
                        this.matched(this.fMatchedString);
                        break;
                    }
                    n3 = xMLAttrList.getNextAttr(n3);
                }
            }
            if (!this.fMatched) {
                ++this.fNoMatchDepth;
                return;
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) throws Exception {
        if (this.fBufferContent && this.fNoMatchDepth == 0) {
            this.fMatchedBuffer.append(cArray, n, n2);
        }
    }

    public void endElement(QName qName) throws Exception {
        if (this.fNoMatchDepth > 0) {
            --this.fNoMatchDepth;
        } else {
            if (this.fBufferContent) {
                this.fBufferContent = false;
                this.fMatchedString = this.fMatchedBuffer.toString();
                this.matched(this.fMatchedString);
            }
            this.clear();
        }
        this.fCurrentStep = this.fStepIndexes.pop();
    }

    public void endDocumentFragment() throws Exception {
        this.clear();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = super.toString();
        int n = string.lastIndexOf(46);
        if (n != -1) {
            string = string.substring(n + 1);
        }
        stringBuffer.append(string);
        stringBuffer.append('[');
        XPath.Step[] stepArray = this.fLocationPath.steps;
        int n2 = 0;
        while (n2 < stepArray.length) {
            if (n2 == this.fCurrentStep) {
                stringBuffer.append('^');
            }
            stringBuffer.append(stepArray[n2].toString());
            if (n2 < stepArray.length - 1) {
                stringBuffer.append('/');
            }
            ++n2;
        }
        if (this.fCurrentStep == stepArray.length) {
            stringBuffer.append('^');
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    private void clear() {
        this.fBufferContent = false;
        this.fMatchedBuffer.setLength(0);
        this.fMatched = false;
        this.fMatchedString = null;
    }

    private String normalize(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '\n': {
                    stringBuffer.append("\\n");
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }
}

