/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.mp3.ID3Reader;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLReplyCollection;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLSchemaRepository;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import com.limegroup.gnutella.xml.RichQueryHandler;
import com.limegroup.gnutella.xml.SchemaReplyCollectionMapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class MetaFileManager
extends FileManager {
    private final Object META_LOCK = new Object();

    public synchronized Response[] query(QueryRequest request) {
        Response[] metas;
        LimeXMLDocument doc;
        Response[] result = super.query(request);
        if (this.shouldIncludeXMLInResponse(request) && (doc = request.getRichQuery()) != null && (metas = RichQueryHandler.instance().query(doc)) != null) {
            result = this.union(result, metas);
        }
        return result;
    }

    protected boolean shouldIncludeXMLInResponse(QueryRequest qr) {
        return qr.desiresXMLResponses() || qr.desiresOutOfBandReplies();
    }

    protected void addXMLToResponse(Response response, FileDesc fd) {
        List docs = fd.getLimeXMLDocuments();
        if (docs.size() == 0) {
            return;
        }
        if (docs.size() == 1) {
            response.setDocument((LimeXMLDocument)docs.get(0));
        }
    }

    public FileDesc fileChanged(File f) {
        FileDesc fd = this.getFileDescForFile(f);
        if (fd == null) {
            return null;
        }
        LinkedList<LimeXMLDocument> xmlDocs = new LinkedList<LimeXMLDocument>();
        if (LimeXMLUtils.isMP3File(f)) {
            try {
                xmlDocs.add(ID3Reader.readDocument(f));
            }
            catch (IOException e) {
                return super.fileChanged(f);
            }
        }
        xmlDocs.addAll(fd.getLimeXMLDocuments());
        FileDesc removed = this.removeFileIfShared(f);
        Assert.that(fd == removed, "did not remove valid fd.");
        return this.addFileIfShared(f, xmlDocs);
    }

    public FileDesc removeFileIfShared(File f) {
        FileDesc fd = super.removeFileIfShared(f);
        if (fd == null) {
            return null;
        }
        SchemaReplyCollectionMapper mapper = SchemaReplyCollectionMapper.instance();
        List xmlDocs = fd.getLimeXMLDocuments();
        LinkedList<String> schemas = new LinkedList<String>();
        Iterator i = xmlDocs.iterator();
        while (i.hasNext()) {
            schemas.add(((LimeXMLDocument)i.next()).getSchemaURI());
        }
        i = schemas.iterator();
        while (i.hasNext()) {
            String uri = (String)i.next();
            LimeXMLReplyCollection col = mapper.getReplyCollection(uri);
            if (col == null) continue;
            col.removeDoc(fd);
        }
        return fd;
    }

    public FileDesc addFileIfShared(File file, List metadata) {
        FileDesc fd = super.addFileIfShared(file);
        if (fd == null) {
            return null;
        }
        if (metadata == null || metadata.size() == 0) {
            LimeXMLDocument doc;
            if (!LimeXMLUtils.isMP3File(file)) {
                return fd;
            }
            try {
                doc = ID3Reader.readDocument(file);
            }
            catch (IOException ioe) {
                return fd;
            }
            metadata = new LinkedList<LimeXMLDocument>();
            metadata.add(doc);
        }
        SchemaReplyCollectionMapper mapper = SchemaReplyCollectionMapper.instance();
        LinkedList<String> schemasAddedTo = new LinkedList<String>();
        Iterator iter = metadata.iterator();
        while (iter.hasNext()) {
            LimeXMLDocument currDoc = (LimeXMLDocument)iter.next();
            String uri = currDoc.getSchemaURI();
            LimeXMLReplyCollection collection = mapper.getReplyCollection(uri);
            if (collection == null || schemasAddedTo.contains(uri)) continue;
            schemasAddedTo.add(uri);
            if (ID3Reader.isCorrupted(currDoc)) {
                currDoc = ID3Reader.fixCorruption(currDoc);
            }
            collection.addReplyWithCommit(file, fd, currDoc);
        }
        return fd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadSettingsBlocking(boolean notifyOnClear) {
        RouterService.getCallback().setAnnotateEnabled(false);
        super.loadSettingsBlocking(notifyOnClear);
        if (this.loadThreadInterrupted()) {
            return;
        }
        Object object = this.META_LOCK;
        synchronized (object) {
            SchemaReplyCollectionMapper mapper = SchemaReplyCollectionMapper.instance();
            LimeXMLSchemaRepository schemaRepository = LimeXMLSchemaRepository.instance();
            if (this.loadThreadInterrupted()) {
                return;
            }
            String[] schemas = schemaRepository.getAvailableSchemaURIs();
            int len = schemas.length;
            FileDesc[] fds = super.getAllSharedFileDescriptors();
            for (int i = 0; i < len && !this.loadThreadInterrupted(); ++i) {
                String s = LimeXMLSchema.getDisplayString(schemas[i]);
                LimeXMLReplyCollection collection = new LimeXMLReplyCollection(fds, schemas[i], s.equalsIgnoreCase("audio"));
                mapper.add(schemas[i], collection);
            }
        }
        RouterService.getCallback().setAnnotateEnabled(true);
    }

    private Response[] union(Response[] normals, Response[] metas) {
        int i;
        if (normals == null) {
            return metas;
        }
        if (metas == null) {
            return normals;
        }
        HashSet<Response> unionSet = new HashSet<Response>();
        for (i = 0; i < metas.length; ++i) {
            unionSet.add(metas[i]);
        }
        for (i = 0; i < normals.length; ++i) {
            unionSet.add(normals[i]);
        }
        Response[] retArray = new Response[unionSet.size()];
        retArray = unionSet.toArray(retArray);
        return retArray;
    }

    public List getKeyWords() {
        ArrayList words = super.getKeyWords();
        if (words == null) {
            words = new ArrayList();
        }
        SchemaReplyCollectionMapper map = SchemaReplyCollectionMapper.instance();
        LimeXMLSchemaRepository rep = null;
        try {
            rep = LimeXMLSchemaRepository.instance();
        }
        catch (Exception e) {
            return words;
        }
        String[] schemas = rep.getAvailableSchemaURIs();
        int len = schemas.length;
        for (int i = 0; i < len; ++i) {
            LimeXMLReplyCollection collection = map.getReplyCollection(schemas[i]);
            if (collection == null) continue;
            words.addAll(collection.getKeyWords());
        }
        return words;
    }

    public List getIndivisibleKeyWords() {
        ArrayList<String> words = super.getIndivisibleKeyWords();
        if (words == null) {
            words = new ArrayList<String>();
        }
        LimeXMLSchemaRepository rep = LimeXMLSchemaRepository.instance();
        String[] schemas = rep.getAvailableSchemaURIs();
        for (int i = 0; i < schemas.length; ++i) {
            if (schemas[i] == null) continue;
            words.add(schemas[i]);
        }
        return words;
    }
}

