/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import com.limegroup.gnutella.xml.SchemaNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class LimeXMLDocumentHelper {
    private static boolean debugOn = false;

    private LimeXMLDocumentHelper() {
    }

    public static List getDocuments(String aggregrateXMLStr, int totalResponseCount) {
        int startIndex;
        ArrayList<LimeXMLDocument[]> retList = new ArrayList<LimeXMLDocument[]>();
        DOMParser parser = new DOMParser();
        if (aggregrateXMLStr == null || aggregrateXMLStr.equals("")) {
            return retList;
        }
        int endIndex = startIndex = aggregrateXMLStr.indexOf("<?xml");
        String chunk = "";
        boolean finished = false;
        while (!finished) {
            startIndex = endIndex;
            if (startIndex == -1) {
                finished = true;
                continue;
            }
            endIndex = aggregrateXMLStr.indexOf("<?xml", startIndex + 1);
            chunk = endIndex > 0 ? aggregrateXMLStr.substring(startIndex, endIndex) : aggregrateXMLStr.substring(startIndex);
            LimeXMLDocument[] docs = new LimeXMLDocument[totalResponseCount];
            Element rootElement = LimeXMLDocumentHelper.getDOMTree(parser, chunk);
            if (rootElement == null) {
                retList.add(null);
                continue;
            }
            List children = LimeXMLUtils.getElements(rootElement.getChildNodes());
            int z = children.size();
            for (int i = 0; i < z; ++i) {
                Node currNode = (Node)children.get(i);
                String cIndex = LimeXMLDocumentHelper.getAttributeValue(currNode, "index");
                try {
                    int currIndex = Integer.parseInt(cIndex);
                }
                catch (NumberFormatException nfe) {
                    continue;
                }
                LimeXMLDocument currDoc = null;
                try {
                    currDoc = new LimeXMLDocument(currNode, rootElement);
                }
                catch (IOException e) {
                    continue;
                }
                catch (SchemaNotFoundException snfx) {
                    continue;
                }
                docs[currIndex] = currDoc;
            }
            retList.add(docs);
        }
        return retList;
    }

    public static List breakSingleSchemaAggregateString(String aggregrateXMLStr) {
        Element rootElement = LimeXMLDocumentHelper.getDOMTree(new DOMParser(), aggregrateXMLStr);
        if (rootElement == null) {
            return null;
        }
        ArrayList<LimeXMLDocument> docs = new ArrayList<LimeXMLDocument>();
        List children = LimeXMLUtils.getElements(rootElement.getChildNodes());
        Iterator iterator = children.iterator();
        while (iterator.hasNext()) {
            Node currNode = (Node)iterator.next();
            LimeXMLDocument doc = null;
            try {
                doc = new LimeXMLDocument(currNode, rootElement);
            }
            catch (IOException iox) {
                continue;
            }
            catch (SchemaNotFoundException snfx) {
                continue;
            }
            docs.add(doc);
        }
        return docs;
    }

    public static String getAggregateString(Response[] responses) {
        HashMap uriToString = new HashMap();
        for (int i = 0; i < responses.length; ++i) {
            LimeXMLDocument doc = responses[i].getDocument();
            if (doc == null) continue;
            LimeXMLDocumentHelper.aggregateResponse(uriToString, doc, i);
        }
        StringBuffer retStringB = new StringBuffer();
        Iterator iter = uriToString.values().iterator();
        while (iter.hasNext()) {
            String str = ((StringBuffer)iter.next()).toString();
            int begin = str.indexOf("<", 2);
            int end = str.indexOf(" ", begin);
            retStringB.append(str);
            retStringB.append("</");
            retStringB.append(str.substring(begin + 1, end));
            retStringB.append(">");
        }
        return retStringB.toString();
    }

    private static void aggregateResponse(HashMap uriToString, LimeXMLDocument doc, int index) {
        if (doc == null) {
            return;
        }
        String uri = doc.getSchemaURI();
        StringBuffer currStringB = (StringBuffer)uriToString.get(uri);
        if (currStringB == null) {
            String str = null;
            try {
                str = doc.getXMLString();
            }
            catch (SchemaNotFoundException e) {
                return;
            }
            if (str == null || str.equals("")) {
                return;
            }
            int p = (str = str.substring(0, str.lastIndexOf("<"))).indexOf("<");
            Assert.that(p >= 0, "LimeXMLDocument is broken");
            p = str.indexOf("<", p + 1);
            Assert.that(p >= 0, "LimeXMLDocument is broken");
            p = str.indexOf("<", p + 1);
            Assert.that(p >= 0, "LimeXMLDocument is broken");
            int q = str.indexOf(">", p + 1);
            int k = str.lastIndexOf("/", q - 1);
            p = k != -1 && p < k && k < q ? (str.substring(k + 1, q).trim().equals("") ? k : q) : q;
            String first = str.substring(0, p);
            String last = str.substring(p);
            StringBuffer strB = new StringBuffer(first.length() + 15 + last.length());
            strB.append(first);
            strB.append(" index=\"");
            strB.append(index);
            strB.append("\" ");
            strB.append(last);
            uriToString.put(uri, strB);
        } else {
            String str = null;
            try {
                str = doc.getXMLString();
            }
            catch (SchemaNotFoundException e) {
                return;
            }
            int begin = str.indexOf("<");
            Assert.that(begin != -1, str);
            begin = str.indexOf("<", begin + 1);
            Assert.that(begin != -1, str);
            begin = str.indexOf("<", begin + 1);
            Assert.that(begin != -1, str);
            int end = str.lastIndexOf("<");
            Assert.that(end != -1, str);
            str = str.substring(begin, end);
            int p = str.indexOf(">");
            int q = str.lastIndexOf("/", p - 1);
            if (q != -1 && q < p && str.substring(q + 1, p).trim().equals("")) {
                p = q;
            }
            String first = str.substring(0, p);
            String last = str.substring(p);
            currStringB.append(first);
            currStringB.append(" index=\"");
            currStringB.append(index);
            currStringB.append("\" ");
            currStringB.append(last);
            uriToString.put(uri, currStringB);
        }
    }

    private static Element getDOMTree(DOMParser parser, String aggrigateXMLStr) {
        InputSource source = new InputSource(new StringReader(aggrigateXMLStr));
        Document root = null;
        try {
            parser.parse(source);
        }
        catch (SAXException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
        root = parser.getDocument();
        Element rootElement = root.getDocumentElement();
        return rootElement;
    }

    private static String getAttributeValue(Node element, String targetName) {
        String lowerTargetName = targetName.toLowerCase(Locale.US);
        List atts = LimeXMLUtils.getAttributes(element.getAttributes());
        String retString = "";
        int z = atts.size();
        for (int i = 0; i < z; ++i) {
            Node att = (Node)atts.get(i);
            String lowerAttName = att.getNodeName().toLowerCase(Locale.US);
            if (lowerAttName.indexOf(lowerTargetName) < 0) continue;
            retString = att.getNodeValue();
        }
        return retString;
    }

    public static void debug(String out) {
        if (debugOn) {
            System.out.println(out);
        }
    }
}

