/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.NetworkUtils;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;

public class Sockets {
    private static Constructor _inetAddressConstructor;
    private static Class _socketClass;
    private static Class _socketAddressClass;
    private static Method _setKeepAliveMethod;
    private static Method _connectMethod;
    static /* synthetic */ Class class$java$lang$String;

    private Sockets() {
    }

    public static boolean setKeepAlive(Socket socket, boolean on) {
        if (CommonUtils.isJava13OrLater()) {
            try {
                _setKeepAliveMethod.invoke((Object)socket, on ? Boolean.TRUE : Boolean.FALSE);
                return true;
            }
            catch (IllegalAccessException e) {
                ErrorService.error(e);
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return false;
    }

    public static Socket connect(String host, int port, int timeout) throws IOException {
        if (!NetworkUtils.isValidPort(port)) {
            throw new IllegalArgumentException("port out of range: " + port);
        }
        if (CommonUtils.isJava14OrLater()) {
            try {
                Socket ret = (Socket)_socketClass.newInstance();
                Object addr = _inetAddressConstructor.newInstance(host, new Integer(port));
                _connectMethod.invoke((Object)ret, addr, new Integer(timeout));
                return ret;
            }
            catch (InvocationTargetException e) {
                Throwable e2 = e.getTargetException();
                if (!(e2 instanceof IOException)) {
                    ErrorService.error(e2);
                }
                throw (IOException)e2;
            }
            catch (InstantiationException e) {
                ErrorService.error(e);
            }
            catch (IllegalAccessException e) {
                ErrorService.error(e);
            }
        }
        if (timeout != 0) {
            return new SocketOpener(host, port).connect(timeout);
        }
        return new Socket(host, port);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            if (CommonUtils.isJava13OrLater()) {
                _socketClass = Class.forName("java.net.Socket");
                _setKeepAliveMethod = _socketClass.getMethod("setKeepAlive", Boolean.TYPE);
            }
            if (CommonUtils.isJava14OrLater()) {
                Class<?> socketAddress = Class.forName("java.net.InetSocketAddress");
                _inetAddressConstructor = socketAddress.getConstructor(class$java$lang$String == null ? (class$java$lang$String = Sockets.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE);
                _socketAddressClass = Class.forName("java.net.SocketAddress");
                _connectMethod = _socketClass.getMethod("connect", _socketAddressClass, Integer.TYPE);
            }
        }
        catch (Exception e) {
            ErrorService.error(e);
        }
    }

    private static class SocketOpener {
        private String host;
        private int port;
        private Socket socket = null;
        private boolean timedOut = false;
        private boolean completed = false;

        public SocketOpener(String host, int port) {
            if ((port & 0xFFFF0000) != 0) {
                throw new IllegalArgumentException("port out of range: " + port);
            }
            this.host = host;
            this.port = port;
        }

        public synchronized Socket connect(int timeout) throws IOException {
            Thread t = new Thread((Runnable)new SocketOpenerThread(), "SocketOpener");
            t.setDaemon(true);
            t.start();
            try {
                this.wait(timeout);
            }
            catch (InterruptedException e) {
                if (this.socket == null) {
                    this.timedOut = true;
                } else {
                    try {
                        this.socket.close();
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                }
                throw new IOException();
            }
            if (!this.completed) {
                t.stop();
            }
            if (this.socket != null) {
                return this.socket;
            }
            this.timedOut = true;
            throw new IOException();
        }

        private class SocketOpenerThread
        implements Runnable {
            private SocketOpenerThread() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Socket sock = null;
                try {
                    try {
                        sock = new Socket(SocketOpener.this.host, SocketOpener.this.port);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    SocketOpener e = SocketOpener.this;
                    synchronized (e) {
                        SocketOpener.this.completed = true;
                        if (SocketOpener.this.timedOut && sock != null) {
                            try {
                                sock.close();
                            }
                            catch (IOException iOException) {}
                        } else {
                            SocketOpener.this.socket = sock;
                            SocketOpener.this.notify();
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }
}

