/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.ErrorService;

class SimpleTimerTask
implements Comparable {
    private final Runnable _task;
    private final long _period;
    private long _nextTime;

    SimpleTimerTask(Runnable task, long period, long nextTime) {
        this._task = task;
        this._period = period;
        this._nextTime = nextTime;
    }

    public long timeUntilExecution() {
        return this._nextTime - System.currentTimeMillis();
    }

    public boolean runAndReschedule() {
        try {
            this._task.run();
        }
        catch (Exception e) {
            ErrorService.error(e);
        }
        if (this._period == 0L) {
            return false;
        }
        this._nextTime = System.currentTimeMillis() + this._period;
        return true;
    }

    public int compareTo(Object x) {
        long ret = ((SimpleTimerTask)x)._nextTime - this._nextTime;
        return ByteOrder.long2int(ret);
    }
}

