/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.downloader.Interval;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class IntervalSet {
    private List intervals = new ArrayList();

    public void add(Interval addInterval) {
        int low = addInterval.low;
        int high = addInterval.high;
        Interval lower = null;
        Interval higher = null;
        Iterator iter = this.intervals.iterator();
        while (iter.hasNext()) {
            Interval interval = (Interval)iter.next();
            if (low <= interval.low && interval.high <= high) {
                iter.remove();
                continue;
            }
            if (low <= interval.high && interval.low < low) {
                lower = interval;
            }
            if (interval.high == low - 1) {
                lower = interval;
            }
            if (interval.low <= high && interval.high > high) {
                higher = interval;
            }
            if (high != interval.low - 1) continue;
            higher = interval;
        }
        if (lower == null && higher == null) {
            this.intervals.add(new Interval(low, high));
        } else if (lower != null && higher != null) {
            this.intervals.remove(higher);
            this.intervals.remove(lower);
            this.intervals.add(new Interval(lower.low, higher.high));
        } else if (higher != null) {
            this.intervals.remove(higher);
            this.intervals.add(new Interval(low, higher.high));
        } else if (lower != null) {
            this.intervals.remove(lower);
            this.intervals.add(new Interval(lower.low, high));
        }
    }

    public Interval removeFirst() {
        return (Interval)this.intervals.remove(0);
    }

    public List getOverlapIntervals(Interval checkInterval) {
        ArrayList<Interval> overlapBlocks = new ArrayList<Interval>();
        long low = checkInterval.low;
        long high = checkInterval.high;
        if (low >= high) {
            return overlapBlocks;
        }
        Iterator iter = this.intervals.iterator();
        while (iter.hasNext()) {
            Interval interval = (Interval)iter.next();
            if (low <= (long)interval.low && (long)interval.high <= high) {
                overlapBlocks.add(interval);
                continue;
            }
            if (low <= (long)interval.high && (long)interval.low < low) {
                overlapBlocks.add(new Interval((int)low, Math.min((int)high, interval.high)));
            }
            if ((long)interval.low > high || (long)interval.high <= high) continue;
            overlapBlocks.add(new Interval(Math.max(interval.low, (int)low), (int)high));
        }
        return overlapBlocks;
    }

    public Iterator getAllIntervals() {
        return this.intervals.iterator();
    }

    public List getAllIntervalsAsList() {
        return this.intervals;
    }

    public int getSize() {
        int sum = 0;
        Iterator iter = this.intervals.iterator();
        while (iter.hasNext()) {
            Interval block = (Interval)iter.next();
            sum += block.high - block.low + 1;
        }
        return sum;
    }

    public boolean isEmpty() {
        return this.intervals.isEmpty();
    }

    public void clear() {
        this.intervals.clear();
    }

    public Iterator getNeededIntervals(int maxSize) {
        if (this.intervals == null || this.intervals.size() == 0) {
            Interval block = new Interval(0, maxSize - 1);
            ArrayList<Interval> buf = new ArrayList<Interval>();
            buf.add(block);
            return buf.iterator();
        }
        Collections.sort(this.intervals, new IntervalComparator());
        ArrayList<Interval> buf = new ArrayList<Interval>();
        int low = -1;
        Interval interval = null;
        Iterator iter = this.intervals.iterator();
        while (iter.hasNext()) {
            interval = (Interval)iter.next();
            if (interval.low != 0 && low < interval.low) {
                buf.add(new Interval(low + 1, interval.low - 1));
            }
            low = interval.high;
        }
        Assert.that(interval != null, "Null interval in getFreeBlocks");
        if (interval.high < maxSize - 1) {
            buf.add(new Interval(interval.high + 1, maxSize - 1));
        }
        return buf.iterator();
    }

    private class IntervalComparator
    implements Comparator {
        private IntervalComparator() {
        }

        public int compare(Object a, Object b) {
            Interval ia = (Interval)a;
            Interval ib = (Interval)b;
            return ia.low - ib.low;
        }
    }
}

