/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.util.UnmodifiableIterator;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;

public final class IntBuffer
implements Cloneable {
    private final int size;
    private final int[] buf;
    private int head;
    private int tail;

    public IntBuffer(int size) {
        Assert.that(size >= 1);
        this.size = size + 1;
        this.buf = new int[size + 1];
        this.head = 0;
        this.tail = 0;
    }

    public IntBuffer(IntBuffer other) {
        this.size = other.size;
        this.head = other.head;
        this.tail = other.tail;
        this.buf = new int[other.buf.length];
        System.arraycopy(other.buf, 0, this.buf, 0, other.buf.length);
    }

    public boolean isEmpty() {
        return this.head == this.tail;
    }

    public boolean isFull() {
        return this.increment(this.tail) == this.head;
    }

    public final int size() {
        return this.getSize();
    }

    public int getSize() {
        if (this.head <= this.tail) {
            return this.tail - this.head;
        }
        return this.size - this.head + this.tail;
    }

    public int getCapacity() {
        return this.size - 1;
    }

    private int decrement(int i) {
        if (i == 0) {
            return this.size - 1;
        }
        return i - 1;
    }

    private int increment(int i) {
        if (i == this.size - 1) {
            return 0;
        }
        return i + 1;
    }

    private int index(int i) throws IndexOutOfBoundsException {
        if (i < 0 || i >= this.getSize()) {
            throw new IndexOutOfBoundsException();
        }
        return (i + this.head) % this.size;
    }

    public int get(int i) throws IndexOutOfBoundsException {
        return this.buf[this.index(i)];
    }

    public void set(int i, int value) throws IndexOutOfBoundsException {
        this.buf[this.index((int)i)] = value;
    }

    public int add(int x) {
        return this.addFirst(x);
    }

    public int addFirst(int x) {
        int ret = -1;
        if (this.isFull()) {
            ret = this.removeLast();
        }
        this.head = this.decrement(this.head);
        this.buf[this.head] = x;
        return ret;
    }

    public int addLast(int x) {
        int ret = -1;
        if (this.isFull()) {
            ret = this.removeFirst();
        }
        this.buf[this.tail] = x;
        this.tail = this.increment(this.tail);
        return ret;
    }

    public boolean contains(int x) {
        IntBufferIterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (iterator.nextInt() != x) continue;
            return true;
        }
        return false;
    }

    public int first() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.buf[this.head];
    }

    public int last() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.buf[this.decrement(this.tail)];
    }

    public int removeFirst() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        int ret = this.buf[this.head];
        this.buf[this.head] = -1;
        this.head = this.increment(this.head);
        return ret;
    }

    public int removeLast() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        this.tail = this.decrement(this.tail);
        int ret = this.buf[this.tail];
        this.buf[this.tail] = -1;
        return ret;
    }

    public int remove(int i) throws IndexOutOfBoundsException {
        int ret = this.get(i);
        int j = this.index(i);
        while (j != this.tail) {
            this.buf[j] = this.buf[this.increment(j)];
            j = this.increment(j);
        }
        this.tail = this.decrement(this.tail);
        return ret;
    }

    public boolean removeValue(int x) {
        for (int i = 0; i < this.getSize(); ++i) {
            if (x != this.get(i)) continue;
            this.remove(i);
            return true;
        }
        return false;
    }

    public boolean removeAll(int x) {
        boolean ret = false;
        for (int i = 0; i < this.getSize(); ++i) {
            if (x != this.get(i)) continue;
            this.remove(i);
            --i;
            ret = true;
        }
        return ret;
    }

    public void clear() {
        this.head = 0;
        this.tail = 0;
    }

    public IntBufferIterator iterator() {
        return new IntBufferIterator();
    }

    public Object clone() {
        return new IntBuffer(this);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        boolean isFirst = true;
        IntBufferIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (!isFirst) {
                buf.append(", ");
            } else {
                isFirst = false;
            }
            buf.append(iter.nextInt());
        }
        buf.append("]");
        return buf.toString();
    }

    private class IntBufferIterator
    extends UnmodifiableIterator {
        int index;
        int oldHead;
        int oldTail;

        IntBufferIterator() {
            this.index = IntBuffer.this.head;
            this.oldHead = IntBuffer.this.head;
            this.oldTail = IntBuffer.this.tail;
        }

        public boolean hasNext() {
            this.ensureNoModifications();
            return this.index != IntBuffer.this.tail;
        }

        public Object next() throws NoSuchElementException {
            throw new UnsupportedOperationException();
        }

        public int nextInt() throws NoSuchElementException {
            this.ensureNoModifications();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int ret = IntBuffer.this.buf[this.index];
            this.index = IntBuffer.this.increment(this.index);
            return ret;
        }

        private void ensureNoModifications() {
            if (this.oldHead != IntBuffer.this.head || this.oldTail != IntBuffer.this.tail) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

