/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.util.NoMoreStorageException;
import java.util.HashMap;
import java.util.Set;

public class FixedsizeHashMap {
    private int count = 0;
    private int size = 0;
    private HashMap hashMap = null;

    public FixedsizeHashMap(int size) {
        this.hashMap = new HashMap(size * 4 / 3);
        this.size = size;
    }

    public synchronized Object put(Object key, Object value) throws NoMoreStorageException {
        Object retValue = null;
        if (this.count < this.size) {
            retValue = this.hashMap.put(key, value);
            if (retValue == null) {
                ++this.count;
            }
        } else {
            retValue = this.hashMap.get(key);
            if (retValue != null) {
                retValue = this.hashMap.put(key, value);
            } else {
                throw new NoMoreStorageException();
            }
        }
        return retValue;
    }

    public synchronized Object get(Object key) {
        return this.hashMap.get(key);
    }

    public synchronized Object remove(Object key) {
        Object ret = this.hashMap.remove(key);
        if (ret != null) {
            --this.count;
        }
        return ret;
    }

    public synchronized Set entrySet() {
        return this.hashMap.entrySet();
    }

    public boolean isFull() {
        return this.count >= this.size;
    }

    public synchronized String toString() {
        return this.hashMap.toString();
    }
}

