/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.util.CommonUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;

public class FileUtils {
    public static void writeMap(String filename, Map map) throws IOException, ClassNotFoundException {
        ObjectOutputStream out = null;
        if (out != null) {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map readMap(String filename) throws IOException, ClassNotFoundException {
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(new FileInputStream(filename));
            Map map = (Map)in.readObject();
            return map;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public static File[] listFiles(File f) {
        String[] children = f.list();
        if (children == null) {
            return null;
        }
        File[] ret = new File[children.length];
        for (int i = 0; i < children.length; ++i) {
            ret[i] = new File(f, children[i]);
        }
        return ret;
    }

    public static File[] listFiles(File f, FilenameFilter filter) {
        String[] children = f.list(filter);
        if (children == null) {
            return null;
        }
        File[] ret = new File[children.length];
        for (int i = 0; i < children.length; ++i) {
            ret[i] = new File(f, children[i]);
        }
        return ret;
    }

    public static File getParentFile(File f) {
        String name = f.getParent();
        if (name == null) {
            return null;
        }
        try {
            return FileUtils.getCanonicalFile(new File(name));
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public static File getCanonicalFile(File f) throws IOException {
        return new File(f.getCanonicalPath());
    }

    public static String getFileExtension(File f) {
        String name = f.getName();
        int index = name.lastIndexOf(".");
        if (index == -1) {
            return null;
        }
        if (index == 0) {
            return null;
        }
        if (index == name.length() - 1) {
            return null;
        }
        return name.substring(index + 1);
    }

    public static boolean setWriteable(File f) {
        String fName;
        if (f.canWrite()) {
            return true;
        }
        try {
            fName = f.getCanonicalPath();
        }
        catch (IOException ioe) {
            fName = f.getPath();
        }
        String[] cmds = null;
        cmds = CommonUtils.isWindows() ? new String[]{"attrib", "-r", fName} : (CommonUtils.isMacClassic() ? null : new String[]{"chmod", "u+w", fName});
        if (cmds != null) {
            try {
                Process p = Runtime.getRuntime().exec(cmds);
                p.waitFor();
            }
            catch (SecurityException ignored) {
            }
            catch (IOException ignored) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return f.canWrite();
    }
}

