/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;

public final class CommonUtils {
    public static final String QHD_VENDOR_NAME = "ACQL";
    private static final Properties PROPS = System.getProperties();
    private static final String VERSION = "0.23";
    private static final String HTTP_SERVER = "LimeWire(AcqLite)/0.23";
    static File SETTINGS_DIRECTORY = new File(System.getProperty("user.home") + "/Library/Application Support/AcqLite/");
    private static final char[] ILLEGAL_CHARS_ANY_OS = new char[]{'/', '\n', '\r', '\t', '\u0000', '\f'};
    private static final char[] ILLEGAL_CHARS_UNIX = new char[]{'`'};
    private static final char[] ILLEGAL_CHARS_WINDOWS = new char[]{'?', '*', '\\', '<', '>', '|', '\"', ':'};

    public static String getVendor() {
        return HTTP_SERVER;
    }

    public static String getHttpServer() {
        return HTTP_SERVER;
    }

    public static String getJavaVersion() {
        return PROPS.getProperty("java.version");
    }

    public static String getOS() {
        return PROPS.getProperty("os.name");
    }

    public static File getCurrentDirectory() {
        return new File(PROPS.getProperty("user.dir"));
    }

    public static boolean isUltrapeerOS() {
        return true;
    }

    public static int getUPMajorVersionNumber() {
        return 0;
    }

    public static int getUPMinorVersionNumber() {
        return 1;
    }

    public static int getGUESSMajorVersionNumber() {
        return 0;
    }

    public static int getGUESSMinorVersionNumber() {
        return 1;
    }

    public static int getMajorVersionNumber() {
        return 0;
    }

    public static int getMinorVersionNumber() {
        return 7;
    }

    public static boolean isJava14OrLater() {
        String version = CommonUtils.getJavaVersion();
        return !version.startsWith("1.3") && !version.startsWith("1.2") && !version.startsWith("1.1") && !version.startsWith("1.0");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static int copy(File src, int amount, File dst) {
        int amountToRead;
        block24: {
            IOException e222;
            OutputStream out;
            BufferedInputStream in;
            block21: {
                int read;
                int BUFFER_SIZE = 1024;
                in = null;
                out = null;
                in = new BufferedInputStream(new FileInputStream(src));
                out = new BufferedOutputStream(new FileOutputStream(dst));
                byte[] buf = new byte[1024];
                for (amountToRead = amount; amountToRead > 0 && (read = ((InputStream)in).read(buf, 0, Math.min(1024, amountToRead))) != -1; amountToRead -= read) {
                    out.write(buf, 0, read);
                }
                Object var10_10 = null;
                if (in == null) break block21;
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e222) {
                    // empty catch block
                }
            }
            if (out != null) {
                try {
                    out.flush();
                }
                catch (IOException e222) {
                    // empty catch block
                }
                try {
                    out.close();
                }
                catch (IOException e222) {}
            }
            break block24;
            {
                catch (IOException e3) {
                    IOException e222;
                    e3.printStackTrace();
                    Object var10_11 = null;
                    if (in != null) {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (IOException e222) {
                            // empty catch block
                        }
                    }
                    if (out == null) break block24;
                    try {
                        out.flush();
                    }
                    catch (IOException e222) {
                        // empty catch block
                    }
                    try {
                        out.close();
                    }
                    catch (IOException e222) {}
                }
            }
            catch (Throwable throwable) {
                IOException e222;
                Object var10_12 = null;
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException e222) {
                        // empty catch block
                    }
                }
                if (out != null) {
                    try {
                        out.flush();
                    }
                    catch (IOException e222) {
                        // empty catch block
                    }
                    try {
                        out.close();
                    }
                    catch (IOException e222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return amount - amountToRead;
    }

    public static boolean copy(File src, File dst) {
        long length = src.length();
        return (long)CommonUtils.copy(src, (int)length, dst) == length;
    }

    public static File getUserHomeDir() {
        return new File(PROPS.getProperty("user.home"));
    }

    public static synchronized File getUserSettingsDir() {
        return SETTINGS_DIRECTORY;
    }

    public static String getLimeWireVersion() {
        return VERSION;
    }

    public static boolean isMacClassic() {
        return false;
    }

    public static boolean isMacOSX() {
        return true;
    }

    public static boolean isWindows() {
        return false;
    }

    public static boolean supportsTray() {
        return false;
    }

    public static boolean isJava13OrLater() {
        return true;
    }

    public static boolean isJava118() {
        return false;
    }

    public static String getUserName() {
        return PROPS.getProperty("user.name");
    }

    public static String convertFileName(String name) {
        int i;
        if (name.length() > 180) {
            int extStart = name.lastIndexOf(46);
            if (extStart == -1) {
                name = name.substring(0, 180);
            } else {
                int extLength = name.length() - extStart;
                int extEnd = extLength > 11 ? extStart + 11 : name.length();
                name = name.substring(0, 180 - extLength) + name.substring(extStart, extEnd);
            }
        }
        for (i = 0; i < ILLEGAL_CHARS_ANY_OS.length; ++i) {
            name = name.replace(ILLEGAL_CHARS_ANY_OS[i], '_');
        }
        if (CommonUtils.isWindows()) {
            for (i = 0; i < ILLEGAL_CHARS_WINDOWS.length; ++i) {
                name = name.replace(ILLEGAL_CHARS_WINDOWS[i], '_');
            }
        }
        return name;
    }
}

