/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

public class BandwidthThrottle {
    private static final int TICKS_PER_SECOND = 10;
    private static final int MILLIS_PER_TICK = 100;
    private volatile int _bytesPerTick;
    private int _availableBytes;
    private long _nextTickTime;

    public BandwidthThrottle(float bytesPerSecond) {
        this.setRate(bytesPerSecond);
    }

    public void setRate(float bytesPerSecond) {
        this._bytesPerTick = (int)(bytesPerSecond / 10.0f);
    }

    public synchronized int request(int desired) {
        this.waitForBandwidth();
        int result = Math.min(desired, this._availableBytes);
        this._availableBytes -= result;
        return result;
    }

    private void waitForBandwidth() {
        while (true) {
            long now = System.currentTimeMillis();
            this.updateWindow(now);
            if (this._availableBytes != 0) break;
            try {
                Thread.currentThread();
                Thread.sleep(this._nextTickTime - now);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void updateWindow(long now) {
        if (now >= this._nextTickTime) {
            this._availableBytes = this._bytesPerTick;
            this._nextTickTime = now + 100L;
        }
    }
}

