/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.statistics.UploadStat;
import java.io.IOException;
import java.io.OutputStream;

public final class StalledUploadWatchdog
implements Runnable {
    public static long DELAY_TIME = 120000L;
    private OutputStream ostream;
    private boolean isScheduled;
    private long nextCheckTime;
    private boolean closed;

    public synchronized boolean deactivate() {
        this.nextCheckTime = -1L;
        this.ostream = null;
        return this.closed;
    }

    public synchronized void activate(OutputStream ostream) {
        this.nextCheckTime = System.currentTimeMillis() + DELAY_TIME;
        if (!this.isScheduled) {
            RouterService.schedule(this, DELAY_TIME, 0L);
            this.isScheduled = true;
        }
        this.ostream = ostream;
    }

    public synchronized void run() {
        this.isScheduled = false;
        if (this.nextCheckTime == -1L) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now < this.nextCheckTime) {
            RouterService.schedule(this, this.nextCheckTime - now, 0L);
        } else {
            this.closed = true;
            try {
                if (this.ostream != null) {
                    UploadStat.STALLED.incrementStat();
                    this.ostream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.ostream = null;
        }
    }
}

