/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.http.ConstantHTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPMessage;
import com.limegroup.gnutella.http.HTTPUtils;
import java.io.IOException;
import java.io.OutputStream;

public class QueuedUploadState
implements HTTPMessage {
    private FileDesc FILE_DESC;
    private int position;

    public QueuedUploadState(int pos, FileDesc desc) {
        this.position = pos;
        this.FILE_DESC = desc;
    }

    public void writeMessageHeaders(OutputStream ostream) throws IOException {
        URN sha1;
        Assert.that(this.position != -1);
        String str = "HTTP/1.1 503 Service Unavailable\r\n";
        ostream.write(str.getBytes());
        HTTPUtils.writeHeader(HTTPHeaderName.SERVER, ConstantHTTPHeaderValue.SERVER_VALUE, ostream);
        str = "X-Queue: position=" + (this.position + 1) + ", pollMin=" + 45 + ", pollMax=" + 120 + "\r\n";
        ostream.write(str.getBytes());
        if (this.FILE_DESC != null && (sha1 = this.FILE_DESC.getSHA1Urn()) != null) {
            HTTPUtils.writeHeader(HTTPHeaderName.GNUTELLA_CONTENT_URN, (HTTPHeaderValue)this.FILE_DESC.getSHA1Urn(), ostream);
            if (this.FILE_DESC.hasAlternateLocations()) {
                HTTPUtils.writeHeader(HTTPHeaderName.ALT_LOCATION, (HTTPHeaderValue)this.FILE_DESC.getAlternateLocationCollection(), ostream);
            }
            if (this.FILE_DESC instanceof IncompleteFileDesc) {
                HTTPUtils.writeHeader(HTTPHeaderName.AVAILABLE_RANGES, (HTTPHeaderValue)((IncompleteFileDesc)this.FILE_DESC), ostream);
            }
        }
        str = "\r\n";
        ostream.write(str.getBytes());
    }

    public void writeMessageBody(OutputStream ostream) throws IOException {
    }

    public boolean getCloseConnection() {
        return false;
    }
}

