/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPMessage;
import com.limegroup.gnutella.http.HTTPUtils;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.UploadSettings;
import com.limegroup.gnutella.uploader.HTTPUploader;
import com.limegroup.gnutella.uploader.StalledUploadWatchdog;
import com.limegroup.gnutella.util.BandwidthThrottle;
import com.limegroup.gnutella.util.CommonUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.SocketException;

public final class NormalUploadState
implements HTTPMessage {
    private static final int BLOCK_SIZE = 1024;
    private final HTTPUploader _uploader;
    private final int _index;
    private final String _fileName;
    private final int _fileSize;
    private InputStream _fis;
    private int _amountWritten;
    private int _uploadBegin;
    private int _uploadEnd;
    private int _amountRequested;
    private StalledUploadWatchdog _stalledChecker;
    private static final BandwidthThrottle THROTTLE = new BandwidthThrottle(NormalUploadState.getUploadSpeed());
    private final FileDesc FILE_DESC;

    public NormalUploadState(HTTPUploader uploader, StalledUploadWatchdog watchdog) {
        this._uploader = uploader;
        this.FILE_DESC = this._uploader.getFileDesc();
        this._index = this._uploader.getIndex();
        this._fileName = this._uploader.getFileName();
        this._fileSize = this._uploader.getFileSize();
        this._amountWritten = 0;
        this._stalledChecker = watchdog;
    }

    public void writeMessageHeaders(OutputStream network) throws IOException {
        try {
            StringWriter ostream = new StringWriter();
            this._fis = this._uploader.getInputStream();
            this._uploadBegin = this._uploader.getUploadBegin();
            this._uploadEnd = this._uploader.getUploadEnd();
            this._amountRequested = this._uploader.getAmountRequested();
            if (this._fileSize < this._uploadBegin) {
                throw new IOException("Invalid Range");
            }
            if (this._uploadBegin == 0 && this._amountRequested == this._fileSize) {
                ostream.write("HTTP/1.1 200 OK\r\n");
            } else {
                ostream.write("HTTP/1.1 206 Partial Content\r\n");
            }
            ostream.write("Server: " + CommonUtils.getHttpServer() + "\r\n");
            ostream.write("Content-Type: " + this.getMimeType() + "\r\n");
            ostream.write("Content-Length: " + this._amountRequested + "\r\n");
            if (this._uploadBegin != 0) {
                ostream.write("Content-Range: bytes " + this._uploadBegin + "-" + (this._uploadEnd - 1) + "/" + this._fileSize + "\r\n");
            }
            if (this.FILE_DESC != null) {
                URN urn = this.FILE_DESC.getSHA1Urn();
                if (urn != null) {
                    HTTPUtils.writeHeader(HTTPHeaderName.GNUTELLA_CONTENT_URN, (HTTPHeaderValue)urn, ostream);
                }
                if (this.FILE_DESC.hasAlternateLocations()) {
                    HTTPUtils.writeHeader(HTTPHeaderName.ALT_LOCATION, (HTTPHeaderValue)this.FILE_DESC.getAlternateLocationCollection(), ostream);
                }
                if (this.FILE_DESC instanceof IncompleteFileDesc) {
                    HTTPUtils.writeHeader(HTTPHeaderName.AVAILABLE_RANGES, (HTTPHeaderValue)((IncompleteFileDesc)this.FILE_DESC), ostream);
                }
            }
            ostream.write("\r\n");
            this._stalledChecker.activate(network);
            network.write(ostream.toString().getBytes());
            this._stalledChecker.deactivate();
        }
        catch (IOException e) {
            this._stalledChecker.deactivate();
            throw e;
        }
    }

    public void writeMessageBody(OutputStream ostream) throws IOException {
        try {
            this._fis.skip(this._uploadBegin);
            this.upload(ostream);
        }
        catch (IOException e) {
            this._stalledChecker.deactivate();
            throw e;
        }
    }

    private void upload(OutputStream ostream) throws IOException {
        byte[] buf = new byte[1024];
        do {
            THROTTLE.setRate(NormalUploadState.getUploadSpeed());
            int c = -1;
            int allowed = THROTTLE.request(1024);
            int burstSent = 0;
            c = this._fis.read(buf, 0, allowed);
            if (c == -1) {
                return;
            }
            if (c > this._amountRequested - this._amountWritten) {
                c = this._amountRequested - this._amountWritten;
            }
            try {
                this._stalledChecker.activate(ostream);
                ostream.write(buf, 0, c);
                this._stalledChecker.deactivate();
            }
            catch (SocketException e) {
                throw new IOException("socketexception");
            }
            this._amountWritten += c;
            this._uploader.setAmountUploaded(this._amountWritten);
            burstSent += c;
        } while (this._amountWritten < this._amountRequested);
    }

    private String getMimeType() {
        return "application/binary";
    }

    public static float getUploadSpeed() {
        int uSpeed = UploadSettings.UPLOAD_SPEED.getValue();
        float ret = uSpeed == 100 ? Float.MAX_VALUE : (float)ConnectionSettings.CONNECTION_SPEED.getValue() / 8.0f * (float)uSpeed / 100.0f * 1024.0f;
        return ret;
    }

    public boolean getCloseConnection() {
        return false;
    }

    public String toString() {
        return "NormalUploadState:\r\nFile Name:  " + this._fileName + "\r\n" + "File Size:  " + this._fileSize + "\r\n" + "File Index: " + this._index + "\r\n" + "File Desc:  " + this.FILE_DESC;
    }
}

