/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.http.ConstantHTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPMessage;
import com.limegroup.gnutella.http.HTTPUtils;
import com.limegroup.gnutella.util.CommonUtils;
import java.io.IOException;
import java.io.OutputStream;

public class LimitReachedUploadState
implements HTTPMessage {
    private final FileDesc FILE_DESC;
    private static final byte[] ERROR_MESSAGE = "Server busy.  Too many active uploads.".getBytes();

    public LimitReachedUploadState(FileDesc fd) {
        this.FILE_DESC = fd;
    }

    public void writeMessageHeaders(OutputStream ostream) throws IOException {
        URN sha1;
        String str = "HTTP/1.1 503 Service Unavailable\r\n";
        ostream.write(str.getBytes());
        str = "Server: " + CommonUtils.getHttpServer() + "\r\n";
        ostream.write(str.getBytes());
        str = "Content-Type: text/plain\r\n";
        ostream.write(str.getBytes());
        str = "Content-Length: " + ERROR_MESSAGE.length + "\r\n";
        ostream.write(str.getBytes());
        if (this.FILE_DESC != null && (sha1 = this.FILE_DESC.getSHA1Urn()) != null) {
            HTTPUtils.writeHeader(HTTPHeaderName.GNUTELLA_CONTENT_URN, (HTTPHeaderValue)sha1, ostream);
            if (this.FILE_DESC.hasAlternateLocations()) {
                HTTPUtils.writeHeader(HTTPHeaderName.ALT_LOCATION, (HTTPHeaderValue)this.FILE_DESC.getAlternateLocationCollection(), ostream);
            }
            if (this.FILE_DESC instanceof IncompleteFileDesc) {
                HTTPUtils.writeHeader(HTTPHeaderName.AVAILABLE_RANGES, (HTTPHeaderValue)((IncompleteFileDesc)this.FILE_DESC), ostream);
            }
        }
        HTTPUtils.writeHeader(HTTPHeaderName.CONNECTION, ConstantHTTPHeaderValue.CLOSE_VALUE, ostream);
        str = "\r\n";
        ostream.write(str.getBytes());
    }

    public void writeMessageBody(OutputStream ostream) throws IOException {
        ostream.write(ERROR_MESSAGE);
    }

    public boolean getCloseConnection() {
        return true;
    }
}

