/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.security;

import com.limegroup.gnutella.security.User;
import com.limegroup.gnutella.settings.SecuritySettings;
import com.limegroup.gnutella.util.FileUtils;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class Cookies
implements Serializable {
    private Map _hostUserInfoMap = new HashMap();
    private static Cookies _instance = new Cookies();

    public static Cookies instance() {
        return _instance;
    }

    private void initialize() {
        try {
            this._hostUserInfoMap = this.readCookies();
        }
        catch (Exception e) {
            this._hostUserInfoMap = new HashMap();
        }
    }

    protected Cookies() {
        this.initialize();
    }

    private Map readCookies() throws IOException, ClassNotFoundException {
        return FileUtils.readMap(SecuritySettings.COOKIES_FILE.getValue());
    }

    public synchronized User getUserInfo(String host) {
        return (User)this._hostUserInfoMap.get(host);
    }

    public synchronized void putCookie(String host, User user) {
        this._hostUserInfoMap.put(host, user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        try {
            Map clone;
            Cookies cookies = this;
            synchronized (cookies) {
                clone = (Map)((HashMap)this._hostUserInfoMap).clone();
            }
            FileUtils.writeMap(SecuritySettings.COOKIES_FILE.getValue(), clone);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        return this._hostUserInfoMap.toString();
    }

    public static void main(String[] args) {
        System.out.println(Cookies.instance().toString());
    }
}

