/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.search;

import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.search.HostData;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLDocumentHelper;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class SearchResultHandler {
    private final boolean debugOn = false;

    public void start() {
    }

    public void handleQueryReply(QueryReply qr) {
        this.handleReply(qr);
    }

    private boolean handleReply(QueryReply qr) {
        HostData data = new HostData(qr);
        if (!(data.isReplyToMulticastQuery() || !data.isFirewalled() || NetworkUtils.isVeryCloseIP(qr.getIPBytes()) || RouterService.acceptedIncomingConnection() && !NetworkUtils.isPrivateAddress(RouterService.getAddress()))) {
            return false;
        }
        List results = null;
        try {
            results = qr.getResultsAsList();
        }
        catch (BadPacketException e) {
            return false;
        }
        String xmlCollectionString = "";
        try {
            this.debug("Trying to do uncompress.....");
            byte[] xmlCompressed = qr.getXMLBytes();
            if (xmlCompressed.length > 1) {
                byte[] xmlUncompressed = LimeXMLUtils.uncompress(xmlCompressed);
                xmlCollectionString = new String(xmlUncompressed);
            }
        }
        catch (Exception e) {
            xmlCollectionString = "";
        }
        this.debug("xmlCollectionString = " + xmlCollectionString);
        List allDocsArray = LimeXMLDocumentHelper.getDocuments(xmlCollectionString, results.size());
        int z = allDocsArray.size();
        int k = -1;
        byte[] replyGUID = data.getMessageGUID();
        Iterator iter = results.iterator();
        while (iter.hasNext()) {
            ++k;
            Response response = (Response)iter.next();
            if (RouterService.isMandragoreWorm(replyGUID, response)) continue;
            ArrayList<LimeXMLDocument> docs = null;
            if (xmlCollectionString == null || xmlCollectionString.equals("")) {
                LimeXMLDocument doc;
                try {
                    String xmlStr = response.getMetadata();
                    doc = new LimeXMLDocument(xmlStr);
                }
                catch (Exception e) {
                    doc = null;
                }
                if (doc == null) {
                    docs = null;
                } else {
                    docs = new ArrayList();
                    docs.add(doc);
                }
            } else {
                docs = new ArrayList<LimeXMLDocument>(z);
                for (int l = 0; l < z; ++l) {
                    LimeXMLDocument[] metaDocs = (LimeXMLDocument[])allDocsArray.get(l);
                    if (metaDocs == null || metaDocs[k] == null) continue;
                    docs.add(metaDocs[k]);
                }
            }
            RemoteFileDesc rfd = null;
            LimeXMLDocument doc = docs == null || docs.size() == 0 ? null : (LimeXMLDocument)docs.get(0);
            rfd = new RemoteFileDesc(data.getIP(), data.getPort(), response.getIndex(), response.getName(), (int)response.getSize(), data.getClientGUID(), data.getSpeed(), data.isChatEnabled(), data.getQuality(), data.isBrowseHostEnabled(), doc, response.getUrns(), data.isReplyToMulticastQuery(), data.isFirewalled(), data.getVendorCode(), System.currentTimeMillis(), data.getPushProxies());
            RouterService.getCallback().handleQueryResult(rfd, data);
        }
        return true;
    }

    private void debug(String out) {
    }
}

