/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.mp3;

import com.limegroup.gnutella.util.FileUtils;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;

public class ID3Editor {
    private String title_;
    private String artist_;
    private String album_;
    private String year_;
    private String track_;
    private String comment_;
    private String genre_;
    private static final String TITLE_STRING = "title=\"";
    private static final String ARTIST_STRING = "artist=\"";
    private static final String ALBUM_STRING = "album=\"";
    private static final String YEAR_STRING = "year=\"";
    private static final String TRACK_STRING = "track=\"";
    private static final String COMMENT_STRING = "comments=\"";
    private static final String GENRE_STRING = "genre=\"";
    private static final String BITRATE_STRING = "bitrate=\"";
    private static final String SECONDS_STRING = "seconds=\"";
    private final boolean debugOn = false;

    private void debug(String out) {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ID3Editor)) {
            return false;
        }
        ID3Editor other = (ID3Editor)o;
        return this.matches(this.title_, other.title_) && this.matches(this.artist_, other.artist_) && this.matches(this.album_, other.album_) && this.matches(this.year_, other.year_) && this.matches(this.track_, other.track_) && this.matches(this.comment_, other.comment_) && this.matches(this.genre_, other.genre_);
    }

    private boolean matches(String a, String b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    private Object[] ripTag(String source, String tagToRip) throws IOException {
        Object[] retObjs = new Object[3];
        int begin = source.indexOf(tagToRip);
        if (begin < 0) {
            throw new IOException("tag not found");
        }
        if (begin != 0) {
            retObjs[0] = new Integer(begin - 1);
        }
        if (begin == 0) {
            retObjs[0] = new Integer(begin);
        }
        int end = begin;
        while (source.charAt(end) != '=') {
            ++end;
        }
        while (source.charAt(end) != '\"') {
            ++end;
        }
        int i = ++end;
        while (source.charAt(end) != '\"') {
            ++end;
        }
        int j = end;
        retObjs[1] = new Integer(end + 1);
        this.debug("ID3Editor.ripTag(): i = " + i + ", j = " + j);
        retObjs[2] = source.substring(i, j);
        return retObjs;
    }

    public String removeID3Tags(String xmlStr) {
        int j;
        int i;
        Object[] rippedStuff = null;
        try {
            rippedStuff = this.ripTag(xmlStr, TITLE_STRING);
            this.title_ = (String)rippedStuff[2];
            this.debug("title = " + this.title_);
            i = (Integer)rippedStuff[0];
            j = (Integer)rippedStuff[1];
            xmlStr = xmlStr.substring(0, i) + xmlStr.substring(j, xmlStr.length());
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            rippedStuff = this.ripTag(xmlStr, ARTIST_STRING);
            this.artist_ = (String)rippedStuff[2];
            this.debug("artist = " + this.artist_);
            i = (Integer)rippedStuff[0];
            j = (Integer)rippedStuff[1];
            xmlStr = xmlStr.substring(0, i) + xmlStr.substring(j, xmlStr.length());
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            rippedStuff = this.ripTag(xmlStr, ALBUM_STRING);
            this.album_ = (String)rippedStuff[2];
            i = (Integer)rippedStuff[0];
            j = (Integer)rippedStuff[1];
            xmlStr = xmlStr.substring(0, i) + xmlStr.substring(j, xmlStr.length());
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            rippedStuff = this.ripTag(xmlStr, YEAR_STRING);
            this.year_ = (String)rippedStuff[2];
            i = (Integer)rippedStuff[0];
            j = (Integer)rippedStuff[1];
            xmlStr = xmlStr.substring(0, i) + xmlStr.substring(j, xmlStr.length());
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            rippedStuff = this.ripTag(xmlStr, TRACK_STRING);
            this.track_ = (String)rippedStuff[2];
            i = (Integer)rippedStuff[0];
            j = (Integer)rippedStuff[1];
            xmlStr = xmlStr.substring(0, i) + xmlStr.substring(j, xmlStr.length());
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            rippedStuff = this.ripTag(xmlStr, COMMENT_STRING);
            this.comment_ = (String)rippedStuff[2];
            i = (Integer)rippedStuff[0];
            j = (Integer)rippedStuff[1];
            xmlStr = xmlStr.substring(0, i) + xmlStr.substring(j, xmlStr.length());
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            rippedStuff = this.ripTag(xmlStr, GENRE_STRING);
            this.genre_ = (String)rippedStuff[2];
            i = (Integer)rippedStuff[0];
            j = (Integer)rippedStuff[1];
            xmlStr = xmlStr.substring(0, i) + xmlStr.substring(j, xmlStr.length());
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            rippedStuff = this.ripTag(xmlStr, BITRATE_STRING);
            i = (Integer)rippedStuff[0];
            j = (Integer)rippedStuff[1];
            xmlStr = xmlStr.substring(0, i) + xmlStr.substring(j, xmlStr.length());
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            rippedStuff = this.ripTag(xmlStr, SECONDS_STRING);
            i = (Integer)rippedStuff[0];
            j = (Integer)rippedStuff[1];
            xmlStr = xmlStr.substring(0, i) + xmlStr.substring(j, xmlStr.length());
        }
        catch (IOException e) {
            // empty catch block
        }
        return xmlStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int writeID3DataToDisk(String fileName) {
        block49: {
            block48: {
                block47: {
                    block46: {
                        block45: {
                            block44: {
                                block43: {
                                    f = null;
                                    file = null;
                                    try {
                                        try {
                                            f = new File(fileName);
                                            FileUtils.setWriteable(f);
                                            file = new RandomAccessFile(f, "rw");
                                        }
                                        catch (IOException e) {
                                            var5_6 = 1;
                                            var14_7 = null;
                                            if (file == null) return var5_6;
                                            try {
                                                file.close();
                                                return var5_6;
                                            }
                                            catch (IOException ignored) {
                                                // empty catch block
                                            }
                                            return var5_6;
                                        }
                                        length = 0L;
                                        try {
                                            length = file.length();
                                            if (length < 128L) {
                                                var6_39 = 1;
                                            }
                                            ** GOTO lbl-1000
                                        }
                                        catch (IOException ee) {
                                            var7_42 = 2;
                                            var14_9 = null;
                                            if (file == null) return var7_42;
                                            ** try [egrp 9[TRYBLOCK] [25 : 480->487)] { 
lbl34:
                                            // 1 sources

                                            file.close();
                                            return var7_42;
lbl36:
                                            // 1 sources

                                            catch (IOException ignored) {
                                                // empty catch block
                                            }
                                            return var7_42;
                                        }
                                        var14_8 = null;
                                        if (file == null) return var6_39;
                                        break block43;
lbl-1000:
                                        // 1 sources

                                        {
                                            file.seek(length - 128L);
                                        }
                                        buffer = new byte[30];
                                        tag = "";
                                        try {
                                            file.readFully(buffer, 0, 3);
                                            tag = new String(buffer, 0, 3);
                                        }
                                        catch (EOFException e) {
                                            var9_49 = 2;
                                            var14_10 = null;
                                            if (file == null) return var9_49;
                                            ** try [egrp 9[TRYBLOCK] [25 : 480->487)] { 
lbl55:
                                            // 1 sources

                                            file.close();
                                            return var9_49;
lbl57:
                                            // 1 sources

                                            catch (IOException ignored) {
                                                // empty catch block
                                            }
                                            return var9_49;
                                        }
                                        catch (IOException e) {
                                            var9_50 = 2;
                                            var14_11 = null;
                                            if (file == null) return var9_50;
                                            ** try [egrp 9[TRYBLOCK] [25 : 480->487)] { 
lbl66:
                                            // 1 sources

                                            file.close();
                                            return var9_50;
lbl68:
                                            // 1 sources

                                            catch (IOException ignored) {
                                                // empty catch block
                                            }
                                            return var9_50;
                                        }
                                        if (!tag.equals("TAG")) {
                                            try {
                                                tagBytes = "TAG".getBytes();
                                                file.seek(length - 128L);
                                                file.write(tagBytes, 0, 3);
                                            }
                                            catch (IOException ioe) {
                                                var9_51 = 3;
                                                var14_12 = null;
                                                if (file == null) return var9_51;
                                                ** try [egrp 9[TRYBLOCK] [25 : 480->487)] { 
lbl83:
                                                // 1 sources

                                                file.close();
                                                return var9_51;
lbl85:
                                                // 1 sources

                                                catch (IOException ignored) {
                                                    // empty catch block
                                                }
                                                return var9_51;
                                            }
                                        }
                                        this.debug("about to start writing to file");
                                        b = this.toFile(this.title_, 30, file, buffer);
                                        if (!b) {
                                            var9_52 = 4;
                                            break block44;
                                        }
                                        b = this.toFile(this.artist_, 30, file, buffer);
                                        if (!b) {
                                            var9_53 = 5;
                                            break block45;
                                        }
                                        b = this.toFile(this.album_, 30, file, buffer);
                                        if (!b) {
                                            var9_54 = 6;
                                            break block46;
                                        }
                                        b = this.toFile(this.year_, 4, file, buffer);
                                        if (!b) {
                                            var9_55 = 7;
                                            break block47;
                                        }
                                        b = this.toFile(this.comment_, 28, file, buffer);
                                        if (!b) {
                                            var9_56 = 8;
                                            break block48;
                                        }
                                        trackByte = -1;
                                        try {
                                            trackByte = this.track_ == null || this.track_.equals("") ? 0 : (int)Byte.parseByte(this.track_);
                                        }
                                        catch (NumberFormatException nfe) {
                                            var11_61 = 9;
                                            var14_18 = null;
                                            if (file == null) return var11_61;
                                            ** try [egrp 9[TRYBLOCK] [25 : 480->487)] { 
lbl124:
                                            // 1 sources

                                            file.close();
                                            return var11_61;
lbl126:
                                            // 1 sources

                                            catch (IOException ignored) {
                                                // empty catch block
                                            }
                                            return var11_61;
                                        }
                                        try {
                                            file.write(0);
                                            file.write(trackByte);
                                        }
                                        catch (IOException e) {
                                            var11_62 = 9;
                                            var14_19 = null;
                                            if (file == null) return var11_62;
                                            ** try [egrp 9[TRYBLOCK] [25 : 480->487)] { 
lbl139:
                                            // 1 sources

                                            file.close();
                                            return var11_62;
lbl141:
                                            // 1 sources

                                            catch (IOException ignored) {
                                                // empty catch block
                                            }
                                            return var11_62;
                                        }
                                        genreByte = this.getGenreByte();
                                        try {
                                            file.write(genreByte);
                                        }
                                        catch (IOException e) {
                                            var12_65 = 10;
                                            var14_20 = null;
                                            if (file == null) return var12_65;
                                            ** try [egrp 9[TRYBLOCK] [25 : 480->487)] { 
lbl154:
                                            // 1 sources

                                            file.close();
                                            return var12_65;
lbl156:
                                            // 1 sources

                                            catch (IOException ignored) {
                                                // empty catch block
                                            }
                                            return var12_65;
                                        }
                                        var11_64 = 0;
                                        break block49;
                                    }
                                    catch (Throwable var13_66) {
                                        var14_22 = null;
                                        if (file == null) throw var13_66;
                                        try {}
                                        catch (IOException ignored) {
                                            throw var13_66;
                                        }
                                        file.close();
                                        throw var13_66;
                                    }
                                }
                                try {}
                                catch (IOException ignored) {
                                    // empty catch block
                                    return var6_39;
                                }
                                file.close();
                                return var6_39;
                            }
                            var14_13 = null;
                            if (file == null) return var9_52;
                            ** try [egrp 9[TRYBLOCK] [25 : 480->487)] { 
lbl182:
                            // 1 sources

                            file.close();
                            return var9_52;
lbl184:
                            // 1 sources

                            catch (IOException ignored) {
                                // empty catch block
                            }
                            return var9_52;
                        }
                        var14_14 = null;
                        if (file == null) return var9_53;
                        ** try [egrp 9[TRYBLOCK] [25 : 480->487)] { 
lbl191:
                        // 1 sources

                        file.close();
                        return var9_53;
lbl193:
                        // 1 sources

                        catch (IOException ignored) {
                            // empty catch block
                        }
                        return var9_53;
                    }
                    var14_15 = null;
                    if (file == null) return var9_54;
                    ** try [egrp 9[TRYBLOCK] [25 : 480->487)] { 
lbl200:
                    // 1 sources

                    file.close();
                    return var9_54;
lbl202:
                    // 1 sources

                    catch (IOException ignored) {
                        // empty catch block
                    }
                    return var9_54;
                }
                var14_16 = null;
                if (file == null) return var9_55;
                ** try [egrp 9[TRYBLOCK] [25 : 480->487)] { 
lbl209:
                // 1 sources

                file.close();
                return var9_55;
lbl211:
                // 1 sources

                catch (IOException ignored) {
                    // empty catch block
                }
                return var9_55;
            }
            var14_17 = null;
            if (file == null) return var9_56;
            ** try [egrp 9[TRYBLOCK] [25 : 480->487)] { 
lbl218:
            // 1 sources

            file.close();
            return var9_56;
lbl220:
            // 1 sources

            catch (IOException ignored) {
                // empty catch block
            }
            return var9_56;
        }
        var14_21 = null;
        if (file == null) return var11_64;
        ** try [egrp 9[TRYBLOCK] [25 : 480->487)] { 
lbl227:
        // 1 sources

        file.close();
        return var11_64;
lbl229:
        // 1 sources

        catch (IOException ignored) {
            // empty catch block
        }
        return var11_64;
    }

    private boolean toFile(String val, int maxLen, RandomAccessFile file, byte[] buffer) {
        byte[] fromString;
        this.debug("writing value to file " + val);
        if (val == null || val.equals("")) {
            fromString = new byte[maxLen];
            Arrays.fill(fromString, 0, maxLen, (byte)0);
        } else {
            fromString = val.getBytes();
        }
        int len = fromString.length;
        if (len < maxLen) {
            System.arraycopy(fromString, 0, buffer, 0, len);
            Arrays.fill(buffer, len, maxLen, (byte)0);
        } else {
            System.arraycopy(fromString, 0, buffer, 0, maxLen);
        }
        try {
            file.write(buffer, 0, maxLen);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private byte getGenreByte() {
        if (this.genre_ == null) {
            return -1;
        }
        if (this.genre_.equals("Blues")) {
            return 0;
        }
        if (this.genre_.equals("Classic Rock")) {
            return 1;
        }
        if (this.genre_.equals("Country")) {
            return 2;
        }
        if (this.genre_.equals("Dance")) {
            return 3;
        }
        if (this.genre_.equals("Disco")) {
            return 4;
        }
        if (this.genre_.equals("Funk")) {
            return 5;
        }
        if (this.genre_.equals("Grunge")) {
            return 6;
        }
        if (this.genre_.equals("Hop")) {
            return 7;
        }
        if (this.genre_.equals("Jazz")) {
            return 8;
        }
        if (this.genre_.equals("Metal")) {
            return 9;
        }
        if (this.genre_.equals("New Age")) {
            return 10;
        }
        if (this.genre_.equals("Oldies")) {
            return 11;
        }
        if (this.genre_.equals("Other")) {
            return 12;
        }
        if (this.genre_.equals("Pop")) {
            return 13;
        }
        if (this.genre_.equals("R &amp; B")) {
            return 14;
        }
        if (this.genre_.equals("Rap")) {
            return 15;
        }
        if (this.genre_.equals("Reggae")) {
            return 16;
        }
        if (this.genre_.equals("Rock")) {
            return 17;
        }
        if (this.genre_.equals("Techno")) {
            return 17;
        }
        if (this.genre_.equals("Industrial")) {
            return 19;
        }
        if (this.genre_.equals("Alternative")) {
            return 20;
        }
        if (this.genre_.equals("Ska")) {
            return 21;
        }
        if (this.genre_.equals("Metal")) {
            return 22;
        }
        if (this.genre_.equals("Pranks")) {
            return 23;
        }
        if (this.genre_.equals("Soundtrack")) {
            return 24;
        }
        if (this.genre_.equals("Euro-Techno")) {
            return 25;
        }
        if (this.genre_.equals("Ambient")) {
            return 26;
        }
        if (this.genre_.equals("Trip-Hop")) {
            return 27;
        }
        if (this.genre_.equals("Vocal")) {
            return 28;
        }
        if (this.genre_.equals("Jazz+Funk")) {
            return 29;
        }
        if (this.genre_.equals("Fusion")) {
            return 30;
        }
        if (this.genre_.equals("Trance")) {
            return 31;
        }
        if (this.genre_.equals("Classical")) {
            return 32;
        }
        if (this.genre_.equals("Instrumental")) {
            return 33;
        }
        if (this.genre_.equals("Acid")) {
            return 34;
        }
        if (this.genre_.equals("House")) {
            return 35;
        }
        if (this.genre_.equals("Game")) {
            return 36;
        }
        if (this.genre_.equals("Sound Clip")) {
            return 37;
        }
        if (this.genre_.equals("Gospel")) {
            return 38;
        }
        if (this.genre_.equals("Noise")) {
            return 39;
        }
        if (this.genre_.equals("AlternRock")) {
            return 40;
        }
        if (this.genre_.equals("Bass")) {
            return 41;
        }
        if (this.genre_.equals("Soul")) {
            return 42;
        }
        if (this.genre_.equals("Punk")) {
            return 43;
        }
        if (this.genre_.equals("Space")) {
            return 44;
        }
        if (this.genre_.equals("Meditative")) {
            return 45;
        }
        if (this.genre_.equals("Instrumental Pop")) {
            return 46;
        }
        if (this.genre_.equals("Instrumental Rock")) {
            return 47;
        }
        if (this.genre_.equals("Ethnic")) {
            return 48;
        }
        if (this.genre_.equals("Gothic")) {
            return 49;
        }
        if (this.genre_.equals("Darkwave")) {
            return 50;
        }
        if (this.genre_.equals("Techno-Industrial")) {
            return 51;
        }
        if (this.genre_.equals("Electronic")) {
            return 52;
        }
        if (this.genre_.equals("Pop-Folk")) {
            return 53;
        }
        if (this.genre_.equals("Eurodance")) {
            return 54;
        }
        if (this.genre_.equals("Dream")) {
            return 55;
        }
        if (this.genre_.equals("Southern Rock")) {
            return 56;
        }
        if (this.genre_.equals("Comedy")) {
            return 57;
        }
        if (this.genre_.equals("Cult")) {
            return 58;
        }
        if (this.genre_.equals("Gangsta")) {
            return 59;
        }
        if (this.genre_.equals("Top 40")) {
            return 60;
        }
        if (this.genre_.equals("Christian Rap")) {
            return 61;
        }
        if (this.genre_.equals("Pop/Funk")) {
            return 62;
        }
        if (this.genre_.equals("Jungle")) {
            return 63;
        }
        if (this.genre_.equals("Native American")) {
            return 64;
        }
        if (this.genre_.equals("Cabaret")) {
            return 65;
        }
        if (this.genre_.equals("New Wave")) {
            return 66;
        }
        if (this.genre_.equals("Psychadelic")) {
            return 67;
        }
        if (this.genre_.equals("Rave")) {
            return 68;
        }
        if (this.genre_.equals("Showtunes")) {
            return 69;
        }
        if (this.genre_.equals("Trailer")) {
            return 70;
        }
        if (this.genre_.equals("Lo-Fi")) {
            return 71;
        }
        if (this.genre_.equals("Tribal")) {
            return 72;
        }
        if (this.genre_.equals("Acid Punk")) {
            return 73;
        }
        if (this.genre_.equals("Acid Jazz")) {
            return 74;
        }
        if (this.genre_.equals("Polka")) {
            return 75;
        }
        if (this.genre_.equals("Retro")) {
            return 76;
        }
        if (this.genre_.equals("Musical")) {
            return 77;
        }
        if (this.genre_.equals("Rock &amp; Roll")) {
            return 78;
        }
        if (this.genre_.equals("Hard Rock")) {
            return 79;
        }
        if (this.genre_.equals("Folk")) {
            return 80;
        }
        if (this.genre_.equals("Folk-Rock")) {
            return 81;
        }
        if (this.genre_.equals("National Folk")) {
            return 82;
        }
        if (this.genre_.equals("Swing")) {
            return 83;
        }
        if (this.genre_.equals("Fast Fusion")) {
            return 84;
        }
        if (this.genre_.equals("Bebob")) {
            return 85;
        }
        if (this.genre_.equals("Latin")) {
            return 86;
        }
        if (this.genre_.equals("Revival")) {
            return 87;
        }
        if (this.genre_.equals("Celtic")) {
            return 88;
        }
        if (this.genre_.equals("Bluegrass")) {
            return 89;
        }
        if (this.genre_.equals("Avantgarde")) {
            return 90;
        }
        if (this.genre_.equals("Gothic Rock")) {
            return 91;
        }
        if (this.genre_.equals("Progressive Rock")) {
            return 92;
        }
        if (this.genre_.equals("Psychedelic Rock")) {
            return 93;
        }
        if (this.genre_.equals("Symphonic Rock")) {
            return 94;
        }
        if (this.genre_.equals("Slow Rock")) {
            return 95;
        }
        if (this.genre_.equals("Big Band")) {
            return 96;
        }
        if (this.genre_.equals("Chorus")) {
            return 97;
        }
        if (this.genre_.equals("Easy Listening")) {
            return 98;
        }
        if (this.genre_.equals("Acoustic")) {
            return 99;
        }
        if (this.genre_.equals("Humour")) {
            return 100;
        }
        if (this.genre_.equals("Speech")) {
            return 101;
        }
        if (this.genre_.equals("Chanson")) {
            return 102;
        }
        if (this.genre_.equals("Opera")) {
            return 103;
        }
        if (this.genre_.equals("Chamber Music")) {
            return 104;
        }
        if (this.genre_.equals("Sonata")) {
            return 105;
        }
        if (this.genre_.equals("Symphony")) {
            return 106;
        }
        if (this.genre_.equals("Booty Bass")) {
            return 107;
        }
        if (this.genre_.equals("Primus")) {
            return 108;
        }
        if (this.genre_.equals("Porn Groove")) {
            return 109;
        }
        if (this.genre_.equals("Satire")) {
            return 110;
        }
        if (this.genre_.equals("Slow Jam")) {
            return 111;
        }
        if (this.genre_.equals("Club")) {
            return 112;
        }
        if (this.genre_.equals("Tango")) {
            return 113;
        }
        if (this.genre_.equals("Samba")) {
            return 114;
        }
        if (this.genre_.equals("Folklore")) {
            return 115;
        }
        if (this.genre_.equals("Ballad")) {
            return 116;
        }
        if (this.genre_.equals("Power Ballad")) {
            return 117;
        }
        if (this.genre_.equals("Rhythmic Soul")) {
            return 118;
        }
        if (this.genre_.equals("Freestyle")) {
            return 119;
        }
        if (this.genre_.equals("Duet")) {
            return 120;
        }
        if (this.genre_.equals("Punk Rock")) {
            return 121;
        }
        if (this.genre_.equals("Drum Solo")) {
            return 122;
        }
        if (this.genre_.equals("A capella")) {
            return 123;
        }
        if (this.genre_.equals("Euro-House")) {
            return 124;
        }
        if (this.genre_.equals("Dance Hall")) {
            return 125;
        }
        return -1;
    }
}

