/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import com.limegroup.gnutella.statistics.SentMessageStatHandler;
import java.io.IOException;
import java.io.OutputStream;

public final class ReplyNumberVendorMessage
extends VendorMessage {
    public static final int VERSION = 1;

    ReplyNumberVendorMessage(byte[] guid, byte ttl, byte hops, int version, byte[] payload) throws BadPacketException {
        super(guid, ttl, hops, F_LIME_VENDOR_ID, 12, version, payload);
        if (this.getVersion() > 1) {
            throw new BadPacketException("UNSUPPORTED VERSION");
        }
        if (this.getPayload().length != 1) {
            throw new BadPacketException("UNSUPPORTED PAYLOAD LENGTH: " + this.getPayload().length);
        }
    }

    public ReplyNumberVendorMessage(GUID replyGUID, int numResults) throws BadPacketException {
        super(F_LIME_VENDOR_ID, 12, 1, ReplyNumberVendorMessage.derivePayload(numResults));
        this.setGUID(replyGUID);
    }

    public int getNumResults() {
        return ByteOrder.ubyte2int(this.getPayload()[0]);
    }

    private static byte[] derivePayload(int numResults) throws BadPacketException {
        if (numResults < 1 || numResults > 255) {
            throw new BadPacketException("Number of results too big: " + numResults);
        }
        byte[] payload = new byte[1];
        byte[] bytes = new byte[2];
        ByteOrder.short2leb((short)numResults, bytes, 0);
        payload[0] = bytes[0];
        return payload;
    }

    public boolean equals(Object other) {
        if (other instanceof ReplyNumberVendorMessage) {
            GUID myGuid = new GUID(this.getGUID());
            GUID otherGuid = new GUID(((VendorMessage)other).getGUID());
            int otherResults = ((ReplyNumberVendorMessage)other).getNumResults();
            return myGuid.equals(otherGuid) && this.getNumResults() == otherResults && super.equals(other);
        }
        return false;
    }

    protected void writePayload(OutputStream out) throws IOException {
        super.writePayload(out);
        if (RECORD_STATS) {
            SentMessageStatHandler.UDP_REPLY_NUMBER.addMessage(this);
        }
    }

    public void recordDrop() {
        super.recordDrop();
    }
}

