/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import com.limegroup.gnutella.statistics.SentMessageStatHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class MessagesSupportedVendorMessage
extends VendorMessage {
    public static final int VERSION = 0;
    private final Set _messagesSupported = new HashSet();
    private static MessagesSupportedVendorMessage _instance;

    MessagesSupportedVendorMessage(byte[] guid, byte ttl, byte hops, int version, byte[] payload) throws BadPacketException {
        super(guid, ttl, hops, F_NULL_VENDOR_ID, 0, version, payload);
        if (this.getVersion() > 0) {
            throw new BadPacketException("UNSUPPORTED VERSION");
        }
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(this.getPayload());
            int vectorSize = ByteOrder.ubytes2int(ByteOrder.leb2short(bais));
            for (int i = 0; i < vectorSize; ++i) {
                this._messagesSupported.add(new SupportedMessageBlock(bais));
            }
        }
        catch (IOException ioe) {
            throw new BadPacketException("Couldn't write to a ByteStream!!!");
        }
    }

    private MessagesSupportedVendorMessage() throws BadPacketException {
        super(F_NULL_VENDOR_ID, 0, 0, MessagesSupportedVendorMessage.derivePayload());
        MessagesSupportedVendorMessage.addSupportedMessages(this._messagesSupported);
    }

    private static byte[] derivePayload() throws BadPacketException {
        HashSet hashSet = new HashSet();
        MessagesSupportedVendorMessage.addSupportedMessages(hashSet);
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ByteOrder.short2leb((short)hashSet.size(), baos);
            Iterator iter = hashSet.iterator();
            while (iter.hasNext()) {
                SupportedMessageBlock currSMP = (SupportedMessageBlock)iter.next();
                baos.write(currSMP.encode());
            }
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            throw new BadPacketException("Couldn't write to a ByteStream!!!");
        }
    }

    private static void addSupportedMessages(Set hashSet) {
        SupportedMessageBlock smp = null;
        smp = new SupportedMessageBlock(F_BEAR_VENDOR_ID, 7, 1);
        hashSet.add(smp);
        smp = new SupportedMessageBlock(F_GTKG_VENDOR_ID, 7, 2);
        hashSet.add(smp);
        smp = new SupportedMessageBlock(F_BEAR_VENDOR_ID, 4, 1);
        hashSet.add(smp);
        smp = new SupportedMessageBlock(F_LIME_VENDOR_ID, 21, 1);
        hashSet.add(smp);
        smp = new SupportedMessageBlock(F_BEAR_VENDOR_ID, 11, 1);
        hashSet.add(smp);
    }

    public static MessagesSupportedVendorMessage instance() throws BadPacketException {
        if (_instance == null) {
            _instance = new MessagesSupportedVendorMessage();
        }
        return _instance;
    }

    public int supportsMessage(byte[] vendorID, int selector) {
        Iterator iter = this._messagesSupported.iterator();
        while (iter.hasNext()) {
            SupportedMessageBlock currSMP = (SupportedMessageBlock)iter.next();
            int version = currSMP.matches(vendorID, selector);
            if (version <= -1) continue;
            return version;
        }
        return -1;
    }

    public int supportsTCPConnectBack() {
        return this.supportsMessage(F_BEAR_VENDOR_ID, 7);
    }

    public int supportsUDPConnectBack() {
        return this.supportsMessage(F_GTKG_VENDOR_ID, 7);
    }

    public int supportsHopsFlow() {
        return this.supportsMessage(F_BEAR_VENDOR_ID, 4);
    }

    public int supportsPushProxy() {
        return this.supportsMessage(F_LIME_VENDOR_ID, 21);
    }

    public int supportsLeafGuidance() {
        return this.supportsMessage(F_BEAR_VENDOR_ID, 11);
    }

    public boolean equals(Object other) {
        if (other instanceof MessagesSupportedVendorMessage) {
            MessagesSupportedVendorMessage vmp = (MessagesSupportedVendorMessage)other;
            return ((Object)this._messagesSupported).equals(vmp._messagesSupported);
        }
        return false;
    }

    public int hashCode() {
        return 17 * ((Object)this._messagesSupported).hashCode();
    }

    protected void writePayload(OutputStream out) throws IOException {
        super.writePayload(out);
        if (RECORD_STATS) {
            SentMessageStatHandler.TCP_MESSAGES_SUPPORTED.addMessage(this);
        }
    }

    public void recordDrop() {
        super.recordDrop();
    }

    static class SupportedMessageBlock {
        final byte[] _vendorID;
        final int _selector;
        final int _version;
        final int _hashCode;

        public SupportedMessageBlock(byte[] vendorID, int selector, int version) {
            this._vendorID = vendorID;
            this._selector = selector;
            this._version = version;
            this._hashCode = SupportedMessageBlock.computeHashCode(this._vendorID, this._selector, this._version);
        }

        public SupportedMessageBlock(InputStream encodedBlock) throws IOException {
            if (encodedBlock.available() < 8) {
                throw new IOException();
            }
            this._vendorID = new byte[4];
            encodedBlock.read(this._vendorID, 0, this._vendorID.length);
            this._selector = ByteOrder.ubytes2int(ByteOrder.leb2short(encodedBlock));
            this._version = ByteOrder.ubytes2int(ByteOrder.leb2short(encodedBlock));
            this._hashCode = SupportedMessageBlock.computeHashCode(this._vendorID, this._selector, this._version);
        }

        public byte[] encode() {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                baos.write(this._vendorID);
                ByteOrder.short2leb((short)this._selector, baos);
                ByteOrder.short2leb((short)this._version, baos);
            }
            catch (IOException ioe) {
                ErrorService.error(ioe);
            }
            return baos.toByteArray();
        }

        public int matches(byte[] vendorID, int selector) {
            if (Arrays.equals(this._vendorID, vendorID) && this._selector == selector) {
                return this._version;
            }
            return -1;
        }

        public boolean equals(Object other) {
            if (other instanceof SupportedMessageBlock) {
                SupportedMessageBlock vmp = (SupportedMessageBlock)other;
                return this._selector == vmp._selector && this._version == vmp._version && Arrays.equals(this._vendorID, vmp._vendorID);
            }
            return false;
        }

        public int hashCode() {
            return this._hashCode;
        }

        private static int computeHashCode(byte[] vendorID, int selector, int version) {
            int hashCode = 0;
            hashCode += 37 * version;
            hashCode += 37 * selector;
            for (int i = 0; i < vendorID.length; ++i) {
                hashCode += 37 * vendorID[i];
            }
            return hashCode;
        }
    }
}

