/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.Statistics;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.guess.QueryKey;
import com.limegroup.gnutella.messages.BadGGEPBlockException;
import com.limegroup.gnutella.messages.BadGGEPPropertyException;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.GGEP;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.statistics.DroppedSentMessageStatHandler;
import com.limegroup.gnutella.statistics.ReceivedErrorStat;
import com.limegroup.gnutella.statistics.SentMessageStatHandler;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.NetworkUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.UnknownHostException;

public class PingReply
extends Message
implements Serializable {
    public static final int STANDARD_PAYLOAD_SIZE = 14;
    private final byte[] PAYLOAD;
    private final String IP;
    private final int PORT;
    private final long FILES;
    private final long KILOBYTES;
    private final int DAILY_UPTIME;
    private final boolean SUPPORTS_UNICAST;
    private final String VENDOR;
    private final int VENDOR_MAJOR_VERSION;
    private final int VENDOR_MINOR_VERSION;
    private final QueryKey QUERY_KEY;
    private final boolean HAS_GGEP_EXTENSION;
    private static final byte[] CACHED_VENDOR = new byte[5];

    public static PingReply create(byte[] guid, byte ttl) {
        return PingReply.create(guid, ttl, RouterService.getPort(), RouterService.getAddress(), RouterService.getNumSharedFiles(), (long)RouterService.getSharedFileSize() / 1024L, RouterService.isSupernode(), Statistics.instance().calculateDailyUptime(), UDPService.instance().isGUESSCapable());
    }

    public static PingReply createQueryKeyReply(byte[] guid, byte ttl, QueryKey key) {
        return PingReply.create(guid, ttl, RouterService.getPort(), RouterService.getAddress(), RouterService.getNumSharedFiles(), RouterService.getSharedFileSize() / 1024, RouterService.isSupernode(), PingReply.qkGGEP(key));
    }

    public static PingReply createQueryKeyReply(byte[] guid, byte ttl, int port, byte[] ip, long sharedFiles, long sharedSize, boolean ultrapeer, QueryKey key) {
        return PingReply.create(guid, ttl, port, ip, sharedFiles, sharedSize, ultrapeer, PingReply.qkGGEP(key));
    }

    public static PingReply create(byte[] guid, byte ttl, int port, byte[] address) {
        if (!NetworkUtils.isValidPort(port)) {
            throw new IllegalArgumentException("invalid port: " + port);
        }
        return PingReply.create(guid, ttl, port, address, 0L, 0L, false, -1, false);
    }

    public static PingReply createExternal(byte[] guid, byte ttl, int port, byte[] address, boolean ultrapeer) {
        if (!NetworkUtils.isValidPort(port)) {
            throw new IllegalArgumentException("invalid port: " + port);
        }
        return PingReply.create(guid, ttl, port, address, 0L, 0L, ultrapeer, -1, false);
    }

    public static PingReply createExternal(byte[] guid, byte ttl, int port, byte[] address, int uptime, boolean ultrapeer) {
        if (!NetworkUtils.isValidPort(port)) {
            throw new IllegalArgumentException("invalid port: " + port);
        }
        return PingReply.create(guid, ttl, port, address, 0L, 0L, ultrapeer, uptime, false);
    }

    public static PingReply createGUESSReply(byte[] guid, byte ttl, Endpoint ep) throws UnknownHostException {
        int port = ep.getPort();
        if (!NetworkUtils.isValidPort(port)) {
            throw new IllegalArgumentException("invalid port: " + port);
        }
        return PingReply.create(guid, ttl, port, ep.getHostBytes(), 0L, 0L, true, -1, true);
    }

    public static PingReply createGUESSReply(byte[] guid, byte ttl, int port, byte[] address) {
        if (!NetworkUtils.isValidPort(port)) {
            throw new IllegalArgumentException("invalid port: " + port);
        }
        return PingReply.create(guid, ttl, port, address, 0L, 0L, true, -1, true);
    }

    public static PingReply create(byte[] guid, byte ttl, int port, byte[] ip, long files, long kbytes) {
        if (!NetworkUtils.isValidPort(port)) {
            throw new IllegalArgumentException("invalid port: " + port);
        }
        return PingReply.create(guid, ttl, port, ip, files, kbytes, false, -1, false);
    }

    public static PingReply create(byte[] guid, byte ttl, int port, byte[] ip, long files, long kbytes, boolean isUltrapeer, int dailyUptime, boolean isGUESSCapable) {
        if (!NetworkUtils.isValidPort(port)) {
            throw new IllegalArgumentException("invalid port: " + port);
        }
        return PingReply.create(guid, ttl, port, ip, files, kbytes, isUltrapeer, PingReply.newGGEP(dailyUptime, isUltrapeer, isGUESSCapable));
    }

    public PingReply mutateGUID(byte[] guid) {
        return PingReply.create(guid, this.getTTL(), this.getPort(), this.getIPBytes(), this.getFiles(), this.getKbytes(), this.isUltrapeer(), this.getDailyUptime(), this.supportsUnicast());
    }

    private static PingReply create(byte[] guid, byte ttl, int port, byte[] ip, long files, long kbytes, boolean isUltrapeer, GGEP ggep) {
        if (!NetworkUtils.isValidPort(port)) {
            throw new IllegalArgumentException("invalid port: " + port);
        }
        byte[] extensions = null;
        if (ggep != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                ggep.write(baos);
            }
            catch (IOException e) {
                ErrorService.error(e);
            }
            extensions = baos.toByteArray();
        }
        int length = 14 + (extensions == null ? 0 : extensions.length);
        byte[] payload = new byte[length];
        ByteOrder.short2leb((short)port, payload, 0);
        payload[2] = ip[0];
        payload[3] = ip[1];
        payload[4] = ip[2];
        payload[5] = ip[3];
        ByteOrder.int2leb((int)files, payload, 6);
        ByteOrder.int2leb((int)(isUltrapeer ? PingReply.mark(kbytes) : kbytes), payload, 10);
        if (extensions != null) {
            System.arraycopy(extensions, 0, payload, 14, extensions.length);
        }
        return new PingReply(guid, ttl, 0, payload, ggep);
    }

    public static PingReply createFromNetwork(byte[] guid, byte ttl, byte hops, byte[] payload) throws BadPacketException {
        if (guid == null) {
            throw new NullPointerException("null guid");
        }
        if (payload == null) {
            throw new NullPointerException("null payload");
        }
        if (payload.length < 14) {
            if (RECORD_STATS) {
                ReceivedErrorStat.PING_REPLY_INVALID_PAYLOAD.incrementStat();
            }
            throw new BadPacketException("invalid payload length");
        }
        int port = ByteOrder.ubytes2int(ByteOrder.leb2short(payload, 0));
        if (!NetworkUtils.isValidPort(port)) {
            if (RECORD_STATS) {
                ReceivedErrorStat.PING_REPLY_INVALID_PORT.incrementStat();
            }
            throw new BadPacketException("invalid port: " + port);
        }
        GGEP ggep = PingReply.parseGGEP(payload);
        if (ggep != null && ggep.hasKey("VC")) {
            byte[] vendorBytes = null;
            try {
                vendorBytes = ggep.getBytes("VC");
            }
            catch (BadGGEPPropertyException e) {
                if (RECORD_STATS) {
                    ReceivedErrorStat.PING_REPLY_INVALID_GGEP.incrementStat();
                }
                throw new BadPacketException("bad GGEP: " + vendorBytes);
            }
            if (vendorBytes.length < 4) {
                if (RECORD_STATS) {
                    ReceivedErrorStat.PING_REPLY_INVALID_VENDOR.incrementStat();
                }
                throw new BadPacketException("invalid vendor length: " + vendorBytes.length);
            }
        }
        return new PingReply(guid, ttl, hops, payload, ggep);
    }

    private PingReply(byte[] guid, byte ttl, byte hops, byte[] payload, GGEP ggep) {
        super(guid, (byte)1, ttl, hops, payload.length);
        this.PAYLOAD = payload;
        this.PORT = ByteOrder.ubytes2int(ByteOrder.leb2short(this.PAYLOAD, 0));
        this.FILES = ByteOrder.ubytes2long(ByteOrder.leb2int(this.PAYLOAD, 6));
        this.KILOBYTES = ByteOrder.ubytes2long(ByteOrder.leb2int(this.PAYLOAD, 10));
        this.IP = NetworkUtils.ip2string(this.PAYLOAD, 2);
        int dailyUptime = -1;
        boolean supportsUnicast = false;
        String vendor = "";
        int vendorMajor = -1;
        int vendorMinor = -1;
        QueryKey key = null;
        if (ggep != null) {
            byte[] bytes;
            if (ggep.hasKey("DU")) {
                try {
                    dailyUptime = ggep.getInt("DU");
                }
                catch (BadGGEPPropertyException e) {
                    // empty catch block
                }
            }
            supportsUnicast = ggep.hasKey("GUE");
            if (ggep.hasKey("VC")) {
                try {
                    vendor = new String(ggep.getBytes("VC"), 0, 4);
                }
                catch (BadGGEPPropertyException e) {
                    // empty catch block
                }
                try {
                    bytes = ggep.getBytes("VC");
                    if (bytes.length > 4) {
                        vendorMajor = bytes[4] >> 4;
                    }
                }
                catch (BadGGEPPropertyException e) {
                    // empty catch block
                }
                try {
                    bytes = ggep.getBytes("VC");
                    vendorMinor = bytes[4] & 0xF;
                }
                catch (BadGGEPPropertyException e) {
                    // empty catch block
                }
            }
            if (ggep.hasKey("QK")) {
                try {
                    bytes = ggep.getBytes("QK");
                    key = QueryKey.getQueryKey(bytes, false);
                }
                catch (IllegalArgumentException malformedQueryKey) {
                }
                catch (BadGGEPPropertyException corrupt) {
                    // empty catch block
                }
            }
        }
        this.HAS_GGEP_EXTENSION = ggep != null;
        this.DAILY_UPTIME = dailyUptime;
        this.SUPPORTS_UNICAST = supportsUnicast;
        this.VENDOR = vendor;
        this.VENDOR_MAJOR_VERSION = vendorMajor;
        this.VENDOR_MINOR_VERSION = vendorMinor;
        this.QUERY_KEY = key;
    }

    private static GGEP newGGEP(int dailyUptime, boolean isUltrapeer, boolean isGUESSCapable) {
        GGEP ggep = new GGEP(true);
        if (dailyUptime >= 0) {
            ggep.put("DU", dailyUptime);
        }
        if (isGUESSCapable && isUltrapeer) {
            byte[] vNum = new byte[]{PingReply.convertToGUESSFormat(CommonUtils.getGUESSMajorVersionNumber(), CommonUtils.getGUESSMinorVersionNumber())};
            ggep.put("GUE", vNum);
        }
        if (isUltrapeer) {
            PingReply.addUltrapeerExtension(ggep);
        }
        ggep.put("VC", CACHED_VENDOR);
        return ggep;
    }

    private static GGEP qkGGEP(QueryKey queryKey) {
        try {
            GGEP ggep = new GGEP(true);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            queryKey.write(baos);
            ggep.put("QK", baos.toByteArray());
            return ggep;
        }
        catch (IOException e) {
            Assert.that(false, "Couldn't encode QueryKey" + queryKey);
            return null;
        }
    }

    private static void addUltrapeerExtension(GGEP ggep) {
        byte[] payload = new byte[]{PingReply.convertToGUESSFormat(CommonUtils.getUPMajorVersionNumber(), CommonUtils.getUPMinorVersionNumber()), (byte)RouterService.getNumFreeLeafSlots(), (byte)RouterService.getNumFreeNonLeafSlots()};
        ggep.put("UP", payload);
    }

    private static byte convertToGUESSFormat(int major, int minor) throws IllegalArgumentException {
        if (major < 0 || minor < 0 || major > 15 || minor > 15) {
            throw new IllegalArgumentException();
        }
        int retInt = major;
        retInt <<= 4;
        return (byte)(retInt |= minor);
    }

    protected void writePayload(OutputStream out) throws IOException {
        out.write(this.PAYLOAD);
        if (RECORD_STATS) {
            SentMessageStatHandler.TCP_PING_REPLIES.addMessage(this);
        }
    }

    public int getPort() {
        return this.PORT;
    }

    public String getIP() {
        return this.IP;
    }

    public byte[] getIPBytes() {
        byte[] ip = new byte[]{this.PAYLOAD[2], this.PAYLOAD[3], this.PAYLOAD[4], this.PAYLOAD[5]};
        return ip;
    }

    public long getFiles() {
        return this.FILES;
    }

    public long getKbytes() {
        return this.KILOBYTES;
    }

    public int getDailyUptime() {
        return this.DAILY_UPTIME;
    }

    public boolean supportsUnicast() {
        return this.SUPPORTS_UNICAST;
    }

    public String getVendor() {
        return this.VENDOR;
    }

    public int getVendorMajorVersion() {
        return this.VENDOR_MAJOR_VERSION;
    }

    public int getVendorMinorVersion() {
        return this.VENDOR_MINOR_VERSION;
    }

    public QueryKey getQueryKey() {
        return this.QUERY_KEY;
    }

    public boolean hasGGEPExtension() {
        return this.HAS_GGEP_EXTENSION;
    }

    private static GGEP parseGGEP(byte[] PAYLOAD) {
        if (PAYLOAD.length <= 14) {
            return null;
        }
        try {
            return new GGEP(PAYLOAD, 14, null);
        }
        catch (BadGGEPBlockException e) {
            return null;
        }
    }

    public Message stripExtendedPayload() {
        byte[] newPayload = new byte[14];
        System.arraycopy(this.PAYLOAD, 0, newPayload, 0, 14);
        return new PingReply(this.getGUID(), this.getTTL(), this.getHops(), newPayload, null);
    }

    public boolean isUltrapeer() {
        long kb = this.getKbytes();
        if (kb < 8L) {
            return false;
        }
        return PingReply.isPowerOf2(ByteOrder.long2int(kb));
    }

    public static boolean isPowerOf2(int x) {
        if (x <= 0) {
            return false;
        }
        return (x & x - 1) == 0;
    }

    public void recordDrop() {
        if (RECORD_STATS) {
            DroppedSentMessageStatHandler.TCP_PING_REPLIES.addMessage(this);
        }
    }

    private static long mark(long kbytes) {
        int x = ByteOrder.long2int(kbytes);
        if (x < 12) {
            return 8L;
        }
        if (x < 24) {
            return 16L;
        }
        if (x < 48) {
            return 32L;
        }
        if (x < 96) {
            return 64L;
        }
        if (x < 192) {
            return 128L;
        }
        if (x < 384) {
            return 256L;
        }
        if (x < 768) {
            return 512L;
        }
        if (x < 1536) {
            return 1024L;
        }
        if (x < 3072) {
            return 2048L;
        }
        if (x < 6144) {
            return 4096L;
        }
        if (x < 12288) {
            return 8192L;
        }
        if (x < 24576) {
            return 16384L;
        }
        if (x < 49152) {
            return 32768L;
        }
        if (x < 98304) {
            return 65536L;
        }
        if (x < 196608) {
            return 131072L;
        }
        if (x < 393216) {
            return 262144L;
        }
        if (x < 786432) {
            return 524288L;
        }
        if (x < 0x180000) {
            return 0x100000L;
        }
        if (x < 0x300000) {
            return 0x200000L;
        }
        if (x < 0x600000) {
            return 0x400000L;
        }
        if (x < 0xC00000) {
            return 0x800000L;
        }
        if (x < 0x1800000) {
            return 0x1000000L;
        }
        if (x < 0x3000000) {
            return 0x2000000L;
        }
        if (x < 0x6000000) {
            return 0x4000000L;
        }
        if (x < 0xC000000) {
            return 0x8000000L;
        }
        if (x < 0x18000000) {
            return 0x10000000L;
        }
        if (x < 0x30000000) {
            return 0x20000000L;
        }
        return 0x40000000L;
    }

    public String toString() {
        return "PingReply(" + this.getIP() + ":" + this.getPort() + ", " + super.toString() + ")";
    }

    static {
        System.arraycopy("ACQL".getBytes(), 0, CACHED_VENDOR, 0, "ACQL".getBytes().length);
        PingReply.CACHED_VENDOR[4] = PingReply.convertToGUESSFormat(CommonUtils.getMajorVersionNumber(), CommonUtils.getMinorVersionNumber());
    }
}

