/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.messages.PushRequest;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import com.limegroup.gnutella.routing.RouteTableMessage;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.MessageSettings;
import com.limegroup.gnutella.statistics.ReceivedErrorStat;
import com.limegroup.gnutella.util.CommonUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Iterator;

public abstract class Message
implements Serializable,
Comparable {
    public static final byte F_PING = 0;
    public static final byte F_PING_REPLY = 1;
    public static final byte F_PUSH = 64;
    public static final byte F_QUERY = -128;
    public static final byte F_QUERY_REPLY = -127;
    public static final byte F_ROUTE_TABLE_UPDATE = 48;
    public static final byte F_VENDOR_MESSAGE = 49;
    public static final byte F_VENDOR_MESSAGE_STABLE = 50;
    public static final int N_UNKNOWN = -1;
    public static final int N_TCP = 1;
    public static final int N_UDP = 2;
    public static final int N_MULTICAST = 3;
    public static final byte SOFT_MAX = ConnectionSettings.SOFT_MAX.getValue();
    private byte[] guid;
    private final byte func;
    private byte ttl;
    private byte hops;
    private int length;
    private int priority = 0;
    private final long creationTime = System.currentTimeMillis();
    private final int network;
    protected static final boolean RECORD_STATS = !CommonUtils.isJava118();

    public static byte[] makeGuid() {
        return GUID.makeGuid();
    }

    protected void repOk() {
        Assert.that(this.guid.length == 16);
        Assert.that(this.func == 0 || this.func == 1 || this.func == 64 || this.func == -128 || this.func == -127 || this.func == 49 || this.func == 50, "Bad function code");
        if (this.func == 64) {
            Assert.that(this.length == 26, "Bad push length: " + this.length);
        }
        Assert.that(this.ttl >= 0, "Negative TTL: " + this.ttl);
        Assert.that(this.hops >= 0, "Negative hops: " + this.hops);
        Assert.that(this.length >= 0, "Negative length: " + this.length);
    }

    protected Message(byte func, byte ttl, int length) {
        this(Message.makeGuid(), func, ttl, 0, length, -1);
    }

    protected Message(byte[] guid, byte func, byte ttl, byte hops, int length) {
        this(guid, func, ttl, hops, length, -1);
    }

    protected Message(byte[] guid, byte func, byte ttl, byte hops, int length, int network) {
        if (guid.length != 16) {
            throw new IllegalArgumentException("invalid guid length: " + guid.length);
        }
        this.guid = guid;
        this.func = func;
        this.ttl = ttl;
        this.hops = hops;
        this.length = length;
        this.network = network;
    }

    public static Message read(InputStream in) throws BadPacketException, IOException {
        return Message.read(in, new byte[23], -1, SOFT_MAX);
    }

    public static Message read(InputStream in, byte softMax) throws BadPacketException, IOException {
        return Message.read(in, new byte[23], -1, softMax);
    }

    public static Message read(InputStream in, int network) throws BadPacketException, IOException {
        return Message.read(in, new byte[23], network, SOFT_MAX);
    }

    public static Message read(InputStream in, byte[] buf, byte softMax) throws BadPacketException, IOException {
        return Message.read(in, buf, -1, softMax);
    }

    public static Message read(InputStream in, byte[] buf, int network, byte softMax) throws BadPacketException, IOException {
        int got;
        for (int i = 0; i < 23; i += got) {
            try {
                got = in.read(buf, i, 23 - i);
            }
            catch (InterruptedIOException e) {
                if (i == 0) {
                    return null;
                }
                throw e;
            }
            if (got != -1) continue;
            if (RECORD_STATS) {
                ReceivedErrorStat.CONNECTION_CLOSED.incrementStat();
            }
            throw new IOException("Connection closed.");
        }
        byte func = buf[16];
        byte ttl = buf[17];
        byte hops = buf[18];
        int length = ByteOrder.leb2int(buf, 19);
        if (length < 0 || length > MessageSettings.MAX_LENGTH.getValue()) {
            if (RECORD_STATS) {
                ReceivedErrorStat.INVALID_LENGTH.incrementStat();
            }
            throw new IOException("Unreasonable message length: " + length);
        }
        byte[] payload = null;
        if (length != 0) {
            int got2;
            payload = new byte[length];
            for (int i = 0; i < length; i += got2) {
                got2 = in.read(payload, i, length - i);
                if (got2 != -1) continue;
                if (RECORD_STATS) {
                    ReceivedErrorStat.CONNECTION_CLOSED.incrementStat();
                }
                throw new IOException("Connection closed.");
            }
        } else {
            payload = new byte[]{};
        }
        int hardMax = 14;
        if (hops < 0) {
            if (RECORD_STATS) {
                ReceivedErrorStat.INVALID_HOPS.incrementStat();
            }
            throw new BadPacketException("Negative (or very large) hops");
        }
        if (ttl < 0) {
            if (RECORD_STATS) {
                ReceivedErrorStat.INVALID_TTL.incrementStat();
            }
            throw new BadPacketException("Negative (or very large) TTL");
        }
        if (hops >= softMax && func != -127 && func != 1) {
            if (RECORD_STATS) {
                ReceivedErrorStat.HOPS_EXCEED_SOFT_MAX.incrementStat();
            }
            throw BadPacketException.HOPS_EXCEED_SOFT_MAX;
        }
        if (ttl + hops > hardMax) {
            if (RECORD_STATS) {
                ReceivedErrorStat.HOPS_AND_TTL_OVER_HARD_MAX.incrementStat();
            }
            throw new BadPacketException("TTL+hops exceeds hard max; probably spam");
        }
        if (ttl + hops > softMax && func != -127 && func != 1) {
            ttl = (byte)(softMax - hops);
            Assert.that(ttl >= 0);
        }
        byte[] guid = new byte[16];
        for (int i = 0; i < 16; ++i) {
            guid[i] = buf[i];
        }
        switch (func) {
            case 0: {
                if (length > 0) {
                    return new PingRequest(guid, ttl, hops, payload);
                }
                return new PingRequest(guid, ttl, hops);
            }
            case 1: {
                return PingReply.createFromNetwork(guid, ttl, hops, payload);
            }
            case -128: {
                if (length < 3) break;
                return QueryRequest.createNetworkQuery(guid, ttl, hops, payload, network);
            }
            case -127: {
                if (length < 26) break;
                return new QueryReply(guid, ttl, hops, payload);
            }
            case 64: {
                return new PushRequest(guid, ttl, hops, payload, network);
            }
            case 48: {
                return RouteTableMessage.read(guid, ttl, hops, payload);
            }
            case 49: {
                if (ttl != 1 || hops != 0) {
                    throw new BadPacketException("VM with bad ttl/hops: " + ttl + "/" + hops);
                }
                return VendorMessage.deriveVendorMessage(guid, ttl, hops, payload);
            }
            case 50: {
                if (ttl != 1 || hops != 0) {
                    throw new BadPacketException("VM with bad ttl/hops: " + ttl + "/" + hops);
                }
                return VendorMessage.deriveVendorMessage(guid, ttl, hops, payload);
            }
        }
        if (RECORD_STATS) {
            ReceivedErrorStat.INVALID_CODE.incrementStat();
        }
        throw new BadPacketException("Unrecognized function code: " + func);
    }

    public void write(OutputStream out) throws IOException {
        byte[] buf = new byte[23];
        for (int i = 0; i < 16; ++i) {
            buf[i] = this.guid[i];
        }
        buf[16] = this.func;
        buf[17] = this.ttl;
        buf[18] = this.hops;
        ByteOrder.int2leb(this.length, buf, 19);
        out.write(buf);
        this.writePayload(out);
    }

    protected abstract void writePayload(OutputStream var1) throws IOException;

    protected boolean writeGemExtension(OutputStream os, boolean addPrefixDelimiter, byte[] extBytes) throws IOException {
        if (extBytes == null || extBytes.length == 0) {
            return addPrefixDelimiter;
        }
        if (addPrefixDelimiter) {
            os.write(28);
        }
        os.write(extBytes);
        return true;
    }

    protected boolean writeGemExtension(OutputStream os, boolean addPrefixDelimiter, String ext) throws IOException {
        if (ext != null) {
            return this.writeGemExtension(os, addPrefixDelimiter, ext.getBytes());
        }
        return this.writeGemExtension(os, addPrefixDelimiter, new byte[0]);
    }

    protected boolean writeGemExtensions(OutputStream os, boolean addPrefixDelimiter, Iterator iter) throws IOException {
        if (iter == null) {
            return addPrefixDelimiter;
        }
        while (iter.hasNext()) {
            addPrefixDelimiter = this.writeGemExtension(os, addPrefixDelimiter, iter.next().toString());
        }
        return addPrefixDelimiter;
    }

    protected byte[] readNullTerminatedBytes(InputStream is) throws IOException {
        int i;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while (is.available() > 0 && (i = is.read()) != 0) {
            baos.write(i);
        }
        return baos.toByteArray();
    }

    public int getNetwork() {
        return this.network;
    }

    public boolean isMulticast() {
        return this.network == 3;
    }

    public boolean isUDP() {
        return this.network == 2;
    }

    public boolean isTCP() {
        return this.network == 1;
    }

    public boolean isUnknownNetwork() {
        return this.network == -1;
    }

    public byte[] getGUID() {
        return this.guid;
    }

    public byte getFunc() {
        return this.func;
    }

    public byte getTTL() {
        return this.ttl;
    }

    public void setTTL(byte ttl) throws IllegalArgumentException {
        if (ttl < 0) {
            throw new IllegalArgumentException("invalid TTL: " + ttl);
        }
        this.ttl = ttl;
    }

    protected void setGUID(GUID guid) {
        this.guid = guid.bytes();
    }

    public void setHops(byte hops) throws IllegalArgumentException {
        if (hops < 0) {
            throw new IllegalArgumentException("invalid hops: " + hops);
        }
        this.hops = hops;
    }

    public byte getHops() {
        return this.hops;
    }

    public int getLength() {
        return this.length;
    }

    protected void updateLength(int l) {
        this.length = l;
    }

    public int getTotalLength() {
        return 23 + this.length;
    }

    public byte hop() {
        this.hops = (byte)(this.hops + 1);
        if (this.ttl > 0) {
            byte by = this.ttl;
            this.ttl = (byte)(by - 1);
            return by;
        }
        return this.ttl;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public abstract Message stripExtendedPayload();

    public int compareTo(Object message) {
        Message m = (Message)message;
        return m.getPriority() - this.getPriority();
    }

    public String toString() {
        return "{guid=" + new GUID(this.guid).toString() + ", ttl=" + this.ttl + ", priority=" + this.getPriority() + "}";
    }

    public abstract void recordDrop();
}

