/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.handshaking;

import com.limegroup.gnutella.Connection;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.HostCatcher;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.handshaking.HeaderNames;
import com.limegroup.gnutella.settings.ConnectionSettings;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

public final class HandshakeResponse {
    public static final int OK = 200;
    public static final String OK_MESSAGE = "OK";
    public static final int SHIELDED = 503;
    public static final String SHIELDED_MESSAGE = "I am a shielded leaf node";
    public static final int SLOTS_FULL = 503;
    public static final String SLOTS_FULL_MESSAGE = "Service unavailable";
    public static final int DEFAULT_BAD_STATUS_CODE = 503;
    public static final String DEFAULT_BAD_STATUS_MESSAGE = "Service Not Available";
    public static final int UNAUTHORIZED_CODE = 401;
    public static final String UNAUTHORIZED_MESSAGE = "Unauthorized";
    public static final String UNABLE_TO_AUTHENTICATE = "Unable To Authenticate";
    public static final String AUTHENTICATING = "AUTHENTICATING";
    private final int STATUS_CODE;
    private final String STATUS_MESSAGE;
    private final Properties HEADERS;
    private Boolean _supportsGGEP;
    private final boolean GOOD_LEAF;
    private final boolean GOOD_ULTRAPEER;
    private final int DEGREE;
    private final boolean HIGH_DEGREE;
    private final boolean ULTRAPEER_QRP;
    private final byte MAX_TTL;
    private final boolean DYNAMIC_QUERY;
    private final boolean ULTRAPEER;
    private final boolean LEAF;
    private final boolean DEFLATE_ENCODED;
    private final boolean PROBE_QUERIES;
    private final boolean PONG_CACHING;
    private final boolean GUESS_CAPABLE;
    private final boolean IS_CRAWLER;

    private HandshakeResponse(Properties headers) {
        this(200, OK_MESSAGE, headers);
    }

    private HandshakeResponse(int code, String message) {
        this(code, message, new Properties());
    }

    HandshakeResponse(int code, String message, Properties headers) {
        this.STATUS_CODE = code;
        this.STATUS_MESSAGE = message;
        this.HEADERS = headers;
        this.DEGREE = HandshakeResponse.extractIntHeaderValue(this.HEADERS, "X-Degree", 6);
        this.HIGH_DEGREE = this.getNumIntraUltrapeerConnections() >= 15;
        this.ULTRAPEER_QRP = HandshakeResponse.isVersionOrHigher(this.HEADERS, "X-Ultrapeer-Query-Routing", 0.1f);
        this.MAX_TTL = HandshakeResponse.extractByteHeaderValue(this.HEADERS, "X-Max-TTL", (byte)4);
        this.DYNAMIC_QUERY = HandshakeResponse.isVersionOrHigher(this.HEADERS, "X-Dynamic-Querying", 0.1f);
        this.PROBE_QUERIES = HandshakeResponse.isVersionOrHigher(this.HEADERS, "X-Ext-Probes", 0.1f);
        this.GOOD_LEAF = this.isHighDegreeConnection() && this.isUltrapeerQueryRoutingConnection() && this.getMaxTTL() < 5 && this.isDynamicQueryConnection();
        this.GOOD_ULTRAPEER = this.isGoodLeaf() && this.supportsProbeQueries();
        this.ULTRAPEER = HandshakeResponse.isTrueValue(this.HEADERS, "X-Ultrapeer");
        this.LEAF = HandshakeResponse.isFalseValue(this.HEADERS, "X-Ultrapeer");
        this.DEFLATE_ENCODED = HandshakeResponse.isStringValue(this.HEADERS, HeaderNames.CONTENT_ENCODING, HeaderNames.DEFLATE_VALUE);
        this.PONG_CACHING = HandshakeResponse.isVersionOrHigher(headers, "Pong-Caching", 0.1f);
        this.GUESS_CAPABLE = HandshakeResponse.isVersionOrHigher(headers, "X-Guess", 0.1f);
        this.IS_CRAWLER = HandshakeResponse.isVersionOrHigher(headers, "Crawler", 0.1f);
    }

    public static HandshakeResponse createEmptyResponse() {
        return new HandshakeResponse(new Properties());
    }

    public static HandshakeResponse createResponse(Properties headers) throws IOException {
        return new HandshakeResponse(headers);
    }

    public static HandshakeResponse createResponse(String line, Properties headers) throws IOException {
        int code = HandshakeResponse.extractCode(line);
        if (code == -1) {
            throw new IOException("could not parse status code: " + line);
        }
        String message = HandshakeResponse.extractMessage(line);
        if (message == null) {
            throw new IOException("could not parse status message: " + line);
        }
        return new HandshakeResponse(code, message, headers);
    }

    static HandshakeResponse createAcceptIncomingResponse(Properties headers) {
        HandshakeResponse.addHighHopsUltrapeers(RouterService.getHostCatcher(), headers);
        return new HandshakeResponse(headers);
    }

    static HandshakeResponse createAcceptOutgoingResponse(Properties headers) {
        return new HandshakeResponse(headers);
    }

    static HandshakeResponse createCrawlerResponse() {
        Properties headers = new Properties();
        headers.put("Leaves", HandshakeResponse.createEndpointString(RouterService.getConnectionManager().getInitializedClientConnections2()));
        headers.put("Peers", HandshakeResponse.createEndpointString(RouterService.getConnectionManager().getInitializedConnections2()));
        return new HandshakeResponse(200, OK_MESSAGE, headers);
    }

    static HandshakeResponse createRejectIncomingResponse() {
        Properties headers = new Properties();
        HandshakeResponse.addConnectedUltrapeers(RouterService.getConnectionManager(), headers);
        return new HandshakeResponse(503, SLOTS_FULL_MESSAGE, headers);
    }

    static HandshakeResponse createRejectOutgoingResponse() {
        return new HandshakeResponse(503, SLOTS_FULL_MESSAGE, new Properties());
    }

    static HandshakeResponse createLeafRejectIncomingResponse() {
        Properties headers = new Properties();
        HandshakeResponse.addHighHopsUltrapeers(RouterService.getHostCatcher(), headers);
        return new HandshakeResponse(503, SHIELDED_MESSAGE, headers);
    }

    static HandshakeResponse createLeafRejectOutgoingResponse() {
        return new HandshakeResponse(503, SHIELDED_MESSAGE);
    }

    private static String createEndpointString(List connections) {
        Iterator iter = connections.iterator();
        StringBuffer sb = new StringBuffer();
        while (iter.hasNext()) {
            Connection conn = (Connection)iter.next();
            sb.append(conn.getIPString());
            sb.append(":");
            sb.append(conn.getListeningPort());
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    private static int extractCode(String line) {
        int statusMessageIndex = line.indexOf(" ");
        if (statusMessageIndex == -1) {
            return -1;
        }
        try {
            return Integer.parseInt(line.substring(0, statusMessageIndex).trim());
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private static String extractMessage(String line) {
        int statusMessageIndex = line.indexOf(" ");
        if (statusMessageIndex == -1) {
            return null;
        }
        return line.substring(statusMessageIndex).trim();
    }

    private static void addConnectedUltrapeers(ConnectionManager cm, Properties headers) {
        StringBuffer hostString = new StringBuffer();
        Set connectedSupernodeEndpoints = cm.getSupernodeEndpoints();
        if (connectedSupernodeEndpoints.size() < 0) {
            return;
        }
        Iterator iter = connectedSupernodeEndpoints.iterator();
        for (int i = 0; iter.hasNext() && i != 10; ++i) {
            Endpoint endpoint = (Endpoint)iter.next();
            hostString.append(endpoint.getHostname());
            hostString.append(":");
            hostString.append(endpoint.getPort());
            if (!iter.hasNext()) continue;
            hostString.append(",");
        }
        headers.put("X-Try-Ultrapeers", hostString.toString());
    }

    private static void addHighHopsUltrapeers(HostCatcher hc, Properties headers) {
        StringBuffer hostString = new StringBuffer();
        Iterator iter = hc.getUltrapeerHosts(10);
        while (iter.hasNext()) {
            Endpoint curHost = (Endpoint)iter.next();
            hostString.append(curHost.getHostname());
            hostString.append(":");
            hostString.append(curHost.getPort());
            if (!iter.hasNext()) continue;
            hostString.append(",");
        }
        headers.put("X-Try-Ultrapeers", hostString.toString());
    }

    public int getStatusCode() {
        return this.STATUS_CODE;
    }

    public String getStatusMessage() {
        return this.STATUS_MESSAGE;
    }

    public boolean notOKStatusCode() {
        return this.STATUS_CODE != 200;
    }

    public boolean isAccepted() {
        return this.STATUS_CODE == 200;
    }

    public String getStatusLine() {
        return new String(this.STATUS_CODE + " " + this.STATUS_MESSAGE);
    }

    public Properties props() {
        return this.HEADERS;
    }

    public String getProperty(String prop) {
        return this.HEADERS.getProperty(prop);
    }

    public String getUserAgent() {
        return this.HEADERS.getProperty("User-Agent");
    }

    public byte getMaxTTL() {
        return this.MAX_TTL;
    }

    public String getXTryUltrapeers() {
        return HandshakeResponse.extractStringHeaderValue(this.HEADERS, "X-Try-Ultrapeers");
    }

    public boolean hasXTryUltrapeers() {
        return HandshakeResponse.headerExists(this.HEADERS, "X-Try-Ultrapeers");
    }

    public boolean hasLeafGuidance() {
        return HandshakeResponse.isFalseValue(this.HEADERS, "X-Ultrapeer-Needed");
    }

    public int getNumIntraUltrapeerConnections() {
        return this.DEGREE;
    }

    public boolean isHighDegreeConnection() {
        return this.HIGH_DEGREE;
    }

    public boolean isGoodLeaf() {
        return this.GOOD_LEAF;
    }

    public boolean isDeflateEnabled() {
        return this.DEFLATE_ENCODED;
    }

    public boolean isDeflateAccepted() {
        return ConnectionSettings.ENCODE_DEFLATE.getValue() && HandshakeResponse.containsStringValue(this.HEADERS, HeaderNames.ACCEPT_ENCODING, HeaderNames.DEFLATE_VALUE);
    }

    public boolean isGoodUltrapeer() {
        return this.GOOD_ULTRAPEER;
    }

    public boolean isUltrapeerQueryRoutingConnection() {
        return this.ULTRAPEER_QRP;
    }

    public boolean isLeaf() {
        return this.LEAF;
    }

    public boolean isUltrapeer() {
        return this.ULTRAPEER;
    }

    public boolean isGUESSCapable() {
        return this.GUESS_CAPABLE;
    }

    public boolean isGUESSUltrapeer() {
        return this.isGUESSCapable() && this.isUltrapeer();
    }

    public boolean isTempConnection() {
        String value = this.HEADERS.getProperty("X-Temp-Connection");
        if (value == null) {
            return false;
        }
        return Boolean.valueOf(value);
    }

    public boolean supportsGGEP() {
        if (this._supportsGGEP == null) {
            String value = this.HEADERS.getProperty("GGEP");
            this._supportsGGEP = new Boolean(value != null);
        }
        return this._supportsGGEP;
    }

    public boolean supportsVendorMessages() {
        String value = this.HEADERS.getProperty("Vendor-Message");
        return value != null && !value.equals("");
    }

    public boolean supportsPongCaching() {
        return this.PONG_CACHING;
    }

    public String getDomainsAuthenticated() {
        return this.HEADERS.getProperty("X-Domains-Authenticated");
    }

    public String getVersion() {
        return this.HEADERS.getProperty("X-Version");
    }

    public boolean isQueryRoutingEnabled() {
        return HandshakeResponse.isVersionOrHigher(this.HEADERS, "X-Query-Routing", 0.1f);
    }

    public boolean isDynamicQueryConnection() {
        return this.DYNAMIC_QUERY;
    }

    public boolean supportsProbeQueries() {
        return this.PROBE_QUERIES;
    }

    public boolean isCrawler() {
        return this.IS_CRAWLER;
    }

    private static boolean headerExists(Properties headers, String headerName) {
        String value = headers.getProperty(headerName);
        return value != null;
    }

    private static boolean isTrueValue(Properties headers, String headerName) {
        String value = headers.getProperty(headerName);
        if (value == null) {
            return false;
        }
        return Boolean.valueOf(value);
    }

    private static boolean isFalseValue(Properties headers, String headerName) {
        String value = headers.getProperty(headerName);
        if (value == null) {
            return false;
        }
        return value.equalsIgnoreCase("false");
    }

    private static boolean isStringValue(Properties headers, String headerName, String headerValue) {
        String value = headers.getProperty(headerName);
        if (value == null) {
            return false;
        }
        return value.equalsIgnoreCase(headerValue);
    }

    private static boolean containsStringValue(Properties headers, String headerName, String headerValue) {
        String value = headers.getProperty(headerName);
        if (value == null) {
            return false;
        }
        if (value.equalsIgnoreCase(headerValue)) {
            return true;
        }
        StringTokenizer st = new StringTokenizer(value, ",");
        while (st.hasMoreTokens()) {
            if (!st.nextToken().equalsIgnoreCase(headerValue)) continue;
            return true;
        }
        return false;
    }

    private static boolean isVersionOrHigher(Properties headers, String headerName, float minVersion) {
        String value = headers.getProperty(headerName);
        if (value == null) {
            return false;
        }
        try {
            Float f = new Float(value);
            return f.floatValue() >= minVersion;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static int extractIntHeaderValue(Properties headers, String headerName, int defaultValue) {
        String value = headers.getProperty(headerName);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private static byte extractByteHeaderValue(Properties headers, String headerName, byte defaultValue) {
        String value = headers.getProperty(headerName);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Byte.valueOf(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private static String extractStringHeaderValue(Properties headers, String headerName) {
        String value = headers.getProperty(headerName);
        if (value == null) {
            return "";
        }
        return value;
    }

    public String toString() {
        return "<" + this.STATUS_CODE + ", " + this.STATUS_MESSAGE + ">" + this.HEADERS;
    }
}

