/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.filters;

import com.limegroup.gnutella.filters.IP;
import com.limegroup.gnutella.filters.IPList;
import com.limegroup.gnutella.filters.SpamFilter;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.PushRequest;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.settings.FilterSettings;
import com.limegroup.gnutella.util.NetworkUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;

public final class IPFilter
extends SpamFilter {
    private static IPFilter _instance;
    private final IPList badHosts = new IPList();
    private final IPList goodHosts = new IPList();

    private IPFilter() {
        int i;
        String[] allHosts = FilterSettings.BLACK_LISTED_IP_ADDRESSES.getValue();
        for (i = 0; i < allHosts.length; ++i) {
            this.badHosts.add(allHosts[i]);
        }
        allHosts = FilterSettings.WHITE_LISTED_IP_ADDRESSES.getValue();
        for (i = 0; i < allHosts.length; ++i) {
            this.goodHosts.add(allHosts[i]);
        }
    }

    public static IPFilter instance() {
        if (_instance == null) {
            _instance = new IPFilter();
        }
        return _instance;
    }

    public static void refreshIPFilter() {
        _instance = new IPFilter();
    }

    public boolean allow(String host) {
        IP ip;
        try {
            ip = new IP(host);
        }
        catch (IllegalArgumentException badHost) {
            try {
                InetAddress lookUp = InetAddress.getByName(host);
                host = lookUp.getHostAddress();
                ip = new IP(host);
            }
            catch (UnknownHostException unknownHost) {
                return false;
            }
            catch (IllegalArgumentException stillBadHost) {
                return false;
            }
        }
        return this.goodHosts.contains(ip) || !this.badHosts.contains(ip);
    }

    /*
     * WARNING - void declaration
     */
    public boolean allow(Message m) {
        void var2_5;
        String ip;
        if (m instanceof PingReply) {
            PingReply pr = (PingReply)m;
            ip = pr.getIP();
        } else if (m instanceof QueryReply) {
            QueryReply qr = (QueryReply)m;
            ip = qr.getIP();
        } else if (m instanceof PushRequest) {
            PushRequest push = (PushRequest)m;
            ip = NetworkUtils.ip2string(push.getIP());
        } else {
            return true;
        }
        return this.allow((String)var2_5);
    }
}

