/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.filters;

public class IP {
    private static final String MSG = "Could not parse: ";
    private final long addr;
    private final long mask;

    public IP(String ip_str) throws IllegalArgumentException {
        int slash = ip_str.indexOf("/");
        if (slash == -1) {
            this.addr = IP.stringToLong(ip_str);
            this.mask = IP.createNetmaskFromWildChars(ip_str);
        } else if (ip_str.lastIndexOf("/") == slash) {
            this.addr = IP.stringToLong(ip_str.substring(0, slash));
            this.mask = IP.parseNetmask(ip_str.substring(slash + 1));
        } else {
            throw new IllegalArgumentException(MSG + ip_str);
        }
    }

    private static long parseNetmask(String mask) throws IllegalArgumentException {
        if (mask.indexOf(".") == -1) {
            try {
                int k = Short.parseShort(mask);
                if (k > 32 || k < 0) {
                    throw new IllegalArgumentException(MSG + mask);
                }
                long netmask = 0L;
                for (int i = 0; i < k; ++i) {
                    netmask <<= 1;
                    ++netmask;
                }
                return netmask <<= 32 - k;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(MSG + mask);
            }
        }
        return IP.stringToLong(mask);
    }

    private static long stringToLong(String ip_str) throws IllegalArgumentException {
        long ip = 0L;
        int numOctets = 0;
        int length = ip_str.length();
        int i = 0;
        while (i < length) {
            int octet = 0;
            int j = 0;
            while (i < length) {
                char c = ip_str.charAt(i);
                if (c == '.') {
                    if (j != 0) break;
                    throw new IllegalArgumentException(MSG + ip_str);
                }
                if (j > 2) {
                    throw new IllegalArgumentException(MSG + ip_str);
                }
                if (c == '*') {
                    if (j != 0) {
                        throw new IllegalArgumentException(MSG + ip_str);
                    }
                } else {
                    if (c < '0' || c > '9') {
                        throw new IllegalArgumentException(MSG + ip_str);
                    }
                    if ((octet = (int)((short)(octet * 10 + c - 48))) > 255 || octet < 0) {
                        throw new IllegalArgumentException(MSG + ip_str);
                    }
                }
                ++i;
                ++j;
            }
            ip = (ip << 8) + (long)octet;
            ++i;
            ++numOctets;
        }
        while (numOctets < 4) {
            ip <<= 8;
            ++numOctets;
        }
        if (numOctets != 4) {
            throw new IllegalArgumentException(MSG + ip_str);
        }
        return ip;
    }

    private static long createNetmaskFromWildChars(String s) throws IllegalArgumentException {
        long mask = 0L;
        int numOctets = 0;
        int length = s.length();
        int i = 0;
        while (i < length) {
            int submask = 0;
            int j = 0;
            while (i < length) {
                char c = s.charAt(i);
                if (c == '.') {
                    if (j != 0) break;
                    throw new IllegalArgumentException(MSG + s);
                }
                if (j > 2) {
                    throw new IllegalArgumentException(MSG + s);
                }
                if (c != '*') {
                    submask = 255;
                } else if (j != 0) {
                    throw new IllegalArgumentException(MSG + s);
                }
                ++i;
                ++j;
            }
            mask = (mask << 8) + (long)submask;
            ++i;
            ++numOctets;
        }
        while (numOctets < 4) {
            mask <<= 8;
            ++numOctets;
        }
        if (numOctets != 4) {
            throw new IllegalArgumentException(MSG + s);
        }
        return mask;
    }

    public boolean contains(IP ip) {
        return (ip.addr & this.mask) == (this.addr & this.mask);
    }

    public boolean equals(Object other) {
        if (other instanceof IP) {
            IP ip = (IP)other;
            return this.addr == ip.addr && this.mask == ip.mask;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.addr ^ this.mask);
    }
}

