/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.filters;

import com.limegroup.gnutella.filters.GUIDPair;
import com.limegroup.gnutella.filters.QueryPair;
import com.limegroup.gnutella.filters.SpamFilter;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.util.Buffer;
import java.util.HashSet;
import java.util.Set;

public class DuplicateFilter
extends SpamFilter {
    private static final int BUF_SIZE = 20;
    private Buffer guids = new Buffer(20);
    private static final int GUID_LAG = 500;
    private static final int TOLERANCE = 2;
    private static final int QUERY_LAG = 1500;
    private long querySwapTime = 0L;
    private long queryClearTime = 1500L;
    private Set youngQueries = new HashSet();
    private Set oldQueries = new HashSet();

    private static long getTime() {
        return System.currentTimeMillis();
    }

    public boolean allow(Message m) {
        if (!this.allowGUID(m)) {
            return false;
        }
        if (m instanceof QueryRequest) {
            return this.allowQuery((QueryRequest)m);
        }
        return true;
    }

    public boolean allowGUID(Message m) {
        if (!(m instanceof QueryRequest) && !(m instanceof PingRequest)) {
            return true;
        }
        GUIDPair me = new GUIDPair(m.getGUID(), DuplicateFilter.getTime(), m.getHops());
        int z = this.guids.getSize();
        for (int j = 0; j < z; ++j) {
            GUIDPair other = (GUIDPair)this.guids.get(j);
            if (me.time - other.time > 500L) break;
            if (other.hops != me.hops) continue;
            int misses = 0;
            for (int i = 0; i < me.guid.length && misses <= 2; ++i) {
                if (me.guid[i] == other.guid[i]) continue;
                ++misses;
            }
            if (misses > 2) continue;
            this.guids.add(me);
            return false;
        }
        this.guids.add(me);
        return true;
    }

    public boolean allowQuery(QueryRequest qr) {
        QueryPair qp;
        long time = DuplicateFilter.getTime();
        if (time > this.querySwapTime) {
            if (time <= this.queryClearTime) {
                Set tmp = this.oldQueries;
                this.oldQueries = this.youngQueries;
                this.youngQueries = tmp;
                this.youngQueries.clear();
            } else {
                this.youngQueries.clear();
                this.oldQueries.clear();
            }
            this.querySwapTime = time + 1500L;
            this.queryClearTime = this.querySwapTime + 1500L;
        }
        if (this.oldQueries.contains(qp = new QueryPair(qr.getQuery(), qr.getHops(), qr.getRichQuery(), qr.getQueryUrns()))) {
            return false;
        }
        boolean added = this.youngQueries.add(qp);
        return added;
    }
}

