/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.downloader.Interval;
import com.limegroup.gnutella.downloader.ManagedDownloader;
import com.limegroup.gnutella.util.FileUtils;
import com.limegroup.gnutella.util.IntervalSet;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Iterator;
import java.util.List;

public class VerifyingFile {
    private RandomAccessFile fos;
    private boolean checkOverlap;
    private volatile boolean isCorrupted;
    private ManagedDownloader managedDownloader;
    private IntervalSet writtenBlocks;

    public VerifyingFile(boolean checkOverlap) {
        this.checkOverlap = checkOverlap;
        this.writtenBlocks = new IntervalSet();
    }

    public void open(File file, ManagedDownloader md) throws IOException {
        this.managedDownloader = md;
        File parentFile = FileUtils.getParentFile(file);
        FileUtils.setWriteable(parentFile);
        FileUtils.setWriteable(file);
        this.fos = new RandomAccessFile(file, "rw");
    }

    public synchronized void addInterval(Interval interval) {
        this.writtenBlocks.add(interval);
    }

    public synchronized void writeBlock(long currPos, int numBytes, byte[] buf) throws IOException {
        if (this.fos == null) {
            throw new IOException();
        }
        boolean checkBeforeWrite = false;
        List overlapBlocks = null;
        Interval intvl = null;
        if (this.checkOverlap && (overlapBlocks = this.writtenBlocks.getOverlapIntervals(intvl = new Interval((int)currPos, (int)currPos + numBytes - 1))).size() > 0) {
            checkBeforeWrite = true;
        }
        if (checkBeforeWrite) {
            Iterator iter = overlapBlocks.iterator();
            while (iter.hasNext()) {
                Interval overlapInterval = (Interval)iter.next();
                int amountToCheck = overlapInterval.high - overlapInterval.low + 1;
                byte[] fileBuf = new byte[amountToCheck];
                this.fos.seek(overlapInterval.low);
                this.fos.readFully(fileBuf, 0, amountToCheck);
                int j = this.findInitialPoint(overlapInterval, currPos);
                int i = 0;
                while (i < amountToCheck) {
                    if (buf[j] != fileBuf[i]) {
                        this.isCorrupted = true;
                        if (this.managedDownloader != null) {
                            this.managedDownloader.promptAboutCorruptDownload();
                        }
                    }
                    ++i;
                    ++j;
                }
            }
        }
        this.fos.seek(currPos);
        this.fos.write(buf, 0, numBytes);
        if (intvl == null) {
            this.writtenBlocks.add(new Interval((int)currPos, (int)currPos + numBytes - 1));
        } else {
            this.writtenBlocks.add(intvl);
        }
    }

    public synchronized Iterator getBlocks() {
        return this.writtenBlocks.getAllIntervals();
    }

    public synchronized List getBlocksAsList() {
        return this.writtenBlocks.getAllIntervalsAsList();
    }

    public synchronized Iterator getFreeBlocks(int maxSize) {
        return this.writtenBlocks.getNeededIntervals(maxSize);
    }

    public synchronized int getBlockSize() {
        return this.writtenBlocks.getSize();
    }

    public void close() {
        if (this.fos == null) {
            return;
        }
        try {
            this.fos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void clearManagedDownloader() {
        this.managedDownloader = null;
    }

    public boolean isCorrupted() {
        return this.isCorrupted;
    }

    public ManagedDownloader getManagedDownloader() {
        return this.managedDownloader;
    }

    private int findInitialPoint(Interval interval, long low) {
        if ((long)interval.low <= low) {
            return 0;
        }
        return interval.low - (int)low;
    }
}

