/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.downloader.IncompleteFileManager;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

class RemoteFileDescGrouper
implements Serializable {
    private List buckets = new ArrayList();
    private List incompletes = new ArrayList();
    private URN[] sha1s = new URN[0];
    private IncompleteFileManager incompleteFileManager;
    private static final int DECENT_QUALITY = 2;
    static boolean DEBUG = false;

    RemoteFileDescGrouper(RemoteFileDesc[] rfds, IncompleteFileManager incompleteFileManager) {
        int i;
        this.incompleteFileManager = incompleteFileManager;
        for (int i2 = 0; i2 < rfds.length; ++i2) {
            this.add(rfds[i2], false);
        }
        this.repOk();
        Object[] pairs = new FileTuple[this.buckets.size()];
        for (i = 0; i < this.buckets.size(); ++i) {
            File incompleteFile = (File)this.incompletes.get(i);
            List files = (List)this.buckets.get(i);
            int size = ((RemoteFileDesc)files.get(0)).getSize() - incompleteFileManager.getBlockSize(incompleteFile);
            int bandwidth = 1;
            Iterator iter2 = files.iterator();
            while (iter2.hasNext()) {
                RemoteFileDesc rfd = (RemoteFileDesc)iter2.next();
                if (rfd.getQuality() < 2) continue;
                bandwidth += RemoteFileDescGrouper.normalize(rfd.getSpeed());
            }
            float time = (float)size / (float)bandwidth;
            pairs[i] = new FileTuple(files, incompleteFile, this.sha1s[i], time);
        }
        Arrays.sort(pairs);
        for (i = 0; i < pairs.length; ++i) {
            Object pair = pairs[i];
            this.buckets.set(i, ((FileTuple)pair).bucket);
            this.incompletes.set(i, ((FileTuple)pair).incompleteFile);
            this.sha1s[i] = ((FileTuple)pair).sha1;
        }
        this.repOk();
    }

    private static int normalize(int speed) {
        if (speed < 56) {
            return 3;
        }
        if (speed < 350) {
            return 30;
        }
        if (speed < 1000) {
            return 40;
        }
        return 50;
    }

    synchronized int add(RemoteFileDesc rfd, boolean checkExisting) {
        this.repOk();
        File incompleteFile = this.incompleteFileManager.getFile(rfd);
        int n = this.buckets.size();
        Assert.that(this.incompletes.size() == n, "Length of buckets and incompletes different: " + n + "!=" + this.incompletes.size());
        for (int i = 0; i < n; ++i) {
            File otherIncompleteFile = (File)this.incompletes.get(i);
            if (!otherIncompleteFile.equals(incompleteFile) || !RemoteFileDescGrouper.hashEquals(rfd.getSHA1Urn(), this.sha1s[i])) continue;
            if (this.sha1s[i] == null && rfd.getSHA1Urn() != null) {
                this.sha1s[i] = rfd.getSHA1Urn();
            }
            List bucket = (List)this.buckets.get(i);
            if (checkExisting && bucket.contains(rfd)) {
                return -1;
            }
            bucket.add(rfd);
            this.repOk();
            return 1;
        }
        ArrayList<RemoteFileDesc> bucket = new ArrayList<RemoteFileDesc>();
        bucket.add(rfd);
        this.buckets.add(bucket);
        this.incompletes.add(incompleteFile);
        int p = this.incompletes.size();
        URN[] newArray = new URN[p];
        System.arraycopy(this.sha1s, 0, newArray, 0, this.sha1s.length);
        newArray[p - 1] = rfd.getSHA1Urn();
        this.sha1s = newArray;
        this.repOk();
        return 0;
    }

    synchronized URN getURNForBucket(int n) {
        if (n < 0 || n >= this.buckets.size()) {
            throw new IllegalArgumentException();
        }
        return this.sha1s[n];
    }

    private static boolean hashEquals(URN urn1, URN urn2) {
        if (urn1 == null || urn2 == null) {
            return true;
        }
        return urn1.equals(urn2);
    }

    Iterator buckets() {
        return new BucketIterator();
    }

    protected void repOk() {
        List bucket;
        int i;
        if (!DEBUG) {
            return;
        }
        Assert.that(this.buckets.size() == this.incompletes.size());
        Assert.that(this.buckets.size() == this.sha1s.length);
        for (i = 0; i < this.buckets.size(); ++i) {
            bucket = (List)this.buckets.get(i);
            File tmp1 = (File)this.incompletes.get(i);
            for (int j = 0; j < bucket.size(); ++j) {
                File tmp2 = this.incompleteFileManager.getFile((RemoteFileDesc)bucket.get(j));
                Assert.that(tmp1.equals(tmp2));
            }
        }
        for (i = 0; i < this.buckets.size(); ++i) {
            bucket = (List)this.buckets.get(i);
            URN urn1 = this.sha1s[i];
            boolean gotURN = false;
            for (int j = 0; j < bucket.size(); ++j) {
                URN urn2 = ((RemoteFileDesc)bucket.get(j)).getSHA1Urn();
                if (urn2 == null) continue;
                Assert.that(urn1 != null);
                Assert.that(urn1.equals(urn2));
                gotURN = true;
            }
        }
    }

    private class BucketIterator
    implements Iterator {
        int i = 0;

        private BucketIterator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasNext() {
            RemoteFileDescGrouper remoteFileDescGrouper = RemoteFileDescGrouper.this;
            synchronized (remoteFileDescGrouper) {
                return this.i < RemoteFileDescGrouper.this.buckets.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object next() {
            RemoteFileDescGrouper remoteFileDescGrouper = RemoteFileDescGrouper.this;
            synchronized (remoteFileDescGrouper) {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return RemoteFileDescGrouper.this.buckets.get(this.i++);
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class FileTuple
    implements Comparable {
        List bucket;
        File incompleteFile;
        URN sha1;
        float time;

        public FileTuple(List bucket, File incompleteFile, URN sha1, float time) {
            this.bucket = bucket;
            this.incompleteFile = incompleteFile;
            this.sha1 = sha1;
            this.time = time;
        }

        public int compareTo(Object o) {
            float diff = this.time - ((FileTuple)o).time;
            if (diff < 0.0f) {
                return -1;
            }
            if (diff > 0.0f) {
                return 1;
            }
            return 0;
        }
    }
}

