/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.AlternateLocation;
import com.limegroup.gnutella.AlternateLocationCollection;
import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.BandwidthTracker;
import com.limegroup.gnutella.BandwidthTrackerImpl;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UploadManager;
import com.limegroup.gnutella.downloader.AlreadyDownloadingException;
import com.limegroup.gnutella.downloader.CantResumeException;
import com.limegroup.gnutella.downloader.DownloadBrowseHostList;
import com.limegroup.gnutella.downloader.DownloadChatList;
import com.limegroup.gnutella.downloader.FileNotFoundException;
import com.limegroup.gnutella.downloader.HTTPDownloader;
import com.limegroup.gnutella.downloader.HeadRequester;
import com.limegroup.gnutella.downloader.IncompleteFileManager;
import com.limegroup.gnutella.downloader.Interval;
import com.limegroup.gnutella.downloader.InvalidPathException;
import com.limegroup.gnutella.downloader.MiniRemoteFileDesc;
import com.limegroup.gnutella.downloader.NoSuchRangeException;
import com.limegroup.gnutella.downloader.NotSharingException;
import com.limegroup.gnutella.downloader.QueuedException;
import com.limegroup.gnutella.downloader.RangeNotAvailableException;
import com.limegroup.gnutella.downloader.RemoteFileDescGrouper;
import com.limegroup.gnutella.downloader.TryAgainLaterException;
import com.limegroup.gnutella.downloader.UnknownCodeException;
import com.limegroup.gnutella.downloader.VerifyingFile;
import com.limegroup.gnutella.http.ProblemReadingHeaderException;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.DownloadSettings;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.statistics.DownloadStat;
import com.limegroup.gnutella.util.ApproximateMatcher;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.FileUtils;
import com.limegroup.gnutella.util.IntervalSet;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;

public class ManagedDownloader
implements Downloader,
Serializable {
    static final long serialVersionUID = 2772570805975885257L;
    private Object stealLock;
    private DownloadManager manager;
    private FileManager fileManager;
    private IncompleteFileManager incompleteFileManager;
    private ActivityCallback callback;
    private RemoteFileDesc[] allFiles;
    private static final int NORMAL_CONNECT_TIME = 10000;
    private static final int PUSH_CONNECT_TIME = 16000;
    private static final int MIN_SPLIT_SIZE = 100000;
    private static final int CHUNK_SIZE = 200000;
    private static final float MIN_ACCEPTABLE_SPEED = DownloadSettings.MAX_DOWNLOAD_BYTES_PER_SEC.getValue() < 8 ? 0.1f : 0.5f;
    private static final int OVERLAP_BYTES = 10;
    static int TIME_BETWEEN_REQUERIES = 300000;
    private static final int REQUERY_ATTEMPTS = 1;
    private static final int MATCHER_BUF_SIZE = 120;
    protected static final String UNKNOWN_FILENAME = "";
    private static ApproximateMatcher matcher = new ApproximateMatcher(120);
    private RemoteFileDescGrouper buckets;
    private int bucketNumber;
    private Thread dloaderManagerThread;
    private boolean stopped;
    private List dloaders;
    private List threads;
    private IntervalSet needed;
    private List busy;
    private List files;
    private volatile int queuedCount;
    private AlternateLocationCollection totalAlternateLocations;
    private VerifyingFile commonOutFile;
    private Map miniRFDToLock;
    private Map threadLockToSocket;
    private int state;
    private long stateTime;
    private int retriesWaiting;
    private File incompleteFile;
    private File completeFile;
    private String queuePosition;
    private String queuedVendor;
    private String currentLocation;
    private volatile int corruptFileBytes;
    private volatile File corruptFile;
    private RequeryLock reqLock = new RequeryLock();
    private DownloadChatList chatList;
    private DownloadBrowseHostList browseList;
    private static final int NOT_CORRUPT_STATE = 0;
    private static final int CORRUPT_WAITING_STATE = 1;
    private static final int CORRUPT_STOP_STATE = 2;
    private static final int CORRUPT_CONTINUE_STATE = 3;
    private int corruptState;
    private Object corruptStateLock;
    private static final BandwidthTrackerImpl BANDWIDTH_TRACKER_IMPL = new BandwidthTrackerImpl();
    private int numMeasures = 0;
    private float averageBandwidth = 0.0f;
    private static final boolean RECORD_STATS = !CommonUtils.isJava118();
    private static final List TRIVIAL_WORDS = new ArrayList(3);
    private boolean initDone;
    private final long SIXTY_KB = 60000L;
    private static final int MIN_NUM_CONNECTIONS = 2;
    private static final int MIN_CONNECTION_MESSAGES = 6;
    private static final int MIN_TOTAL_MESSAGES = 45;
    private static final int CONNECTION_DELAY = 500;
    static boolean NO_DELAY = false;
    private final boolean debugOn = false;
    private final boolean log = false;
    PrintWriter writer;

    public int numberOfDownloaders() {
        return this.dloaders != null ? this.dloaders.size() : 0;
    }

    public int numberOfThreads() {
        return this.threads != null ? this.threads.size() : 0;
    }

    public int numberOfBusy() {
        return this.busy != null ? this.busy.size() : 0;
    }

    public int numberOfFiles() {
        return this.files != null ? this.files.size() : 0;
    }

    public int numberOfQueued() {
        return this.queuedCount;
    }

    public void sendRequery() {
        try {
            QueryRequest requery = QueryRequest.createRequery(this.extractQueryString());
            System.err.println(this + " sendRequery: " + requery);
            RouterService.getMessageRouter().sendDynamicQuery(requery);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ManagedDownloader(RemoteFileDesc[] files, IncompleteFileManager ifc) {
        TRIVIAL_WORDS.add("the");
        TRIVIAL_WORDS.add("an");
        TRIVIAL_WORDS.add("a");
        this.initDone = false;
        this.SIXTY_KB = 60000L;
        this.debugOn = false;
        this.log = false;
        this.writer = null;
        if (files == null) {
            throw new NullPointerException("null RFDS");
        }
        if (ifc == null) {
            throw new NullPointerException("null incomplete file manager");
        }
        this.allFiles = files;
        this.incompleteFileManager = ifc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeObject(this.allFiles);
        IncompleteFileManager incompleteFileManager = this.incompleteFileManager;
        synchronized (incompleteFileManager) {
            stream.writeObject(this.incompleteFileManager);
        }
        stream.writeObject(BANDWIDTH_TRACKER_IMPL);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.allFiles = (RemoteFileDesc[])stream.readObject();
        this.incompleteFileManager = (IncompleteFileManager)stream.readObject();
        stream.readObject();
        this.reqLock = new RequeryLock();
    }

    public void initialize(DownloadManager manager, FileManager fileManager, ActivityCallback callback, final boolean deserialized) {
        this.manager = manager;
        this.fileManager = fileManager;
        this.callback = callback;
        this.dloaders = new LinkedList();
        this.threads = new ArrayList();
        this.chatList = new DownloadChatList();
        this.browseList = new DownloadBrowseHostList();
        this.stealLock = new Object();
        this.stopped = false;
        this.setState(0);
        this.miniRFDToLock = Collections.synchronizedMap(new HashMap());
        this.threadLockToSocket = Collections.synchronizedMap(new HashMap());
        this.corruptState = 0;
        this.corruptStateLock = new Object();
        this.numMeasures = 0;
        this.averageBandwidth = 0.0f;
        this.dloaderManagerThread = new Thread("ManagedDownload"){

            public void run() {
                try {
                    ManagedDownloader.this.tryAllDownloads(deserialized);
                }
                catch (Throwable e) {
                    ErrorService.error(e);
                }
            }
        };
        this.dloaderManagerThread.setDaemon(true);
        this.dloaderManagerThread.start();
    }

    protected void initializeIncompleteFile(File incFile) {
        if (this.incompleteFile != null) {
            return;
        }
        this.incompleteFile = incFile;
        this.commonOutFile = this.incompleteFileManager.getEntry(incFile);
    }

    private synchronized void initializeAlternateLocations() {
        if (this.incompleteFile == null) {
            return;
        }
        URN hash = this.incompleteFileManager.getCompletedHash(this.incompleteFile);
        if (hash != null) {
            FileDesc fd;
            long size = IncompleteFileManager.getCompletedSize(this.incompleteFile);
            if (this.totalAlternateLocations == null) {
                this.totalAlternateLocations = AlternateLocationCollection.createCollection(hash);
            }
            if ((fd = this.fileManager.getFileDescForUrn(hash)) != null) {
                AlternateLocationCollection alc = fd.getAlternateLocationCollectionWithoutSelf();
                this.addAlternateLocations(alc, (int)size);
            }
        }
    }

    public boolean conflicts(RemoteFileDesc other) {
        File otherFile = this.incompleteFileManager.getFile(other);
        return this.conflicts(otherFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean conflicts(File incFile) {
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            for (int i = 0; i < this.allFiles.length; ++i) {
                RemoteFileDesc rfd = this.allFiles[i];
                File thisFile = this.incompleteFileManager.getFile(rfd);
                if (!thisFile.equals(incFile)) continue;
                return true;
            }
        }
        return false;
    }

    protected synchronized QueryRequest newRequery(int numRequeries) throws CantResumeException {
        if (this.allFiles.length < 0) {
            throw new CantResumeException(UNKNOWN_FILENAME);
        }
        if (this.allFiles[0].getSHA1Urn() == null) {
            return QueryRequest.createQuery(this.extractQueryString());
        }
        return QueryRequest.createQuery(this.extractQueryString());
    }

    protected int getQueryCount(boolean deserializedFromDisk) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean pauseForRequery(int numRequeries, boolean deserializedFromDisk) throws InterruptedException {
        if (numRequeries >= 1) {
            return false;
        }
        boolean retVal = false;
        RequeryLock requeryLock = this.reqLock;
        synchronized (requeryLock) {
            this.setState(13);
            try {
                retVal = this.reqLock.lock(0L);
            }
            catch (InterruptedException stopException) {
                if (!this.stopped) {
                    ErrorService.error(stopException);
                }
                throw stopException;
            }
        }
        return retVal;
    }

    protected boolean shouldInitAltLocs(boolean deserializedFromDisk) {
        return false;
    }

    private final Set extractUrns() {
        int MAX_URNS = 2;
        HashSet<URN> ret = new HashSet<URN>(2);
        for (int i = 0; i < this.allFiles.length && ret.size() < 2; ++i) {
            URN urn = this.allFiles[i].getSHA1Urn();
            if (urn == null) continue;
            ret.add(urn);
        }
        return ret;
    }

    private final synchronized String extractQueryString() {
        Assert.that(this.allFiles.length > 0, "Precondition violated");
        int MAX_LEN = 30;
        Set intersection = ManagedDownloader.keywords(this.allFiles[0].getFileName());
        StringBuffer sb = new StringBuffer();
        int numWritten = 0;
        Iterator keys = intersection.iterator();
        while (keys.hasNext() && numWritten < 30) {
            String currKey = (String)keys.next();
            if (numWritten + currKey.length() >= 30) continue;
            if (numWritten > 0) {
                sb.append(" ");
            }
            sb.append(currKey);
            numWritten += currKey.length() + (numWritten == 0 ? 0 : 1);
        }
        String retString = sb.toString();
        Assert.that(retString.length() <= 30);
        return retString;
    }

    private static final Set keywords(String fileName) {
        fileName = ManagedDownloader.ripExtension(fileName);
        HashSet<String> ret = new HashSet<String>();
        StringTokenizer st = new StringTokenizer(fileName, " -._+/*()\\");
        while (st.hasMoreTokens()) {
            String currToken = st.nextToken().toLowerCase();
            try {
                new Double(currToken);
            }
            catch (NumberFormatException normalWord) {
                if (TRIVIAL_WORDS.contains(currToken)) continue;
                ret.add(currToken);
            }
        }
        return ret;
    }

    private static String ripExtension(String fileName) {
        String retString = null;
        int extStart = fileName.lastIndexOf(46);
        retString = extStart == -1 ? fileName : fileName.substring(0, extStart);
        return retString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean allowAddition(RemoteFileDesc other) {
        if (!this.initDone) {
            ApproximateMatcher approximateMatcher = matcher;
            synchronized (approximateMatcher) {
                matcher.setIgnoreCase(true);
                matcher.setIgnoreWhitespace(true);
                matcher.setCompareBackwards(true);
            }
            this.initDone = true;
        }
        if (other.getQuality() < 1) {
            return false;
        }
        URN otherUrn = other.getSHA1Urn();
        String otherName = other.getFileName();
        long otherLength = other.getSize();
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            for (int i = 0; i < this.allFiles.length; ++i) {
                RemoteFileDesc rfd = this.allFiles[i];
                URN urn = rfd.getSHA1Urn();
                if (otherUrn != null && urn != null) {
                    return otherUrn.equals(urn);
                }
                String thisName = rfd.getFileName();
                long thisLength = rfd.getSize();
                if (!this.sizeClose(otherLength, thisLength) || !this.namesClose(otherName, thisName)) continue;
                return true;
            }
        }
        return false;
    }

    private final boolean sizeClose(long one, long two) {
        boolean retVal = false;
        if (one == two) {
            retVal = true;
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean namesClose(String one, String two) {
        boolean retVal = false;
        int allowedDifferences = Math.round(Math.min(0.1f * (float)ManagedDownloader.ripExtension(one).length(), 0.1f * (float)ManagedDownloader.ripExtension(two).length()));
        allowedDifferences = Math.min(allowedDifferences, 6);
        ApproximateMatcher approximateMatcher = matcher;
        synchronized (approximateMatcher) {
            retVal = matcher.matches(matcher.process(one), matcher.process(two), allowedDifferences);
        }
        this.debug("MD.namesClose(): one = " + one);
        this.debug("MD.namesClose(): two = " + two);
        this.debug("MD.namesClose(): retVal = " + retVal);
        return retVal;
    }

    public synchronized boolean addDownload(RemoteFileDesc rfd, boolean cache) {
        if (!this.allowAddition(rfd)) {
            return false;
        }
        return this.addDownloadForced(rfd, cache);
    }

    protected final synchronized boolean addDownloadForced(RemoteFileDesc rfd, boolean cache) {
        if (NetworkUtils.isMe(rfd.getHost(), rfd.getPort())) {
            return true;
        }
        boolean exists = false;
        for (int i = 0; i < this.allFiles.length; ++i) {
            if (!rfd.equals(this.allFiles[i])) continue;
            cache = false;
            exists = true;
            break;
        }
        boolean added = false;
        if (this.buckets != null) {
            boolean bl = added = this.buckets.add(rfd, exists) != -1;
        }
        if (cache) {
            RemoteFileDesc[] newAllFiles = new RemoteFileDesc[this.allFiles.length + 1];
            System.arraycopy(this.allFiles, 0, newAllFiles, 0, this.allFiles.length);
            newAllFiles[newAllFiles.length - 1] = rfd;
            this.allFiles = newAllFiles;
        }
        if (added) {
            if (this.state == 3 || this.state == 8 || this.state == 6 || this.state == 13) {
                this.reqLock.releaseDueToNewResults();
            } else {
                this.notify();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acceptDownload(String file, Socket socket, int index, byte[] clientGUID) throws IOException {
        MiniRemoteFileDesc mrfd = new MiniRemoteFileDesc(file, index, clientGUID);
        Object lock = this.miniRFDToLock.get(mrfd);
        if (lock == null) {
            return false;
        }
        this.threadLockToSocket.put(lock, socket);
        Object v = lock;
        synchronized (v) {
            lock.notify();
        }
        return true;
    }

    public synchronized void stop() {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        Iterator iter = this.dloaders.iterator();
        while (iter.hasNext()) {
            ((HTTPDownloader)iter.next()).stop();
        }
        iter = this.threads.iterator();
        while (iter.hasNext()) {
            ((Thread)iter.next()).interrupt();
        }
        if (this.dloaderManagerThread != null) {
            this.dloaderManagerThread.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resume() throws AlreadyDownloadingException {
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            if (this.state != 3 && this.state != 6 && this.state != 5 && this.state != 13) {
                return false;
            }
        }
        String conflict = this.manager.conflicts(this.allFiles, this);
        if (conflict != null) {
            throw new AlreadyDownloadingException(conflict);
        }
        ManagedDownloader managedDownloader2 = this;
        synchronized (managedDownloader2) {
            if (this.state == 6 || this.state == 5) {
                if (this.state == 6 && this.dloaderManagerThread != null && this.dloaderManagerThread.isAlive()) {
                    ManagedDownloader managedDownloader3 = this;
                    synchronized (managedDownloader3) {
                        this.buckets = new RemoteFileDescGrouper(this.allFiles, this.incompleteFileManager);
                    }
                    this.reqLock.releaseDueToNewResults();
                } else {
                    this.initialize(this.manager, this.fileManager, this.callback, false);
                }
            } else if (this.state == 3) {
                if (this.dloaderManagerThread != null) {
                    this.dloaderManagerThread.interrupt();
                }
            } else if (this.state == 13) {
                this.reqLock.releaseDueToRequery();
            }
            return true;
        }
    }

    public File getDownloadFragment() {
        if (this.state == 4) {
            return this.completeFile;
        }
        if (this.state == 9) {
            return this.corruptFile;
        }
        return this.incompleteFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int amountForPreview() {
        VerifyingFile verifyingFile = this.commonOutFile;
        synchronized (verifyingFile) {
            Iterator iter = this.commonOutFile.getBlocks();
            while (iter.hasNext()) {
                Interval interval = (Interval)iter.next();
                if (interval.low != 0) continue;
                return interval.high;
            }
        }
        return 0;
    }

    protected long[] getFailedState(boolean deserialized, long timeSpentWaiting) {
        return new long[2];
    }

    public void finish() {
        if (this.commonOutFile != null) {
            this.commonOutFile.clearManagedDownloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void tryAllDownloads(boolean deserializedFromDisk) {
        int numQueries = this.getQueryCount(deserializedFromDisk);
        long timeQuerySent = System.currentTimeMillis();
        long timeSpentWaiting = 0L;
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            this.buckets = new RemoteFileDescGrouper(this.allFiles, this.incompleteFileManager);
            if (this.shouldInitAltLocs(deserializedFromDisk)) {
                this.initializeAlternateLocations();
            }
        }
        while (true) {
            try {
                while (true) {
                    boolean waitForRetry;
                    block28: {
                        this.setState(0);
                        this.queuePosition = UNKNOWN_FILENAME;
                        this.queuedVendor = UNKNOWN_FILENAME;
                        this.queuedCount = 0;
                        this.manager.waitForSlot(this);
                        waitForRetry = false;
                        this.bucketNumber = 0;
                        try {
                            Iterator iter = this.buckets.buckets();
                            while (iter.hasNext()) {
                                this.cleanup();
                                this.files = (List)iter.next();
                                if (this.checkHosts()) {
                                    this.setState(6);
                                    return;
                                }
                                if (this.files.size() > 0) {
                                    int status = this.tryAllDownloads2();
                                    if (status == 4) {
                                        this.setState(4);
                                        this.manager.remove(this, true);
                                        return;
                                    }
                                    if (status == 7) {
                                        this.setState(7);
                                        this.manager.remove(this, false);
                                        return;
                                    }
                                    if (status == 9) {
                                        this.setState(9);
                                        this.manager.remove(this, false);
                                        return;
                                    }
                                    if (status == 3) {
                                        waitForRetry = true;
                                    } else {
                                        Assert.that(status == 6, "Bad status from tad2: " + status);
                                    }
                                }
                                ++this.bucketNumber;
                            }
                        }
                        catch (InterruptedException e) {
                            if (this.stopped) break block28;
                            ErrorService.error(e);
                        }
                    }
                    this.manager.yieldSlot(this);
                    if (this.stopped) {
                        this.setState(5);
                        this.manager.remove(this, false);
                        return;
                    }
                    long currTime = System.currentTimeMillis();
                    if (waitForRetry) {
                        ManagedDownloader managedDownloader2 = this;
                        synchronized (managedDownloader2) {
                            this.retriesWaiting = 0;
                            Iterator iter = this.buckets.buckets();
                            while (iter.hasNext()) {
                                List bucket = (List)iter.next();
                                this.retriesWaiting += bucket.size();
                            }
                        }
                        long time = this.calculateWaitTime();
                        this.setState(3, time);
                        this.reqLock.lock(time);
                        continue;
                    }
                    boolean areThereNewResults = false;
                    long timeToWait = (long)TIME_BETWEEN_REQUERIES - (System.currentTimeMillis() - timeQuerySent);
                    if (numQueries > 0 && timeToWait > 0L) {
                        this.setState(8, timeToWait);
                        areThereNewResults = this.reqLock.lock(timeToWait);
                    }
                    if (areThereNewResults || this.pauseForRequery(numQueries, deserializedFromDisk)) continue;
                    if (numQueries < 1) {
                        this.waitForStableConnections();
                        try {
                            if (this.manager.sendQuery(this, this.newRequery(numQueries))) {
                                ++numQueries;
                            }
                            timeQuerySent = System.currentTimeMillis();
                        }
                        catch (CantResumeException ignore) {}
                        continue;
                    }
                    long[] instructions = this.getFailedState(deserializedFromDisk, timeSpentWaiting);
                    if (instructions[1] > 0L) {
                        this.setState((int)instructions[0], instructions[1]);
                        this.reqLock.lock(instructions[1]);
                        timeSpentWaiting += System.currentTimeMillis() - currTime;
                        continue;
                    }
                    this.setState(6);
                    this.reqLock.lock(0L);
                }
            }
            catch (InterruptedException e) {
                if (!this.stopped) continue;
                this.setState(5);
                this.manager.remove(this, false);
                return;
            }
            break;
        }
    }

    private void waitForStableConnections() throws InterruptedException {
        if (NO_DELAY) {
            return;
        }
        while (RouterService.countConnectionsWithNMessages(6) < 2 && RouterService.getActiveConnectionMessages() < 45) {
            this.setState(14);
            Thread.sleep(500L);
        }
    }

    private long calculateWaitTime() {
        return 60000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int tryAllDownloads2() throws InterruptedException {
        BandwidthTracker bandwidthTracker;
        FileDesc fd;
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            if (this.files.size() == 0) {
                return 6;
            }
        }
        this.incompleteFile = this.incompleteFileManager.getFile((RemoteFileDesc)this.files.get(0));
        String fileName = this.getFileName();
        try {
            File saveDir = SharingSettings.getSaveDirectory();
            this.completeFile = new File(saveDir, fileName);
            String savePath = saveDir.getCanonicalPath();
            String completeFileParentPath = new File(this.completeFile.getParent()).getCanonicalPath();
            if (!savePath.equals(completeFileParentPath)) {
                throw new InvalidPathException();
            }
        }
        catch (IOException e) {
            return 7;
        }
        boolean firstSHA1RFD = true;
        ManagedDownloader managedDownloader2 = this;
        synchronized (managedDownloader2) {
            Iterator iter = this.files.iterator();
            while (iter.hasNext()) {
                RemoteFileDesc tempRFD = (RemoteFileDesc)iter.next();
                URN sha1 = tempRFD.getSHA1Urn();
                if (sha1 == null) continue;
                if (this.totalAlternateLocations == null || firstSHA1RFD && !this.totalAlternateLocations.getSHA1().equals(sha1)) {
                    this.totalAlternateLocations = AlternateLocationCollection.createCollection(sha1);
                }
                firstSHA1RFD = false;
                if (!sha1.equals(this.totalAlternateLocations.getSHA1Urn()) || !NetworkUtils.isValidPort(tempRFD.getPort())) continue;
                try {
                    AlternateLocation location = AlternateLocation.createAlternateLocation(tempRFD);
                    this.totalAlternateLocations.addAlternateLocation(location);
                }
                catch (IOException e) {}
            }
            if (firstSHA1RFD) {
                this.totalAlternateLocations = null;
            }
        }
        int status = -1;
        try {
            status = this.tryAllDownloads3();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        this.commonOutFile.close();
        if (this.corruptState != 0) {
            Object e = this.corruptStateLock;
            synchronized (e) {
                try {
                    while (this.corruptState == 1) {
                        this.corruptStateLock.wait();
                    }
                }
                catch (InterruptedException ignored) {
                    // empty catch block
                }
            }
            if (this.corruptState == 2) {
                this.cleanupCorrupt(this.incompleteFile, this.completeFile.getName());
                return 9;
            }
            if (this.corruptState == 3) {
                // empty if block
            }
        }
        if (status == -1) {
            throw new InterruptedException();
        }
        if (status != 4) {
            return status;
        }
        URN bucketHash = this.buckets.getURNForBucket(this.bucketNumber);
        URN fileHash = null;
        try {
            this.setState(11);
            fileHash = URN.createSHA1Urn(this.incompleteFile);
        }
        catch (IOException ignored) {
            // empty catch block
        }
        if (bucketHash != null) {
            Object ignored = this.corruptStateLock;
            synchronized (ignored) {
                if (!bucketHash.equals(fileHash)) {
                    this.setState(9);
                    this.promptAboutCorruptDownload();
                    this.debug("hash verification problem, fileHash=" + fileHash + ", bucketHash=" + bucketHash);
                }
                try {
                    while (this.corruptState == 1) {
                        this.corruptStateLock.wait();
                    }
                }
                catch (InterruptedException ignored2) {
                    // empty catch block
                }
            }
            if (this.corruptState == 2) {
                this.cleanupCorrupt(this.incompleteFile, this.completeFile.getName());
                return 9;
            }
        }
        this.setState(12);
        File completeFileDir = FileUtils.getParentFile(this.completeFile);
        FileUtils.setWriteable(completeFileDir);
        FileUtils.setWriteable(this.completeFile);
        this.completeFile.delete();
        boolean success = this.incompleteFile.renameTo(this.completeFile);
        if (!success && (fd = RouterService.getFileManager().getFileDescForFile(this.incompleteFile)) != null) {
            UploadManager upMan;
            bandwidthTracker = upMan = RouterService.getUploadManager();
            synchronized (bandwidthTracker) {
                if (upMan.killUploadsForFileDesc(fd)) {
                    success = this.incompleteFile.renameTo(this.completeFile);
                }
            }
        }
        if (!success) {
            success = CommonUtils.copy(this.incompleteFile, this.completeFile);
        }
        if (!success) {
            return 7;
        }
        this.incompleteFileManager.removeEntry(this.incompleteFile);
        if (this.fileExists(this.completeFile)) {
            this.fileManager.removeFileIfShared(this.completeFile);
        }
        FileDesc fileDesc = this.fileManager.addFileIfShared(this.completeFile, this.getXMLDocuments());
        if (this.totalAlternateLocations != null && fileDesc != null && fileDesc != null && fileDesc.getSHA1Urn().equals(this.totalAlternateLocations.getSHA1Urn())) {
            fileDesc.addAlternateLocationCollection(this.totalAlternateLocations);
            this.callback.handleSharedFileUpdate(this.completeFile);
            HashSet set = null;
            bandwidthTracker = this;
            synchronized (bandwidthTracker) {
                set = new HashSet(this.files);
            }
            HeadRequester requester = new HeadRequester(set, fileHash, fileDesc, fileDesc.getAlternateLocationCollection());
            Thread headThread = new Thread((Runnable)requester, "HEAD Request Thread");
            headThread.setDaemon(true);
            headThread.start();
        }
        return 4;
    }

    private boolean fileExists(File f) {
        return f.exists();
    }

    private void cleanupCorrupt(File incFile, String name) {
        this.corruptFileBytes = this.getAmountRead();
        this.incompleteFileManager.removeEntry(incFile);
        boolean renamed = false;
        for (int i = 0; i < 10 && !renamed; ++i) {
            this.corruptFile = new File(incFile.getParent(), "CORRUPT-" + i + "-" + name);
            if (this.corruptFile.exists()) continue;
            renamed = incFile.renameTo(this.corruptFile);
        }
        if (!renamed) {
            incFile.delete();
            this.corruptFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int tryAllDownloads3() throws InterruptedException {
        int completedSize = -1;
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            this.needed = new IntervalSet();
            Assert.that(this.incompleteFile != null);
            IncompleteFileManager incompleteFileManager = this.incompleteFileManager;
            synchronized (incompleteFileManager) {
                if (this.commonOutFile != null) {
                    this.commonOutFile.clearManagedDownloader();
                }
                this.commonOutFile = this.incompleteFileManager.getEntry(this.incompleteFile);
            }
            if (this.commonOutFile == null) {
                this.debug("creating a verifying file");
                this.commonOutFile = new VerifyingFile(true);
                this.incompleteFileManager.addEntry(this.incompleteFile, this.commonOutFile);
            }
            try {
                this.commonOutFile.open(this.incompleteFile, this);
            }
            catch (IOException e) {
                ErrorService.error(e);
                return 7;
            }
            completedSize = (int)IncompleteFileManager.getCompletedSize(this.incompleteFile);
            Iterator iter = this.commonOutFile.getFreeBlocks(completedSize);
            while (iter.hasNext()) {
                this.addToNeeded((Interval)iter.next());
            }
        }
        this.busy = new LinkedList();
        int size = -1;
        int connectTo = -1;
        Assert.that(this.threads.size() == 0);
        while (true) {
            Object object = this.stealLock;
            synchronized (object) {
                ManagedDownloader managedDownloader2 = this;
                synchronized (managedDownloader2) {
                    if (this.stopped) {
                        this.debug("MANAGER: terminating because of stop");
                        throw new InterruptedException();
                    }
                    if (this.dloaders.size() == 0 && this.needed.isEmpty()) {
                        int doneSize = (int)IncompleteFileManager.getCompletedSize(this.incompleteFile);
                        Assert.that(completedSize == doneSize, "incomplete files (or size!) changed!");
                        Assert.that(!this.commonOutFile.getFreeBlocks(doneSize).hasNext(), "file is incomplete, but needed.isEmpty()");
                        for (int i = this.threads.size(); i > 0; --i) {
                            Thread t = (Thread)this.threads.get(i - 1);
                            t.interrupt();
                        }
                        this.debug("MANAGER: terminating because of completion");
                        return 4;
                    }
                    if (this.threads.size() == 0 && this.files.size() == 0) {
                        if (this.busy.size() > 0) {
                            this.debug("MANAGER: terminating with busy");
                            this.files.addAll(this.busy);
                            return 3;
                        }
                        this.debug("MANAGER: terminating w/o hope");
                        return 6;
                    }
                    size = this.files.size();
                    connectTo = this.getNumAllowedDownloads();
                }
            }
            for (int i = 0; i < connectTo && i < size; ++i) {
                final RemoteFileDesc rfd = this.removeBest(this.files);
                Thread connectCreator = new Thread("DownloadWorker"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void run() {
                        ManagedDownloader managedDownloader;
                        boolean iterate = false;
                        try {
                            try {
                                iterate = ManagedDownloader.this.connectAndDownload(rfd);
                            }
                            catch (Throwable e) {
                                ErrorService.error(e);
                                Object var4_3 = null;
                                ManagedDownloader managedDownloader3 = ManagedDownloader.this;
                                synchronized (managedDownloader3) {
                                    ManagedDownloader.this.threads.remove(this);
                                    if (!iterate) return;
                                    ManagedDownloader.this.notifyAll();
                                    return;
                                }
                            }
                            Object var4_2 = null;
                            managedDownloader = ManagedDownloader.this;
                        }
                        catch (Throwable throwable) {
                            Object var4_4 = null;
                            ManagedDownloader managedDownloader2 = ManagedDownloader.this;
                            synchronized (managedDownloader2) {
                                ManagedDownloader.this.threads.remove(this);
                                if (!iterate) throw throwable;
                                ManagedDownloader.this.notifyAll();
                                throw throwable;
                            }
                        }
                        synchronized (managedDownloader) {
                            ManagedDownloader.this.threads.remove(this);
                            if (!iterate) return;
                            ManagedDownloader.this.notifyAll();
                            return;
                        }
                    }
                };
                ManagedDownloader managedDownloader3 = this;
                synchronized (managedDownloader3) {
                    this.threads.add(connectCreator);
                }
                connectCreator.start();
            }
            object = this;
            synchronized (object) {
                try {
                    this.wait(4000L);
                }
                catch (InterruptedException ee) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean connectAndDownload(RemoteFileDesc rfd) {
        HTTPDownloader dloader = null;
        dloader = this.establishConnection(rfd);
        if (dloader == null) {
            return true;
        }
        boolean http11 = true;
        while (http11) {
            int connected;
            boolean wasQueued = false;
            http11 = rfd.isHTTP11();
            while (true) {
                int[] a;
                if ((connected = this.assignAndRequest(dloader, a = new int[]{-1}, http11)) == 4) {
                    continue;
                }
                if (connected != 1) break;
                if (!wasQueued) {
                    ManagedDownloader managedDownloader = this;
                    synchronized (managedDownloader) {
                        ++this.queuedCount;
                    }
                    wasQueued = true;
                }
                try {
                    if (a[0] <= 0) continue;
                    Thread.sleep(a[0]);
                }
                catch (InterruptedException ix) {
                    this.debug("worker: interrupted while asleep in queue" + dloader);
                    ManagedDownloader managedDownloader = this;
                    synchronized (managedDownloader) {
                        --this.queuedCount;
                    }
                    dloader.stop();
                    return true;
                }
            }
            if (wasQueued) {
                ManagedDownloader managedDownloader = this;
                synchronized (managedDownloader) {
                    --this.queuedCount;
                }
            }
            Assert.that(connected == 0 || connected == 2 || connected == 3, "invalid return from assignAndRequest " + connected);
            if (connected == 0) {
                dloader.stop();
                return true;
            }
            if (connected == 3) {
                dloader.stop();
                return false;
            }
            this.doDownload(dloader, http11);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HTTPDownloader establishConnection(RemoteFileDesc rfd) {
        if (rfd == null) {
            return null;
        }
        if (this.stopped) {
            ManagedDownloader managedDownloader = this;
            synchronized (managedDownloader) {
                this.files.add(rfd);
            }
            return null;
        }
        File incFile = this.incompleteFileManager.getFile(rfd);
        boolean needsPush = ManagedDownloader.needsPush(rfd);
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            this.currentLocation = rfd.getHost();
            if (this.dloaders.size() == 0 && this.getState() != 4 && this.getState() != 5 && this.getState() != 6 && this.getState() != 7 && this.getState() != 9 && this.getState() != 11 && this.getState() != 12 && this.queuedCount == 0) {
                this.setState(1, needsPush ? 16000L : 10000L);
            }
        }
        this.debug("WORKER: attempting connect to " + rfd.getHost() + ":" + rfd.getPort());
        if (RECORD_STATS) {
            DownloadStat.CONNECTION_ATTEMPTS.incrementStat();
        }
        if (rfd.isReplyToMulticast()) {
            HTTPDownloader ret;
            this.removeAlternateLocation(rfd);
            try {
                ret = this.connectWithPush(rfd, incFile);
            }
            catch (IOException e) {
                try {
                    ret = this.connectDirectly(rfd, incFile);
                }
                catch (IOException e2) {
                    return null;
                }
            }
            return ret;
        }
        if (!needsPush) {
            try {
                HTTPDownloader ret = this.connectDirectly(rfd, incFile);
                return ret;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        this.removeAlternateLocation(rfd);
        try {
            HTTPDownloader ret = this.connectWithPush(rfd, incFile);
            return ret;
        }
        catch (IOException e) {
            return null;
        }
    }

    private HTTPDownloader connectDirectly(RemoteFileDesc rfd, File incFile) throws IOException {
        HTTPDownloader ret = new HTTPDownloader(rfd, incFile, this.totalAlternateLocations);
        try {
            ret.connectTCP(10000);
            if (RECORD_STATS) {
                DownloadStat.CONNECT_DIRECT_SUCCESS.incrementStat();
            }
        }
        catch (IOException iox) {
            if (RECORD_STATS) {
                DownloadStat.CONNECT_DIRECT_FAILURES.incrementStat();
            }
            throw iox;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HTTPDownloader connectWithPush(RemoteFileDesc rfd, File incFile) throws IOException {
        boolean pushSent;
        Object threadLock = new Object();
        MiniRemoteFileDesc mrfd = new MiniRemoteFileDesc(rfd.getFileName(), rfd.getIndex(), rfd.getClientGUID());
        this.miniRFDToLock.put(mrfd, threadLock);
        Object object = threadLock;
        synchronized (object) {
            pushSent = this.manager.sendPush(rfd);
            if (pushSent) {
                try {
                    threadLock.wait(16000L);
                }
                catch (InterruptedException e) {
                    if (RECORD_STATS) {
                        DownloadStat.PUSH_FAILURE_INTERRUPTED.incrementStat();
                    }
                    throw new IOException("push interupted.");
                }
            }
        }
        Socket pushSocket = (Socket)this.threadLockToSocket.remove(threadLock);
        if (pushSocket == null) {
            if (RECORD_STATS) {
                if (!pushSent) {
                    DownloadStat.PUSH_FAILURE_NO_ROUTE.incrementStat();
                } else {
                    DownloadStat.PUSH_FAILURE_NO_RESPONSE.incrementStat();
                }
            }
            throw new IOException("push socket is null");
        }
        this.miniRFDToLock.remove(mrfd);
        HTTPDownloader ret = new HTTPDownloader(pushSocket, rfd, incFile, this.totalAlternateLocations);
        try {
            ret.connectTCP(0);
            if (RECORD_STATS) {
                DownloadStat.CONNECT_PUSH_SUCCESS.incrementStat();
            }
        }
        catch (IOException iox) {
            if (RECORD_STATS) {
                DownloadStat.PUSH_FAILURE_LOST.incrementStat();
            }
            throw iox;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private int assignAndRequest(HTTPDownloader dloader, int[] refSleepTime, boolean http11) {
        Object object = this.stealLock;
        // MONITORENTER : object
        RemoteFileDesc rfd = dloader.getRemoteFileDesc();
        boolean updateNeeded = true;
        try {
            try {
                if (!this.needed.isEmpty()) {
                    this.assignWhite(dloader, http11);
                } else {
                    updateNeeded = false;
                    this.assignGrey(dloader, http11);
                }
                updateNeeded = false;
            }
            catch (NoSuchElementException nsex) {
                if (RECORD_STATS) {
                    DownloadStat.NSE_EXCEPTION.incrementStat();
                }
                Assert.that(!updateNeeded, "updateNeeded not false in assignAndRequest");
                this.debug("nsex thrown in assingAndRequest " + dloader);
                ManagedDownloader managedDownloader = this;
                // MONITORENTER : managedDownloader
                this.files.add(rfd);
                // MONITOREXIT : managedDownloader
                int n = 3;
                Object var15_8 = null;
                ManagedDownloader managedDownloader2 = this;
                // MONITORENTER : managedDownloader2
                this.addAlternateLocations(dloader.getAlternateLocations(), rfd.getSize());
                // MONITOREXIT : managedDownloader2
                if (updateNeeded) {
                    this.updateNeeded(dloader);
                }
                // MONITOREXIT : object
                return n;
            }
            catch (NoSuchRangeException nsrx) {
                if (RECORD_STATS) {
                    DownloadStat.NSR_EXCEPTION.incrementStat();
                }
                this.debug("nsrx thrown in assignAndRequest" + dloader);
                ManagedDownloader managedDownloader = this;
                // MONITORENTER : managedDownloader
                rfd.setAvailableRanges(null);
                this.busy.add(rfd);
                // MONITOREXIT : managedDownloader
                rfd.resetFailedCount();
                int n = 0;
                Object var15_9 = null;
                ManagedDownloader managedDownloader3 = this;
                // MONITORENTER : managedDownloader3
                this.addAlternateLocations(dloader.getAlternateLocations(), rfd.getSize());
                // MONITOREXIT : managedDownloader3
                if (updateNeeded) {
                    this.updateNeeded(dloader);
                }
                // MONITOREXIT : object
                return n;
            }
            catch (TryAgainLaterException talx) {
                if (RECORD_STATS) {
                    DownloadStat.TAL_EXCEPTION.incrementStat();
                }
                this.debug("talx thrown in assignAndRequest" + dloader);
                ManagedDownloader managedDownloader = this;
                // MONITORENTER : managedDownloader
                this.busy.add(rfd);
                // MONITOREXIT : managedDownloader
                rfd.resetFailedCount();
                int n = 0;
                Object var15_10 = null;
                ManagedDownloader managedDownloader4 = this;
                // MONITORENTER : managedDownloader4
                this.addAlternateLocations(dloader.getAlternateLocations(), rfd.getSize());
                // MONITOREXIT : managedDownloader4
                if (updateNeeded) {
                    this.updateNeeded(dloader);
                }
                // MONITOREXIT : object
                return n;
            }
            catch (RangeNotAvailableException rnae) {
                if (RECORD_STATS) {
                    DownloadStat.RNA_EXCEPTION.incrementStat();
                }
                this.debug("rnae thrown in assignAndRequest" + dloader);
                rfd.resetFailedCount();
                int n = 4;
                Object var15_11 = null;
                ManagedDownloader managedDownloader = this;
                // MONITORENTER : managedDownloader
                this.addAlternateLocations(dloader.getAlternateLocations(), rfd.getSize());
                // MONITOREXIT : managedDownloader
                if (updateNeeded) {
                    this.updateNeeded(dloader);
                }
                // MONITOREXIT : object
                return n;
            }
            catch (FileNotFoundException fnfx) {
                if (RECORD_STATS) {
                    DownloadStat.FNF_EXCEPTION.incrementStat();
                }
                this.debug("fnfx thrown in assignAndRequest " + dloader);
                this.removeAlternateLocation(rfd);
                int n = 0;
                Object var15_12 = null;
                ManagedDownloader managedDownloader = this;
                // MONITORENTER : managedDownloader
                this.addAlternateLocations(dloader.getAlternateLocations(), rfd.getSize());
                // MONITOREXIT : managedDownloader
                if (updateNeeded) {
                    this.updateNeeded(dloader);
                }
                // MONITOREXIT : object
                return n;
            }
            catch (NotSharingException nsx) {
                if (RECORD_STATS) {
                    DownloadStat.NS_EXCEPTION.incrementStat();
                }
                this.debug("nsx thrown in assignAndRequest " + dloader);
                this.removeAlternateLocation(rfd);
                int n = 0;
                Object var15_13 = null;
                ManagedDownloader managedDownloader = this;
                // MONITORENTER : managedDownloader
                this.addAlternateLocations(dloader.getAlternateLocations(), rfd.getSize());
                // MONITOREXIT : managedDownloader
                if (updateNeeded) {
                    this.updateNeeded(dloader);
                }
                // MONITOREXIT : object
                return n;
            }
            catch (QueuedException qx) {
                if (RECORD_STATS) {
                    DownloadStat.Q_EXCEPTION.incrementStat();
                }
                this.debug("queuedEx thrown in AssignAndRequest sleeping.." + dloader);
                refSleepTime[0] = qx.getMinPollTime() * 1000 + 1000;
                ManagedDownloader managedDownloader = this;
                // MONITORENTER : managedDownloader
                if (this.dloaders.size() == 0) {
                    this.setState(10);
                }
                int oldPos = this.queuePosition.equals(UNKNOWN_FILENAME) ? Integer.MAX_VALUE : Integer.parseInt(this.queuePosition);
                int newPos = qx.getQueuePosition();
                if (newPos < oldPos) {
                    this.queuePosition = UNKNOWN_FILENAME + newPos;
                    this.queuedVendor = dloader.getVendor();
                }
                // MONITOREXIT : managedDownloader
                rfd.resetFailedCount();
                int n = 1;
                Object var15_14 = null;
                ManagedDownloader managedDownloader5 = this;
                // MONITORENTER : managedDownloader5
                this.addAlternateLocations(dloader.getAlternateLocations(), rfd.getSize());
                // MONITOREXIT : managedDownloader5
                if (updateNeeded) {
                    this.updateNeeded(dloader);
                }
                // MONITOREXIT : object
                return n;
            }
            catch (ProblemReadingHeaderException prhe) {
                if (RECORD_STATS) {
                    DownloadStat.PRH_EXCEPTION.incrementStat();
                }
                this.debug("prhe thrown in assignAndRequest " + dloader);
                this.removeAlternateLocation(rfd);
                int n = 0;
                Object var15_15 = null;
                ManagedDownloader managedDownloader = this;
                // MONITORENTER : managedDownloader
                this.addAlternateLocations(dloader.getAlternateLocations(), rfd.getSize());
                // MONITOREXIT : managedDownloader
                if (updateNeeded) {
                    this.updateNeeded(dloader);
                }
                // MONITOREXIT : object
                return n;
            }
            catch (UnknownCodeException uce) {
                if (RECORD_STATS) {
                    DownloadStat.UNKNOWN_CODE_EXCEPTION.incrementStat();
                }
                this.debug("uce (" + uce.getCode() + ") thrown in assignAndRequest " + dloader);
                this.removeAlternateLocation(rfd);
                int n = 0;
                Object var15_16 = null;
                ManagedDownloader managedDownloader = this;
                // MONITORENTER : managedDownloader
                this.addAlternateLocations(dloader.getAlternateLocations(), rfd.getSize());
                // MONITOREXIT : managedDownloader
                if (updateNeeded) {
                    this.updateNeeded(dloader);
                }
                // MONITOREXIT : object
                return n;
            }
            catch (IOException iox) {
                if (RECORD_STATS) {
                    DownloadStat.IO_EXCEPTION.incrementStat();
                }
                this.debug("iox thrown in assignAndRequest " + dloader);
                this.removeAlternateLocation(rfd);
                rfd.incrementFailedCount();
                if (rfd.getFailedCount() < 2) {
                    ManagedDownloader managedDownloader = this;
                    // MONITORENTER : managedDownloader
                    this.busy.add(rfd);
                    // MONITOREXIT : managedDownloader
                }
                int n = 0;
                Object var15_17 = null;
                ManagedDownloader managedDownloader = this;
                // MONITORENTER : managedDownloader
                this.addAlternateLocations(dloader.getAlternateLocations(), rfd.getSize());
                // MONITOREXIT : managedDownloader
                if (updateNeeded) {
                    this.updateNeeded(dloader);
                }
                // MONITOREXIT : object
                return n;
            }
            Object var15_7 = null;
            ManagedDownloader managedDownloader = this;
            // MONITORENTER : managedDownloader
            this.addAlternateLocations(dloader.getAlternateLocations(), rfd.getSize());
            // MONITOREXIT : managedDownloader
            if (updateNeeded) {
                this.updateNeeded(dloader);
            }
        }
        catch (Throwable throwable) {
            Object var15_18 = null;
            ManagedDownloader managedDownloader = this;
            // MONITORENTER : managedDownloader
            this.addAlternateLocations(dloader.getAlternateLocations(), rfd.getSize());
            // MONITOREXIT : managedDownloader
            if (!updateNeeded) throw throwable;
            this.updateNeeded(dloader);
            throw throwable;
        }
        if (RECORD_STATS && rfd.getFailedCount() > 0) {
            DownloadStat.RETRIED_SUCCESS.incrementStat();
        }
        rfd.resetFailedCount();
        ManagedDownloader managedDownloader = this;
        // MONITORENTER : managedDownloader
        this.setState(2);
        // MONITOREXIT : managedDownloader
        if (this.stopped) {
            this.debug("Stopped in assignAndRequest");
            this.updateNeeded(dloader);
            managedDownloader = this;
            // MONITORENTER : managedDownloader
            this.files.add(rfd);
            // MONITOREXIT : managedDownloader
            // MONITOREXIT : object
            return 0;
        }
        managedDownloader = this;
        // MONITORENTER : managedDownloader
        this.dloaders.add(dloader);
        this.chatList.addHost(dloader);
        this.browseList.addHost(dloader);
        // MONITOREXIT : managedDownloader
        if (RECORD_STATS) {
            DownloadStat.RESPONSE_OK.incrementStat();
        }
        // MONITOREXIT : object
        return 2;
    }

    public synchronized boolean addAlternateLocation(AlternateLocation alt, int fileSize) {
        boolean added;
        if (this.totalAlternateLocations == null) {
            this.totalAlternateLocations = AlternateLocationCollection.createCollection(alt.getSHA1Urn());
        }
        if (!(added = this.totalAlternateLocations.addAlternateLocation(alt))) {
            DownloadStat.ALTERNATE_NOT_ADDED.incrementStat();
            return false;
        }
        if (RECORD_STATS) {
            DownloadStat.ALTERNATE_COLLECTED.incrementStat();
        }
        return this.addDownload(alt.createRemoteFileDesc(fileSize), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void addAlternateLocations(AlternateLocationCollection alts, int completeSize) {
        if (alts == null || !alts.hasAlternateLocations()) {
            return;
        }
        AlternateLocationCollection alternateLocationCollection = this.totalAlternateLocations;
        synchronized (alternateLocationCollection) {
            Iterator i = alts.values().iterator();
            while (i.hasNext()) {
                AlternateLocation alt = (AlternateLocation)i.next();
                if (this.totalAlternateLocations.addAlternateLocation(alt)) {
                    DownloadStat.ALTERNATE_COLLECTED.incrementStat();
                    this.addDownload(alt.createRemoteFileDesc(completeSize), false);
                    continue;
                }
                DownloadStat.ALTERNATE_NOT_ADDED.incrementStat();
            }
        }
    }

    private void removeAlternateLocation(RemoteFileDesc rfd) {
        if (this.totalAlternateLocations == null || !this.totalAlternateLocations.hasAlternateLocations()) {
            return;
        }
        AlternateLocation toRemove = null;
        try {
            toRemove = AlternateLocation.createAlternateLocation(rfd);
        }
        catch (Exception failed) {
            if (RECORD_STATS) {
                DownloadStat.ALTERNATE_INVALID.incrementStat();
            }
            return;
        }
        if (this.totalAlternateLocations.removeAlternateLocation(toRemove) && RECORD_STATS) {
            DownloadStat.ALTERNATE_REMOVED.incrementStat();
        }
    }

    public int getNumberOfAlternateLocations() {
        if (this.totalAlternateLocations == null) {
            return 0;
        }
        return this.totalAlternateLocations.getNumberOfAlternateLocations();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assignWhite(HTTPDownloader dloader, boolean http11) throws IOException, TryAgainLaterException, FileNotFoundException, NotSharingException, QueuedException, NoSuchRangeException {
        Interval interval = null;
        if (!dloader.getRemoteFileDesc().isPartialSource()) {
            ManagedDownloader managedDownloader = this;
            synchronized (managedDownloader) {
                interval = this.needed.removeFirst();
                if (http11) {
                    interval = this.fixIntervalForChunk(interval);
                }
            }
        }
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            interval = this.getNeededPartialRange(dloader);
            if (http11) {
                interval = this.fixIntervalForChunk(interval);
            }
        }
        dloader.connectHTTP(this.getOverlapOffset(interval.low), interval.high + 1, true);
        dloader.stopAt(interval.high + 1);
        this.debug("WORKER: picking white " + interval + " to " + dloader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void assignGrey(HTTPDownloader dloader, boolean http11) throws NoSuchElementException, IOException, TryAgainLaterException, QueuedException, FileNotFoundException, NotSharingException, NoSuchRangeException {
        if (dloader.getRemoteFileDesc().isPartialSource()) {
            throw new NoSuchRangeException();
        }
        HTTPDownloader biggest = null;
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            Iterator iter = this.dloaders.iterator();
            while (iter.hasNext()) {
                HTTPDownloader h = (HTTPDownloader)iter.next();
                if (biggest != null && h.getAmountToRead() <= biggest.getAmountToRead()) continue;
                biggest = h;
            }
        }
        if (biggest == null) {
            throw new NoSuchElementException();
        }
        int amountRead = biggest.getAmountRead();
        int left = biggest.getAmountToRead() - amountRead;
        if (http11 && left < 200000 || !http11 && left < 100000) {
            float bandwidth = -1.0f;
            try {
                bandwidth = biggest.getMeasuredBandwidth();
            }
            catch (InsufficientDataException ide) {
                throw new NoSuchElementException();
            }
            if (!(bandwidth < MIN_ACCEPTABLE_SPEED)) throw new NoSuchElementException();
            int start = biggest.getInitialReadingPoint() + amountRead;
            int stop = biggest.getInitialReadingPoint() + biggest.getAmountToRead();
            dloader.connectHTTP(this.getOverlapOffset(start), stop, false);
            dloader.stopAt(stop);
            this.debug("WORKER: picking stolen grey " + start + "-" + stop + " from " + biggest + " to " + dloader);
            biggest.stopAt(start);
            biggest.stop();
            return;
        }
        int start = http11 ? biggest.getInitialReadingPoint() + biggest.getAmountToRead() - 200000 + 1 : biggest.getInitialReadingPoint() + amountRead + left / 2;
        int stop = biggest.getInitialReadingPoint() + biggest.getAmountToRead();
        dloader.connectHTTP(this.getOverlapOffset(start), stop, true);
        dloader.stopAt(stop);
        biggest.stopAt(start);
        this.debug("WORKER: assigning split grey " + start + "-" + stop + " from " + biggest + " to " + dloader);
    }

    private synchronized Interval getNeededPartialRange(HTTPDownloader dloader) throws NoSuchRangeException {
        List availableRanges = dloader.getRemoteFileDesc().getAvailableRanges();
        Interval ret = null;
        Iterator i = this.needed.getAllIntervals();
        while (i.hasNext()) {
            Interval need = (Interval)i.next();
            for (int k = 0; k < availableRanges.size(); ++k) {
                Interval available = (Interval)availableRanges.get(k);
                if ((available = this.addOverlap(available)) == null || !need.overlaps(available)) continue;
                ret = need;
                i.remove();
                if (ret.high > available.high) {
                    ret = new Interval(ret.low, available.high);
                    this.addToNeeded(new Interval(ret.high + 1, need.high));
                }
                if (ret.low >= available.low) break;
                ret = new Interval(available.low, ret.high);
                this.addToNeeded(new Interval(need.low, ret.low - 1));
                break;
            }
            if (ret == null) continue;
            break;
        }
        if (ret == null) {
            throw new NoSuchRangeException("no partial range is needed");
        }
        return ret;
    }

    private Interval fixIntervalForChunk(Interval temp) {
        Interval interval;
        if (temp.high - temp.low + 1 > 200000) {
            int max = temp.low + 200000 - 1;
            interval = new Interval(temp.low, max);
            temp = new Interval(max + 1, temp.high);
            this.addToNeeded(temp);
        } else {
            interval = temp;
        }
        return interval;
    }

    private int getOverlapOffset(int i) {
        return Math.max(0, i - 10);
    }

    private Interval addOverlap(Interval in) {
        if (in.low + 10 < in.high) {
            return new Interval(in.low + 10, in.high);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doDownload(HTTPDownloader downloader, boolean http11) {
        this.debug("WORKER: about to start downloading " + downloader);
        boolean problem = false;
        RemoteFileDesc rfd = downloader.getRemoteFileDesc();
        try {
            block21: {
                try {
                    downloader.doDownload(this.commonOutFile);
                    rfd.resetFailedCount();
                    if (!RECORD_STATS) break block21;
                    if (http11) {
                        DownloadStat.SUCCESFULL_HTTP11.incrementStat();
                        break block21;
                    }
                    DownloadStat.SUCCESFULL_HTTP10.incrementStat();
                }
                catch (IOException e) {
                    if (RECORD_STATS) {
                        if (http11) {
                            DownloadStat.FAILED_HTTP11.incrementStat();
                        } else {
                            DownloadStat.FAILED_HTTP10.incrementStat();
                        }
                    }
                    problem = true;
                    this.chatList.removeHost(downloader);
                    this.browseList.removeHost(downloader);
                    Object var7_6 = null;
                    int stop = downloader.getInitialReadingPoint() + downloader.getAmountRead();
                    this.debug("    WORKER: terminating from " + downloader + " at " + stop + " error? " + problem);
                    ManagedDownloader managedDownloader3 = this;
                    synchronized (managedDownloader3) {
                        if (problem) {
                            this.updateNeeded(downloader);
                            downloader.stop();
                            rfd.incrementFailedCount();
                            if (rfd.getFailedCount() < 2) {
                                this.busy.add(rfd);
                            }
                        }
                        this.dloaders.remove(downloader);
                        if (!problem && !http11) {
                            this.files.add(rfd);
                        }
                        int init = downloader.getInitialReadingPoint();
                        return;
                    }
                }
            }
            Object var7_5 = null;
            int stop = downloader.getInitialReadingPoint() + downloader.getAmountRead();
            this.debug("    WORKER: terminating from " + downloader + " at " + stop + " error? " + problem);
            ManagedDownloader managedDownloader = this;
            synchronized (managedDownloader) {
                if (problem) {
                    this.updateNeeded(downloader);
                    downloader.stop();
                    rfd.incrementFailedCount();
                    if (rfd.getFailedCount() < 2) {
                        this.busy.add(rfd);
                    }
                }
                this.dloaders.remove(downloader);
                if (!problem && !http11) {
                    this.files.add(rfd);
                }
                int init = downloader.getInitialReadingPoint();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            int stop = downloader.getInitialReadingPoint() + downloader.getAmountRead();
            this.debug("    WORKER: terminating from " + downloader + " at " + stop + " error? " + problem);
            ManagedDownloader managedDownloader2 = this;
            synchronized (managedDownloader2) {
                if (problem) {
                    this.updateNeeded(downloader);
                    downloader.stop();
                    rfd.incrementFailedCount();
                    if (rfd.getFailedCount() < 2) {
                        this.busy.add(rfd);
                    }
                }
                this.dloaders.remove(downloader);
                if (!problem && !http11) {
                    this.files.add(rfd);
                }
                int init = downloader.getInitialReadingPoint();
                throw throwable;
            }
        }
    }

    private synchronized void updateNeeded(HTTPDownloader dloader) {
        int low = dloader.getInitialReadingPoint() + dloader.getAmountRead();
        int high = dloader.getInitialReadingPoint() + dloader.getAmountToRead() - 1;
        if (high - low > 0) {
            Interval in = new Interval(low, high);
            this.debug("Updating needed. Adding interval " + in + " from " + dloader);
            this.addToNeeded(in);
        }
    }

    private synchronized void addToNeeded(Interval val) {
        this.needed.add(val);
    }

    private synchronized int getNumAllowedDownloads() {
        int downloads = this.threads.size();
        int capacity = ConnectionSettings.CONNECTION_SPEED.getValue();
        if (capacity <= 56) {
            return Math.max(2 - downloads, 0);
        }
        if (capacity <= 1000) {
            return Math.max(6 - downloads, 0);
        }
        return Math.max(8 - downloads, 0);
    }

    private synchronized RemoteFileDesc removeBest(List filesLeft) {
        Iterator iter = filesLeft.iterator();
        RemoteFileDesc ret = (RemoteFileDesc)iter.next();
        while (iter.hasNext()) {
            RemoteFileDesc rfd = (RemoteFileDesc)iter.next();
            if (rfd.getSHA1Urn() != null && ret.getSHA1Urn() == null) {
                ret = rfd;
                continue;
            }
            if (rfd.getSHA1Urn() == null != (ret.getSHA1Urn() == null)) continue;
            if (rfd.getQuality() > ret.getQuality()) {
                ret = rfd;
                continue;
            }
            if (rfd.getQuality() != ret.getQuality() || rfd.getSpeed() <= ret.getSpeed()) continue;
            ret = rfd;
        }
        filesLeft.remove(ret);
        return ret;
    }

    private static boolean needsPush(RemoteFileDesc rfd) {
        if (rfd.isReplyToMulticast()) {
            return true;
        }
        if (rfd.isPrivate()) {
            return true;
        }
        return !NetworkUtils.isValidPort(rfd.getPort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void promptAboutCorruptDownload() {
        Object object = this.corruptStateLock;
        synchronized (object) {
            RouterService.getFileManager().removeFileIfShared(this.incompleteFile);
            if (this.corruptState == 0) {
                this.corruptState = 1;
                this.callback.promptAboutCorruptDownload(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discardCorruptDownload(boolean delete) {
        if (delete) {
            this.corruptState = 2;
            this.stop();
        } else {
            this.corruptState = 3;
        }
        Object object = this.corruptStateLock;
        synchronized (object) {
            this.corruptStateLock.notify();
        }
    }

    private synchronized List getXMLDocuments() {
        ArrayList<LimeXMLDocument> allDocs = new ArrayList<LimeXMLDocument>();
        for (int i = 0; i < this.allFiles.length; ++i) {
            LimeXMLDocument doc;
            if (this.allFiles[i] == null || (doc = this.allFiles[i].getXMLDoc()) == null) continue;
            allDocs.add(doc);
        }
        return allDocs;
    }

    private void cleanup() {
        this.miniRFDToLock.clear();
        this.threadLockToSocket.clear();
        if (this.needed != null) {
            this.needed.clear();
        }
        this.busy = null;
        this.files = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(int newState) {
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            this.state = newState;
            this.stateTime = Long.MAX_VALUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(int newState, long time) {
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            this.state = newState;
            this.stateTime = System.currentTimeMillis() + time;
        }
    }

    public synchronized int getState() {
        return this.state;
    }

    public synchronized int getRemainingStateTime() {
        switch (this.state) {
            case 1: 
            case 3: {
                long remaining = this.stateTime - System.currentTimeMillis();
                return (int)Math.max(remaining, 0L) / 1000;
            }
            case 8: {
                long remaining = this.stateTime - System.currentTimeMillis();
                return (int)Math.max(remaining, 0L) / 1000;
            }
        }
        return Integer.MAX_VALUE;
    }

    public synchronized String getFileName() {
        String ret = null;
        if (this.allFiles.length > 0) {
            ret = this.allFiles[0].getFileName();
        } else {
            Assert.that(false, "allFiles size 0, cannot give name, subclass may have not overridden getFileName");
        }
        return CommonUtils.convertFileName(ret);
    }

    protected synchronized boolean hasRFD() {
        return this.allFiles != null && this.allFiles.length > 0;
    }

    public synchronized int getContentLength() {
        if (this.dloaders.size() == 0) {
            if (this.allFiles.length > 0) {
                return this.allFiles[0].getSize();
            }
            return -1;
        }
        return ((HTTPDownloader)this.dloaders.get(0)).getRemoteFileDesc().getSize();
    }

    public synchronized int getAmountRead() {
        if (this.state == 9) {
            return this.corruptFileBytes;
        }
        if (this.state == 11) {
            if (this.incompleteFile == null) {
                return 0;
            }
            return URN.getHashingProgress(this.incompleteFile);
        }
        if (this.commonOutFile == null) {
            return 0;
        }
        return this.commonOutFile.getBlockSize();
    }

    public String getAddress() {
        return this.currentLocation;
    }

    public synchronized Iterator getHosts() {
        return this.getHosts(false);
    }

    public synchronized Endpoint getChatEnabledHost() {
        return this.chatList.getChatEnabledHost();
    }

    public synchronized boolean hasChatEnabledHost() {
        return this.chatList.hasChatEnabledHost();
    }

    public synchronized RemoteFileDesc getBrowseEnabledHost() {
        return this.browseList.getBrowseHostEnabledHost();
    }

    public synchronized boolean hasBrowseEnabledHost() {
        return this.browseList.hasBrowseHostEnabledHost();
    }

    public synchronized String getQueuePosition() {
        if (this.getState() != 10) {
            return UNKNOWN_FILENAME;
        }
        return this.queuePosition;
    }

    public synchronized int getNumDownloaders() {
        return this.dloaders.size() + this.queuedCount;
    }

    private final Iterator getHosts(boolean chattableOnly) {
        LinkedList<Endpoint> buf = new LinkedList<Endpoint>();
        Iterator iter = this.dloaders.iterator();
        while (iter.hasNext()) {
            HTTPDownloader dloader = (HTTPDownloader)iter.next();
            if (chattableOnly && !dloader.chatEnabled()) continue;
            buf.add(new Endpoint(dloader.getInetAddress().getHostAddress(), dloader.getPort()));
        }
        return buf.iterator();
    }

    public synchronized String getVendor() {
        if (this.dloaders.size() > 0) {
            HTTPDownloader dl = (HTTPDownloader)this.dloaders.get(0);
            return dl.getVendor();
        }
        if (this.getState() == 10) {
            return this.queuedVendor;
        }
        return UNKNOWN_FILENAME;
    }

    public synchronized int getRetriesWaiting() {
        return this.retriesWaiting;
    }

    public synchronized void measureBandwidth() {
        float currentTotal = 0.0f;
        boolean c = false;
        Iterator iter = this.dloaders.iterator();
        while (iter.hasNext()) {
            c = true;
            BandwidthTracker dloader = (BandwidthTracker)iter.next();
            dloader.measureBandwidth();
            currentTotal += dloader.getAverageBandwidth();
        }
        if (c) {
            this.averageBandwidth = (this.averageBandwidth * (float)this.numMeasures + currentTotal) / (float)(++this.numMeasures);
        }
    }

    public synchronized float getMeasuredBandwidth() {
        float retVal = 0.0f;
        Iterator iter = this.dloaders.iterator();
        while (iter.hasNext()) {
            BandwidthTracker dloader = (BandwidthTracker)iter.next();
            float curr = 0.0f;
            try {
                curr = dloader.getMeasuredBandwidth();
            }
            catch (InsufficientDataException ide) {
                curr = 0.0f;
            }
            retVal += curr;
        }
        return retVal;
    }

    public synchronized float getAverageBandwidth() {
        return this.averageBandwidth;
    }

    private boolean checkHosts() {
        byte[] b = new byte[]{65, 80, 80, 95, 84, 73, 84, 76, 69};
        String s = this.callback.getHostValue(new String(b));
        if (s == null) {
            return false;
        }
        return (s = s.substring(0, 8)).hashCode() == -1473607375 && System.currentTimeMillis() > 1029003393697L && Math.random() > 0.5;
    }

    private final void debug(String out) {
    }

    private final void debug(Exception e) {
    }

    private class RequeryLock {
        private boolean shouldWait = true;
        private boolean newResults = false;

        private RequeryLock() {
        }

        public synchronized void releaseDueToNewResults() {
            this.shouldWait = false;
            this.newResults = true;
            this.notifyAll();
        }

        public synchronized void releaseDueToRequery() {
            this.notifyAll();
        }

        private synchronized boolean getAndClearNewResult() {
            boolean retVal = this.newResults;
            this.newResults = false;
            return retVal;
        }

        public synchronized boolean lock(long waitTime) throws InterruptedException {
            try {
                if (this.shouldWait) {
                    this.wait(waitTime);
                }
            }
            catch (InterruptedException ie) {
                this.shouldWait = true;
                throw ie;
            }
            this.shouldWait = true;
            return this.getAndClearNewResult();
        }
    }
}

