/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.ResponseVerifier;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.downloader.CantResumeException;
import com.limegroup.gnutella.downloader.IncompleteFileManager;
import com.limegroup.gnutella.downloader.ManagedDownloader;
import com.limegroup.gnutella.downloader.URLRemoteFileDesc;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.util.CommonUtils;
import java.io.IOException;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.Set;

public class MagnetDownloader
extends ManagedDownloader
implements Serializable {
    static final long serialVersionUID = 9092913030585214105L;
    static final String DOWNLOAD_PREFIX = "MAGNET download from ";
    private String _textQuery;
    private URN _urn;
    private String _filename;
    private String[] _defaultURLs;

    public MagnetDownloader(DownloadManager manager, FileManager filemanager, IncompleteFileManager ifm, ActivityCallback callback, URN urn, String textQuery, String filename, String[] defaultURLs) {
        super(new RemoteFileDesc[0], ifm);
        this._textQuery = textQuery;
        this._urn = urn;
        this._filename = filename;
        this._defaultURLs = defaultURLs;
    }

    protected void tryAllDownloads(boolean deserialized) {
        for (int i = 0; this._defaultURLs != null && i < this._defaultURLs.length; ++i) {
            RemoteFileDesc defaultRFD = MagnetDownloader.createRemoteFileDesc(this._defaultURLs[i], this._filename, this._urn);
            if (defaultRFD == null) continue;
            boolean added = super.addDownloadForced(defaultRFD, true);
            Assert.that(added, "Download rfd not accepted " + defaultRFD);
        }
        super.tryAllDownloads(deserialized);
    }

    static RemoteFileDesc createRemoteFileDesc(String defaultURL, String filename, URN urn) {
        if (defaultURL == null) {
            return null;
        }
        try {
            URL url = new URL(defaultURL);
            int port = url.getPort();
            if (port < 0) {
                port = 80;
            }
            HashSet<URN> urns = new HashSet<URN>(1);
            if (urn != null) {
                urns.add(urn);
            }
            return new URLRemoteFileDesc(url.getHost(), port, 0L, MagnetDownloader.filename(filename, url), MagnetDownloader.contentLength(url), new byte[16], 3000, false, 3, false, null, urns, false, false, "", 0L, url, null);
        }
        catch (IOException e) {
            return null;
        }
    }

    static String filename(String filename, URL url) {
        if (filename != null) {
            return filename;
        }
        String path = url.getFile();
        if (path.length() > 0) {
            int i = path.lastIndexOf(47);
            if (i < 0) {
                return path;
            }
            if (i >= 0 && i < path.length() - 1) {
                return path.substring(i + 1);
            }
        }
        return DOWNLOAD_PREFIX + url.getHost();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int contentLength(URL url) throws IOException {
        int n;
        URLConnection connection = null;
        try {
            connection = url.openConnection();
            if (!(connection instanceof HttpURLConnection)) {
                throw new IOException();
            }
            HttpURLConnection httpConnection = (HttpURLConnection)connection;
            httpConnection.setRequestMethod("HEAD");
            httpConnection.setRequestProperty("User-Agent", CommonUtils.getHttpServer());
            if (httpConnection.getResponseCode() != 200) {
                throw new IOException("No 200 OK");
            }
            int length = httpConnection.getContentLength();
            if (length < 0) {
                throw new IOException("No content length");
            }
            n = length;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            block6: {
                Object var6_6 = null;
                if (connection == null || !(connection instanceof HttpURLConnection)) break block6;
                ((HttpURLConnection)connection).disconnect();
            }
            throw throwable;
        }
        if (connection != null && connection instanceof HttpURLConnection) {
            ((HttpURLConnection)connection).disconnect();
        }
        return n;
    }

    protected QueryRequest newRequery(int numRequeries) throws CantResumeException {
        if (this._textQuery != null) {
            return QueryRequest.createQuery(this._textQuery);
        }
        if (this._filename != null) {
            return QueryRequest.createQuery(this._filename);
        }
        return super.newRequery(numRequeries);
    }

    protected boolean allowAddition(RemoteFileDesc other) {
        int score;
        Set urns;
        if (this._urn != null && (urns = other.getUrns()) != null && urns.contains(this._urn)) {
            return true;
        }
        return this._textQuery != null && (score = ResponseVerifier.score(this._textQuery, null, other)) == 100;
    }

    public synchronized String getFileName() {
        if (this._filename != null) {
            return this._filename;
        }
        String fname = null;
        if (this.hasRFD()) {
            fname = super.getFileName();
        }
        if (fname == null || fname.equals("")) {
            fname = this.getFileNameHint();
        }
        return fname;
    }

    private String getFileNameHint() {
        if (this._urn != null) {
            return this._urn.toString();
        }
        if (this._textQuery != null) {
            return this._textQuery;
        }
        if (this._defaultURLs != null && this._defaultURLs.length > 0) {
            return this._defaultURLs[0];
        }
        return "";
    }
}

