/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.AlternateLocationCollection;
import com.limegroup.gnutella.AlternateLocationCollector;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.util.CommonUtils;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Iterator;
import java.util.Set;

final class HeadRequester
implements Runnable {
    private final Set HOSTS;
    private final URN RESOURCE_NAME;
    private final AlternateLocationCollector COLLECTOR;
    private final AlternateLocationCollection TOTAL_ALTS;

    public HeadRequester(Set hosts, URN resourceName, AlternateLocationCollector collector, AlternateLocationCollection totalAlts) {
        this.HOSTS = hosts;
        this.RESOURCE_NAME = resourceName;
        this.COLLECTOR = collector;
        this.TOTAL_ALTS = totalAlts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            Iterator iter = this.HOSTS.iterator();
            while (iter.hasNext()) {
                URL url;
                URN urn;
                RemoteFileDesc rfd = (RemoteFileDesc)iter.next();
                if (QueryReply.isFirewalledQuality(rfd.getQuality()) || (urn = rfd.getSHA1Urn()) == null || !urn.equals(this.RESOURCE_NAME) || (url = rfd.getUrl()) == null) continue;
                HttpURLConnection httpConnection = null;
                try {
                    AlternateLocationCollection alc;
                    URN reportedUrn;
                    httpConnection = (HttpURLConnection)url.openConnection();
                    httpConnection.setRequestMethod("HEAD");
                    httpConnection.setRequestProperty("User-Agent", CommonUtils.getHttpServer());
                    httpConnection.setDoOutput(true);
                    httpConnection.setDoInput(true);
                    httpConnection.setUseCaches(false);
                    httpConnection.setAllowUserInteraction(false);
                    httpConnection.setRequestProperty(HTTPHeaderName.GNUTELLA_CONTENT_URN.httpStringValue(), this.RESOURCE_NAME.httpStringValue());
                    httpConnection.setRequestProperty(HTTPHeaderName.ALT_LOCATION.httpStringValue(), this.TOTAL_ALTS.httpStringValue());
                    httpConnection.setRequestProperty(HTTPHeaderName.CONNECTION.httpStringValue(), "close");
                    httpConnection.connect();
                    String contentUrn = HeadRequester.getHeaderField(httpConnection, HTTPHeaderName.GNUTELLA_CONTENT_URN);
                    if (contentUrn == null || !(reportedUrn = URN.createSHA1Urn(contentUrn)).equals(this.RESOURCE_NAME)) continue;
                    String altLocs = HeadRequester.getHeaderField(httpConnection, HTTPHeaderName.ALT_LOCATION);
                    if (altLocs == null || (alc = AlternateLocationCollection.createCollectionFromHttpValue(altLocs)) == null || !alc.getSHA1Urn().equals(this.COLLECTOR.getSHA1Urn())) continue;
                    this.COLLECTOR.addAlternateLocationCollection(alc);
                }
                catch (IOException e) {}
                continue;
                finally {
                    httpConnection.disconnect();
                }
            }
        }
        catch (Throwable e) {
            ErrorService.error(e);
        }
    }

    private static String getHeaderField(HttpURLConnection conn, HTTPHeaderName header) throws IOException {
        try {
            return conn.getHeaderField(header.httpStringValue());
        }
        catch (NullPointerException e) {
            throw new IOException("high server load with 1.1.8 client");
        }
    }
}

