/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.ResponseVerifier;
import com.limegroup.gnutella.util.ApproximateMatcher;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.SchemaNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.xml.sax.SAXException;

public class AutoDownloadDetails
implements Serializable {
    static final long serialVersionUID = 3400666689236195243L;
    private String query = null;
    private String richQuery = null;
    private transient LimeXMLDocument xmlDoc = null;
    private transient boolean xmlCreated = false;
    private MediaType type = null;
    private byte[] guid = null;
    private List dlList = null;
    private static final int MATCHER_BUF_SIZE = 120;
    private static ApproximateMatcher matcher = new ApproximateMatcher(120);
    private float MATCH_PRECISION_DL = 0.3f;
    private float WORD_INCIDENCE_RATE = 0.509999f;
    private int LOW_SCORE = 95;
    private Set wordSet = null;
    public static final int MAX_DOWNLOADS = 1;
    private int committedDLs = 0;
    private static final boolean debugOn = false;

    public AutoDownloadDetails(String inQuery, String inRichQuery, byte[] inGuid, MediaType inType) {
        this.query = inQuery;
        this.richQuery = inRichQuery;
        this.type = inType;
        this.guid = inGuid;
        this.dlList = new Vector();
        this.wordSet = new HashSet();
    }

    public String getQuery() {
        return this.query;
    }

    public String getRichQuery() {
        return this.richQuery;
    }

    public MediaType getMediaType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean addDownload(RemoteFileDesc toAdd) {
        AutoDownloadDetails.debug("ADD.addDownload(): *-----------");
        AutoDownloadDetails.debug("ADD.addDownload(): entered.");
        boolean retVal = true;
        if (!this.expired()) {
            StringTokenizer st;
            int score;
            String inputFileName = toAdd.getFileName();
            if (this.type != null && !this.type.matches(inputFileName)) {
                retVal = false;
                AutoDownloadDetails.debug("ADD.addDownload(): file " + inputFileName + " isn't the right type.");
            }
            if (!this.xmlCreated) {
                this.xmlCreated = true;
                if (this.richQuery != null && !this.richQuery.equals("")) {
                    try {
                        this.xmlDoc = new LimeXMLDocument(this.richQuery);
                    }
                    catch (SchemaNotFoundException ignored) {
                    }
                    catch (SAXException ignored) {
                    }
                    catch (IOException ignored) {
                        // empty catch block
                    }
                }
            }
            if ((score = ResponseVerifier.score(this.query, this.xmlDoc, toAdd)) < this.LOW_SCORE) {
                retVal = false;
                AutoDownloadDetails.debug("ADD.addDownload(): file " + inputFileName + " has low score of " + score);
            }
            if (retVal && this.wordSet.size() > 0) {
                st = new StringTokenizer(this.ripExtension(inputFileName), " -._+/*()\\");
                int additions = 0;
                int numTokens = st.countTokens();
                while (st.hasMoreTokens()) {
                    String currToken = st.nextToken().toLowerCase();
                    AutoDownloadDetails.debug("ADD.addDownload(): currToken = " + currToken);
                    if (this.wordSet.contains(currToken)) continue;
                    ++additions;
                }
                float matchRate = (float)(numTokens - additions) / (float)this.wordSet.size();
                if (additions == 0 || matchRate > this.WORD_INCIDENCE_RATE) {
                    retVal = false;
                    AutoDownloadDetails.debug("ADD.addDownload(): file " + inputFileName + " has many elements similar to" + " other files. matchRate = " + matchRate + ", additions = " + additions);
                }
            }
            if (retVal && this.dlList.size() > 0) {
                String processedFileName;
                ApproximateMatcher additions = matcher;
                synchronized (additions) {
                    processedFileName = matcher.process(inputFileName);
                }
                for (int i = 0; i < this.dlList.size(); ++i) {
                    String currProcessedFileName;
                    RemoteFileDesc currRFD = (RemoteFileDesc)this.dlList.get(i);
                    String currFileName = currRFD.getFileName();
                    int diffs = 0;
                    ApproximateMatcher approximateMatcher = matcher;
                    synchronized (approximateMatcher) {
                        currProcessedFileName = matcher.process(currFileName);
                        diffs = matcher.match(processedFileName, currProcessedFileName);
                    }
                    int smaller = Math.min(processedFileName.length(), currProcessedFileName.length());
                    if ((float)diffs / (float)smaller < this.MATCH_PRECISION_DL) {
                        retVal = false;
                        AutoDownloadDetails.debug("ADD.addDownload(): conflict for file " + inputFileName + " and " + currFileName);
                    }
                    if (!retVal) break;
                }
            }
            if (retVal) {
                this.dlList.add(toAdd);
                st = new StringTokenizer(this.ripExtension(inputFileName), " -._+/*()\\");
                while (st.hasMoreTokens()) {
                    this.wordSet.add(st.nextToken().toLowerCase());
                }
                AutoDownloadDetails.debug("ADD.addDownload(): wordSet = " + this.wordSet);
            }
        } else {
            retVal = false;
        }
        AutoDownloadDetails.debug("ADD.addDownload(): returning " + retVal);
        AutoDownloadDetails.debug("ADD.addDownload(): -----------*");
        return retVal;
    }

    public synchronized void removeDownload(RemoteFileDesc toRemove) {
        this.dlList.remove(toRemove);
        StringTokenizer st = new StringTokenizer(this.ripExtension(toRemove.getFileName()), " -._+/*()\\");
        while (st.hasMoreTokens()) {
            this.wordSet.remove(st.nextToken().toLowerCase());
        }
    }

    public synchronized void commitDownload(RemoteFileDesc toCommit) {
        if (this.dlList.contains(toCommit)) {
            ++this.committedDLs;
        }
    }

    public synchronized boolean expired() {
        boolean retVal = false;
        if (this.committedDLs >= 1) {
            retVal = true;
        }
        return retVal;
    }

    private String ripExtension(String fileName) {
        String retString = null;
        int extStart = fileName.lastIndexOf(46);
        retString = extStart == -1 ? fileName : fileName.substring(0, extStart);
        return retString;
    }

    private static void debug(String out) {
    }

    private static void debug(Exception e) {
    }

    static {
        matcher.setIgnoreCase(true);
        matcher.setIgnoreWhitespace(true);
        matcher.setCompareBackwards(true);
    }
}

