/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.browser;

import com.limegroup.gnutella.ByteReader;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.browser.ExternalControl;
import com.limegroup.gnutella.browser.HTTPHandler;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.util.URLDecoder;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Date;

public class HTTPAcceptor
implements Runnable {
    private static final String MAGNET_DEFAULT = "magnet10/default.js?";
    private static final String MAGNET_PAUSE = "magnet10/pause";
    private static final String LOCALHOST = "127.0.0.1";
    private static final String MAGNET = "magnet:?";
    private static final String NOCONTENT = "HTTP/1.1 204 No Content\r\n";
    private volatile ServerSocket _socket = null;
    private int _port = 45100;
    private Object _socketLock = new Object();
    private static String _lastRequest = null;
    private static long _lastRequestTime = 0L;

    public void start() {
        Thread httpAcceptorThread = new Thread((Runnable)this, "HTTPAcceptor");
        httpAcceptorThread.setDaemon(true);
        httpAcceptorThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setListeningPort(int port) throws IOException {
        if (this._socket != null && this._port == port) {
            return;
        }
        if (port == 0) {
            if (this._socket != null) {
                try {
                    this._socket.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            Object e = this._socketLock;
            synchronized (e) {
                this._socket = null;
                this._port = 0;
                this._socketLock.notify();
            }
            return;
        }
        ServerSocket newSocket = null;
        try {
            newSocket = new ServerSocket(port);
        }
        catch (IOException e) {
            throw e;
        }
        catch (IllegalArgumentException e) {
            throw new IOException();
        }
        if (this._socket != null) {
            try {
                this._socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Object object = this._socketLock;
        synchronized (object) {
            this._socket = newSocket;
            this._port = port;
            this._socketLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block18: {
            IOException socketError = null;
            try {
                this.setListeningPort(this._port);
            }
            catch (IOException e) {
                boolean error = true;
                socketError = e;
                for (int i = 0; i < 10; ++i) {
                    this._port = i + 45100;
                    try {
                        this.setListeningPort(this._port);
                        error = false;
                        break;
                    }
                    catch (IOException e2) {
                        socketError = e2;
                        continue;
                    }
                }
                if (!error || socketError instanceof UnknownHostException && CommonUtils.isMacClassic()) break block18;
                ErrorService.error(e);
            }
        }
        while (true) {
            try {
                while (true) {
                    Socket client = null;
                    Object object = this._socketLock;
                    synchronized (object) {
                        if (this._socket != null) {
                            try {
                                client = this._socket.accept();
                            }
                            catch (IOException e) {
                                continue;
                            }
                        }
                        try {
                            this._socketLock.wait();
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        continue;
                    }
                    new ConnectionDispatchRunner(client);
                }
            }
            catch (SecurityException e) {
                ErrorService.error(e);
                return;
            }
            catch (Exception e) {
                ErrorService.error(e);
                continue;
            }
            break;
        }
    }

    private void handleHTTPRequest(Socket socket) throws IOException {
        if (!LOCALHOST.equals(socket.getInetAddress().getHostAddress())) {
            return;
        }
        socket.setSoTimeout(8000);
        ByteReader br = new ByteReader(socket.getInputStream());
        String str = br.readLine();
        if (str == null) {
            throw new IOException();
        }
        str.trim();
        str = URLDecoder.decode(str);
        if (str.indexOf("magnet10") > 0) {
            int loc = 0;
            loc = str.indexOf(MAGNET_DEFAULT);
            if (loc > 0) {
                int loc2 = str.lastIndexOf(" HTTP");
                String command = str.substring(loc + MAGNET_DEFAULT.length(), loc2);
                this.triggerMagnetHandling(socket, MAGNET + command);
            } else {
                loc = str.indexOf(MAGNET_PAUSE);
                if (loc > 0) {
                    try {
                        Thread.sleep(250L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.returnNoContent(socket);
                } else {
                    HTTPHandler.create(socket, str);
                }
            }
        } else if (str.indexOf(MAGNET) >= 0) {
            int loc = str.indexOf(MAGNET);
            int loc2 = str.lastIndexOf(" HTTP");
            if (loc < 0) {
                return;
            }
            String command = str.substring(loc, loc2);
            this.triggerMagnetHandling(socket, command);
        }
        try {
            socket.close();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private void triggerMagnetHandling(Socket socket, String command) {
        long curTime = new Date().getTime();
        if (!command.equals(_lastRequest) || curTime - _lastRequestTime >= 1500L) {
            ExternalControl.handleMagnetRequest(command);
            _lastRequest = command;
            _lastRequestTime = curTime;
        }
        this.returnNoContent(socket);
    }

    private void returnNoContent(Socket socket) {
        try {
            BufferedOutputStream out = new BufferedOutputStream(socket.getOutputStream());
            String s = NOCONTENT;
            byte[] bytes = s.getBytes();
            out.write(bytes);
            out.flush();
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class ConnectionDispatchRunner
    extends Thread {
        private Socket _socket;

        public ConnectionDispatchRunner(Socket socket) {
            super("ConnectionDispatchRunner");
            this._socket = socket;
            this.setDaemon(true);
            this.start();
        }

        public void run() {
            block9: {
                try {
                    InputStream in = null;
                    try {
                        in = this._socket.getInputStream();
                    }
                    catch (Exception e) {
                        throw new IOException();
                    }
                    this._socket.setSoTimeout(8000);
                    String word = IOUtils.readWord(in, 8);
                    this._socket.setSoTimeout(0);
                    if (word.equals("GET")) {
                        HTTPAcceptor.this.handleHTTPRequest(this._socket);
                        break block9;
                    }
                    if (word.equals("MAGNET")) {
                        ExternalControl.fireMagnet(this._socket);
                        break block9;
                    }
                    throw new IOException();
                }
                catch (IOException e) {
                    try {
                        this._socket.close();
                    }
                    catch (IOException iOException) {}
                }
                catch (Exception e) {
                    ErrorService.error(e);
                }
            }
        }
    }
}

