/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.util.DataUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class UrnCache {
    private static final File URN_CACHE_FILE = new File(System.getProperty("user.home") + "/Library/Application Support/AcqLite/fileurns.cache");
    private static UrnCache instance = null;
    private static final Map URN_MAP = UrnCache.createMap();

    public static synchronized UrnCache instance() {
        if (instance == null) {
            instance = new UrnCache();
        }
        return instance;
    }

    private UrnCache() {
        UrnCache.removeOldEntries(URN_MAP);
    }

    public synchronized Set getUrns(File file) {
        if (file.lastModified() == 0L) {
            return DataUtils.EMPTY_SET;
        }
        UrnSetKey key = new UrnSetKey(file);
        Set cachedUrns = (Set)URN_MAP.get(key);
        if (cachedUrns == null) {
            return DataUtils.EMPTY_SET;
        }
        return Collections.unmodifiableSet(cachedUrns);
    }

    public synchronized void removeUrns(File f) {
        UrnSetKey k = new UrnSetKey(f);
        URN_MAP.remove(k);
    }

    public synchronized void addUrns(File file, Set urns) {
        UrnSetKey key = new UrnSetKey(file);
        URN_MAP.put(key, Collections.unmodifiableSet(urns));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map createMap() {
        ois = null;
        try {
            try {
                ois = new ObjectInputStream(new FileInputStream(UrnCache.URN_CACHE_FILE));
                var1_1 = (Map)ois.readObject();
                var4_6 = null;
                if (ois == null) return var1_1;
            }
            catch (FileNotFoundException e) {
                var2_18 = new HashMap<K, V>();
                var4_7 = null;
                if (ois == null) return var2_18;
                try {
                    ois.close();
                    return var2_18;
                }
                catch (IOException e) {
                    // empty catch block
                }
                return var2_18;
            }
            catch (IOException e) {
                var2_19 = new HashMap<K, V>();
                var4_8 = null;
                if (ois == null) return var2_19;
                ** try [egrp 2[TRYBLOCK] [10 : 101->108)] { 
lbl27:
                // 1 sources

                ois.close();
                return var2_19;
lbl29:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
                return var2_19;
            }
            catch (ClassNotFoundException e) {
                var2_20 = new HashMap<K, V>();
                var4_9 = null;
                if (ois == null) return var2_20;
                ** try [egrp 2[TRYBLOCK] [10 : 101->108)] { 
lbl38:
                // 1 sources

                ois.close();
                return var2_20;
lbl40:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
                return var2_20;
            }
            catch (ClassCastException e) {
                var2_21 = new HashMap<K, V>();
                var4_10 = null;
                if (ois == null) return var2_21;
                ** try [egrp 2[TRYBLOCK] [10 : 101->108)] { 
lbl49:
                // 1 sources

                ois.close();
                return var2_21;
lbl51:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
                return var2_21;
            }
        }
        catch (Throwable var3_22) {
            var4_11 = null;
            if (ois == null) throw var3_22;
            try {}
            catch (IOException e) {
                throw var3_22;
            }
            ois.close();
            throw var3_22;
        }
        try {}
        catch (IOException e) {
            // empty catch block
            return var1_1;
        }
        ois.close();
        return var1_1;
    }

    private static void removeOldEntries(Map map) {
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            File f;
            UrnSetKey key = (UrnSetKey)iter.next();
            if (key == null || (f = new File(key._path)).exists() && f.lastModified() == key._modTime) continue;
            iter.remove();
        }
    }

    public synchronized void persistCache() {
        try {
            System.err.println("UrnCache writing file: " + URN_CACHE_FILE.getAbsolutePath());
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(URN_CACHE_FILE));
            oos.writeObject(URN_MAP);
            oos.close();
        }
        catch (Exception e) {
            ErrorService.error(e);
        }
    }

    private static class UrnSetKey
    implements Serializable {
        static final long serialVersionUID = -7183232365833531645L;
        transient long _modTime;
        transient String _path;
        transient int _hashCode;

        UrnSetKey(File file) {
            this._modTime = file.lastModified();
            this._path = file.getAbsolutePath();
            this._hashCode = this.calculateHashCode();
        }

        int calculateHashCode() {
            int result = 17;
            result = result * 37 + (int)(this._modTime ^ this._modTime >>> 32);
            result = result * 37 + this._path.hashCode();
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UrnSetKey)) {
                return false;
            }
            UrnSetKey key = (UrnSetKey)o;
            return this._modTime == key._modTime && this._path.equals(key._path);
        }

        public int hashCode() {
            return this._hashCode;
        }

        private void writeObject(ObjectOutputStream s) throws IOException {
            s.defaultWriteObject();
            s.writeLong(this._modTime);
            s.writeObject(this._path);
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
            this._modTime = s.readLong();
            this._path = (String)s.readObject();
            this._hashCode = this.calculateHashCode();
        }
    }
}

