/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.PongCacher;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.Statistics;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.guess.GUESSEndpoint;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.messages.vendor.ReplyNumberVendorMessage;
import com.limegroup.gnutella.settings.ChatSettings;
import com.limegroup.gnutella.statistics.RoutedQueryStat;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.xml.LimeXMLDocumentHelper;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class StandardMessageRouter
extends MessageRouter {
    private final boolean RECORD_STATS = !CommonUtils.isJava118();

    protected void respondToPingRequest(PingRequest ping, ReplyHandler handler) {
        byte ttl;
        byte hops = ping.getHops();
        if (hops + (ttl = ping.getTTL()) > 2 && !_manager.allowAnyConnection()) {
            return;
        }
        if (hops == 1 && ttl == 1) {
            this.handleCrawlerPing(ping, handler);
            return;
        }
        if (hops == 1 && ttl == 0) {
            PingReply pr = PingReply.create(ping.getGUID(), (byte)1);
            this.sendPingReply(pr, handler);
            return;
        }
        int newTTL = hops + 1;
        if (hops + ttl <= 2) {
            newTTL = 1;
        }
        if (RouterService.getConnectionManager().hasFreeSlots() || Statistics.instance().calculateDailyUptime() > 1800) {
            PingReply pr = PingReply.create(ping.getGUID(), (byte)newTTL);
            this.sendPingReply(pr, handler);
        }
        List pongs = PongCacher.instance().getBestPongs();
        Iterator iter = pongs.iterator();
        byte[] guid = ping.getGUID();
        while (iter.hasNext()) {
            this.sendPingReply(((PingReply)iter.next()).mutateGUID(guid), handler);
        }
    }

    protected void respondToUDPPingRequest(PingRequest request, DatagramPacket datagram, ReplyHandler handler) {
        List unicastEndpoints = this.UNICASTER.getUnicastEndpoints();
        Iterator iter = unicastEndpoints.iterator();
        if (iter.hasNext()) {
            while (iter.hasNext()) {
                GUESSEndpoint host = (GUESSEndpoint)iter.next();
                PingReply pr = PingReply.createExternal(request.getGUID(), (byte)1, host.getPort(), host.getAddress().getAddress(), true);
                this.sendPingReply(pr, handler);
            }
        } else {
            this.sendAcknowledgement(datagram, request.getGUID());
        }
    }

    private void handleCrawlerPing(PingRequest m, ReplyHandler handler) {
        List leafConnections = _manager.getInitializedClientConnections2();
        Iterator iterator = leafConnections.iterator();
        while (iterator.hasNext()) {
            ManagedConnection connection = (ManagedConnection)iterator.next();
            PingReply pr = PingReply.createExternal(m.getGUID(), (byte)2, connection.getListeningPort(), connection.getInetAddress().getAddress(), false);
            pr.hop();
            this.sendPingReply(pr, handler);
        }
    }

    protected void handlePingReply(PingReply pingReply, ReplyHandler receivingConnection) {
        if (receivingConnection instanceof ManagedConnection) {
            ManagedConnection mc = (ManagedConnection)receivingConnection;
            mc.updateHorizonStats(pingReply);
        }
        super.handlePingReply(pingReply, receivingConnection);
    }

    protected boolean respondToQueryRequest(QueryRequest queryRequest, byte[] clientGUID) {
        Response[] responses = RouterService.getFileManager().query(queryRequest);
        if (RouterService.isShieldedLeaf() && queryRequest.isTCP() && this.RECORD_STATS) {
            if (responses != null && responses.length > 0) {
                RoutedQueryStat.LEAF_HIT.incrementStat();
            } else {
                RoutedQueryStat.LEAF_FALSE_POSITIVE.incrementStat();
            }
        }
        return this.sendResponses(responses, queryRequest);
    }

    public boolean sendResponses(Response[] responses, QueryRequest query) {
        if (responses == null || responses.length < 1) {
            return false;
        }
        if (query.desiresOutOfBandReplies() && query.getHops() > 1 && !query.isFirewalledSource() && RouterService.isGUESSCapable() && RouterService.acceptedIncomingConnection() && !RouterService.getUploadManager().isBusy()) {
            if (this.bufferResponsesForLaterDelivery(query, responses)) {
                InetAddress addr = null;
                try {
                    addr = InetAddress.getByName(query.getReplyAddress());
                }
                catch (UnknownHostException uhe) {
                    return false;
                }
                int port = query.getReplyPort();
                try {
                    int resultCount = responses.length > 255 ? 255 : responses.length;
                    ReplyNumberVendorMessage vm = new ReplyNumberVendorMessage(new GUID(query.getGUID()), resultCount);
                    try {
                        UDPService.instance().send(vm, addr, port);
                    }
                    catch (IOException ioe) {
                        ErrorService.error(ioe, "ip/port: " + addr + ":" + port);
                    }
                }
                catch (BadPacketException bpe) {
                    ErrorService.error(bpe);
                }
                return true;
            }
            return false;
        }
        Iterator iterator = this.responsesToQueryReplies(responses, query);
        try {
            while (iterator.hasNext()) {
                QueryReply queryReply = (QueryReply)iterator.next();
                this.sendQueryReply(queryReply);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return true;
    }

    protected List createQueryReply(byte[] guid, byte ttl, long speed, Response[] res, byte[] clientGUID, boolean busy, boolean uploaded, boolean measuredSpeed, boolean isFromMcast) {
        Set proxies;
        ArrayList<QueryReply> queryReplies = new ArrayList<QueryReply>();
        QueryReply queryReply = null;
        int port = isFromMcast ? RouterService.getNonForcedPort() : RouterService.getPort();
        byte[] ip = isFromMcast ? RouterService.getNonForcedAddress() : RouterService.getAddress();
        String xmlCollectionString = LimeXMLDocumentHelper.getAggregateString(res);
        if (xmlCollectionString == null) {
            xmlCollectionString = "";
        }
        byte[] xmlBytes = null;
        try {
            xmlBytes = xmlCollectionString.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ueex) {
            xmlCollectionString = "";
            xmlBytes = xmlCollectionString.getBytes();
        }
        boolean notIncoming = !RouterService.acceptedIncomingConnection();
        Set set = proxies = notIncoming ? _manager.getPushProxies() : null;
        if (xmlBytes.length > 32768) {
            LinkedList splitResps = new LinkedList();
            this.splitAndAddResponses(splitResps, res);
            while (!splitResps.isEmpty()) {
                Response[] currResps = (Response[])splitResps.remove(0);
                String currXML = LimeXMLDocumentHelper.getAggregateString(currResps);
                byte[] currXMLBytes = null;
                try {
                    currXMLBytes = currXML.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException ueex) {
                    currXMLBytes = "".getBytes();
                }
                if (currXMLBytes.length > 32768 && currResps.length > 1) {
                    this.splitAndAddResponses(splitResps, currResps);
                    continue;
                }
                byte[] xmlCompressed = null;
                xmlCompressed = currXML != null && !currXML.equals("") ? LimeXMLUtils.compress(currXMLBytes) : DataUtils.EMPTY_BYTE_ARRAY;
                queryReply = new QueryReply(guid, ttl, port, ip, speed, currResps, this._clientGUID, xmlCompressed, notIncoming, busy, uploaded, measuredSpeed, ChatSettings.CHAT_ENABLED.getValue(), isFromMcast, proxies);
                queryReplies.add(queryReply);
            }
        } else {
            byte[] xmlCompressed = null;
            xmlCompressed = xmlCollectionString != null && !xmlCollectionString.equals("") ? LimeXMLUtils.compress(xmlBytes) : DataUtils.EMPTY_BYTE_ARRAY;
            queryReply = new QueryReply(guid, ttl, port, ip, speed, res, this._clientGUID, xmlCompressed, notIncoming, busy, uploaded, measuredSpeed, ChatSettings.CHAT_ENABLED.getValue(), isFromMcast, proxies);
            queryReplies.add(queryReply);
        }
        return queryReplies;
    }

    private Response[][] splitResponses(Response[] in) {
        int i;
        int middle = in.length / 2;
        Response[][] retResps = new Response[][]{new Response[middle], new Response[in.length - middle]};
        for (i = 0; i < middle; ++i) {
            retResps[0][i] = in[i];
        }
        for (i = 0; i < in.length - middle; ++i) {
            retResps[1][i] = in[i + middle];
        }
        return retResps;
    }

    private void splitAndAddResponses(List addTo, Response[] toSplit) {
        Response[][] splits = this.splitResponses(toSplit);
        addTo.add(splits[0]);
        addTo.add(splits[1]);
    }
}

