/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class RemoteFileDesc
implements Serializable {
    private static final long serialVersionUID = 6619479308616716538L;
    private final String _host;
    private final int _port;
    private final String _filename;
    private final long _index;
    private final byte[] _clientGUID;
    private final int _speed;
    private final int _size;
    private final boolean _chatEnabled;
    private final int _quality;
    private final boolean _replyToMulticast;
    private LimeXMLDocument[] _xmlDocs;
    private Set _urns;
    private boolean _browseHostEnabled;
    private boolean _firewalled;
    private String _vendor;
    private long _timestamp;
    private boolean _http11;
    private transient Set _proxies;
    private transient List _availableRanges = null;
    private transient int _failedCount = 0;

    public RemoteFileDesc(String host, int port, long index, String filename, int size, byte[] clientGUID, int speed, boolean chat, int quality, boolean browseHost, LimeXMLDocument xmlDoc, Set urns, boolean replyToMulticast, boolean firewalled, String vendor, long timestamp, Set proxies) {
        if (!NetworkUtils.isValidPort(port)) {
            throw new IllegalArgumentException("invalid port: " + port);
        }
        if (((long)speed & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalArgumentException("invalid speed: " + speed);
        }
        if (filename == null) {
            throw new NullPointerException("null filename");
        }
        if (filename.equals("")) {
            throw new IllegalArgumentException("cannot accept empty string file name");
        }
        if (((long)size & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalArgumentException("invalid size: " + size);
        }
        if ((index & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalArgumentException("invalid index: " + index);
        }
        if (host == null) {
            throw new NullPointerException("null host");
        }
        this._speed = speed;
        this._host = host;
        this._port = port;
        this._index = index;
        this._filename = filename;
        this._size = size;
        this._clientGUID = clientGUID;
        this._chatEnabled = chat;
        this._quality = quality;
        this._browseHostEnabled = browseHost;
        this._replyToMulticast = replyToMulticast;
        this._firewalled = firewalled;
        this._vendor = vendor;
        this._timestamp = timestamp;
        this._proxies = proxies == null ? DataUtils.EMPTY_SET : Collections.unmodifiableSet(proxies);
        this._xmlDocs = xmlDoc != null ? new LimeXMLDocument[]{xmlDoc} : null;
        this._urns = urns == null ? DataUtils.EMPTY_SET : Collections.unmodifiableSet(urns);
        this._http11 = !this._urns.isEmpty();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this._urns == null) {
            this._urns = DataUtils.EMPTY_SET;
            this._browseHostEnabled = false;
        }
        if (this._proxies == null) {
            this._proxies = DataUtils.EMPTY_SET;
        }
        if (this._xmlDocs != null && this._xmlDocs.length == 0) {
            this._xmlDocs = null;
        }
        this._http11 = this._http11 || !this._urns.isEmpty();
    }

    public boolean isHTTP11() {
        return this._http11;
    }

    public void setHTTP11(boolean http11) {
        this._http11 = http11;
    }

    public boolean isPartialSource() {
        return this._availableRanges != null;
    }

    public List getAvailableRanges() {
        return this._availableRanges;
    }

    public void setAvailableRanges(List availableRanges) {
        this._availableRanges = availableRanges;
    }

    public int getFailedCount() {
        return this._failedCount;
    }

    public void incrementFailedCount() {
        ++this._failedCount;
    }

    public void resetFailedCount() {
        this._failedCount = 0;
    }

    public final String getHost() {
        return this._host;
    }

    public final int getPort() {
        return this._port;
    }

    public final long getIndex() {
        return this._index;
    }

    public final int getSize() {
        return this._size;
    }

    public final String getFileName() {
        return this._filename;
    }

    public final byte[] getClientGUID() {
        return this._clientGUID;
    }

    public final int getSpeed() {
        return this._speed;
    }

    public final String getVendor() {
        return this._vendor;
    }

    public final boolean chatEnabled() {
        return this._chatEnabled;
    }

    public final boolean browseHostEnabled() {
        return this._browseHostEnabled;
    }

    public final int getQuality() {
        return this._quality;
    }

    public final LimeXMLDocument getXMLDoc() {
        if (this._xmlDocs == null) {
            return null;
        }
        return this._xmlDocs[0];
    }

    public final Set getUrns() {
        return this._urns;
    }

    public final URN getSHA1Urn() {
        Iterator iter = this._urns.iterator();
        while (iter.hasNext()) {
            URN urn = (URN)iter.next();
            if (urn == null || !urn.isSHA1()) continue;
            return urn;
        }
        return null;
    }

    public URL getUrl() {
        try {
            String fileName = "";
            URN urn = this.getSHA1Urn();
            fileName = urn == null ? "/get/" + this._index + "/" + this._filename : "/uri-res/N2R?" + urn.httpStringValue();
            return new URL("http", this._host, this._port, fileName);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public final boolean isReplyToMulticast() {
        return this._replyToMulticast;
    }

    public final boolean isPrivate() {
        try {
            return NetworkUtils.isPrivateAddress(this._host);
        }
        catch (UnknownHostException e) {
            return true;
        }
    }

    public final Set getPushProxies() {
        return this._proxies;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoteFileDesc)) {
            return false;
        }
        RemoteFileDesc other = (RemoteFileDesc)o;
        return (this._host == null ? other._host == null : this._host.equals(other._host)) && this._port == other._port && (this._filename == null ? other._filename == null : this._filename.equals(other._filename)) && this._index == other._index && (this._clientGUID == null ? other._clientGUID == null : Arrays.equals(this._clientGUID, other._clientGUID)) && this._speed == other._speed && this._size == other._size && (this.getXMLDoc() == null ? other.getXMLDoc() == null : this.getXMLDoc().equals(other.getXMLDoc())) && (this._urns == null ? other._urns == null : ((Object)this._urns).equals(other._urns));
    }

    public String toString() {
        return "<" + this.getHost() + ":" + this.getPort() + ", " + this.getFileName() + "/" + this.getSize() + ", " + this.getSpeed() + ", " + this.getSHA1Urn() + ", " + this.getQuality() + ", mcast: " + this._replyToMulticast + ">";
    }
}

